/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.ability.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.tydic.payment.pay.ability.PayProQryPayMethodAbilityService;
import com.tydic.payment.pay.ability.bo.PayProQryPayMethodReqBo;
import com.tydic.payment.pay.ability.bo.PayProQryPayMethodRspBo;
import com.tydic.payment.pay.busi.PayProQueryInfoBusiSystemByConditionService;
import com.tydic.payment.pay.busi.QueryCashierPayMethodService;
import com.tydic.payment.pay.busi.QueryCashierService;
import com.tydic.payment.pay.busi.bo.PayProQueryInfoBusiSystemByConditionBusiInfoRspBo;
import com.tydic.payment.pay.busi.bo.QueryCashierPayMethodReqBo;
import com.tydic.payment.pay.busi.bo.QueryCashierPayMethodRspBo;
import com.tydic.payment.pay.busi.bo.QueryCashierReqBo;
import com.tydic.payment.pay.busi.bo.QueryCashierRspBo;
import com.tydic.payment.pay.dao.PayMethodMapper;
import com.tydic.payment.pay.dao.po.PayMethodPo;
import com.tydic.payment.pay.exception.BusinessException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"PAYMENT_GROUP_DEV/2.0.0/com.tydic.payment.pay.ability.PayProQryPayMethodAbilityService"})
public class PayProQryPayMethodAbilityServiceImpl
implements PayProQryPayMethodAbilityService {
    private static final Logger log = LoggerFactory.getLogger(PayProQryPayMethodAbilityServiceImpl.class);
    private QueryCashierService queryCashierService;
    private QueryCashierPayMethodService queryCashierPayMethodService;
    private PayProQueryInfoBusiSystemByConditionService queryInfoBusiSystemByConditionService;
    private PayMethodMapper payMethodMapper;

    public PayProQryPayMethodAbilityServiceImpl(QueryCashierService queryCashierService, QueryCashierPayMethodService queryCashierPayMethodService, PayProQueryInfoBusiSystemByConditionService queryInfoBusiSystemByConditionService, PayMethodMapper payMethodMapper) {
        this.queryCashierService = queryCashierService;
        this.queryCashierPayMethodService = queryCashierPayMethodService;
        this.payMethodMapper = payMethodMapper;
        this.queryInfoBusiSystemByConditionService = queryInfoBusiSystemByConditionService;
    }

    @PostMapping(value={"queryPayMethods"})
    public PayProQryPayMethodRspBo queryPayMethods(@RequestBody PayProQryPayMethodReqBo reqBo) {
        PayProQryPayMethodRspBo retBo = new PayProQryPayMethodRspBo();
        String validateArgStr = this.validateArg(reqBo);
        if (!StringUtils.isEmpty((Object)validateArgStr)) {
            retBo.setRespCode("214036");
            retBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateArgStr);
            return retBo;
        }
        PayProQueryInfoBusiSystemByConditionBusiInfoRspBo busiCodeRspBo = this.queryInfoBusiSystemByConditionService.queryBusiSysByBusiCode(reqBo.getBusiCode());
        if (!"0000".equals(busiCodeRspBo.getRespCode())) {
            retBo.setRespCode("214036");
            retBo.setRespDesc("\u67e5\u8be2\u4e1a\u52a1\u7cfb\u7edf\u5931\u8d25:" + busiCodeRspBo.getRespDesc());
            return retBo;
        }
        if (!"1".equals(busiCodeRspBo.getState())) {
            retBo.setRespCode("214036");
            retBo.setRespDesc("\u8be5\u4e1a\u52a1\u7cfb\u7edf(" + reqBo.getBusiCode() + ")\u5df2\u5931\u6548");
            return retBo;
        }
        PayMethodPo quryPo = new PayMethodPo();
        quryPo.setPaymentInsId(Long.valueOf(reqBo.getPaymentInsId()));
        quryPo.setPayMethodStatus("1");
        List<PayMethodPo> payInsMethodPos = this.payMethodMapper.queryPayMethod(quryPo);
        if (CollectionUtil.isEmpty(payInsMethodPos)) {
            retBo.setRespCode("214036");
            retBo.setRespDesc("\u8be5\u652f\u4ed8\u673a\u6784(" + reqBo.getPaymentInsId() + ")\u672a\u914d\u7f6e\u6709\u6548\u7684\u652f\u4ed8\u65b9\u5f0f");
            return retBo;
        }
        List payMethodIds = payInsMethodPos.stream().map(item -> String.valueOf(item.getPayMethod())).collect(Collectors.toList());
        QueryCashierReqBo queryCashierReqBo = new QueryCashierReqBo();
        queryCashierReqBo.setBusiId(busiCodeRspBo.getBusiId().toString());
        queryCashierReqBo.setReqWay(reqBo.getReqWay());
        QueryCashierRspBo queryCashierRspBo = this.queryCashierService.queryCashier(queryCashierReqBo);
        if ("8888".equals(queryCashierRspBo.getRspCode())) {
            BeanUtils.copyProperties((Object)queryCashierRspBo, (Object)retBo);
            return retBo;
        }
        QueryCashierPayMethodReqBo queryCashierPayMethodReqBo = new QueryCashierPayMethodReqBo();
        queryCashierPayMethodReqBo.setMerchantId(String.valueOf(reqBo.getMerchantId()));
        queryCashierPayMethodReqBo.setCashierTemplate(queryCashierRspBo.getCashierTemplate());
        QueryCashierPayMethodRspBo queryCashierPayMethodRspBo = this.queryCashierPayMethodService.queryCashierPayMethod(queryCashierPayMethodReqBo);
        if ("8888".equals(queryCashierPayMethodRspBo.getRspCode())) {
            throw new BusinessException("214036", "\u5546\u6237\u672a\u914d\u7f6e\u652f\u4ed8\u65b9\u5f0f");
        }
        List<Object> payMethods = new ArrayList();
        payMethods.addAll(queryCashierPayMethodRspBo.getCodePayMethodList());
        if (CollectionUtil.isNotEmpty(payMethods)) {
            payMethods = payMethods.stream().filter(item -> payMethodIds.contains(item.getPayMethod())).collect(Collectors.toList());
        }
        retBo.setPayMethods(payMethods);
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        return retBo;
    }

    private String validateArg(PayProQryPayMethodReqBo reqBo) {
        if (null == reqBo) {
            return "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getBusiCode())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027busiCode\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getMerchantId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027merchantId\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getPaymentInsId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027paymentInsId\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getPaymentInsId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027reqWay\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }
}

