/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.comb.impl;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.payment.pay.atom.BusiSystemInfoAtomService;
import com.tydic.payment.pay.atom.MerchantInfoAtomService;
import com.tydic.payment.pay.atom.PayMethodAtomService;
import com.tydic.payment.pay.atom.PayOrderAtomService;
import com.tydic.payment.pay.atom.PaymentInsAtomService;
import com.tydic.payment.pay.atom.PorderRefundTransAtomService;
import com.tydic.payment.pay.atom.bo.PorderRefundTransAtomReqBo;
import com.tydic.payment.pay.atom.bo.PorderRefundTransAtomRspBo;
import com.tydic.payment.pay.bo.PayProBaseRspBo;
import com.tydic.payment.pay.busi.DataEncryptionService;
import com.tydic.payment.pay.busi.QueryDBDateBusiService;
import com.tydic.payment.pay.busi.bo.DataEncryptionReqBo;
import com.tydic.payment.pay.busi.bo.DataEncryptionRspBo;
import com.tydic.payment.pay.comb.PayProTriggerRefundCallSysCombService;
import com.tydic.payment.pay.comb.bo.PayProTriggerRefundCallSysCombReqBo;
import com.tydic.payment.pay.comb.bo.PayProTriggerRefundCallSysCombRspBo;
import com.tydic.payment.pay.config.PayProAsyncNotice;
import com.tydic.payment.pay.dao.po.BusiSystemInfoPO;
import com.tydic.payment.pay.dao.po.MerChantInfoPo;
import com.tydic.payment.pay.dao.po.PayMethodPo;
import com.tydic.payment.pay.dao.po.PaymentInsPo;
import com.tydic.payment.pay.dao.po.PorderPo;
import com.tydic.payment.pay.util.PayProRspUtil;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="payProTriggerRefundCallSysCombService")
public class PayProTriggerRefundCallSysCombServiceImpl
implements PayProTriggerRefundCallSysCombService {
    private static final Logger log = LoggerFactory.getLogger(PayProTriggerRefundCallSysCombServiceImpl.class);
    private static final String RESULT_CODE = "resultCode";
    private static final String SUCCESS = "SUCCESS";
    private static final String NOTIFY_SUCCESS = "0";
    @Autowired
    private PayOrderAtomService payOrderAtomService;
    @Autowired
    private PorderRefundTransAtomService porderRefundTransAtomService;
    @Autowired
    private QueryDBDateBusiService queryDbDateBusiService;
    @Autowired
    private DataEncryptionService dataEncryptionService;
    @Autowired
    private BusiSystemInfoAtomService busiSystemInfoAtomService;
    @Autowired
    private MerchantInfoAtomService merchantInfoAtomService;
    @Autowired
    private PaymentInsAtomService paymentInsAtomService;
    @Autowired
    private PayMethodAtomService payMethodAtomService;

    public PayProTriggerRefundCallSysCombRspBo noticeBusiSys(PayProTriggerRefundCallSysCombReqBo reqBo) {
        log.info("\u652f\u4ed8\u4e2d\u5fc3\u4e3b\u52a8\u56de\u8c03\u53d1\u8d77http\u8bf7\u6c42\u56de\u8c03\u4e1a\u52a1\u7cfb\u7edf\u9000\u6b3e\u6210\u529f\u670d\u52a1\u5165\u53c2\uff1a", (Object)JSON.toJSONString((Object)reqBo));
        PayProTriggerRefundCallSysCombRspBo retBo = new PayProTriggerRefundCallSysCombRspBo();
        String validateStr = this.validateArgs(reqBo);
        if (!StringUtils.isEmpty((Object)validateStr)) {
            retBo.setRespCode("8888");
            retBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            return retBo;
        }
        Long orderId = Long.parseLong(reqBo.getOrderId());
        PorderPo orderInfo = this.payOrderAtomService.queryPorderInfo(orderId);
        if (null == orderInfo) {
            retBo.setRespCode("8888");
            retBo.setRespDesc("\u672a\u67e5\u8be2\u5230\u8ba2\u5355\uff1a" + orderId + "\u7684\u4fe1\u606f");
            return retBo;
        }
        if (StringUtils.isEmpty((Object)orderInfo.getNotifyUrl())) {
            retBo.setRespCode("8888");
            retBo.setRespDesc("\u8ba2\u5355\uff1a" + orderId + "\u4e0d\u9700\u8981\u56de\u8c03\u901a\u77e5");
            return retBo;
        }
        if (!"06".equals(orderInfo.getOrderType()) && !"02".equals(orderInfo.getOrderType())) {
            log.debug("\u8ba2\u5355\u53f7orderId(" + orderInfo.getOrderId() + ")\u4e0d\u662f\u9000\u6b3e\u8ba2\u5355");
            retBo.setRespCode("8888");
            retBo.setRespDesc("\u8ba2\u5355\u53f7orderId(" + orderInfo.getOrderId() + ")\u4e0d\u662f\u9000\u6b3e\u8ba2\u5355");
            return retBo;
        }
        if (!"B10".equals(orderInfo.getOrderStatus())) {
            log.debug("\u8ba2\u5355\u53f7orderId(" + orderInfo.getOrderId() + ")\u672a\u9000\u6b3e\u6210\u529f\uff0c\u4e0d\u80fd\u53d1\u8d77\u901a\u77e5");
            retBo.setRespCode("8888");
            retBo.setRespDesc("\u8ba2\u5355\u53f7orderId(" + orderInfo.getOrderId() + ")\u672a\u9000\u6b3e\u6210\u529f\uff0c\u4e0d\u80fd\u53d1\u8d77\u901a\u77e5");
            return retBo;
        }
        PorderRefundTransAtomReqBo refundTransReqBo = new PorderRefundTransAtomReqBo();
        refundTransReqBo.setOrderId(orderInfo.getOrderId());
        refundTransReqBo.setOrderStatus("B10");
        List<PorderRefundTransAtomRspBo> refundTranRetBos = this.porderRefundTransAtomService.queryOrderRefundTransByCondition(refundTransReqBo);
        if (CollectionUtils.isEmpty(refundTranRetBos)) {
            log.info("\u672a\u67e5\u8be2\u5230\u9000\u6b3e\u6d41\u6c34\u8ba2\u5355\u4fe1\u606f");
            retBo.setRespCode("8888");
            retBo.setRespDesc("\u672a\u67e5\u8be2\u5230\u9000\u6b3e\u6d41\u6c34\u8ba2\u5355\u4fe1\u606f\uff0c\u4e0d\u80fd\u53d1\u8d77\u901a\u77e5");
            return retBo;
        }
        PorderRefundTransAtomRspBo refundTranBo = refundTranRetBos.get(0);
        BusiSystemInfoPO busiSystemInfoPO = new BusiSystemInfoPO();
        busiSystemInfoPO.setBusiId(orderInfo.getBusiId());
        List<BusiSystemInfoPO> busiSystem = this.busiSystemInfoAtomService.queryBusiSystemInfoByCondition(busiSystemInfoPO);
        if (busiSystem.size() == 0) {
            log.error("\u672a\u67e5\u8be2\u5230 \u4e1a\u52a1\u7cfb\u7edf\u3010busiId = " + orderInfo.getBusiId() + "\u3011\u7684\u4fe1\u606f");
            retBo.setRespCode("8888");
            retBo.setRespDesc("\u672a\u67e5\u8be2\u5230 \u4e1a\u52a1\u7cfb\u7edf\u3010busiId = " + orderInfo.getBusiId() + "\u3011\u7684\u4fe1\u606f");
            return retBo;
        }
        int callType = busiSystem.get(0).getCallType();
        if (3 == callType) {
            Object msgData = PayProAsyncNotice.assignData(orderInfo, refundTranBo);
            JSONObject msgJson = JSON.parseObject((String)JSON.toJSONString((Object)msgData));
            this.assignMsg(msgJson, refundTranBo);
            log.debug("\u56de\u8c03\u901a\u77e5\u7684\u53c2\u6570\u4e3a: {}", (Object)msgJson.toJSONString());
            String dealResult = this.dealHttpPost(msgJson, orderInfo);
            if (!StringUtils.isEmpty((Object)dealResult)) {
                retBo.setRespCode("8888");
                retBo.setRespDesc(dealResult);
                return retBo;
            }
        } else {
            log.error("\u4e0d\u652f\u6301\u7684\u5f02\u6b65\u901a\u77e5\u7c7b\u578b\u4e3a\uff1acallType = " + callType + ",\u4ec5\u652f\u6301http\u56de\u8c03");
            retBo.setRespCode("8888");
            retBo.setRespDesc("\u4e0d\u652f\u6301\u7684\u5f02\u6b65\u901a\u77e5\u7c7b\u578b\u4e3a\uff1acallType = " + callType);
            return retBo;
        }
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        return retBo;
    }

    private String dealHttpPost(Object msgData, PorderPo orderInfo) {
        PayProBaseRspBo retBo = PayProRspUtil.generateSucRspBo(PayProBaseRspBo.class);
        DataEncryptionReqBo dataEncryptionReqBo = new DataEncryptionReqBo();
        dataEncryptionReqBo.setBusiId(orderInfo.getBusiId().toString());
        dataEncryptionReqBo.setContent(JSON.toJSONString((Object)msgData));
        DataEncryptionRspBo dataEncryptionRspBo = this.dataEncryptionService.dataEncryption(dataEncryptionReqBo);
        log.info("\u901a\u77e5\u7684\u6d88\u606f\u4e3b\u9898\u5185\u5bb9\u4e3a\uff1a{}\uff0c\u76ee\u6807\u5730\u5740\u4e3a\uff1a{}", (Object)dataEncryptionRspBo.getEncrypData(), (Object)orderInfo.getNotifyUrl());
        HashMap<String, String> postData = new HashMap<String, String>(16);
        postData.put("busiCode", orderInfo.getBusiCode());
        postData.put("content", dataEncryptionRspBo.getEncrypData());
        String result = HttpUtil.post((String)orderInfo.getNotifyUrl(), postData);
        log.info("\u8fd4\u56de\u53c2\u6570\u4e3a\uff1a{}", (Object)result);
        if (StringUtils.isEmpty((Object)result)) {
            log.debug("\u8c03\u7528\u76ee\u6807\u5730\u5740\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a");
            retBo.setRespCode("8888");
            retBo.setRespDesc("\u8c03\u7528\u76ee\u6807\u5730\u5740\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a");
            return "\u8c03\u7528\u76ee\u6807\u5730\u5740\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a";
        }
        PorderPo pOrder = new PorderPo();
        pOrder.setOrderId(orderInfo.getOrderId());
        if (result.contains(RESULT_CODE)) {
            if (!result.contains(SUCCESS)) {
                log.debug("===========\u672c\u6b21\u901a\u77e5\u5931\u8d25===========");
                pOrder.setCustyNotifyCode("1");
                pOrder.setCustNotifyMsg("FAIL");
                return "\u76ee\u6807\u5730\u5740\u8fd4\u56de\u7ed3\u679c\uff1a" + result;
            }
        } else {
            pOrder.setCustyNotifyCode("1");
            pOrder.setCustNotifyMsg("FAIL");
            return "\u76ee\u6807\u5730\u5740\u8fd4\u56de\u7ed3\u679c\u672a\u5305\u542b\u6b63\u786e\uff1a" + result;
        }
        log.debug("===========\u672c\u6b21\u901a\u77e5\u6210\u529f===========");
        pOrder.setCustyNotifyCode(NOTIFY_SUCCESS);
        pOrder.setCustNotifyMsg(SUCCESS);
        pOrder.setCustNotifyTime(this.queryDbDateBusiService.getDBDate());
        try {
            this.payOrderAtomService.update(pOrder);
        }
        catch (Exception e) {
            log.error("\u652f\u4ed8\u4e2d\u5fc3\u901a\u77e5\uff0c\u66f4\u65b0\u6570\u636e\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
            return "\u652f\u4ed8\u4e2d\u5fc3\u66f4\u65b0\u8ba2\u5355\u6570\u636e\u5f02\u5e38\uff1a" + e.getMessage();
        }
        return null;
    }

    private void assignMsg(JSONObject msgJson, PorderRefundTransAtomRspBo refundTranBo) {
        MerChantInfoPo merChantInfo;
        Long merchantId = refundTranBo.getMerchantId();
        Long payMethod = refundTranBo.getPayMethod();
        if (null != merchantId && null != (merChantInfo = this.merchantInfoAtomService.queryMerchantInfoById(merchantId))) {
            msgJson.put("merchantName", (Object)merChantInfo.getMerchantName());
        }
        if (null != payMethod) {
            PayMethodPo methodInfo = this.payMethodAtomService.queryPayMethodById(payMethod);
            if (null != methodInfo) {
                msgJson.put("payMethodName", (Object)methodInfo.getPayMethodName());
            }
            PaymentInsPo paymentInsPo = new PaymentInsPo();
            paymentInsPo.setPaymentInsId(methodInfo.getPaymentInsId());
            List<PaymentInsPo> paymentInsList = this.paymentInsAtomService.queryPaymentInf(paymentInsPo);
            if (!CollectionUtils.isEmpty(paymentInsList)) {
                PaymentInsPo paymentInsInfo = paymentInsList.get(0);
                msgJson.put("paymentInsId", (Object)paymentInsInfo.getPaymentInsId());
                msgJson.put("paymentInsName", (Object)paymentInsInfo.getPaymentInsName());
            }
        }
    }

    private String validateArgs(PayProTriggerRefundCallSysCombReqBo reqBo) {
        if (null == reqBo) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        String orderId = reqBo.getOrderId();
        if (!StringUtils.isEmpty((Object)orderId)) {
            try {
                Long.parseLong(orderId);
            }
            catch (NumberFormatException e) {
                return "orderId\u5fc5\u987b\u4e3a\u6570\u5b57";
            }
        }
        return null;
    }
}

