/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.payment.pay.ability.CashierUrlUnencryptedService;
import com.tydic.payment.pay.ability.bo.CashierUrlUnencryptedReqBo;
import com.tydic.payment.pay.ability.bo.CashierUrlUnencryptedRspBo;
import com.tydic.payment.pay.busi.bo.GoodsDetail;
import com.tydic.payment.pay.comb.CashierPayUrlCombService;
import com.tydic.payment.pay.comb.bo.CombCashierPayUrlReqBo;
import com.tydic.payment.pay.comb.bo.CombCashierPayUrlRspBo;
import java.math.BigDecimal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"PAYMENT_GROUP_DEV/2.0.0/com.tydic.payment.pay.ability.CashierUrlUnencryptedService"})
public class CashierUrlUnencryptedServiceImpl
implements CashierUrlUnencryptedService {
    private static final Logger LOG = LoggerFactory.getLogger(CashierUrlUnencryptedServiceImpl.class);
    @Autowired
    private CashierPayUrlCombService cashierPayUrlCombService;

    @PostMapping(value={"cashierPay"})
    public CashierUrlUnencryptedRspBo cashierPay(@RequestBody CashierUrlUnencryptedReqBo cashierUrlUnencryptedReqBo) {
        LOG.info("\u4e0b\u5355\u8fd4\u56deURL \u5165\u53c2\u4e3a:" + JSONObject.toJSONString((Object)cashierUrlUnencryptedReqBo));
        CashierUrlUnencryptedRspBo rspBo = new CashierUrlUnencryptedRspBo();
        String errMsg = this.checkParams(cashierUrlUnencryptedReqBo);
        if (!"TRUE".equals(errMsg)) {
            LOG.info("\u4e0b\u5355\u8fd4\u56deURL\u6821\u9a8c\u4e0d\u901a\u8fc7\uff1a" + errMsg);
            rspBo.setRspCode("\u5931\u8d25");
            rspBo.setRspName(errMsg);
            return rspBo;
        }
        CombCashierPayUrlReqBo combCashierPayUrlReqBo = new CombCashierPayUrlReqBo();
        BeanUtils.copyProperties((Object)cashierUrlUnencryptedReqBo, (Object)combCashierPayUrlReqBo);
        CombCashierPayUrlRspBo combCashierPayUrlRspBo = this.cashierPayUrlCombService.pmcCashierPayUrlComb(combCashierPayUrlReqBo);
        BeanUtils.copyProperties((Object)combCashierPayUrlRspBo, (Object)rspBo);
        return rspBo;
    }

    private String checkParams(CashierUrlUnencryptedReqBo cashierUrlUnencryptedReqBo) {
        String errMsg = "TRUE";
        if (cashierUrlUnencryptedReqBo == null) {
            errMsg = "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a";
            return errMsg;
        }
        if (StringUtils.isEmpty((Object)cashierUrlUnencryptedReqBo.getBusiId())) {
            errMsg = "\u5165\u53c2\u3010busiId\u3011 \u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)cashierUrlUnencryptedReqBo.getCreateOperId())) {
            errMsg = "\u5165\u53c2\u3010createOperId\u3011 \u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)cashierUrlUnencryptedReqBo.getDetailName())) {
            errMsg = "\u5165\u53c2\u3010detailName\u3011 \u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)cashierUrlUnencryptedReqBo.getNotifyUrl())) {
            errMsg = "\u5165\u53c2\u3010notifyUrl\u3011 \u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)cashierUrlUnencryptedReqBo.getOrderType()) || !"01".equals(cashierUrlUnencryptedReqBo.getOrderType())) {
            errMsg = "\u5165\u53c2\u3010orderType\u3011 \u4e0d\u6b63\u786e";
        }
        if (StringUtils.isEmpty((Object)cashierUrlUnencryptedReqBo.getOutOrderId())) {
            errMsg = "\u5165\u53c2\u3010outOrderId\u3011 \u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (cashierUrlUnencryptedReqBo.getOutOrderId() != null && cashierUrlUnencryptedReqBo.getOutOrderId().length() > 32) {
            errMsg = "\u5165\u53c2\u3010outOrderId\u3011 \u957f\u5ea6\u8d85\u957f\u5566";
        }
        if (!cashierUrlUnencryptedReqBo.getRedirectUrl().startsWith("http://") && !cashierUrlUnencryptedReqBo.getRedirectUrl().startsWith("https://")) {
            errMsg = "redirect_url \u56de\u8c03\u5730\u5740\u4e0d\u5408\u6cd5";
        }
        if (!(cashierUrlUnencryptedReqBo.getNotifyUrl().startsWith("http://") || cashierUrlUnencryptedReqBo.getNotifyUrl().startsWith("https://") || cashierUrlUnencryptedReqBo.getNotifyUrl().equals("MQ"))) {
            errMsg = "notify_url \u56de\u8c03\u5730\u5740\u4e0d\u5408\u6cd5";
        }
        if (StringUtils.isEmpty((Object)cashierUrlUnencryptedReqBo.getTotalFee())) {
            errMsg = "\u5165\u53c2\u3010totalFee\u3011 \u4e0d\u80fd\u4e3a\u7a7a";
            return errMsg;
        }
        try {
            int a = Integer.valueOf(cashierUrlUnencryptedReqBo.getTotalFee());
            if (new BigDecimal(cashierUrlUnencryptedReqBo.getTotalFee()).compareTo(new BigDecimal("0")) < 0) {
                errMsg = "\u5165\u53c2\u3010totalFee\u3011 \u91d1\u989d\u5fc5\u987b\u5927\u4e8e0";
            }
        }
        catch (Exception e) {
            LOG.info("\u8bf7\u4f20\u5165\u6709\u6548\u3010totalFee\u3011 \u6570\u636e\uff1a" + e.getMessage());
            errMsg = "\u8bf7\u4f20\u5165\u6709\u6548\u3010totalFee\u3011 \u6570\u636e";
        }
        if (!(!StringUtils.isEmpty((Object)cashierUrlUnencryptedReqBo.getReqWay()) && ("2".equals(cashierUrlUnencryptedReqBo.getReqWay()) || "3".equals(cashierUrlUnencryptedReqBo.getReqWay()) || "4".equals(cashierUrlUnencryptedReqBo.getReqWay()) || "6".equals(cashierUrlUnencryptedReqBo.getReqWay()) || "1".equals(cashierUrlUnencryptedReqBo.getReqWay()) || "5".equals(cashierUrlUnencryptedReqBo.getReqWay())))) {
            errMsg = "\u8bf7\u4f20\u5165\u6709\u6548\u7684\u3010reqWay\u3011\u6570\u636e";
        }
        if (cashierUrlUnencryptedReqBo.getGoodsDetail() != null && cashierUrlUnencryptedReqBo.getGoodsDetail().size() > 0) {
            for (GoodsDetail goods : cashierUrlUnencryptedReqBo.getGoodsDetail()) {
                if (StringUtils.isEmpty((Object)goods.getGoodsId())) {
                    errMsg = "\u3010goodsId \u3011 \u5546\u54c1ID\u4e3a\u5fc5\u4f20\u5b57\u6bb5";
                    break;
                }
                if (StringUtils.isEmpty((Object)goods.getGoodsNum()) || "0".equals(goods.getGoodsNum())) {
                    errMsg = "\u3010goodsNum \u3011 \u5546\u54c1\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a";
                    break;
                }
                if (!StringUtils.isEmpty((Object)goods.getGoodsNum())) {
                    try {
                        int n = Integer.valueOf(goods.getGoodsNum());
                    }
                    catch (Exception e) {
                        errMsg = "\u8bf7\u786e\u8ba4 \u3010goodsNum\u3011 \u5546\u54c1\u6570\u91cf";
                    }
                }
                if (StringUtils.isEmpty((Object)goods.getGoodsName())) {
                    errMsg = "\u3010goodsName \u3011\u5546\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a";
                    break;
                }
                if (StringUtils.isEmpty((Object)goods.getGoodsPrice()) || "0".equals(goods.getGoodsNum())) {
                    errMsg = "\u3010goodsPrice \u3011 \u5546\u54c1\u4ef7\u683c\u4e0d\u80fd\u4e3a\u7a7a";
                    break;
                }
                if (StringUtils.isEmpty((Object)goods.getGoodsPrice())) continue;
                try {
                    BigDecimal price = new BigDecimal(goods.getGoodsPrice());
                    if (price.compareTo(new BigDecimal(0)) > 0) continue;
                    errMsg = "\u3010goodsPrice \u3011 \u8bf7\u786e\u8ba4\u5546\u54c1\u4ef7\u683c";
                }
                catch (Exception e) {
                    errMsg = "\u3010goodsPrice \u3011 \u8bf7\u786e\u8ba4\u5546\u54c1\u4ef7\u683c";
                }
                break;
            }
        }
        return errMsg;
    }
}

