/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.bill.comb.impl;

import com.tydic.payment.bill.busi.BillPaymentTransCreateBusiService;
import com.tydic.payment.bill.busi.PaymentInsIdBusiService;
import com.tydic.payment.bill.busi.QueryPayTransBusiService;
import com.tydic.payment.bill.busi.QueryRefundBusiService;
import com.tydic.payment.bill.busi.bo.BillPaymentTransCreateReqBO;
import com.tydic.payment.bill.busi.bo.QueryPayTransRspBO;
import com.tydic.payment.bill.busi.bo.QueryRefundRspBO;
import com.tydic.payment.bill.comb.BillCebPayTransInputCombService;
import com.tydic.payment.bill.comb.bo.BillCebPayTransInputCombReqBo;
import com.tydic.payment.bill.comb.bo.BillCebPayTransInputCombRspBo;
import com.tydic.payment.bill.constant.BillConstant;
import com.tydic.payment.bill.exception.BillDownAndTransException;
import com.tydic.payment.bill.support.cebpay.bo.CebPayResultBo;
import com.tydic.payment.bill.support.cebpay.bo.CebPayResultNativeBo;
import com.tydic.payment.pay.busi.TransCebPayBusiService;
import com.tydic.payment.pay.busi.bo.TransCebPayBusiServiceReqBo;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="billCebPayTransInputCombService")
public class BillCebPayTransInputCombServiceImpl
implements BillCebPayTransInputCombService {
    @Autowired
    private TransCebPayBusiService transCebPayBusiService;
    @Autowired
    private QueryPayTransBusiService queryPayTransBusiService;
    @Autowired
    private QueryRefundBusiService queryRefundBusiService;
    @Autowired
    private PaymentInsIdBusiService paymentInsIdBusiService;
    @Autowired
    private BillPaymentTransCreateBusiService billPaymentTransCreateBusiService;

    public BillCebPayTransInputCombRspBo trans(BillCebPayTransInputCombReqBo bo) {
        BillCebPayTransInputCombRspBo retBo = new BillCebPayTransInputCombRspBo();
        CebPayResultNativeBo cebPayResultNativeBo = bo.getCebPayResultNativeBo();
        String merid = cebPayResultNativeBo.getMerid();
        List cebPayResultBos = cebPayResultNativeBo.getData();
        Long billDate = 0L;
        if (cebPayResultBos != null) {
            if (!cebPayResultBos.isEmpty()) {
                billDate = Long.valueOf(((CebPayResultBo)cebPayResultBos.get(0)).getPaydate().substring(0, 8));
            }
            for (CebPayResultBo tempBo : cebPayResultBos) {
                TransCebPayBusiServiceReqBo cebPayBusiBo = this.buildCebPayBusiBo(tempBo, billDate, merid);
                BillPaymentTransCreateReqBO paymentTrans = this.buildPaymentTrans(cebPayBusiBo);
                this.transCebPayBusiService.createTrans(cebPayBusiBo);
                this.billPaymentTransCreateBusiService.create(paymentTrans);
            }
        }
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u5165\u5e93\u6210\u529f");
        return retBo;
    }

    private BillPaymentTransCreateReqBO buildPaymentTrans(TransCebPayBusiServiceReqBo cebPayBusiBo) {
        BillPaymentTransCreateReqBO trans = new BillPaymentTransCreateReqBO();
        trans.setBillDate(cebPayBusiBo.getBillDate());
        trans.setBillFlag(cebPayBusiBo.getBillCheckFlag());
        trans.setPaymentMchId(cebPayBusiBo.getMerId());
        trans.setTypeTransId(cebPayBusiBo.getBankNumber());
        trans.setRealFee(Long.valueOf(cebPayBusiBo.getPrice()));
        String status = cebPayBusiBo.getStatus();
        trans.setTypeOrderId(cebPayBusiBo.getOrderNumber());
        trans.setPaymentInsId(BillConstant.PaymentIns.CEB_PAY.getPaymentInsId());
        if ("1".equals(status)) {
            QueryPayTransRspBO payOrder = this.queryPayTransBusiService.queryByPayOrderId(cebPayBusiBo.getOrderNumber());
            trans.setOrderType("01");
            if (payOrder != null) {
                cebPayBusiBo.setOrderId(payOrder.getOrderId());
                trans.setBusiId(payOrder.getBusiId());
                trans.setOrderId(payOrder.getOrderId());
            }
        } else if ("3".equals(status)) {
            QueryRefundRspBO refundOrder = this.queryRefundBusiService.queryByRefundOrderId(cebPayBusiBo.getOrderNumber());
            trans.setOrderType("02");
            if (refundOrder != null) {
                cebPayBusiBo.setOrderId(refundOrder.getOrderId());
                trans.setBusiId(refundOrder.getBusiId());
                trans.setOrderId(refundOrder.getOrderId());
            }
        } else {
            throw new BillDownAndTransException("\u5149\u5927\u94f6\u884c\u8d26\u5355\u4fe1\u606f\u5165\u5e93\u5931\u8d25\uff0c\u8fd4\u56de\u4e86\u4e0d\u652f\u6301\u7684\u8ba2\u5355\u72b6\u6001\uff1a\uff08" + status + ")");
        }
        return trans;
    }

    private TransCebPayBusiServiceReqBo buildCebPayBusiBo(CebPayResultBo tempBo, Long billDate, String merId) {
        TransCebPayBusiServiceReqBo retBo = new TransCebPayBusiServiceReqBo();
        retBo.setBillDate(billDate);
        retBo.setBillCheckFlag("0");
        retBo.setOrderNumber(tempBo.getOrdernumber());
        retBo.setBankNumber(tempBo.getBanknumber());
        retBo.setPrice(tempBo.getPrice());
        retBo.setStatus(tempBo.getStatus());
        retBo.setPayDate(tempBo.getPaydate());
        retBo.setRemark1(tempBo.getRemark1());
        retBo.setRemark2(tempBo.getRemark2());
        retBo.setRemark3(tempBo.getRemark3());
        retBo.setMerId(merId);
        return retBo;
    }
}

