/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.busi.impl;

import com.alibaba.druid.util.StringUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.payment.pay.ali.model.AlipayF2FPrecreateResult;
import com.tydic.payment.pay.ali.model.AlipayTradePrecreateRequestBuilder;
import com.tydic.payment.pay.ali.model.ExtendParams;
import com.tydic.payment.pay.ali.model.GoodsDetail;
import com.tydic.payment.pay.ali.service.impl.AlipayTradeServiceImpl;
import com.tydic.payment.pay.atom.PayOrderAtomService;
import com.tydic.payment.pay.atom.PorderPayTransAtomService;
import com.tydic.payment.pay.atom.bo.PorderPayTransAtomReqBo;
import com.tydic.payment.pay.busi.AliHbfqPayBusiService;
import com.tydic.payment.pay.busi.bo.AliHbfqPayBusiReqBo;
import com.tydic.payment.pay.busi.bo.AliHbfqPayBusiRspBo;
import com.tydic.payment.pay.common.util.MoneyUtils;
import com.tydic.payment.pay.config.vo.PayPropertiesVo;
import com.tydic.payment.pay.dao.po.PorderPo;
import com.tydic.payment.pay.exception.BusinessException;
import java.math.BigDecimal;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"PAYMENT_GROUP_DEV/2.0.0/com.tydic.payment.pay.busi.AliHbfqPayBusiService"})
public class AliHbfqPayBusiServiceImpl
implements AliHbfqPayBusiService {
    private static final Logger log = LoggerFactory.getLogger(AliHbfqPayBusiServiceImpl.class);
    @Autowired
    private PayOrderAtomService payOrderAtomService;
    @Autowired
    private PayPropertiesVo payPropertiesVo;
    @Autowired
    private PorderPayTransAtomService porderPayTransAtomService;

    @PostMapping(value={"dealAliHbfq"})
    public AliHbfqPayBusiRspBo dealAliHbfq(@RequestBody AliHbfqPayBusiReqBo reqBo) {
        if (reqBo == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u652f\u4ed8\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)reqBo.getOrderId())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u652f\u4ed8\u5165\u53c2orderId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)reqBo.getMerchantId())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u652f\u4ed8\u5165\u53c2merchantId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getParamMap().isEmpty()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u652f\u4ed8\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getTotalFee() == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u652f\u4ed8\u91d1\u989d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)reqBo.getHbfqNum())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u652f\u4ed8\u5165\u53c2hbfqNum(\u82b1\u5457\u5206\u671f\u6570)\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!(reqBo.getHbfqNum().equals("3") || reqBo.getHbfqNum().equals("6") || reqBo.getHbfqNum().equals("12"))) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u652f\u4ed8\u5165\u53c2hbfqNum(\u82b1\u5457\u5206\u671f\u6570)\u53ea\u80fd\u4f20\u51653\u62166\u621612");
        }
        if (StringUtils.isEmpty((String)reqBo.getHbfqSellerPercent())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u652f\u4ed8\u5165\u53c2hbfqSellerPercent(\u627f\u62c5\u624b\u7eed\u8d39\u6bd4\u4f8b)\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!reqBo.getHbfqSellerPercent().equals("100") && !reqBo.getHbfqSellerPercent().equals("0")) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u652f\u4ed8\u5165\u53c2hbfqSellerPercent(\u627f\u62c5\u624b\u7eed\u8d39\u6bd4\u4f8b)\u53ea\u80fd\u4f20\u5165100\u62160");
        }
        AliHbfqPayBusiRspBo rspBo = new AliHbfqPayBusiRspBo();
        try {
            PorderPo pOrder = this.payOrderAtomService.queryPorderInfo(Long.parseLong(reqBo.getOrderId()));
            if (pOrder == null) {
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u672a\u67e5\u8be2\u5230\u8ba2\u5355\u4fe1\u606f");
            }
            if ("A10".equals(pOrder.getOrderStatus())) {
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8ba2\u5355\u5df2\u7ecf\u652f\u4ed8");
            }
            PorderPayTransAtomReqBo orderPayTransAtomReq = new PorderPayTransAtomReqBo();
            orderPayTransAtomReq.setOrderId(pOrder.getOrderId());
            orderPayTransAtomReq.setBusiId(pOrder.getBusiId());
            orderPayTransAtomReq.setMerchantId(pOrder.getMerchantId());
            orderPayTransAtomReq.setOrderStatus(pOrder.getOrderStatus());
            orderPayTransAtomReq.setPayMethod(Long.parseLong("26"));
            orderPayTransAtomReq.setPayFee(MoneyUtils.fenToHaoToLong((BigDecimal)reqBo.getTotalFee()));
            String outTradeNo = this.porderPayTransAtomService.createOrderPayTrans(orderPayTransAtomReq);
            ArrayList<GoodsDetail> goodsDetailList = new ArrayList<GoodsDetail>();
            String notifyUrl = this.payPropertiesVo.getAliNotifyUrl();
            log.info("\u652f\u4ed8\u5b9d\u901a\u77e5\u5730\u5740\uff1a" + notifyUrl);
            String totalAmount = MoneyUtils.fenToYuan((BigDecimal)reqBo.getTotalFee()).toString();
            String undiscountableAmount = "0.00";
            String sellerId = "";
            String body = pOrder.getDetailName();
            String operatorId = pOrder.getCreateOperId();
            String storeId = String.valueOf(pOrder.getMerchantId());
            ExtendParams extendParams = new ExtendParams().setHbfqNum(reqBo.getHbfqNum()).setHbfqSellerPercent(reqBo.getHbfqSellerPercent());
            String timeoutExpress = "3m";
            AlipayTradePrecreateRequestBuilder builder = new AlipayTradePrecreateRequestBuilder().setSubject(body).setTotalAmount(totalAmount).setOutTradeNo(outTradeNo).setUndiscountableAmount(undiscountableAmount).setSellerId(sellerId).setBody(body).setOperatorId(operatorId).setStoreId(storeId).setExtendParams(extendParams).setTimeoutExpress(timeoutExpress).setGoodsDetailList(goodsDetailList).setNotifyUrl(notifyUrl);
            AlipayTradeServiceImpl tradeService = new AlipayTradeServiceImpl.ClientBuilder().build(String.valueOf(reqBo.getParamMap().get("appid")), String.valueOf(reqBo.getParamMap().get("privateKey")), String.valueOf(reqBo.getParamMap().get("publicKey")), "");
            log.info("builder:" + JSON.toJSONString((Object)builder));
            log.info("tradeService:" + JSON.toJSONString((Object)tradeService));
            AlipayF2FPrecreateResult result = tradeService.tradePrecreate(builder);
            if (result == null) {
                log.info("\u652f\u4ed8\u5b9d\u4e0b\u5355\u8fd4\u56de\u5bf9\u8c61\u4e3a\u7a7a");
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u652f\u4ed8\u5b9d\u4e0b\u5355\u8fd4\u56de\u5bf9\u8c61\u4e3a\u7a7a");
            }
            switch (result.getTradeStatus()) {
                case SUCCESS: {
                    JSONObject json = JSONObject.parseObject((String)result.getResponse().getBody()).getJSONObject("alipay_trade_precreate_response");
                    rspBo.setRspCode("0000");
                    rspBo.setQrCode(json.getString("qr_code"));
                    rspBo.setRspName("\u652f\u4ed8\u5b9d\u4e0b\u5355\u6210\u529f");
                    break;
                }
                case FAILED: {
                    JSONObject json2 = JSONObject.parseObject((String)result.getResponse().getBody()).getJSONObject("alipay_trade_precreate_response");
                    rspBo.setRspCode("8888");
                    rspBo.setRspName(json2.getString("msg"));
                    break;
                }
                case UNKNOWN: {
                    rspBo.setRspCode("8888");
                    rspBo.setRspName("\u672a\u80fd\u8bc6\u522b\u7684\u8fd4\u56de\u9519\u8bef");
                    break;
                }
                default: {
                    rspBo.setRspCode("8888");
                    rspBo.setRspName("\u4ea4\u6613\u8fd4\u56de\u72b6\u6001\u5f02\u5e38");
                }
            }
            rspBo.setEffectiveSeconds(String.valueOf(new BigDecimal(3).multiply(new BigDecimal(60))));
            rspBo.setPayOrderId(outTradeNo);
        }
        catch (Exception e) {
            log.error("\u652f\u4ed8\u5b9d\u4e0b\u5355\u63a5\u53e3\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
            rspBo.setRspCode("8888");
            rspBo.setRspName("\u8c03\u7528\u652f\u4ed8\u5b9d\u4e0b\u5355\u5f02\u5e38" + e.getMessage());
        }
        return rspBo;
    }
}

