/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.payable.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.payment.pay.busi.bo.PayAbleDealPayReqBo;
import com.tydic.payment.pay.busi.bo.PayAbleDealPayRspBo;
import com.tydic.payment.pay.config.PayProSequence;
import com.tydic.payment.pay.config.vo.PayPropertiesVo;
import com.tydic.payment.pay.constant.PayProConstants;
import com.tydic.payment.pay.dao.PRelOrderParamMapper;
import com.tydic.payment.pay.dao.po.PRelOrderParamPO;
import com.tydic.payment.pay.exception.BusinessException;
import com.tydic.payment.pay.payable.api.PayAble;
import com.tydic.payment.pay.payable.impl.AbstractSftPayAble;
import com.tydic.payment.pay.payable.impl.transbo.SftPayReqBO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class PaySftPayAbleImpl
extends AbstractSftPayAble
implements PayAble {
    private static final Logger log = LoggerFactory.getLogger(PaySftPayAbleImpl.class);
    @Autowired
    private PayPropertiesVo payPropertiesVo;
    @Autowired
    private PRelOrderParamMapper pRelOrderParamMapper;

    public Long getPayMethod() {
        return PayProConstants.PayMethod.CBC_SFT_PAY.getPayMethod();
    }

    public PayAbleDealPayRspBo dealPay(PayAbleDealPayReqBo reqBo) {
        log.info("\u8fdb\u5165\u5584\u4ed8\u901a\u652f\u4ed8\u80fd\u529b\u5b9e\u73b0\u7c7b\uff0c\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)reqBo));
        PayAbleDealPayRspBo retBo = new PayAbleDealPayRspBo();
        String validateStr = this.validateArgs(reqBo);
        if (!StringUtils.isEmpty((Object)validateStr)) {
            log.error("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            retBo.setRespCode("8888");
            retBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            return retBo;
        }
        String requestUrl = this.payPropertiesVo.getSFTRequestUrl();
        String secretKey = this.payPropertiesVo.getSFTThirdSysId();
        if (StringUtils.isEmpty((Object)requestUrl)) {
            log.error("\u5584\u4ed8\u901a\u8bf7\u6c42\u5730\u5740(sft.request.url)\u672a\u914d\u7f6e");
            throw new BusinessException("219001", "\u5584\u4ed8\u901a\u8bf7\u6c42\u5730\u5740(sft.request.url)\u672a\u914d\u7f6e");
        }
        if (StringUtils.isEmpty((Object)secretKey)) {
            log.error("\u5584\u4ed8\u901a\u5bc6\u94a5(sft.third.sys.id)\u672a\u914d\u7f6e");
            throw new BusinessException("219001", "\u5584\u4ed8\u901a\u8bf7\u6c42\u5730\u5740(sft.third.sys.id)\u672a\u914d\u7f6e");
        }
        Long orderId = reqBo.getOrderId();
        PRelOrderParamPO relPo = new PRelOrderParamPO();
        relPo.setOrderId(orderId);
        relPo.setStatus(1);
        PRelOrderParamPO relResultPo = this.pRelOrderParamMapper.getModelBy(relPo);
        String text = relResultPo.getText();
        SftPayReqBO sftPayReqBO = (SftPayReqBO)JSONObject.parseObject((String)text, SftPayReqBO.class);
        sftPayReqBO.setTxCode("SFT10012");
        Long transId = PayProSequence.nextId();
        sftPayReqBO.setTransID(transId.toString());
        sftPayReqBO.setGoPayType("1");
        sftPayReqBO.setPayType("01");
        sftPayReqBO.setOrderIniter("0");
        sftPayReqBO.getOrderInfos().get(0).setOrder_No(reqBo.getPayOrderId());
        BeanUtils.copyProperties((Object)reqBo, (Object)retBo);
        String buildHtml = this.buildHtml("SFT10012", sftPayReqBO);
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        retBo.setHtmlBody(buildHtml);
        return retBo;
    }

    private String validateArgs(PayAbleDealPayReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getDetailName())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'detailName'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getPayFee())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'payFee'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getPayOrderId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'payOrderId'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getParaMap())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'paraMap'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }
}

