/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.bill.support.wxpay;

import com.alibaba.fastjson.JSON;
import com.tydic.payment.bill.BillExecuteRequest;
import com.tydic.payment.bill.able.BillDownAndTransAble;
import com.tydic.payment.bill.able.BillFile;
import com.tydic.payment.bill.able.BillFileInfo;
import com.tydic.payment.bill.busi.BillPaymentParamQueryBusiService;
import com.tydic.payment.bill.busi.BillPaymentTransRemoveBusiService;
import com.tydic.payment.bill.busi.BillWxPayTransRemoveBusiService;
import com.tydic.payment.bill.busi.bo.BillPaymentTransRemoveBusiReqBO;
import com.tydic.payment.bill.busi.bo.BillWxPayParam;
import com.tydic.payment.bill.busi.bo.BillWxPayTransRemoveBusiReqBO;
import com.tydic.payment.bill.comb.BillWxPayDownLoadCombService;
import com.tydic.payment.bill.comb.BillWxPayTransCombService;
import com.tydic.payment.bill.comb.bo.BillWxPayDownLoadCombReqBO;
import com.tydic.payment.bill.comb.bo.BillWxPayDownLoadCombRspBO;
import com.tydic.payment.bill.exception.BillDownAndTransException;
import com.tydic.payment.bill.util.BillFileUtils;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="billWxPayDownAndTrans")
public class BillWxPayDownAndTrans
implements BillDownAndTransAble {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private boolean isDebug = this.log.isDebugEnabled();
    @Autowired
    private BillPaymentTransRemoveBusiService billPaymentTransRemoveBusiService;
    @Autowired
    private BillWxPayTransRemoveBusiService billWxPayTransRemoveBusiService;
    @Autowired
    private BillPaymentParamQueryBusiService billPaymentParamQueryBusiService;
    @Autowired
    private BillWxPayDownLoadCombService billWxPayDownLoadCombService;
    @Autowired
    private BillWxPayTransCombService billWxPayTransCombService;

    @Override
    public BillFileInfo doDown(BillExecuteRequest request) throws BillDownAndTransException {
        BillWxPayDownLoadCombRspBO downRspBO;
        BillWxPayParam payParam = this.getPayParam(request);
        BillWxPayDownLoadCombReqBO downReqBO = new BillWxPayDownLoadCombReqBO();
        downReqBO.setAppid(payParam.getAppid());
        downReqBO.setMchid(payParam.getMchid());
        downReqBO.setKey(payParam.getSignkey());
        downReqBO.setBillDate(request.getBillDate().toString());
        downReqBO.setSubMchId("");
        try {
            downRspBO = this.billWxPayDownLoadCombService.dealWxDownLoadBill(downReqBO);
        }
        catch (Exception ex) {
            if (this.isDebug) {
                this.log.debug("\u5fae\u4fe1\u8d26\u5355\u4e0b\u8f7d\u5f02\u5e38\uff1a{}", (Throwable)ex);
            }
            throw new BillDownAndTransException("\u5fae\u4fe1\u8d26\u5355\u4e0b\u8f7d\u5f02\u5e38\uff1a" + ex.getMessage(), (Throwable)ex);
        }
        if (downRspBO == null || !Objects.equals("0000", downRspBO.getRspCode())) {
            if (this.isDebug) {
                this.log.debug("\u5fae\u4fe1\u8d26\u5355\u4e0b\u8f7d\u5931\u8d25\uff0c\u8bf7\u6c42\u53c2\u6570\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)request));
            }
            throw new BillDownAndTransException("\u5fae\u4fe1\u8d26\u5355\u4e0b\u8f7d\u5931\u8d25");
        }
        ByteArrayInputStream inputStream = new ByteArrayInputStream(downRspBO.getRspName().getBytes());
        String fileName = BillFileUtils.buildBillFileNameByRequest(request);
        BillFileInfo billFileInfo = new BillFileInfo();
        BillFile billFile = new BillFile();
        billFile.setFileName(fileName);
        billFile.setInputStream(inputStream);
        ArrayList<BillFile> billFileList = new ArrayList<BillFile>(1);
        billFileList.add(billFile);
        billFileInfo.setBillFileList(billFileList);
        billFileInfo.setBillExecuteRequest(request);
        return billFileInfo;
    }

    private BillWxPayParam getPayParam(BillExecuteRequest request) {
        Collection paymentMchList = this.billPaymentParamQueryBusiService.query(BillWxPayParam.class, request.getPaymentInsId());
        if (paymentMchList == null || paymentMchList.size() < 1) {
            throw new BillDownAndTransException("\u4e0b\u8f7d\u5fae\u4fe1\u8d26\u5355\u5931\u8d25\uff0c\u67e5\u8be2\u5546\u6237\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        for (BillWxPayParam payParam : paymentMchList) {
            if (!Objects.equals(request.getPaymentMchId(), payParam.getMchid())) continue;
            return payParam;
        }
        throw new BillDownAndTransException("\u4e0b\u8f7d\u5fae\u4fe1\u8d26\u5355\u5931\u8d25\uff0c\u67e5\u8be2[" + request.getPaymentMchId() + "]\u5546\u6237\u4fe1\u606f\u4e3a\u7a7a\uff01");
    }

    @Override
    public void doTrans(BillFileInfo billFileInfo) throws BillDownAndTransException {
        for (BillFile billFile : billFileInfo.getBillFileList()) {
            InputStreamReader reader = new InputStreamReader(billFile.getInputStream());
            BufferedReader bufferedReader = new BufferedReader(reader);
            try {
                String content;
                bufferedReader.readLine();
                while ((content = bufferedReader.readLine()) != null && content.contains("`")) {
                    this.billWxPayTransCombService.trans(content);
                }
            }
            catch (Exception ex) {
                throw new BillDownAndTransException("\u5fae\u4fe1\u652f\u4ed8\u8d26\u5355\u6570\u636e\u5165\u5e93\u5f02\u5e38\uff1a" + ex.getMessage(), (Throwable)ex);
            }
            try {
                bufferedReader.close();
                ((Reader)reader).close();
                billFile.getInputStream().close();
            }
            catch (IOException ex) {
                this.log.warn("\u5173\u95ed\u5fae\u4fe1\u652f\u4ed8\u8d26\u5355\u6570\u636e\u8bfb\u53d6\u6d41\u5f02\u5e38\uff1a" + ex.getMessage());
            }
        }
    }

    @Override
    public void doDownAndTransClean(BillExecuteRequest request) throws BillDownAndTransException {
        BillPaymentTransRemoveBusiReqBO paymentReqBO = new BillPaymentTransRemoveBusiReqBO();
        paymentReqBO.setBillDate(request.getBillDate());
        paymentReqBO.setPaymentInsId(request.getPaymentInsId());
        paymentReqBO.setPaymentMchId(request.getPaymentMchId());
        this.billPaymentTransRemoveBusiService.removeBatch(paymentReqBO);
        BillWxPayTransRemoveBusiReqBO reqBO = new BillWxPayTransRemoveBusiReqBO();
        reqBO.setBillDate(request.getBillDate());
        reqBO.setPaymentInsId(request.getPaymentInsId());
        reqBO.setPaymentMchId(request.getPaymentMchId());
        this.billWxPayTransRemoveBusiService.removeBatch(reqBO);
    }
}

