/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.ability.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSONObject;
import com.tydic.payment.pay.ability.ImmediatelyPayAbilityService;
import com.tydic.payment.pay.ability.bo.ImmediatelyPayAbilityServiceReqBo;
import com.tydic.payment.pay.ability.bo.ImmediatelyPayAbilityServiceRspBo;
import com.tydic.payment.pay.ability.impl.ExternalQueryAbilitySeriveImpl;
import com.tydic.payment.pay.busi.OrderQueryConstructionBusiService;
import com.tydic.payment.pay.busi.PayOrderBusiService;
import com.tydic.payment.pay.busi.bo.OrderQueryConstructionReqBo;
import com.tydic.payment.pay.busi.bo.OrderQueryConstructionRspBo;
import com.tydic.payment.pay.busi.bo.PayOrderRspBo;
import com.tydic.payment.pay.comb.UniPayCombService;
import com.tydic.payment.pay.comb.bo.UniPayCombReqBO;
import com.tydic.payment.pay.comb.bo.UniPayCombRspBO;
import com.tydic.payment.pay.common.util.MoneyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="immediatelyPayAbilityService")
@HSFProvider(serviceVersion="2.0.0", serviceGroup="PAYMENT_GROUP_DEV", serviceInterface=ImmediatelyPayAbilityService.class)
public class ImmediatelyPayAbilityServiceImpl
implements ImmediatelyPayAbilityService {
    private static final Logger LOG = LoggerFactory.getLogger(ExternalQueryAbilitySeriveImpl.class);
    @Autowired
    private OrderQueryConstructionBusiService orderQueryConstructionBusiService;
    @Autowired
    private PayOrderBusiService payOrderBusiService;
    @Autowired
    private UniPayCombService uniPayCombService;

    public ImmediatelyPayAbilityServiceRspBo dealPay(ImmediatelyPayAbilityServiceReqBo payBo) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("\u7acb\u5373\u652f\u4ed8\u63a5\u53e3\u5165\u53c2\u4e3a\uff1a " + JSONObject.toJSONString((Object)payBo));
        }
        ImmediatelyPayAbilityServiceRspBo rspBo = new ImmediatelyPayAbilityServiceRspBo();
        if (StringUtils.isEmpty((Object)payBo.getOutOrderId())) {
            rspBo.setRspCode("8888");
            rspBo.setRspName("\u7acb\u5373\u652f\u4ed8\u63a5\u53e3\u8c03\u7528\u5931\u8d25");
            rspBo.setPayResultCode("FAIL");
            rspBo.setMsg("\u7acb\u5373\u652f\u4ed8\u63a5\u53e3\uff1a\u5165\u53c2outorderId \u4e0d\u80fd\u4e3a\u7a7a");
            return rspBo;
        }
        if (StringUtils.isEmpty((Object)payBo.getPayMethod())) {
            rspBo.setRspCode("8888");
            rspBo.setRspName("\u7acb\u5373\u652f\u4ed8\u63a5\u53e3\u8c03\u7528\u5931\u8d25");
            rspBo.setPayResultCode("FAIL");
            rspBo.setMsg("\u7acb\u5373\u652f\u4ed8\u63a5\u53e3\uff1a\u652f\u4ed8\u65b9\u5f0f payMethod \u4e0d\u80fd\u4e3a\u7a7a");
            return rspBo;
        }
        if (!"30".equals(payBo.getPayMethod()) && StringUtils.isEmpty((Object)payBo.getAuthCode())) {
            rspBo.setRspCode("8888");
            rspBo.setRspName("\u7acb\u5373\u652f\u4ed8\u63a5\u53e3\u8c03\u7528\u5931\u8d25");
            rspBo.setPayResultCode("FAIL");
            rspBo.setMsg("\u7acb\u5373\u652f\u4ed8\u63a5\u53e3\uff1a\u6263\u6b3e\u6761\u5f62\u7801 \u4e0d\u80fd\u4e3a\u7a7a");
            return rspBo;
        }
        if (StringUtils.isEmpty((Object)payBo.getBusiId())) {
            rspBo.setRspCode("8888");
            rspBo.setRspName("\u7acb\u5373\u652f\u4ed8\u63a5\u53e3\u8c03\u7528\u5931\u8d25");
            rspBo.setPayResultCode("FAIL");
            rspBo.setMsg("\u7acb\u5373\u652f\u4ed8\u63a5\u53e3\uff1abusiId \u4e0d\u80fd\u4e3a\u7a7a");
            return rspBo;
        }
        OrderQueryConstructionReqBo orderQueryConstructionReqBo = new OrderQueryConstructionReqBo();
        orderQueryConstructionReqBo.setBusiId(Long.valueOf(Long.parseLong(payBo.getBusiId())));
        orderQueryConstructionReqBo.setOutOrderId(payBo.getOutOrderId());
        OrderQueryConstructionRspBo rsp = this.orderQueryConstructionBusiService.queryConstruction(orderQueryConstructionReqBo);
        if (!"0000".equals(rsp.getRspCode())) {
            rspBo.setRspCode("8888");
            rspBo.setRspName("\u7acb\u5373\u652f\u4ed8\u63a5\u53e3\u8c03\u7528\u5931\u8d25");
            rspBo.setPayResultCode("FAIL");
            rspBo.setMsg("\u672a\u67e5\u8be2\u5230\u9884\u521b\u5efa\u8ba2\u5355ID  - outOrderId =" + payBo.getOutOrderId());
            return rspBo;
        }
        PayOrderRspBo payOrderRspBo = this.payOrderBusiService.selectOrderByOrderId(rsp.getOrderId());
        if (!"01".equals(payOrderRspBo.getOrderType())) {
            rspBo.setRspCode("8888");
            rspBo.setRspName("\u7acb\u5373\u652f\u4ed8\u63a5\u53e3\u8c03\u7528\u5931\u8d25");
            rspBo.setPayResultCode("FAIL");
            rspBo.setMsg("\u8ba2\u5355ID\uff1aoutOrderId =" + payBo.getOutOrderId() + "\u975e\u652f\u4ed8\u8ba2\u5355");
            return rspBo;
        }
        if ("A10".equals(payOrderRspBo.getOrderStatus())) {
            rspBo.setRspName("\u7acb\u5373\u652f\u4ed8\u63a5\u53e3\u8c03\u7528\u5931\u8d25");
            rspBo.setPayResultCode("FAIL");
            rspBo.setMsg("\u8ba2\u5355\u5df2\u7ecf\u652f\u4ed8\u6210\u529f\uff0c\u8bf7\u52ff\u91cd\u590d\u652f\u4ed8");
            return rspBo;
        }
        UniPayCombReqBO uniPayCombReqBO = new UniPayCombReqBO();
        uniPayCombReqBO.setAuthCode(payBo.getAuthCode());
        uniPayCombReqBO.setOrderId(String.valueOf(rsp.getOrderId()));
        uniPayCombReqBO.setPayMethod(payBo.getPayMethod());
        uniPayCombReqBO.setRealFee(MoneyUtils.haoToFen((Long)payOrderRspBo.getTotalFee()).toString());
        UniPayCombRspBO uniPayCombRspBO = new UniPayCombRspBO();
        try {
            uniPayCombRspBO = this.uniPayCombService.dealUniPay(uniPayCombReqBO);
        }
        catch (Exception e) {
            LOG.error("\u7edf\u4e00\u652f\u4ed8\u5931\u8d25");
        }
        rspBo.setRspCode(uniPayCombRspBO.getRspCode());
        rspBo.setRspName(uniPayCombRspBO.getRspName());
        rspBo.setPayResultCode(uniPayCombRspBO.getPayStatus());
        rspBo.setPayNotifyTransId(uniPayCombRspBO.getPayNotifyTransId());
        if ("8888".equals(uniPayCombRspBO.getRspCode())) {
            rspBo.setMsg(uniPayCombRspBO.getRspName());
        }
        return rspBo;
    }
}

