/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.ability.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSON;
import com.tydic.payment.pay.ability.PayProAbleQueryOrderStatusAbilityService;
import com.tydic.payment.pay.ability.bo.PayProAbleQueryOrderStatusAbilityReqBo;
import com.tydic.payment.pay.ability.bo.PayProAbleQueryOrderStatusAbilityRspBo;
import com.tydic.payment.pay.atom.MerchantInfoAtomService;
import com.tydic.payment.pay.atom.PayMethodAtomService;
import com.tydic.payment.pay.atom.PaymentInsAtomService;
import com.tydic.payment.pay.busi.PayProOrderQueryBusiService;
import com.tydic.payment.pay.busi.PayProQueryInfoBusiSystemByConditionService;
import com.tydic.payment.pay.busi.bo.PayProOrderQueryBusiReqBo;
import com.tydic.payment.pay.busi.bo.PayProOrderQueryByOutOrderIdAndBusiIdBusiRspBo;
import com.tydic.payment.pay.busi.bo.PayProQueryInfoBusiSystemByConditionBusiInfoRspBo;
import com.tydic.payment.pay.comb.PayAbleQryPayStatusCombService;
import com.tydic.payment.pay.comb.bo.PayAbleQryPayStatusCombReqBo;
import com.tydic.payment.pay.comb.bo.PayAbleQryPayStatusCombRspBo;
import com.tydic.payment.pay.dao.po.MerChantInfoPo;
import com.tydic.payment.pay.dao.po.PayMethodPo;
import com.tydic.payment.pay.dao.po.PaymentInsPo;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
@HSFProvider(serviceVersion="2.0.0", serviceGroup="PAYMENT_GROUP_DEV", serviceInterface=PayProAbleQueryOrderStatusAbilityService.class)
public class PayProAbleQueryOrderStatusAbilityServiceImpl
implements PayProAbleQueryOrderStatusAbilityService {
    private static final Logger LOG = LoggerFactory.getLogger(PayProAbleQueryOrderStatusAbilityServiceImpl.class);
    @Autowired
    private PayAbleQryPayStatusCombService payAbleQryPayStatusCombService;
    @Autowired
    private PayProQueryInfoBusiSystemByConditionService queryInfoBusiSystemByConditionService;
    @Autowired
    private PayProOrderQueryBusiService payProOrderQueryBusiService;
    @Autowired
    private MerchantInfoAtomService merchantInfoAtomService;
    @Autowired
    private PaymentInsAtomService paymentInsAtomService;
    @Autowired
    private PayMethodAtomService payMethodAtomService;

    public PayProAbleQueryOrderStatusAbilityRspBo queryStatus(PayProAbleQueryOrderStatusAbilityReqBo reqBo) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("\u67e5\u8be2\u652f\u4ed8\u72b6\u6001abilityService\u5165\u53c2\uff1a" + JSON.toJSONString((Object)reqBo));
        }
        PayProAbleQueryOrderStatusAbilityRspBo retBo = new PayProAbleQueryOrderStatusAbilityRspBo();
        String validateArgStr = this.validateArg(reqBo);
        if (!StringUtils.isEmpty((Object)validateArgStr)) {
            retBo.setRespCode("214008");
            retBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateArgStr);
            return retBo;
        }
        String busiCode = reqBo.getBusiCode();
        PayProQueryInfoBusiSystemByConditionBusiInfoRspBo busiCodeRspBo = this.queryInfoBusiSystemByConditionService.queryBusiSysByBusiCode(busiCode);
        if (!"0000".equals(busiCodeRspBo.getRespCode())) {
            retBo.setRespCode("214008");
            retBo.setRespDesc("\u67e5\u8be2\u4e1a\u52a1\u7cfb\u7edf\u5931\u8d25:" + busiCodeRspBo.getRespDesc());
            return retBo;
        }
        if (!"1".equals(busiCodeRspBo.getState())) {
            retBo.setRespCode("214008");
            retBo.setRespDesc("\u8be5\u4e1a\u52a1\u7cfb\u7edf(" + busiCode + ")\u5df2\u5931\u6548");
            return retBo;
        }
        Long busiId = busiCodeRspBo.getBusiId();
        PayProOrderQueryBusiReqBo qryOrderBo = new PayProOrderQueryBusiReqBo();
        qryOrderBo.setBusiId(busiId);
        qryOrderBo.setOutOrderId(reqBo.getOriOrderId());
        PayProOrderQueryByOutOrderIdAndBusiIdBusiRspBo qryOrderBoRetBo = this.payProOrderQueryBusiService.queryOrderQueryByBusiIdAndOutOrderId(qryOrderBo);
        if (!"0000".equals(qryOrderBoRetBo.getRespCode())) {
            retBo.setRespCode("214008");
            retBo.setRespDesc("\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f\u5931\u8d25:" + qryOrderBoRetBo.getRespDesc());
            return retBo;
        }
        PayAbleQryPayStatusCombReqBo queryBo = new PayAbleQryPayStatusCombReqBo();
        BeanUtils.copyProperties((Object)reqBo, (Object)queryBo);
        queryBo.setOrderId(qryOrderBoRetBo.getOrderId());
        PayAbleQryPayStatusCombRspBo payAbleQryPayStatusCombRspBo = this.payAbleQryPayStatusCombService.qryOrderStatus(queryBo);
        if (!"0000".equals(payAbleQryPayStatusCombRspBo.getRespCode())) {
            retBo.setRespCode("214008");
            retBo.setRespDesc(payAbleQryPayStatusCombRspBo.getRespDesc());
            return retBo;
        }
        this.assignment(payAbleQryPayStatusCombRspBo, retBo);
        return retBo;
    }

    private void assignment(PayAbleQryPayStatusCombRspBo combRspBo, PayProAbleQueryOrderStatusAbilityRspBo retBo) {
        MerChantInfoPo merChantInfo;
        BeanUtils.copyProperties((Object)combRspBo, (Object)retBo);
        retBo.setOrderId(combRspBo.getOrderId() != null ? combRspBo.getOrderId() + "" : null);
        Long merchantId = combRspBo.getMerchantId();
        Long payMethod = combRspBo.getPayMethod();
        if (null != merchantId && null != (merChantInfo = this.merchantInfoAtomService.queryMerchantInfoById(merchantId))) {
            retBo.setMerchantId(merchantId.toString());
            retBo.setMerchantName(merChantInfo.getMerchantName());
        }
        if (null != payMethod) {
            PayMethodPo methodInfo = this.payMethodAtomService.queryPayMethodById(payMethod);
            if (null != methodInfo) {
                retBo.setPayMethod(payMethod.toString());
                retBo.setPayMethodName(methodInfo.getPayMethodName());
            }
            PaymentInsPo paymentInsPo = new PaymentInsPo();
            paymentInsPo.setPaymentInsId(methodInfo.getPaymentInsId());
            List<PaymentInsPo> paymentInsList = this.paymentInsAtomService.queryPaymentInf(paymentInsPo);
            if (!CollectionUtils.isEmpty(paymentInsList)) {
                PaymentInsPo paymentInsInfo = paymentInsList.get(0);
                retBo.setPaymentInsId(paymentInsInfo.getPaymentInsId().toString());
                retBo.setPaymentInsName(paymentInsInfo.getPaymentInsName());
            }
        }
    }

    private String validateArg(PayProAbleQueryOrderStatusAbilityReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getBusiCode())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027busiCode\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getOriOrderId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027oriOrderId\u4e0d\u80fd\u4e3a\u7a7a ";
        }
        return null;
    }
}

