/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.ability.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.payment.pay.ability.PayProAbleQueryOrderStatusAbilityService;
import com.tydic.payment.pay.ability.PayProAbleQueryOrderStatusEncryptAbilityService;
import com.tydic.payment.pay.ability.bo.PayProAbleQueryOrderStatusAbilityReqBo;
import com.tydic.payment.pay.ability.bo.PayProAbleQueryOrderStatusAbilityRspBo;
import com.tydic.payment.pay.ability.bo.PayProAbleQueryOrderStatusEncryptAbilityReqBo;
import com.tydic.payment.pay.ability.bo.PayProAbleQueryOrderStatusEncryptAbilityRspBo;
import com.tydic.payment.pay.busi.DataEncryptionService;
import com.tydic.payment.pay.busi.DataValidationService;
import com.tydic.payment.pay.busi.PayProQueryInfoBusiSystemByConditionService;
import com.tydic.payment.pay.busi.bo.DataEncryptionReqBo;
import com.tydic.payment.pay.busi.bo.DataEncryptionRspBo;
import com.tydic.payment.pay.busi.bo.DataValidationReqBO;
import com.tydic.payment.pay.busi.bo.DataValidationRspBO;
import com.tydic.payment.pay.busi.bo.PayProQueryInfoBusiSystemByConditionBusiInfoRspBo;
import com.tydic.payment.pay.common.util.MapUtils;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
@HSFProvider(serviceVersion="2.0.0", serviceGroup="PAYMENT_GROUP_DEV", serviceInterface=PayProAbleQueryOrderStatusEncryptAbilityService.class)
public class PayProAbleQueryOrderStatusEncryptAbilityServiceImpl
implements PayProAbleQueryOrderStatusEncryptAbilityService {
    private static final Logger LOG = LoggerFactory.getLogger(PayProAbleQueryOrderStatusEncryptAbilityServiceImpl.class);
    private static final String SERVICE_NAME = "\u4ea7\u54c1\u52a0\u5bc6\u67e5\u8be2\u652f\u4ed8\u72b6\u6001ability\u670d\u52a1";
    @Autowired
    private PayProAbleQueryOrderStatusAbilityService payProAbleQueryOrderStatusAbilityService;
    @Autowired
    private PayProQueryInfoBusiSystemByConditionService queryInfoBusiSystemByConditionService;
    @Autowired
    private DataValidationService dataValidationService;
    @Autowired
    private DataEncryptionService dataEncryptionService;

    public PayProAbleQueryOrderStatusEncryptAbilityRspBo queryStatus(PayProAbleQueryOrderStatusEncryptAbilityReqBo reqBo) {
        PayProAbleQueryOrderStatusAbilityReqBo orderBo;
        DataValidationRspBO dataValidationRspBO;
        if (LOG.isDebugEnabled()) {
            LOG.debug("\u67e5\u8be2\u652f\u4ed8\u72b6\u6001abilityService\u5165\u53c2\uff1a" + JSON.toJSONString((Object)reqBo));
        }
        PayProAbleQueryOrderStatusEncryptAbilityRspBo retBo = new PayProAbleQueryOrderStatusEncryptAbilityRspBo();
        String validateArgStr = this.validateArg(reqBo);
        if (!StringUtils.isEmpty((Object)validateArgStr)) {
            retBo.setRespCode("214014");
            retBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateArgStr);
            return retBo;
        }
        String busiCode = reqBo.getBusiCode();
        PayProQueryInfoBusiSystemByConditionBusiInfoRspBo busiCodeRspBo = this.queryInfoBusiSystemByConditionService.queryBusiSysByBusiCode(busiCode);
        if (!"0000".equals(busiCodeRspBo.getRespCode())) {
            retBo.setRespCode("214014");
            retBo.setRespDesc("\u67e5\u8be2\u4e1a\u52a1\u7cfb\u7edf\u5931\u8d25:" + busiCodeRspBo.getRespDesc());
            return retBo;
        }
        if (!"1".equals(busiCodeRspBo.getState())) {
            retBo.setRespCode("214014");
            retBo.setRespDesc("\u8be5\u4e1a\u52a1\u7cfb\u7edf(" + busiCode + ")\u5df2\u5931\u6548");
            return retBo;
        }
        DataValidationReqBO dataValidationReqBO = new DataValidationReqBO();
        dataValidationReqBO.setBusiId(busiCodeRspBo.getBusiId() + "");
        dataValidationReqBO.setContent(reqBo.getContent());
        try {
            dataValidationRspBO = this.dataValidationService.validation(dataValidationReqBO);
        }
        catch (Exception e) {
            LOG.error("\u4ea7\u54c1\u52a0\u5bc6\u67e5\u8be2\u652f\u4ed8\u72b6\u6001ability\u670d\u52a1 -> \u89e3\u5bc6\u5f02\u5e38\uff1a" + e);
            retBo.setRespCode("214014");
            retBo.setRespDesc("\u89e3\u5bc6\u5f02\u5e38\uff1a" + e.getMessage());
            return retBo;
        }
        if (!"0000".equals(dataValidationRspBO.getRspCode())) {
            LOG.error("\u4ea7\u54c1\u52a0\u5bc6\u67e5\u8be2\u652f\u4ed8\u72b6\u6001ability\u670d\u52a1 -> \u89e3\u5bc6\u5931\u8d25:" + JSON.toJSONString((Object)dataValidationRspBO));
            retBo.setRespCode("214014");
            retBo.setRespDesc(dataValidationRspBO.getRspName());
            return retBo;
        }
        if (!dataValidationRspBO.isSign()) {
            retBo.setRespCode("214014");
            retBo.setRespDesc("\u9a8c\u8bc1\u7b7e\u540d\u4e0d\u901a\u8fc7");
            return retBo;
        }
        try {
            orderBo = (PayProAbleQueryOrderStatusAbilityReqBo)MapUtils.mapToObject((Map)dataValidationRspBO.getContentMap(), PayProAbleQueryOrderStatusAbilityReqBo.class);
            orderBo.setBusiCode(reqBo.getBusiCode());
        }
        catch (Exception e) {
            retBo.setRespCode("214014");
            retBo.setRespDesc("\u4ea7\u54c1\u52a0\u5bc6\u67e5\u8be2\u652f\u4ed8\u72b6\u6001ability\u670d\u52a1 -> \u89e3\u5bc6\u540e\u8f6c\u6362\u5bf9\u8c61\u5f02\u5e38\uff1a" + e);
            return retBo;
        }
        PayProAbleQueryOrderStatusAbilityRspBo rspBo = this.payProAbleQueryOrderStatusAbilityService.queryStatus(orderBo);
        if (!"0000".equals(rspBo.getRespCode())) {
            retBo.setRespCode("214014");
            retBo.setRespDesc(rspBo.getRespDesc());
            return retBo;
        }
        DataEncryptionReqBo dataEncryptionReqBo = new DataEncryptionReqBo();
        JSONObject content = JSONObject.parseObject((String)JSONObject.toJSONString((Object)rspBo));
        content.remove((Object)"respCode");
        content.remove((Object)"respDesc");
        dataEncryptionReqBo.setBusiId(busiCodeRspBo.getBusiId() + "");
        dataEncryptionReqBo.setContent(content.toString());
        DataEncryptionRspBo dataEncryptionRspBo = this.dataEncryptionService.dataEncryption(dataEncryptionReqBo);
        if (!"0000".equals(dataEncryptionRspBo.getRspCode())) {
            retBo.setRespCode("214014");
            retBo.setRespDesc("\u4ea7\u54c1\u52a0\u5bc6\u67e5\u8be2\u652f\u4ed8\u72b6\u6001ability\u670d\u52a1 -> RSA\u52a0\u5bc6\u5f02\u5e38\uff1a" + dataEncryptionRspBo.getRspName());
            return retBo;
        }
        retBo.setBusiCode(reqBo.getBusiCode());
        retBo.setContent(dataEncryptionRspBo.getEncrypData());
        retBo.setRespDesc(rspBo.getRespDesc());
        retBo.setRespCode("0000");
        return retBo;
    }

    private String validateArg(PayProAbleQueryOrderStatusEncryptAbilityReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getBusiCode())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027\uff08busiCode\uff09\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getContent())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027\uff08content\uff09\u4e0d\u80fd\u4e3a\u7a7a ";
        }
        return null;
    }
}

