/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.busi.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.tydic.payment.pay.ali.model.AlipayTradeWapPayRequestBuilder;
import com.tydic.payment.pay.ali.model.AlipayWapPayResult;
import com.tydic.payment.pay.ali.model.ExtendParams;
import com.tydic.payment.pay.ali.service.impl.AlipayTradeServiceImpl;
import com.tydic.payment.pay.atom.PayOrderAtomService;
import com.tydic.payment.pay.atom.PorderPayTransAtomService;
import com.tydic.payment.pay.atom.bo.PorderPayTransAtomReqBo;
import com.tydic.payment.pay.busi.AliH5PayBusiService;
import com.tydic.payment.pay.busi.QueryCashierService;
import com.tydic.payment.pay.busi.bo.AliH5PayBusiReqBO;
import com.tydic.payment.pay.busi.bo.AliH5PayBusiRspBO;
import com.tydic.payment.pay.busi.bo.QueryCashierReqBo;
import com.tydic.payment.pay.busi.bo.QueryCashierRspBo;
import com.tydic.payment.pay.common.util.MoneyUtils;
import com.tydic.payment.pay.common.util.OrderCiphertext;
import com.tydic.payment.pay.config.vo.PayPropertiesVo;
import com.tydic.payment.pay.dao.po.PorderPo;
import com.tydic.payment.pay.exception.BusinessException;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="aliH5PayBusiService")
@HSFProvider(serviceVersion="2.0.0", serviceGroup="PAYMENT_GROUP_DEV", serviceInterface=AliH5PayBusiService.class)
public class AliH5PayBusiServiceImpl
implements AliH5PayBusiService {
    private static final Logger log = LoggerFactory.getLogger(AliH5PayBusiServiceImpl.class);
    @Autowired
    private PayOrderAtomService payOrderAtomService;
    @Autowired
    private PayPropertiesVo payPropertiesVo;
    @Autowired
    private PorderPayTransAtomService porderPayTransAtomService;
    @Autowired
    private QueryCashierService queryCashierService;

    public AliH5PayBusiRspBO dealAliH5Pay(AliH5PayBusiReqBO req) throws Exception {
        log.info("\u8fdb\u5165\u652f\u4ed8\u5b9d\u624b\u673a\u7f51\u7ad9\u652f\u4ed8\uff08h5\u652f\u4ed8\uff09\u4e1a\u52a1\u670d\u52a1----->" + req);
        if (req == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u652f\u4ed8\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)req.getOrderId())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u652f\u4ed8\u5165\u53c2\u4e0d orderId\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)req.getMerchantId())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u652f\u4ed8\u5165\u53c2\u4e0d merchantId\u80fd\u4e3a\u7a7a");
        }
        if (req.getParamMap().isEmpty()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u652f\u4ed8\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (req.getTotalFee() == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u652f\u4ed8\u91d1\u989d\u80fd\u4e3a\u7a7a");
        }
        PorderPo orderInfo = this.payOrderAtomService.queryPorderInfo(Long.valueOf(req.getOrderId()));
        if (orderInfo == null) {
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u6839\u636e\u8ba2\u5355id\u3010ORDER_ID=" + req.getOrderId() + "\u3011\u67e5\u8be2\u4e0d\u5230\u8ba2\u5355\u4fe1\u606f\uff01");
        }
        PorderPayTransAtomReqBo orderPayTransAtomReq = new PorderPayTransAtomReqBo();
        orderPayTransAtomReq.setOrderId(orderInfo.getOrderId());
        orderPayTransAtomReq.setBusiId(orderInfo.getBusiId());
        orderPayTransAtomReq.setMerchantId(Long.parseLong(req.getMerchantId()));
        orderPayTransAtomReq.setPayMethod(Long.parseLong("23"));
        orderPayTransAtomReq.setOrderStatus("A00");
        orderPayTransAtomReq.setPayFee(MoneyUtils.fenToHaoToLong((BigDecimal)req.getTotalFee()));
        String outTradeNo = this.porderPayTransAtomService.createOrderPayTrans(orderPayTransAtomReq);
        ArrayList goodsDetailList = new ArrayList();
        String notifyUrl = this.payPropertiesVo.getAliNotifyUrl();
        String totalAmount = MoneyUtils.fenToYuan((BigDecimal)req.getTotalFee()).toString();
        String body = orderInfo.getDetailName();
        String storeId = String.valueOf(orderInfo.getMerchantId());
        String secOrderId = OrderCiphertext.encode((byte[])String.valueOf(req.getOrderId()).getBytes());
        String returnUrl = this.payPropertiesVo.getPayAccessIp() + this.payPropertiesVo.getPayAccessProjectName() + "/html/app/cashierDesk.html?orderId=" + secOrderId;
        if (!StringUtils.isEmpty((Object)req.getReturnUrl())) {
            returnUrl = new StringBuffer(this.payPropertiesVo.getPayAccessIp()).append(this.payPropertiesVo.getPayAccessProjectName()).append(req.getReturnUrl()).append("?payOrderId=").append(outTradeNo).append("&orderId=").append(req.getOrderId()).append("&totalFee=").append(req.getTotalFee()).append("&detailName=").append(URLEncoder.encode(orderInfo.getDetailName(), "utf-8")).append("&redirectUrl=").append(URLEncoder.encode(orderInfo.getRedirectUrl(), "utf-8")).toString();
        }
        log.info("\u652f\u4ed8\u5b9d\u624b\u673a\u7f51\u7ad9\u652f\u4ed8\uff08h5\u652f\u4ed8\uff09\u4e1a\u52a1\u670d\u52a1 -> \u4f20\u7ed9\u652f\u4ed8\u5b9d\u7684\u56de\u8c03\u5730\u5740\u4e3a\uff1a" + returnUrl);
        AliH5PayBusiRspBO rsp = new AliH5PayBusiRspBO();
        QueryCashierReqBo queryCashierReqBo = new QueryCashierReqBo();
        queryCashierReqBo.setBusiId(orderInfo.getBusiId() + "");
        queryCashierReqBo.setReqWay("3");
        QueryCashierRspBo queryCashierRspBo = this.queryCashierService.queryCashier(queryCashierReqBo);
        if (!"0000".equals(queryCashierRspBo.getRspCode())) {
            rsp.setRspCode(queryCashierRspBo.getRspCode());
            rsp.setRspName(queryCashierRspBo.getRspName());
            return rsp;
        }
        if (!StringUtils.isEmpty((Object)this.payPropertiesVo.getValueByKey("pay.h5.result.url"))) {
            log.info("\u4f7f\u7528\u914d\u7f6e\u6587\u4ef6\u7684H5\u8df3\u8f6c\u9875\u9762\u4f5c\u4e3a\u652f\u4ed8\u5b9dH5\u652f\u4ed8\u7684\u8df3\u8f6c\u9875\u9762\uff1a" + this.payPropertiesVo.getValueByKey("pay.h5.result.url"));
            returnUrl = this.payPropertiesVo.getValueByKey("pay.h5.result.url") + "?orderId=" + orderInfo.getOrderId();
        } else {
            log.info("\u4f7f\u7528\u6536\u94f6\u53f0H5\u5730\u5740\u4f5c\u4e3a\u652f\u4ed8\u5b9dH5\u652f\u4ed8\u7684\u8df3\u8f6c\u9875\u9762");
            String cashierTemplateUrl = queryCashierRspBo.getCashierTemplateUrl();
            if (StringUtils.isEmpty((Object)cashierTemplateUrl)) {
                rsp.setRspCode("8888");
                rsp.setRspName("\u8be5\u63a5\u5165\u65b9\u5f0f\u5bf9\u5e94\u7684\u6536\u94f6\u53f0\u6ca1\u6709\u914d\u7f6e\u6536\u94f6\u53f0\u5730\u5740");
                return rsp;
            }
            String secreteOrde = OrderCiphertext.encode((byte[])req.getOrderId().getBytes());
            returnUrl = cashierTemplateUrl + "?orderId=" + secreteOrde;
        }
        log.info("\u9875\u9762\u5de5\u7a0b\u83b7\u53d6\u652f\u4ed8\u5b9dH5\u652f\u4ed8\u9875\u9762\u56de\u8c03\u5730\u5740\u4e3a\uff1a" + returnUrl);
        ExtendParams extendParams = null;
        String timeoutExpress = "2m";
        AlipayTradeWapPayRequestBuilder builder = new AlipayTradeWapPayRequestBuilder().setSubject(body).setTotalAmount(totalAmount).setOutTradeNo(outTradeNo).setBody(body).setStoreId(storeId).setExtendParams(extendParams).setTimeoutExpress(timeoutExpress).setNotifyUrl(notifyUrl).setRerutnUrl(returnUrl);
        AlipayTradeServiceImpl tradeService = new AlipayTradeServiceImpl.ClientBuilder().build(String.valueOf(req.getParamMap().get("appid")), String.valueOf(req.getParamMap().get("privateKey")), String.valueOf(req.getParamMap().get("publicKey")), "H5");
        AlipayWapPayResult result = tradeService.h5Pay(builder);
        rsp.setPayOrderId(outTradeNo);
        if (result == null) {
            log.info("\u652f\u4ed8\u5b9d\u624b\u673a\u7f51\u7ad9\u652f\u4ed8\u4e0b\u5355\u5931\u8d25");
            rsp.setRspCode("8888");
            rsp.setRspName("\u652f\u4ed8\u5b9d\u624b\u673a\u7f51\u7ad9\u652f\u4ed8\u4e0b\u5355\u5931\u8d25");
            rsp.setPayStatus("FAIL");
            return rsp;
        }
        if (result.getResponse() == null) {
            log.info("\u652f\u4ed8\u5b9d\u624b\u673a\u7f51\u7ad9\u652f\u4ed8\u4e0b\u5355\u5931\u8d25");
            rsp.setRspCode("8888");
            rsp.setRspName("\u652f\u4ed8\u5b9d\u624b\u673a\u7f51\u7ad9\u652f\u4ed8\u4e0b\u5355\u5931\u8d25");
            rsp.setPayStatus("FAIL");
            return rsp;
        }
        if (result.getResponse().getErrorCode() != null) {
            log.info("\u652f\u4ed8\u5b9d\u624b\u673a\u7f51\u7ad9\u652f\u4ed8\u4e0b\u5355\u5931\u8d25\uff1a" + result.getResponse().getMsg());
            rsp.setRspCode("8888");
            rsp.setRspName(result.getResponse().getMsg());
            rsp.setPayStatus("FAIL");
            return rsp;
        }
        if (result.getResponse().getBody() != null) {
            log.info("\u652f\u4ed8\u5b9d\u624b\u673a\u7f51\u7ad9\u652f\u4ed8\u4e0b\u5355\u6210\u529f");
            rsp.setRspCode("0000");
            rsp.setPayStatus("SUCCESS");
            rsp.setBody(result.getResponse().getBody());
            rsp.setRspName("\u652f\u4ed8\u5b9d\u624b\u673a\u7f51\u7ad9\u652f\u4ed8\u4e0b\u5355\u6210\u529f");
        }
        return rsp;
    }
}

