/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.busi.impl;

import com.tydic.payment.pay.atom.PayOrderAtomService;
import com.tydic.payment.pay.atom.PorderPayTransAtomService;
import com.tydic.payment.pay.atom.bo.PorderPayTransAtomRspBo;
import com.tydic.payment.pay.bo.PayParaInfoAttrBo;
import com.tydic.payment.pay.busi.AliPayQueryService;
import com.tydic.payment.pay.busi.ExternalQueryBusiSerive;
import com.tydic.payment.pay.busi.OrderQueryConstructionBusiService;
import com.tydic.payment.pay.busi.QueryCashierInfoPayParaAttrService;
import com.tydic.payment.pay.busi.WXPayStateQueryBusiService;
import com.tydic.payment.pay.busi.bo.AliPayQueryReqBo;
import com.tydic.payment.pay.busi.bo.AliPayQueryRspBo;
import com.tydic.payment.pay.busi.bo.ExternalQueryBusiReqBo;
import com.tydic.payment.pay.busi.bo.ExternalQueryBusiRspBo;
import com.tydic.payment.pay.busi.bo.OrderQueryConstructionReqBo;
import com.tydic.payment.pay.busi.bo.OrderQueryConstructionRspBo;
import com.tydic.payment.pay.busi.bo.QueryCashierInfoPayParaAttrReqBo;
import com.tydic.payment.pay.busi.bo.QueryCashierInfoPayParaAttrRspBo;
import com.tydic.payment.pay.busi.bo.WXPayStateQueryBusiReqBO;
import com.tydic.payment.pay.busi.bo.WXPayStateQueryBusiRspBO;
import com.tydic.payment.pay.common.util.MoneyUtils;
import com.tydic.payment.pay.dao.po.PorderPo;
import com.tydic.payment.pay.exception.BusinessException;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="externalQueryBusiSerive")
public class ExternalQueryBusiSeriveImpl
implements ExternalQueryBusiSerive {
    @Autowired
    private PayOrderAtomService payOrderAtomService;
    @Autowired
    private PorderPayTransAtomService porderPayTransAtomService;
    @Autowired
    private OrderQueryConstructionBusiService orderQueryConstructionBusiService;
    @Autowired
    private QueryCashierInfoPayParaAttrService queryCashierInfoPayParaAttrService;
    @Autowired
    private WXPayStateQueryBusiService wXPayStateQueryBusiService;
    @Autowired
    private AliPayQueryService aliPayQueryService;

    public ExternalQueryBusiRspBo dealQuery(ExternalQueryBusiReqBo externalQueryBusiReqBo) {
        ExternalQueryBusiRspBo externalQueryBusiRspBo = new ExternalQueryBusiRspBo();
        String busiId = externalQueryBusiReqBo.getBusiId();
        String oriOrderId = externalQueryBusiReqBo.getOriOrderId();
        String outOrderId = externalQueryBusiReqBo.getOutOrderId();
        OrderQueryConstructionReqBo orderQueryConstructionReqBo = new OrderQueryConstructionReqBo();
        orderQueryConstructionReqBo.setBusiId(Long.valueOf(Long.parseLong(busiId)));
        orderQueryConstructionReqBo.setOutOrderId(oriOrderId);
        OrderQueryConstructionRspBo constructionRspBo = this.orderQueryConstructionBusiService.queryConstruction(orderQueryConstructionReqBo);
        if (!"0000".equals(constructionRspBo.getRspCode())) {
            externalQueryBusiRspBo.setResultCode("FAIL");
            externalQueryBusiRspBo.setResultMsg("\u5916\u90e8\u8ba2\u5355\u53f7 \u3010" + outOrderId + "\u3011\u3010busiId= " + busiId + "\u3011\u8ba2\u5355\u4e0d\u5b58\u5728");
            externalQueryBusiRspBo.setRspCode("0000");
            externalQueryBusiRspBo.setRspName("\u67e5\u8be2\u5931\u8d25");
            return externalQueryBusiRspBo;
        }
        Long orderId = constructionRspBo.getOrderId();
        PorderPo orderInfo = this.payOrderAtomService.queryByOrderId(orderId);
        PorderPayTransAtomRspBo transAtomRspBo = this.porderPayTransAtomService.queryLastRecordByOrderId(orderId);
        if (transAtomRspBo == null) {
            externalQueryBusiRspBo.setResultCode("PAYING");
            externalQueryBusiRspBo.setResultMsg("\u652f\u4ed8\u5355\u672a\u521b\u5efa");
            externalQueryBusiRspBo.setRspCode("0000");
            externalQueryBusiRspBo.setRspName("\u67e5\u8be2\u5931\u8d25");
            return externalQueryBusiRspBo;
        }
        String payOrderId = transAtomRspBo.getPayOrderId();
        if ("A20".equals(orderInfo.getOrderStatus()) && "30".equals(transAtomRspBo.getPayMethod())) {
            externalQueryBusiRspBo.setRspCode("0000");
            externalQueryBusiRspBo.setRspName("\u67e5\u8be2\u6210\u529f");
            externalQueryBusiRspBo.setResultCode("FAIL");
            externalQueryBusiRspBo.setResultMsg(transAtomRspBo.getPayMsg());
            return externalQueryBusiRspBo;
        }
        if ("A10".equals(orderInfo.getOrderStatus())) {
            externalQueryBusiRspBo.setRspCode("0000");
            externalQueryBusiRspBo.setRspName("\u67e5\u8be2\u6210\u529f");
            externalQueryBusiRspBo.setCreateOperId(orderInfo.getCreateOperId());
            externalQueryBusiRspBo.setMerchantId(String.valueOf(orderInfo.getMerchantId()));
            externalQueryBusiRspBo.setOriOrderId(externalQueryBusiReqBo.getOriOrderId());
            externalQueryBusiRspBo.setOutOrderId(externalQueryBusiReqBo.getOutOrderId());
            externalQueryBusiRspBo.setRealFee(orderInfo.getRealFee() != null ? MoneyUtils.haoToFen((Long)orderInfo.getRealFee()).toString() : "0");
            externalQueryBusiRspBo.setRemark(orderInfo.getOutRemark());
            externalQueryBusiRspBo.setReqWay(orderInfo.getReqWay());
            externalQueryBusiRspBo.setResultCode("SUCCESS");
            externalQueryBusiRspBo.setTotalFee(MoneyUtils.haoToFen((Long)orderInfo.getTotalFee()).toString());
            externalQueryBusiRspBo.setTradeTime(orderInfo.getTradeTime());
            externalQueryBusiRspBo.setTransactionsId(String.valueOf(orderInfo.getOrderId()));
            externalQueryBusiRspBo.setCouponFee(String.valueOf(MoneyUtils.haoToFen((Long)(orderInfo.getDiscountFee() == null ? 0L : orderInfo.getDiscountFee()))));
            externalQueryBusiRspBo.setBanlenceFee(String.valueOf(MoneyUtils.haoToFen((Long)(orderInfo.getBalanceFee() == null ? 0L : orderInfo.getBalanceFee()))));
            externalQueryBusiRspBo.setPayMethod(String.valueOf(transAtomRspBo.getPayMethod()));
            externalQueryBusiRspBo.setPayNotifyTransId(transAtomRspBo.getPayNotifyTransId());
            return externalQueryBusiRspBo;
        }
        String payMethod = String.valueOf(transAtomRspBo.getPayMethod());
        QueryCashierInfoPayParaAttrReqBo paraReq = new QueryCashierInfoPayParaAttrReqBo();
        paraReq.setMerchantId(String.valueOf(orderInfo.getMerchantId()));
        paraReq.setPayMethod(payMethod);
        QueryCashierInfoPayParaAttrRspBo paraInfo = this.queryCashierInfoPayParaAttrService.queryPayParaAttr(paraReq);
        Map<String, Object> paramMap = this.getParamMap(paraInfo);
        String payStatus = null;
        String payNotifyTransId = null;
        String msg = null;
        if ("10".equals(transAtomRspBo.getPayMethod() + "") || "11".equals(transAtomRspBo.getPayMethod() + "") || "13".equals(transAtomRspBo.getPayMethod() + "") || "12".equals(transAtomRspBo.getPayMethod() + "") || "14".equals(transAtomRspBo.getPayMethod() + "") || "15".equals(transAtomRspBo.getPayMethod() + "")) {
            WXPayStateQueryBusiReqBO wXPayOrderQueryReq = new WXPayStateQueryBusiReqBO();
            wXPayOrderQueryReq.setOrderId(String.valueOf(orderId));
            wXPayOrderQueryReq.setPayOrderId(payOrderId);
            wXPayOrderQueryReq.setParamMap(paramMap);
            WXPayStateQueryBusiRspBO wXPayStateQueryBusiRspBO = null;
            try {
                wXPayStateQueryBusiRspBO = this.wXPayStateQueryBusiService.dealWXPayStateQuery(wXPayOrderQueryReq);
            }
            catch (Exception e) {
                throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u5fae\u4fe1\u67e5\u8be2\u5f02\u5e38");
            }
            payStatus = wXPayStateQueryBusiRspBO.getPayStatus();
            msg = wXPayStateQueryBusiRspBO.getMsg();
            payNotifyTransId = wXPayStateQueryBusiRspBO.getPayNotifyTransId();
        } else if ("20".equals(transAtomRspBo.getPayMethod() + "") || "21".equals(transAtomRspBo.getPayMethod() + "") || "23".equals(transAtomRspBo.getPayMethod() + "") || "22".equals(transAtomRspBo.getPayMethod() + "") || "24".equals(transAtomRspBo.getPayMethod() + "")) {
            AliPayQueryReqBo aliPayQueryReqBo = new AliPayQueryReqBo();
            aliPayQueryReqBo.setOrderId(orderId);
            aliPayQueryReqBo.setPayOrderId(payOrderId);
            aliPayQueryReqBo.setParamMap(paramMap);
            AliPayQueryRspBo aliPayQueryRspBo = this.aliPayQueryService.dealQuery(aliPayQueryReqBo);
            payStatus = aliPayQueryRspBo.getPayStatus();
            msg = aliPayQueryRspBo.getMsg();
            payNotifyTransId = aliPayQueryRspBo.getPayNotifyTransId();
        }
        if ("SUCCESS".equals(payStatus)) {
            orderInfo = this.payOrderAtomService.queryByOrderId(constructionRspBo.getOrderId());
            externalQueryBusiRspBo.setCreateOperId(orderInfo.getCreateOperId());
            externalQueryBusiRspBo.setMerchantId(String.valueOf(orderInfo.getMerchantId()));
            externalQueryBusiRspBo.setOriOrderId(externalQueryBusiReqBo.getOriOrderId());
            externalQueryBusiRspBo.setOutOrderId(externalQueryBusiReqBo.getOutOrderId());
            externalQueryBusiRspBo.setRealFee(String.valueOf(MoneyUtils.haoToFen((Long)orderInfo.getRealFee())));
            externalQueryBusiRspBo.setRemark(orderInfo.getOutRemark());
            externalQueryBusiRspBo.setReqWay(orderInfo.getReqWay());
            externalQueryBusiRspBo.setResultCode("SUCCESS");
            externalQueryBusiRspBo.setTotalFee(String.valueOf(MoneyUtils.haoToFen((Long)orderInfo.getTotalFee())));
            externalQueryBusiRspBo.setTradeTime(orderInfo.getTradeTime());
            externalQueryBusiRspBo.setTransactionsId(String.valueOf(orderInfo.getOrderId()));
            externalQueryBusiRspBo.setCouponFee(String.valueOf(MoneyUtils.haoToFen((Long)(orderInfo.getDiscountFee() == null ? 0L : orderInfo.getDiscountFee()))));
            externalQueryBusiRspBo.setBanlenceFee(String.valueOf(MoneyUtils.haoToFen((Long)(orderInfo.getBalanceFee() == null ? 0L : orderInfo.getDiscountFee()))));
            externalQueryBusiRspBo.setPayMethod(String.valueOf(transAtomRspBo.getPayMethod()));
            externalQueryBusiRspBo.setPayNotifyTransId(payNotifyTransId);
        } else if ("FAIL".equals(payStatus)) {
            externalQueryBusiRspBo.setResultCode("FAIL");
            externalQueryBusiRspBo.setResultMsg(msg);
        } else {
            externalQueryBusiRspBo.setResultCode("PAYING");
            externalQueryBusiRspBo.setResultMsg("\u8ba2\u5355\u672a\u652f\u4ed8");
        }
        externalQueryBusiRspBo.setRspCode("0000");
        externalQueryBusiRspBo.setRspName("\u67e5\u8be2\u6210\u529f");
        return externalQueryBusiRspBo;
    }

    private Map<String, Object> getParamMap(QueryCashierInfoPayParaAttrRspBo paraInfo) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        for (PayParaInfoAttrBo para : paraInfo.getInfoPayParaAttrList()) {
            paramMap.put(para.getAttrCode(), para.getAttrValue());
        }
        return paramMap;
    }
}

