/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.busi.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSONObject;
import com.tydic.payment.pay.atom.PayOrderAtomService;
import com.tydic.payment.pay.atom.PorderPayTransAtomService;
import com.tydic.payment.pay.atom.bo.PorderPayTransAtomReqBo;
import com.tydic.payment.pay.atom.bo.PorderPayTransAtomRspBo;
import com.tydic.payment.pay.bo.PayParaInfoAttrBo;
import com.tydic.payment.pay.busi.CallBackNoticeService;
import com.tydic.payment.pay.busi.GdBank4AcpPayBackNotifyBusiService;
import com.tydic.payment.pay.busi.QueryCashierInfoPayParaAttrService;
import com.tydic.payment.pay.busi.QueryDBDateBusiService;
import com.tydic.payment.pay.busi.bo.CallBackNoticeReqBo;
import com.tydic.payment.pay.busi.bo.CallBackNoticeRspBo;
import com.tydic.payment.pay.busi.bo.GdBank4AcpPayBackNotifyReqBo;
import com.tydic.payment.pay.busi.bo.QueryCashierInfoPayParaAttrReqBo;
import com.tydic.payment.pay.busi.bo.QueryCashierInfoPayParaAttrRspBo;
import com.tydic.payment.pay.config.vo.PayPropertiesVo;
import com.tydic.payment.pay.dao.po.PorderPo;
import com.tydic.payment.pay.exception.BusinessException;
import com.tydic.payment.pay.util.BankPayUtil;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="gbBank4AcpPayBackNotifyBusiService")
@HSFProvider(serviceVersion="2.0.0", serviceGroup="PAYMENT_GROUP_DEV", serviceInterface=GdBank4AcpPayBackNotifyBusiService.class)
public class GdBank4AcpPayBackNotifyBusiServiceImpl
implements GdBank4AcpPayBackNotifyBusiService {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private PayPropertiesVo payPropertiesVo;
    @Autowired
    private QueryCashierInfoPayParaAttrService queryCashierInfoPayParaAttrService;
    @Autowired
    private PayOrderAtomService payOrderAtomService;
    @Autowired
    private PorderPayTransAtomService porderPayTransAtomService;
    @Autowired
    private QueryDBDateBusiService queryDBDateBusiService;
    @Autowired
    private CallBackNoticeService callBackNoticeService;

    public boolean dealNotify(GdBank4AcpPayBackNotifyReqBo reqBo) {
        if (reqBo == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5149\u5927\u94f6\u884c\u8fd4\u56de\u901a\u77e5\u7ed3\u679c\u5185\u5bb9\u4e3a\u7a7a\uff0c\u65e0\u5185\u5bb9\uff0c\u5904\u7406\u7ed3\u675f\uff01");
        }
        if (reqBo.getParams() == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5149\u5927\u94f6\u884c\u5f02\u6b65\u901a\u77e5\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.LOGGER.info("\u5165\u53c2\u53c2\u6570" + reqBo.getParams().toString());
        this.LOGGER.info("reqBo" + reqBo);
        try {
            JSONObject data = JSONObject.parseObject((String)((String)reqBo.getParams().get("result")));
            String payOrderId = data.getString("ordernumber");
            this.LOGGER.info("ordernumber:" + payOrderId);
            PorderPayTransAtomReqBo orderPayTransAtomReq = new PorderPayTransAtomReqBo();
            orderPayTransAtomReq.setPayOrderId(payOrderId);
            List<PorderPayTransAtomRspBo> transAtomList = this.porderPayTransAtomService.queryOrderPayTransByCondition(orderPayTransAtomReq);
            if (CollectionUtils.isEmpty(transAtomList)) {
                this.LOGGER.info("\u5149\u5927\u94f6\u884c\u5f02\u6b65\u56de\u8c03\u6839\u636e\u3010payOrderId=" + payOrderId + "\u3011\u67e5\u8be2\u652f\u4ed8\u8bf7\u6c42\u8868\u65e0\u6570\u636e");
                throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u5149\u5927\u94f6\u884c\u5f02\u6b65\u56de\u8c03\u67e5\u8be2\u652f\u4ed8\u8bf7\u6c42\u8868\u65e0\u6570\u636e\uff01");
            }
            Long orderId = transAtomList.get(0).getOrderId();
            PorderPo orderInfo = this.payOrderAtomService.queryPorderInfo(orderId);
            if (orderInfo == null) {
                this.LOGGER.info("\u5149\u5927\u94f6\u884c\u5f02\u6b65\u56de\u8c03\u6839\u636e\u3010orderId=" + orderId + "\u3011\u67e5\u8be2\u8ba2\u5355\u8868\u65e0\u6570\u636e");
                throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u5149\u5927\u94f6\u884c\u5f02\u6b65\u56de\u8c03\u67e5\u8be2\u8ba2\u5355\u8868\u65e0\u6570\u636e\uff01");
            }
            String payTransStatus = transAtomList.get(0).getOrderStatus();
            String orderStatus2 = orderInfo.getOrderStatus();
            if ("A10".equals(orderStatus2) && "A10".equals(payTransStatus)) {
                return true;
            }
            String merchant_id = String.valueOf(orderInfo.getMerchantId());
            Map<String, String> paraMap = this.getPayParamMap(merchant_id);
            this.LOGGER.info("\u5149\u5927\u94f6\u884c\u914d\u7f6e\u53c2\u6570paraMap:" + paraMap);
            String signkey = paraMap.get("key");
            this.LOGGER.info("OrderConstant.GdBandPayParams.KEY:" + signkey);
            this.LOGGER.info("paraMap:" + paraMap);
            if (!this.verify((String)reqBo.getParams().get("result"), (String)reqBo.getParams().get("sign"), signkey)) {
                throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u5149\u5927\u94f6\u884c\u5f02\u6b65\u56de\u8c03\u9a8c\u7b7e\u5931\u8d25\uff01");
            }
            if (data.getString("status") != null) {
                this.LOGGER.info("status:" + data.getString("status"));
                PorderPayTransAtomReqBo orderPayTransUpdateReq = new PorderPayTransAtomReqBo();
                orderPayTransUpdateReq.setPayOrderId(payOrderId);
                orderPayTransUpdateReq.setOrderId(orderId);
                if (data.getString("banknumber") != null) {
                    orderPayTransUpdateReq.setPayNotifyTransId(data.getString("banknumber"));
                }
                PorderPo updatePo = new PorderPo();
                updatePo.setOrderId(orderId);
                if (StringUtils.isEmpty((String)data.getString("timestamp"))) {
                    String tradeTime = data.getString("timestamp").replace(":", "").replace("-", "").replace(" ", "");
                    orderPayTransUpdateReq.setTradeTime(tradeTime);
                    updatePo.setTradeTime(tradeTime);
                } else {
                    Date dbDate = this.queryDBDateBusiService.getDBDate();
                    String tradeTime = new SimpleDateFormat("yyyyMMddHHmmss").format(dbDate);
                    orderPayTransUpdateReq.setTradeTime(tradeTime);
                    updatePo.setTradeTime(tradeTime);
                }
                if (data.getString("amount") != null) {
                    String amount = data.getString("amount");
                    long totalFee = Long.valueOf(amount);
                    if (totalFee > 0L) {
                        totalFee *= 100L;
                    }
                    updatePo.setRealFee(totalFee);
                    updatePo.setOnlineFee(totalFee);
                }
                if ("0".equals(data.getString("status"))) {
                    orderPayTransUpdateReq.setOrderStatus("A10");
                    updatePo.setOrderStatus("A10");
                } else {
                    orderPayTransUpdateReq.setOrderStatus("A20");
                    updatePo.setOrderStatus("A20");
                }
                this.porderPayTransAtomService.updateOrderPayTransByPayOrderId(orderPayTransUpdateReq);
                this.payOrderAtomService.update(updatePo);
                CallBackNoticeReqBo callBackNoticeReqBo = new CallBackNoticeReqBo();
                callBackNoticeReqBo.setOrderId(orderId);
                CallBackNoticeRspBo callBackNoticeRspBo = this.callBackNoticeService.dealPayPutMq(callBackNoticeReqBo);
                if ("0000".equals(callBackNoticeRspBo.getRspCode())) {
                    this.LOGGER.info(orderId + "\u53d1\u9001\u6d88\u606f\u961f\u5217\u6210\u529f");
                }
                return true;
            }
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5149\u5927\u94f6\u884c\u8fd4\u56de\u901a\u77e5\u7ed3\u679cstatus\u4e3a\u7a7a\uff0c\u65e0\u5185\u5bb9\uff0c\u5904\u7406\u5f02\u5e38\uff01");
        }
        catch (Exception e) {
            this.LOGGER.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    private Map<String, String> getPayParamMap(String merchantId) {
        QueryCashierInfoPayParaAttrReqBo paraReq = new QueryCashierInfoPayParaAttrReqBo();
        paraReq.setMerchantId(String.valueOf(merchantId));
        paraReq.setPayMethod("120");
        QueryCashierInfoPayParaAttrRspBo paraInfo = this.queryCashierInfoPayParaAttrService.queryPayParaAttr(paraReq);
        if (paraInfo == null || !"0000".equals(paraInfo.getRspCode())) {
            throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u6839\u636e\u5546\u6237\u53f7\u3010" + merchantId + "\u3011\u67e5\u8be2\u652f\u4ed8\u53c2\u6570\u914d\u7f6e\u5931\u8d25\uff01");
        }
        if (paraInfo.getInfoPayParaAttrList() == null || paraInfo.getInfoPayParaAttrList().size() < 1) {
            throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u6839\u636e\u5546\u6237\u53f7\u3010" + merchantId + "\u3011\u67e5\u8be2\u65e0\u652f\u4ed8\u53c2\u6570\u914d\u7f6e\uff01");
        }
        HashMap<String, String> paramMap = new HashMap<String, String>(8);
        for (PayParaInfoAttrBo para : paraInfo.getInfoPayParaAttrList()) {
            paramMap.put(para.getAttrCode(), para.getAttrValue());
        }
        return paramMap;
    }

    private boolean verify(String data, String sign, String key) {
        String signData = key + data;
        try {
            return sign.equals(BankPayUtil.MD5(signData));
        }
        catch (Exception e) {
            this.LOGGER.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }
}

