/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.payment.pay.atom.PayOrderAtomService;
import com.tydic.payment.pay.atom.PorderPayTransAtomService;
import com.tydic.payment.pay.atom.bo.PorderPayTransAtomReqBo;
import com.tydic.payment.pay.atom.bo.PorderPayTransAtomRspBo;
import com.tydic.payment.pay.bo.PayParaInfoAttrBo;
import com.tydic.payment.pay.busi.CallBackNoticeService;
import com.tydic.payment.pay.busi.GdBank4PayStateQueryBusiService;
import com.tydic.payment.pay.busi.QueryCashierInfoPayParaAttrService;
import com.tydic.payment.pay.busi.QueryDBDateBusiService;
import com.tydic.payment.pay.busi.WXOrderQueryBusiService;
import com.tydic.payment.pay.busi.bo.CallBackNoticeReqBo;
import com.tydic.payment.pay.busi.bo.CallBackNoticeRspBo;
import com.tydic.payment.pay.busi.bo.GdBank4PayStateQueryBusiReqBo;
import com.tydic.payment.pay.busi.bo.GdBank4PayStateQueryBusiRspBo;
import com.tydic.payment.pay.busi.bo.QueryCashierInfoPayParaAttrReqBo;
import com.tydic.payment.pay.busi.bo.QueryCashierInfoPayParaAttrRspBo;
import com.tydic.payment.pay.common.util.HttpUtil;
import com.tydic.payment.pay.config.vo.PayPropertiesVo;
import com.tydic.payment.pay.dao.po.PorderPo;
import com.tydic.payment.pay.exception.BusinessException;
import com.tydic.payment.pay.util.BankPayUtil;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="gbBank4PayStateQueryBusiService")
public class GdBank4PayStateQueryBusiServiceImpl
implements GdBank4PayStateQueryBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(GdBank4PayStateQueryBusiServiceImpl.class);
    @Autowired
    private PorderPayTransAtomService porderPayTransAtomService;
    @Autowired
    private PayOrderAtomService payOrderAtomService;
    @Autowired
    private CallBackNoticeService callBackNoticeService;
    @Autowired
    private QueryDBDateBusiService queryDBDateBusiService;
    @Autowired
    private WXOrderQueryBusiService wXOrderQueryBusiService;
    @Autowired
    private PayPropertiesVo payPropertiesVo;
    @Autowired
    private QueryCashierInfoPayParaAttrService queryCashierInfoPayParaAttrService;

    public GdBank4PayStateQueryBusiRspBo dealGbBank4QueryStateQuery(GdBank4PayStateQueryBusiReqBo req) throws Exception {
        LOGGER.info("\u8fdb\u5165\u67e5\u8be2\u5149\u5927\u94f6\u884c\u652f\u4ed8\u8ba2\u5355\u4e1a\u52a1\u670d\u52a1" + req);
        GdBank4PayStateQueryBusiRspBo rsp = new GdBank4PayStateQueryBusiRspBo();
        rsp.setPayOrderId(req.getPayOrderId());
        this.checkInputParas(req);
        try {
            PorderPayTransAtomRspBo orderPayTransAtomRsp;
            PorderPayTransAtomReqBo orderPayTransAtomReq = new PorderPayTransAtomReqBo();
            orderPayTransAtomReq.setOrderId(Long.valueOf(req.getOrderId()));
            orderPayTransAtomReq.setPayOrderId(req.getPayOrderId());
            if (!StringUtils.isEmpty((Object)req.getMerchantId())) {
                orderPayTransAtomReq.setMerchantId(Long.valueOf(req.getMerchantId()));
            }
            if ((orderPayTransAtomRsp = this.porderPayTransAtomService.queryOrderPayTransByPayOrderId(orderPayTransAtomReq)) == null) {
                throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u67e5\u8be2\u5149\u5927\u94f6\u884c\u652f\u4ed8\u8ba2\u5355\u670d\u52a1\u3010payOrderId=" + req.getPayOrderId() + "\u3011\u67e5\u8be2\u4e0d\u5230\u652f\u4ed8\u8bf7\u6c42\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\u6d41\u6c34\u662f\u5426\u6b63\u786e\uff01");
            }
            if (req.getParamMap() == null || req.getParamMap().isEmpty()) {
                PorderPo orderInfo = this.payOrderAtomService.queryPorderInfo(orderPayTransAtomRsp.getOrderId());
                if (orderInfo == null) {
                    throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u67e5\u8be2\u652f\u4ed8\u8ba2\u5355\u7ec4\u5408\u670d\u52a1\u6839\u636e\u8ba2\u5355id\u3010ORDER_ID=" + orderPayTransAtomRsp.getOrderId() + "\u3011\u67e5\u8be2\u4e0d\u5230\u8ba2\u5355\u4fe1\u606f\uff01");
                }
                Long merchant_id = orderInfo.getMerchantId();
                String orderId = String.valueOf(orderPayTransAtomRsp.getOrderId());
                if (StringUtils.isEmpty((Object)merchant_id)) {
                    throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u67e5\u8be2\u652f\u4ed8\u8ba2\u5355\u7ec4\u5408\u670d\u52a1\u6839\u636e\u8ba2\u5355id\u3010ORDER_ID=" + orderPayTransAtomRsp.getOrderId() + "\u3011\u67e5\u8be2\u5230\u8ba2\u5355\u4fe1\u606f\u4e2d\u65e0\u5546\u6237\u53f7\uff01");
                }
                String payMethod = String.valueOf(orderPayTransAtomRsp.getPayMethod());
                QueryCashierInfoPayParaAttrReqBo paraReq = new QueryCashierInfoPayParaAttrReqBo();
                paraReq.setMerchantId(String.valueOf(merchant_id));
                paraReq.setPayMethod(payMethod);
                QueryCashierInfoPayParaAttrRspBo paraInfo = this.queryCashierInfoPayParaAttrService.queryPayParaAttr(paraReq);
                if (paraInfo == null || !"0000".equals(paraInfo.getRspCode())) {
                    throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u67e5\u8be2\u652f\u4ed8\u8ba2\u5355\u7ec4\u5408\u670d\u52a1\u6839\u636e\u5546\u6237\u53f7\u3010" + merchant_id + "\u3011\u67e5\u8be2\u652f\u4ed8\u53c2\u6570\u914d\u7f6e\u5931\u8d25\uff01");
                }
                if (paraInfo.getInfoPayParaAttrList() == null || paraInfo.getInfoPayParaAttrList().size() < 1) {
                    throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u67e5\u8be2\u652f\u4ed8\u8ba2\u5355\u7ec4\u5408\u670d\u52a1\u6839\u636e\u5546\u6237\u53f7\u3010" + merchant_id + "\u3011\u67e5\u8be2\u65e0\u652f\u4ed8\u53c2\u6570\u914d\u7f6e\uff01");
                }
                HashMap<String, String> paramMap = new HashMap<String, String>();
                for (PayParaInfoAttrBo para : paraInfo.getInfoPayParaAttrList()) {
                    paramMap.put(para.getAttrCode(), para.getAttrValue());
                }
                req.setParamMap(paramMap);
            }
            if ("A10".equals(orderPayTransAtomRsp.getOrderStatus())) {
                rsp.setRspCode("0000");
                rsp.setRspName("\u652f\u4ed8\u6210\u529f");
                rsp.setPayStatus("SUCCESS");
                return rsp;
            }
            String key = req.getParamMap().get("key") + "";
            String merid = req.getParamMap().get("merid") + "";
            String banknumber = req.getParamMap().get("banknumber") + "";
            String numberName = req.getParamMap().get("numbername") + "";
            String timeEnd = "180";
            JSONObject jo = new JSONObject(new LinkedHashMap());
            jo.put("merid", (Object)merid);
            jo.put("ordernumber", (Object)req.getPayOrderId());
            jo.put("remark1", (Object)"");
            jo.put("remark2", (Object)"");
            jo.put("remark3", (Object)"");
            jo.put("remark4", (Object)"");
            String sign = BankPayUtil.generateSignature(key, jo.toString());
            LOGGER.info("jo:" + JSONObject.toJSONString((Object)jo));
            LOGGER.info("sign:" + sign);
            LOGGER.info("\u8bf7\u6c42\u62a5\u6587\uff1aresult=" + JSONObject.toJSONString((Object)jo) + sign);
            LOGGER.info("\u8bf7\u6c42\u5730\u5740\uff1a" + this.payPropertiesVo.getGdBankPay4QueryOrderUrl());
            String result = "";
            try {
                result = HttpUtil.sendRequest((String)("result=" + JSONObject.toJSONString((Object)jo) + sign), (String)this.payPropertiesVo.getGdBankPay4QueryOrderUrl(), (String)"GET", (String)"UTF-8");
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
            LOGGER.info("\u8fd4\u56de\u4fe1\u606f\uff1a" + result);
            String str = result.substring(1, result.length() - 1);
            str = str.replaceAll("\"", "");
            String[] varStr = str.split(",");
            HashMap<String, String> resultMap = new HashMap<String, String>();
            for (String temp : varStr) {
                System.out.println(temp);
                String[] tempStr = temp.split(":");
                if (tempStr.length <= 1) continue;
                resultMap.put(tempStr[0], tempStr[1]);
            }
            String tradeTime = new SimpleDateFormat("yyyyMMddHHmmss").format(this.queryDBDateBusiService.getDBDate());
            if (resultMap.get("status") != null) {
                if (((String)resultMap.get("status")).equals("0")) {
                    PorderPo queryPorderInfo = this.payOrderAtomService.queryPorderInfo(orderPayTransAtomRsp.getOrderId());
                    if (!queryPorderInfo.getOrderStatus().equals("A10")) {
                        PorderPo updateOrderPo = new PorderPo();
                        updateOrderPo.setOrderId(Long.valueOf(req.getOrderId()));
                        updateOrderPo.setOrderStatus("A10");
                        updateOrderPo.setOnlineFee(queryPorderInfo.getTotalFee());
                        updateOrderPo.setRealFee(queryPorderInfo.getTotalFee());
                        updateOrderPo.setTradeTime(tradeTime);
                        this.payOrderAtomService.update(updateOrderPo);
                    }
                    PorderPayTransAtomReqBo queryPorderPayTransReq = new PorderPayTransAtomReqBo();
                    queryPorderPayTransReq.setPayOrderId(req.getPayOrderId());
                    PorderPayTransAtomRspBo queryPorderPayTransInfo = this.porderPayTransAtomService.queryOrderPayTransByPayOrderId(queryPorderPayTransReq);
                    if (!queryPorderPayTransInfo.getOrderStatus().equals("A10")) {
                        PorderPayTransAtomReqBo updorderPayTransReq = new PorderPayTransAtomReqBo();
                        updorderPayTransReq.setOrderId(Long.valueOf(req.getOrderId()));
                        updorderPayTransReq.setPayOrderId(req.getPayOrderId());
                        updorderPayTransReq.setTradeTime(tradeTime);
                        updorderPayTransReq.setOrderStatus("A10");
                        if (resultMap.get("info") != null) {
                            updorderPayTransReq.setPayMsg((String)resultMap.get("info"));
                        }
                        this.porderPayTransAtomService.updateOrderPayTransByPayOrderId(updorderPayTransReq);
                    }
                    rsp.setRspCode("0000");
                    rsp.setRspName("\u6210\u529f");
                    rsp.setPayStatus("SUCCESS");
                    CallBackNoticeReqBo callBackNoticeReqBo = new CallBackNoticeReqBo();
                    callBackNoticeReqBo.setOrderId(Long.valueOf(Long.parseLong(req.getOrderId())));
                    CallBackNoticeRspBo rspBo = this.callBackNoticeService.dealPayPutMq(callBackNoticeReqBo);
                    if (!"0000".equals(rspBo.getRspCode())) {
                        LOGGER.info("\u67e5\u8be2\u652f\u4ed8\u72b6\u6001\u8fd4\u56de\uff0c\u53d1\u9001\u6d88\u606f\u961f\u5217\u5931\u8d25\uff1aorderId=" + req.getOrderId());
                    }
                } else {
                    rsp.setRspCode("0000");
                    rsp.setRspName("\u6210\u529f");
                    rsp.setPayStatus("FAIL");
                }
            } else {
                JSONObject err = JSONObject.parseObject((String)result);
                rsp.setRspCode("8888");
                rsp.setRspName(err.getString("info"));
            }
            return rsp;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return rsp;
        }
    }

    private void checkInputParas(GdBank4PayStateQueryBusiReqBo req) {
        if (StringUtils.isEmpty((Object)req.getOrderId())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u67e5\u8be2\u5149\u5927\u94f6\u884c\u652f\u4ed8\u8ba2\u5355\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\u8ba2\u5355\u7f16\u53f7\u3010orderId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)req.getPayOrderId())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u67e5\u8be2\u5149\u5927\u94f6\u884c\u652f\u4ed8\u8ba2\u5355\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\u3010payOrderId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }
}

