/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.busi.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.ohaotian.plugin.file.FileClient;
import com.tydic.payment.pay.atom.PayOrderAtomService;
import com.tydic.payment.pay.atom.PorderPayTransAtomService;
import com.tydic.payment.pay.atom.PorderRefundTransAtomService;
import com.tydic.payment.pay.atom.bo.PorderPayTransAtomReqBo;
import com.tydic.payment.pay.atom.bo.PorderPayTransAtomRspBo;
import com.tydic.payment.pay.atom.bo.PorderRefundTransAtomReqBo;
import com.tydic.payment.pay.atom.bo.PorderRefundTransAtomRspBo;
import com.tydic.payment.pay.bo.PayParaInfoAttrBo;
import com.tydic.payment.pay.busi.CallBackNoticeService;
import com.tydic.payment.pay.busi.QueryCashierInfoPayParaAttrService;
import com.tydic.payment.pay.busi.UnionAcpPayBackNotifyBusiService;
import com.tydic.payment.pay.busi.UnionAcpPayQueryBusiService;
import com.tydic.payment.pay.busi.bo.CallBackNoticeReqBo;
import com.tydic.payment.pay.busi.bo.CallBackNoticeRspBo;
import com.tydic.payment.pay.busi.bo.QueryCashierInfoPayParaAttrReqBo;
import com.tydic.payment.pay.busi.bo.QueryCashierInfoPayParaAttrRspBo;
import com.tydic.payment.pay.busi.bo.UnionAcpPayBackNotifyBusiReqBO;
import com.tydic.payment.pay.busi.bo.UnionAcpPayQueryBusiReqBO;
import com.tydic.payment.pay.busi.bo.UnionAcpPayQueryBusiRspBO;
import com.tydic.payment.pay.common.util.MoneyUtils;
import com.tydic.payment.pay.config.vo.PayPropertiesVo;
import com.tydic.payment.pay.dao.po.PorderPo;
import com.tydic.payment.pay.exception.BusinessException;
import com.tydic.payment.pay.sdk.unionpay.AcpService;
import com.tydic.payment.pay.sdk.unionpay.LogUtil;
import com.tydic.payment.pay.util.UnionPayAcpSdkConfigUtils;
import com.tydic.payment.pay.util.UnionPayAcpSdkRspUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@HSFProvider(serviceVersion="2.0.0", serviceGroup="PAYMENT_GROUP_DEV", serviceInterface=UnionAcpPayBackNotifyBusiService.class)
public class UnionAcpPayBackNotifyBusiServiceImpl
implements UnionAcpPayBackNotifyBusiService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private PayPropertiesVo payPropertiesVo;
    @Resource
    private FileClient fileClient;
    @Autowired
    private PayOrderAtomService payOrderAtomService;
    @Autowired
    private PorderPayTransAtomService porderPayTransAtomService;
    @Autowired
    private PorderRefundTransAtomService porderRefundTransAtomService;
    @Autowired
    private CallBackNoticeService callBackNoticeService;
    @Autowired
    private QueryCashierInfoPayParaAttrService queryCashierInfoPayParaAttrService;
    @Autowired
    private UnionAcpPayQueryBusiService unionAcpPayQueryBusiService;

    public void dealNotify(UnionAcpPayBackNotifyBusiReqBO reqBO) {
        Map reqParam = reqBO.getParams();
        LogUtil.printRequestLog((Map)reqParam);
        String encoding = (String)reqParam.get("encoding");
        String merchantId = this.getMerchantId(reqParam);
        Map<String, String> paramMap = this.getPayParamMap(merchantId);
        this.loadProperties(paramMap);
        if (!AcpService.validate((Map)reqParam, (String)encoding)) {
            this.logger.error("\u9a8c\u8bc1\u7b7e\u540d\u7ed3\u679c\uff1a\u5931\u8d25");
            throw new RuntimeException("\u9a8c\u8bc1\u7b7e\u540d\u7ed3\u679c\uff1a\u5931\u8d25");
        }
        UnionAcpPayQueryBusiReqBO queryBusiReqBO = new UnionAcpPayQueryBusiReqBO();
        queryBusiReqBO.setMerchantId(merchantId);
        queryBusiReqBO.setOrderId((String)reqParam.get("orderId"));
        queryBusiReqBO.setTxnTime((String)reqParam.get("txnTime"));
        UnionAcpPayQueryBusiRspBO queryBusiRspBO = this.unionAcpPayQueryBusiService.query(queryBusiReqBO);
        if (!"0000".equals(queryBusiRspBO.getRspCode())) {
            throw new RuntimeException("\u67e5\u8be2\u4ea4\u6613\u72b6\u6001\u63a5\u53e3\u5931\u8d25\uff1a" + queryBusiRspBO.getRspName());
        }
        if (!UnionPayAcpSdkRspUtils.isSuccess(queryBusiRspBO.getOrigRespCode())) {
            throw new RuntimeException("\u4ea4\u6613\u72b6\u6001\u5931\u8d25\uff1a" + queryBusiRspBO.getOrigRespMsg());
        }
        if ("01".equals(queryBusiRspBO.getTxnType())) {
            this.updatePayOrder(queryBusiReqBO, queryBusiRspBO);
        }
        if ("31".equals(queryBusiRspBO.getTxnType())) {
            this.updateRefundOrder(queryBusiReqBO, queryBusiRspBO);
        }
        if ("04".equals(queryBusiRspBO.getTxnType())) {
            this.updateRefundOrder(queryBusiReqBO, queryBusiRspBO);
        }
    }

    private void updateRefundOrder(UnionAcpPayQueryBusiReqBO reqBO, UnionAcpPayQueryBusiRspBO rspBO) {
        String refundOrderId = reqBO.getOrderId();
        PorderRefundTransAtomReqBo orderRefundTransAtomReq = new PorderRefundTransAtomReqBo();
        orderRefundTransAtomReq.setRefundOrderId(refundOrderId);
        PorderRefundTransAtomRspBo orderRefundTrans = this.porderRefundTransAtomService.queryOrderRefundTransByRefundOrderId(orderRefundTransAtomReq);
        if (orderRefundTrans == null) {
            this.logger.debug("\u94f6\u8054\u7f51\u5173\u5f02\u6b65\u56de\u8c03\u6839\u636e\u3010refundOrderId=" + refundOrderId + "\u3011\u67e5\u8be2\u9000\u6b3e\u8bf7\u6c42\u8868\u65e0\u6570\u636e");
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u94f6\u8054\u7f51\u5173\u5f02\u6b65\u56de\u8c03\u67e5\u8be2\u9000\u6b3e\u8bf7\u6c42\u8868\u65e0\u6570\u636e\uff01");
        }
        PorderPo orderInfo = this.payOrderAtomService.queryPorderInfo(orderRefundTrans.getOrderId());
        if (orderInfo == null) {
            this.logger.debug("\u94f6\u8054\u7f51\u5173\u5f02\u6b65\u56de\u8c03\u3010orderId=" + orderRefundTrans.getOrderId() + "\u3011\u67e5\u8be2\u8ba2\u5355\u8868\u65e0\u6570\u636e");
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u94f6\u8054\u7f51\u5173\u5f02\u6b65\u56de\u8c03\u67e5\u8be2\u8ba2\u5355\u8868\u65e0\u6570\u636e\uff01");
        }
        if ("B10".equals(orderRefundTrans.getOrderStatus()) && "B10".equals(orderInfo.getOrderStatus())) {
            this.logger.debug("\u94f6\u8054\u7f51\u5173\u5f02\u6b65\u56de\u8c03\u3010refundOrderId=" + refundOrderId + "\u3011\u3010orderId=" + orderInfo.getOrderId() + "\u3011\u5df2\u9000\u6b3e\u6210\u529f");
            return;
        }
        String tradeTime = rspBO.getTxnTime();
        PorderRefundTransAtomReqBo refundTransUpdateBO = new PorderRefundTransAtomReqBo();
        refundTransUpdateBO.setRefundOrderId(refundOrderId);
        refundTransUpdateBO.setOrderId(orderInfo.getOrderId());
        refundTransUpdateBO.setPayNotifyTransId(rspBO.getQueryId());
        refundTransUpdateBO.setTradeTime(tradeTime);
        refundTransUpdateBO.setOrderStatus("B10");
        try {
            this.porderRefundTransAtomService.updateOrderRefundTransByRefundOrderId(refundTransUpdateBO);
        }
        catch (Exception e) {
            throw new RuntimeException("\u9000\u6b3e\u8bf7\u6c42\u8868\u66f4\u65b0\u5f02\u5e38\uff1a", e);
        }
        PorderPo orderUpdatePO = new PorderPo();
        orderUpdatePO.setOrderId(orderInfo.getOrderId());
        orderUpdatePO.setTradeTime(tradeTime);
        orderUpdatePO.setRealFee(MoneyUtils.fenToHao((String)rspBO.getTxnAmt()).longValue());
        orderUpdatePO.setOnlineFee(MoneyUtils.fenToHao((String)rspBO.getTxnAmt()).longValue());
        orderUpdatePO.setOrderStatus("B10");
        this.payOrderAtomService.update(orderUpdatePO);
    }

    private void updatePayOrder(UnionAcpPayQueryBusiReqBO reqBO, UnionAcpPayQueryBusiRspBO rspBO) {
        String payOrderId = reqBO.getOrderId();
        PorderPayTransAtomReqBo orderPayTransAtomReq = new PorderPayTransAtomReqBo();
        orderPayTransAtomReq.setPayOrderId(payOrderId);
        List<PorderPayTransAtomRspBo> transAtomList = this.porderPayTransAtomService.queryOrderPayTransByCondition(orderPayTransAtomReq);
        if (transAtomList == null || transAtomList.size() < 1) {
            this.logger.debug("\u94f6\u8054\u7f51\u5173\u5f02\u6b65\u56de\u8c03\u6839\u636e\u3010payOrderId=" + payOrderId + "\u3011\u67e5\u8be2\u652f\u4ed8\u8bf7\u6c42\u8868\u65e0\u6570\u636e");
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u94f6\u8054\u7f51\u5173\u5f02\u6b65\u56de\u8c03\u67e5\u8be2\u652f\u4ed8\u8bf7\u6c42\u8868\u65e0\u6570\u636e\uff01");
        }
        PorderPayTransAtomRspBo orderPayTrans = transAtomList.get(0);
        PorderPo orderInfo = this.payOrderAtomService.queryPorderInfo(orderPayTrans.getOrderId());
        if (orderInfo == null) {
            this.logger.debug("\u94f6\u8054\u7f51\u5173\u5f02\u6b65\u56de\u8c03\u3010orderId=" + orderPayTrans.getOrderId() + "\u3011\u67e5\u8be2\u8ba2\u5355\u8868\u65e0\u6570\u636e");
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u94f6\u8054\u7f51\u5173\u5f02\u6b65\u56de\u8c03\u67e5\u8be2\u8ba2\u5355\u8868\u65e0\u6570\u636e\uff01");
        }
        if ("A10".equals(orderPayTrans.getOrderStatus()) && "A10".equals(orderInfo.getOrderStatus())) {
            this.logger.debug("\u94f6\u8054\u7f51\u5173\u5f02\u6b65\u56de\u8c03\u3010payOrderId=" + payOrderId + "\u3011\u3010orderId=" + orderInfo.getOrderId() + "\u3011\u5df2\u652f\u4ed8\u6210\u529f");
            return;
        }
        String tradeTime = rspBO.getTxnTime();
        PorderPayTransAtomReqBo payTransUpdateBO = new PorderPayTransAtomReqBo();
        payTransUpdateBO.setPayOrderId(payOrderId);
        payTransUpdateBO.setOrderId(orderInfo.getOrderId());
        payTransUpdateBO.setPayNotifyTransId(rspBO.getQueryId());
        payTransUpdateBO.setTradeTime(tradeTime);
        payTransUpdateBO.setOrderStatus("A10");
        try {
            this.porderPayTransAtomService.updateOrderPayTransByPayOrderId(payTransUpdateBO);
        }
        catch (Exception e) {
            throw new RuntimeException("\u652f\u4ed8\u8bf7\u6c42\u8868\u66f4\u65b0\u5f02\u5e38\uff1a", e);
        }
        PorderPo orderUpdatePO = new PorderPo();
        orderUpdatePO.setOrderId(orderInfo.getOrderId());
        orderUpdatePO.setTradeTime(tradeTime);
        orderUpdatePO.setRealFee(MoneyUtils.fenToHao((String)rspBO.getTxnAmt()).longValue());
        orderUpdatePO.setOnlineFee(MoneyUtils.fenToHao((String)rspBO.getTxnAmt()).longValue());
        orderUpdatePO.setOrderStatus("A10");
        this.payOrderAtomService.update(orderUpdatePO);
        CallBackNoticeReqBo noticeReqBO = new CallBackNoticeReqBo();
        noticeReqBO.setOrderId(orderInfo.getOrderId());
        CallBackNoticeRspBo noticeRspBO = this.callBackNoticeService.dealPayPutMq(noticeReqBO);
        if ("0000".equals(noticeRspBO.getRspCode())) {
            this.logger.debug(orderInfo.getOrderId() + "\u53d1\u9001\u6d88\u606f\u961f\u5217\u6210\u529f");
        } else {
            this.logger.error(orderInfo.getOrderId() + "\u53d1\u9001\u6d88\u606f\u961f\u5217\u5931\u8d25\uff1a" + noticeRspBO.getRspName());
        }
    }

    private void loadProperties(Map<String, String> paramMap) {
        UnionPayAcpSdkConfigUtils.setMerInfoByMap(this.payPropertiesVo, this.fileClient, paramMap);
    }

    private Map<String, String> getPayParamMap(String merchantId) {
        QueryCashierInfoPayParaAttrReqBo paraReq = new QueryCashierInfoPayParaAttrReqBo();
        paraReq.setMerchantId(String.valueOf(merchantId));
        paraReq.setPayMethod("110");
        QueryCashierInfoPayParaAttrRspBo paraInfo = this.queryCashierInfoPayParaAttrService.queryPayParaAttr(paraReq);
        if (paraInfo == null || !"0000".equals(paraInfo.getRspCode())) {
            throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u6839\u636e\u5546\u6237\u53f7\u3010" + merchantId + "\u3011\u67e5\u8be2\u652f\u4ed8\u53c2\u6570\u914d\u7f6e\u5931\u8d25\uff01");
        }
        if (paraInfo.getInfoPayParaAttrList() == null || paraInfo.getInfoPayParaAttrList().size() < 1) {
            throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u6839\u636e\u5546\u6237\u53f7\u3010" + merchantId + "\u3011\u67e5\u8be2\u65e0\u652f\u4ed8\u53c2\u6570\u914d\u7f6e\uff01");
        }
        HashMap<String, String> paramMap = new HashMap<String, String>(8);
        for (PayParaInfoAttrBo para : paraInfo.getInfoPayParaAttrList()) {
            paramMap.put(para.getAttrCode(), para.getAttrValue());
        }
        return paramMap;
    }

    private String getMerchantId(Map<String, String> reqParam) {
        if (!UnionPayAcpSdkRspUtils.isSuccess(reqParam.get("respCode"))) {
            throw new RuntimeException("\u540e\u53f0\u901a\u77e5\u5931\u8d25\uff1a" + reqParam.get("respMsg"));
        }
        String txnType = reqParam.get("txnType");
        String orderId = reqParam.get("orderId");
        if ("01".equals(txnType)) {
            return this.getMerchantIdByPayOrder(orderId);
        }
        if ("31".equals(txnType)) {
            return this.getMerchantIdByRefundOrder(orderId);
        }
        if ("04".equals(txnType)) {
            return this.getMerchantIdByRefundOrder(orderId);
        }
        throw new RuntimeException("\u6682\u4e0d\u652f\u6301\u7684\u4ea4\u6613\u7c7b\u578b\uff1a" + txnType);
    }

    private String getMerchantIdByRefundOrder(String orderId) {
        PorderRefundTransAtomReqBo reqBO = new PorderRefundTransAtomReqBo();
        reqBO.setRefundOrderId(orderId);
        return this.porderRefundTransAtomService.queryOrderRefundTransByRefundOrderId(reqBO).getMerchantId().toString();
    }

    private String getMerchantIdByPayOrder(String orderId) {
        PorderPayTransAtomReqBo reqBO = new PorderPayTransAtomReqBo();
        reqBO.setPayOrderId(orderId);
        try {
            return this.porderPayTransAtomService.queryOrderPayTransByPayOrderId(reqBO).getMerchantId().toString();
        }
        catch (Exception e) {
            throw new RuntimeException("\u67e5\u8be2\u652f\u4ed8\u8bf7\u6c42\u8868\u5f02\u5e38\uff1a", e);
        }
    }
}

