/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.busi.impl;

import com.ohaotian.plugin.common.util.DateUtils;
import com.ohaotian.plugin.file.FileClient;
import com.tydic.payment.pay.atom.PayOrderAtomService;
import com.tydic.payment.pay.atom.PorderPayTransAtomService;
import com.tydic.payment.pay.atom.PorderRefundTransAtomService;
import com.tydic.payment.pay.atom.bo.PorderPayTransAtomReqBo;
import com.tydic.payment.pay.atom.bo.PorderPayTransAtomRspBo;
import com.tydic.payment.pay.atom.bo.PorderRefundTransAtomReqBo;
import com.tydic.payment.pay.atom.bo.PorderRefundTransAtomRspBo;
import com.tydic.payment.pay.bo.PayParaInfoAttrBo;
import com.tydic.payment.pay.busi.QueryCashierInfoPayParaAttrService;
import com.tydic.payment.pay.busi.UnionAcpPayRefundBusiService;
import com.tydic.payment.pay.busi.bo.QueryCashierInfoPayParaAttrReqBo;
import com.tydic.payment.pay.busi.bo.QueryCashierInfoPayParaAttrRspBo;
import com.tydic.payment.pay.busi.bo.UnionAcpPayRefundBusiReqBO;
import com.tydic.payment.pay.busi.bo.UnionAcpPayRefundBusiRspBO;
import com.tydic.payment.pay.common.util.MoneyUtils;
import com.tydic.payment.pay.config.vo.PayPropertiesVo;
import com.tydic.payment.pay.dao.po.PorderPo;
import com.tydic.payment.pay.exception.BusinessException;
import com.tydic.payment.pay.sdk.unionpay.AcpService;
import com.tydic.payment.pay.sdk.unionpay.SdkConfig;
import com.tydic.payment.pay.util.UnionPayAcpSdkConfigUtils;
import com.tydic.payment.pay.util.UnionPayAcpSdkRspUtils;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UnionAcpPayRefundBusiServiceImpl
implements UnionAcpPayRefundBusiService {
    @Resource
    private FileClient fileClient;
    @Autowired
    private PayPropertiesVo payPropertiesVo;
    @Autowired
    private PorderPayTransAtomService porderPayTransAtomService;
    @Autowired
    private PorderRefundTransAtomService porderRefundTransAtomService;
    @Autowired
    private PayOrderAtomService payOrderAtomService;
    @Autowired
    private QueryCashierInfoPayParaAttrService queryCashierInfoPayParaAttrService;

    public UnionAcpPayRefundBusiRspBO refund(UnionAcpPayRefundBusiReqBO reqBO) {
        PorderRefundTransAtomRspBo orderRefundTrans = this.getOrderRefundTrans(reqBO);
        PorderPayTransAtomRspBo orderPayTrans = this.getOrderPayTrans(orderRefundTrans.getPayOrderId());
        String txnType = this.getTxnType(orderPayTrans, orderRefundTrans, reqBO);
        Map<String, String> paramMap = this.getPayParamMap(reqBO.getMerchantId());
        String merId = paramMap.get("merId");
        UnionPayAcpSdkConfigUtils.setMerInfoByMap(this.payPropertiesVo, this.fileClient, paramMap);
        Map<String, String> requestData = this.buildRequestData(reqBO, orderRefundTrans, txnType, merId, orderPayTrans.getPayNotifyTransId());
        Map reqData = AcpService.sign(requestData, (String)"UTF-8");
        String reqUrl = SdkConfig.getConfig().getBackRequestUrl();
        Map rspData = AcpService.post((Map)reqData, (String)reqUrl, (String)"UTF-8");
        return this.buildRspBO(reqBO, paramMap, rspData);
    }

    private UnionAcpPayRefundBusiRspBO buildRspBO(UnionAcpPayRefundBusiReqBO reqBO, Map<String, String> paramMap, Map<String, String> rspData) {
        UnionAcpPayRefundBusiRspBO rspBO = new UnionAcpPayRefundBusiRspBO();
        rspBO.setRspCode("8888");
        PorderRefundTransAtomReqBo orderRefundTransUpdateReqBO = new PorderRefundTransAtomReqBo();
        orderRefundTransUpdateReqBO.setRefundOrderId(reqBO.getRefundOrderId());
        orderRefundTransUpdateReqBO.setOrderId(reqBO.getRefundId());
        PorderPo orderUpdateReqPO = new PorderPo();
        orderUpdateReqPO.setOrderId(reqBO.getRefundId());
        if (rspData.isEmpty()) {
            rspBO.setRspName("\u672a\u83b7\u53d6\u5230\u8fd4\u56de\u62a5\u6587\u6216\u8fd4\u56dehttp\u72b6\u6001\u7801\u975e200");
            rspBO.setMsg("\u672a\u83b7\u53d6\u5230\u8fd4\u56de\u62a5\u6587\u6216\u8fd4\u56dehttp\u72b6\u6001\u7801\u975e200");
            rspBO.setRefundStatus("FAIL");
            return rspBO;
        }
        if (!AcpService.validate(rspData, (String)"UTF-8")) {
            rspBO.setRspName("\u89e3\u6790\u54cd\u5e94\u62a5\u6587\uff0c\u9a8c\u8bc1\u7b7e\u540d\u5931\u8d25");
            rspBO.setMsg("\u89e3\u6790\u54cd\u5e94\u62a5\u6587\uff0c\u9a8c\u8bc1\u7b7e\u540d\u5931\u8d25");
            rspBO.setRefundStatus("FAIL");
            return rspBO;
        }
        String tradeTime = rspData.get("txnTime");
        if (UnionPayAcpSdkRspUtils.isSuccess(rspData.get("respCode"))) {
            rspBO.setRefundStatus("SUCCESS");
            rspBO.setTradeTime(tradeTime);
            rspBO.setRspName("\u9000\u6b3e\u6210\u529f");
            orderUpdateReqPO.setOrderStatus("B10");
            orderUpdateReqPO.setTradeTime(tradeTime);
            orderRefundTransUpdateReqBO.setOrderStatus("B10");
            orderRefundTransUpdateReqBO.setTradeTime(tradeTime);
            orderRefundTransUpdateReqBO.setPayNotifyTransId(tradeTime);
            orderRefundTransUpdateReqBO.setPayMsg("\u9000\u6b3e\u8bf7\u6c42\u53d7\u7406\u6210\u529f");
        } else {
            rspBO.setRefundStatus("FAIL");
            rspBO.setRspName("\u6210\u529f");
            rspBO.setMsg(rspData.get("respMsg"));
            orderUpdateReqPO.setOrderStatus("B20");
            orderRefundTransUpdateReqBO.setOrderStatus("B20");
            orderRefundTransUpdateReqBO.setPayMsg(rspData.get("respMsg"));
            orderRefundTransUpdateReqBO.setTradeTime(tradeTime);
        }
        this.payOrderAtomService.update(orderUpdateReqPO);
        try {
            this.porderRefundTransAtomService.updateOrderRefundTransByRefundOrderId(orderRefundTransUpdateReqBO);
        }
        catch (Exception ex) {
            throw new BusinessException("\u7cfb\u7edf\u5f02\u5e38", "\u66f4\u65b0\u9000\u6b3e\u6d41\u6c34\u8868\u5f02\u5e38", (Throwable)ex);
        }
        rspBO.setRspCode("0000");
        return rspBO;
    }

    private Map<String, String> buildRequestData(UnionAcpPayRefundBusiReqBO reqBO, PorderRefundTransAtomRspBo orderRefundTrans, String txnType, String merId, String payNotifyTransId) {
        HashMap<String, String> data = new HashMap<String, String>(32);
        data.put("version", SdkConfig.getConfig().getVersion());
        data.put("encoding", "UTF-8");
        data.put("signMethod", SdkConfig.getConfig().getSignMethod());
        data.put("txnType", txnType);
        data.put("txnSubType", "00");
        data.put("bizType", "000201");
        data.put("channelType", "07");
        data.put("merId", merId);
        data.put("accessType", "0");
        data.put("orderId", reqBO.getRefundOrderId());
        String txnTime = DateUtils.dateToStr((Date)orderRefundTrans.getCreateTime(), (String)"yyyyMMddHHmmss");
        data.put("txnTime", txnTime);
        data.put("currencyCode", "156");
        data.put("txnAmt", new BigDecimal(reqBO.getRefundFee()).longValue() + "");
        data.put("backUrl", SdkConfig.getConfig().getBackUrl());
        data.put("origQryId", payNotifyTransId);
        return data;
    }

    private Map<String, String> getPayParamMap(Long merchantId) {
        QueryCashierInfoPayParaAttrReqBo paraReq = new QueryCashierInfoPayParaAttrReqBo();
        paraReq.setPayMethod("110");
        paraReq.setMerchantId(String.valueOf(merchantId));
        QueryCashierInfoPayParaAttrRspBo paraInfo = this.queryCashierInfoPayParaAttrService.queryPayParaAttr(paraReq);
        if (paraInfo == null || !"0000".equals(paraInfo.getRspCode())) {
            throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u6839\u636e\u5546\u6237\u53f7\u3010" + merchantId + "\u3011\u67e5\u8be2\u652f\u4ed8\u53c2\u6570\u914d\u7f6e\u5931\u8d25\uff01");
        }
        if (paraInfo.getInfoPayParaAttrList() == null || paraInfo.getInfoPayParaAttrList().size() < 1) {
            throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u6839\u636e\u5546\u6237\u53f7\u3010" + merchantId + "\u3011\u67e5\u8be2\u65e0\u652f\u4ed8\u53c2\u6570\u914d\u7f6e\uff01");
        }
        HashMap<String, String> paramMap = new HashMap<String, String>(8);
        for (PayParaInfoAttrBo para : paraInfo.getInfoPayParaAttrList()) {
            paramMap.put(para.getAttrCode(), para.getAttrValue());
        }
        return paramMap;
    }

    private String getTxnType(PorderPayTransAtomRspBo orderPayTrans, PorderRefundTransAtomRspBo orderRefundTrans, UnionAcpPayRefundBusiReqBO reqBO) {
        String refundOrderTransDay;
        String payOrderTransDay = DateUtils.dateToStrYYYYMMdd((Date)orderPayTrans.getCreateTime());
        if (Objects.equals(payOrderTransDay, refundOrderTransDay = DateUtils.dateToStrYYYYMMdd((Date)orderRefundTrans.getCreateTime()))) {
            String payFee = MoneyUtils.haoToFen((Long)orderPayTrans.getPayFee()).toString();
            if (Objects.equals(payFee, reqBO.getRefundFee())) {
                return "31";
            }
            throw new RuntimeException("\u5f53\u5929\u9000\u6b3e\u91d1\u989d\u3010" + payFee + "\u5206\u3011\u4e0e\u652f\u4ed8\u91d1\u989d\u3010" + reqBO.getRefundFee() + "\u5206\u3011\u4e0d\u4e00\u81f4");
        }
        Long availableRefundFee = MoneyUtils.haoToFen((Long)(orderPayTrans.getPayFee() - orderPayTrans.getRefundFee())).longValue();
        Long refundFee = new BigDecimal(reqBO.getRefundFee()).longValue();
        if (refundFee > availableRefundFee) {
            throw new RuntimeException("\u9000\u6b3e\u91d1\u989d\u3010" + reqBO.getRefundFee() + "\u5206\u3011\u5927\u4e8e\u53ef\u9000\u6b3e\u91d1\u989d\u3010" + availableRefundFee + "\u5206\u3011");
        }
        return "04";
    }

    private PorderRefundTransAtomRspBo getOrderRefundTrans(UnionAcpPayRefundBusiReqBO reqBO) {
        PorderRefundTransAtomRspBo queryRspBO;
        PorderRefundTransAtomReqBo queryReqBO = new PorderRefundTransAtomReqBo();
        queryReqBO.setRefundOrderId(reqBO.getRefundOrderId());
        try {
            queryRspBO = this.porderRefundTransAtomService.queryOrderRefundTransByRefundOrderId(queryReqBO);
        }
        catch (Exception e) {
            throw new RuntimeException("\u67e5\u8be2\u9000\u6b3e\u6d41\u6c34\u3010refundOrderId = " + reqBO.getRefundOrderId() + "\u3011\u5f02\u5e38", e);
        }
        if (queryRspBO == null) {
            throw new RuntimeException("\u67e5\u8be2\u9000\u6b3e\u6d41\u6c34\u3010refundOrderId = " + reqBO.getRefundOrderId() + "\u3011\u4e3a\u7a7a");
        }
        return queryRspBO;
    }

    private PorderPayTransAtomRspBo getOrderPayTrans(String payOrderId) {
        PorderPayTransAtomRspBo queryRspBO;
        PorderPayTransAtomReqBo queryReqBO = new PorderPayTransAtomReqBo();
        queryReqBO.setPayOrderId(payOrderId);
        try {
            queryRspBO = this.porderPayTransAtomService.queryOrderPayTransByPayOrderId(queryReqBO);
        }
        catch (Exception e) {
            throw new RuntimeException("\u67e5\u8be2\u652f\u4ed8\u6d41\u6c34\u3010payOrderId = " + payOrderId + "\u3011\u5f02\u5e38", e);
        }
        if (queryRspBO == null) {
            throw new RuntimeException("\u67e5\u8be2\u652f\u4ed8\u6d41\u6c34\u3010payOrderId = " + payOrderId + "\u3011\u4e3a\u7a7a");
        }
        return queryRspBO;
    }
}

