/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.comb.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSON;
import com.tydic.payment.pay.atom.PorderPayTransAtomService;
import com.tydic.payment.pay.atom.bo.PorderPayTransAtomRspBo;
import com.tydic.payment.pay.busi.PayOrderBusiService;
import com.tydic.payment.pay.busi.PayProOrderQueryBusiService;
import com.tydic.payment.pay.busi.PayProQueryPayParaBusiService;
import com.tydic.payment.pay.busi.bo.PayOrderRspBo;
import com.tydic.payment.pay.busi.bo.PayProOrderQueryBusiReqBo;
import com.tydic.payment.pay.busi.bo.PayProOrderQueryByOutOrderIdAndBusiIdBusiRspBo;
import com.tydic.payment.pay.busi.bo.PayProQueryPayParaBusiReqBo;
import com.tydic.payment.pay.busi.bo.PayProQueryPayParaBusiRspBo;
import com.tydic.payment.pay.comb.PayProQryCertifiedInfoCombService;
import com.tydic.payment.pay.comb.bo.PayProQryCertifiedInfoCombServiceReqBo;
import com.tydic.payment.pay.comb.bo.PayProQryCertifiedInfoCombServiceRspBo;
import com.tydic.payment.pay.common.util.MoneyUtils;
import com.tydic.payment.pay.constant.PayProConstants;
import com.tydic.payment.pay.icbc.util.StringUtils;
import com.tydic.payment.pay.util.PayProRspUtil;
import com.tydic.utils.generatedoc.util.ArgValidator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="payProQryCertifiedInfoCombService")
@HSFProvider(serviceVersion="2.0.0", serviceGroup="PAYMENT_GROUP_DEV", serviceInterface=PayProQryCertifiedInfoCombService.class)
public class PayProQryCertifiedInfoCombServiceImpl
implements PayProQryCertifiedInfoCombService {
    private static final Logger log = LoggerFactory.getLogger(PayProQryCertifiedInfoCombServiceImpl.class);
    @Autowired
    private PayProOrderQueryBusiService payProOrderQueryBusiService;
    @Autowired
    private PayOrderBusiService payOrderBusiService;
    @Autowired
    private PorderPayTransAtomService porderPayTransAtomService;
    @Autowired
    private PayProQueryPayParaBusiService payProQueryPayParaBusiService;

    public PayProQryCertifiedInfoCombServiceRspBo qryCertifiedOrder(PayProQryCertifiedInfoCombServiceReqBo reqBo) {
        PayProQryCertifiedInfoCombServiceRspBo retBo = PayProRspUtil.generateRspBo("213017", "\u5931\u8d25", PayProQryCertifiedInfoCombServiceRspBo.class);
        String validateStr = ArgValidator.validateArg((Object)reqBo);
        if (!StringUtils.isEmpty((String)validateStr)) {
            log.error("\u67e5\u8be2\u4fdd\u4ed8\u8ba2\u5355\u4fe1\u606f\u670d\u52a1\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a{}", (Object)validateStr);
            retBo.setRespDesc("\u67e5\u8be2\u4fdd\u4ed8\u8ba2\u5355\u4fe1\u606f\u670d\u52a1\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            return retBo;
        }
        PayProOrderQueryBusiReqBo qryOrderReqBo = new PayProOrderQueryBusiReqBo();
        qryOrderReqBo.setBusiId(reqBo.getBusiId());
        qryOrderReqBo.setOutOrderId(reqBo.getOriOutOrderId());
        PayProOrderQueryByOutOrderIdAndBusiIdBusiRspBo qryOrderRetBo = this.payProOrderQueryBusiService.queryOrderQueryByBusiIdAndOutOrderId(qryOrderReqBo);
        if (!"0000".equals(qryOrderRetBo.getRespCode())) {
            log.error("\u67e5\u8be2\u4fdd\u4ed8\u8ba2\u5355\u4fe1\u606f\u5931\u8d25\uff1a{}", (Object)qryOrderRetBo.getRespDesc());
            BeanUtils.copyProperties((Object)qryOrderRetBo, (Object)retBo);
            return retBo;
        }
        Long orderId = qryOrderRetBo.getOrderId();
        PayOrderRspBo orderInfoRetBo = this.payOrderBusiService.selectOrderByOrderId(orderId);
        if (!"0000".equals(orderInfoRetBo.getRspCode())) {
            BeanUtils.copyProperties((Object)orderInfoRetBo, (Object)retBo);
            return retBo;
        }
        String oriRealPayOutOrderId = orderInfoRetBo.getOrderAttrValue3();
        if (!StringUtils.isEmpty((String)oriRealPayOutOrderId) && !oriRealPayOutOrderId.equals(reqBo.getOutOrderId())) {
            log.error("\u4fdd\u4ed8\u8ba2\u5355[oriOutOrderId={}]\u66fe\u53d1\u8d77\u8fc7\u5b9e\u4ed8\uff0c\u539f\u5b9e\u4ed8\u5916\u90e8\u8ba2\u5355\u4e3a[{}]\uff0c\u4e0e\u672c\u6b21\u4f20\u5165\u7684\u5b9e\u4ed8\u5916\u90e8\u8ba2\u5355[outOrderId={}]\u4e0d\u5339\u914d", new Object[]{reqBo.getOriOutOrderId(), oriRealPayOutOrderId, reqBo.getOutOrderId()});
            retBo.setRespDesc("\u4fdd\u4ed8\u8ba2\u5355[oriOutOrderId=" + reqBo.getOriOutOrderId() + "]\u66fe\u53d1\u8d77\u5b9e\u4ed8\uff0c\u539f\u5b9e\u4ed8\u5916\u90e8\u8ba2\u5355\u4e3a[" + oriRealPayOutOrderId + "]\uff0c\u4e0e\u672c\u6b21\u4f20\u5165\u7684\u5b9e\u4ed8\u5916\u90e8\u8ba2\u5355[outOrderId=" + reqBo.getOutOrderId() + "]\u4e0d\u5339\u914d");
            return retBo;
        }
        PorderPayTransAtomRspBo transInfoRetBo = this.porderPayTransAtomService.queryLastRecordByOrderId(orderId);
        if (null == transInfoRetBo) {
            log.error("\u539f\u8ba2\u5355{}\u8fd8\u672a\u53d1\u8d77\u652f\u4ed8\uff0c\u4e0d\u53ef\u6267\u884c\u5b9e\u4ed8\u64cd\u4f5c", (Object)reqBo.getOriOutOrderId());
            retBo.setRespDesc("\u539f\u8ba2\u5355" + reqBo.getOriOutOrderId() + "\u8fd8\u672a\u53d1\u8d77\u652f\u4ed8\uff0c\u4e0d\u53ef\u6267\u884c\u5b9e\u4ed8\u64cd\u4f5c");
            return retBo;
        }
        Long oriPayMethod = (long)transInfoRetBo.getPayMethod();
        if (!PayProConstants.PayMethod.CNNC_CQT_PUBLIC.getPayMethod().equals(oriPayMethod) && !PayProConstants.PayMethod.CHINA_BANK_ORDER_PAY.getPayMethod().equals(oriPayMethod)) {
            log.error("\u539f\u652f\u4ed8\u8ba2\u5355\u975e\u7279\u6b8a\u652f\u4ed8\u65b9\u5f0f\u8ba2\u5355\uff0c\u4e0d\u53ef\u8fdb\u884c\u5b9e\u4ed8\u64cd\u4f5c");
            retBo.setRespDesc("\u539f\u652f\u4ed8\u8ba2\u5355\u975e\u7279\u6b8a\u652f\u4ed8\u65b9\u5f0f\u8ba2\u5355\uff0c\u4e0d\u53ef\u8fdb\u884c\u5b9e\u4ed8\u64cd\u4f5c");
            return retBo;
        }
        if (!"A10".equals(orderInfoRetBo.getOrderStatus()) || !"A10".equals(transInfoRetBo.getOrderStatus())) {
            log.error("\u539f\u8ba2\u5355\u672a\u652f\u4ed8\u6210\u529f\uff0c\u4e0d\u53ef\u8fdb\u884c\u5b9e\u4ed8\u64cd\u4f5c");
            retBo.setRespDesc("\u539f\u8ba2\u5355\u672a\u652f\u4ed8\uff0c\u4e0d\u53ef\u8fdb\u884c\u5b9e\u4ed8\u64cd\u4f5c");
            return retBo;
        }
        String busiReqData = this.getCertifiedParams(transInfoRetBo);
        if (busiReqData == null) {
            retBo.setRespDesc("\u83b7\u53d6\u4fdd\u4ed8\u8ba2\u5355\u652f\u4ed8\u673a\u6784\u914d\u7f6e\u53c2\u6570\u5931\u8d25");
            return retBo;
        }
        BeanUtils.copyProperties((Object)transInfoRetBo, (Object)retBo);
        retBo.setOriOrderId(orderId);
        retBo.setCertifiedMerchantId(transInfoRetBo.getMerchantId());
        retBo.setPayFee(Long.valueOf(MoneyUtils.haoToFen((Long)transInfoRetBo.getPayFee()).longValue()));
        retBo.setDetailName(orderInfoRetBo.getDetailName());
        retBo.setBusiReqData(busiReqData);
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        return retBo;
    }

    private String getCertifiedParams(PorderPayTransAtomRspBo transInfoRetBo) {
        PayProQueryPayParaBusiReqBo qryParaReqBo = new PayProQueryPayParaBusiReqBo();
        qryParaReqBo.setPayMethod(transInfoRetBo.getPayMethod());
        qryParaReqBo.setMerchantId(transInfoRetBo.getMerchantId());
        PayProQueryPayParaBusiRspBo qryParaRetBo = this.payProQueryPayParaBusiService.queryPayPara(qryParaReqBo);
        if (!"0000".equals(qryParaRetBo.getRespCode())) {
            log.error("\u67e5\u8be2\u4fdd\u4ed8\u8ba2\u5355\u652f\u4ed8\u53c2\u6570\u9519\u8bef\uff1a{}", (Object)qryParaRetBo.getRespDesc());
            return null;
        }
        Map detailAttrs = qryParaRetBo.getDetailAttrs();
        detailAttrs.put("traceNo", transInfoRetBo.getPayOrderId());
        return JSON.toJSONString((Object)detailAttrs);
    }
}

