/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.config;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.payment.pay.atom.MerchantInfoAtomService;
import com.tydic.payment.pay.atom.PayMethodAtomService;
import com.tydic.payment.pay.atom.PayOrderAtomService;
import com.tydic.payment.pay.atom.PaymentInsAtomService;
import com.tydic.payment.pay.atom.PorderPayTransAtomService;
import com.tydic.payment.pay.atom.PorderRefundTransAtomService;
import com.tydic.payment.pay.atom.bo.PorderRefundTransAtomReqBo;
import com.tydic.payment.pay.atom.bo.PorderRefundTransAtomRspBo;
import com.tydic.payment.pay.bo.PayProAsyncNoticeDataBo;
import com.tydic.payment.pay.bo.PayProBaseRspBo;
import com.tydic.payment.pay.busi.DataEncryptionService;
import com.tydic.payment.pay.busi.QueryDBDateBusiService;
import com.tydic.payment.pay.busi.bo.DataEncryptionReqBo;
import com.tydic.payment.pay.busi.bo.DataEncryptionRspBo;
import com.tydic.payment.pay.common.util.MoneyUtils;
import com.tydic.payment.pay.config.quartz.RefundCallBackSender;
import com.tydic.payment.pay.config.vo.PayPropertiesVo;
import com.tydic.payment.pay.constant.CodeTypeValueConstants;
import com.tydic.payment.pay.dao.po.MerChantInfoPo;
import com.tydic.payment.pay.dao.po.PayMethodPo;
import com.tydic.payment.pay.dao.po.PaymentInsPo;
import com.tydic.payment.pay.dao.po.PorderPo;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component
public class PayProAsyncNotice {
    private static final Logger log = LoggerFactory.getLogger(PayProAsyncNotice.class);
    private static final String RESULT_CODE = "resultCode";
    private static final String SUCCESS = "SUCCESS";
    private static final String NOTIFY_SUCCESS = "0";
    @Autowired
    private PayOrderAtomService payOrderAtomService;
    @Autowired
    private PorderPayTransAtomService porderPayTransAtomService;
    @Autowired
    private PorderRefundTransAtomService porderRefundTransAtomService;
    @Autowired
    private QueryDBDateBusiService queryDbDateBusiService;
    @Autowired
    private PayPropertiesVo payPropertiesVo;
    @Autowired
    private RefundCallBackSender refundCallBackSender;
    @Autowired
    private DataEncryptionService dataEncryptionService;
    @Autowired
    private MerchantInfoAtomService merchantInfoAtomService;
    @Autowired
    private PaymentInsAtomService paymentInsAtomService;
    @Autowired
    private PayMethodAtomService payMethodAtomService;

    @Async(value="payAsyncExecutor")
    public void sendMessage(Long orderId, String payNotifyTransId) {
        Assert.notNull((Object)orderId, (String)"\u5f02\u6b65\u901a\u77e5\u670d\u52a1\uff0c\u5165\u53c2'orderId'\u4e3a\u7a7a\uff0c\u89e6\u53d1\u652f\u4ed8\u4e2d\u5fc3\u901a\u77e5\u5931\u8d25");
        PorderPo orderInfo = this.payOrderAtomService.queryPorderInfo(orderId);
        Assert.notNull((Object)orderInfo, (String)("\u672a\u67e5\u8be2\u5230\u8ba2\u5355:" + orderId + "\u7684\u4fe1\u606f"));
        Assert.notNull((Object)orderInfo.getNotifyUrl(), (String)("\u8ba2\u5355:" + orderId + "\u4e0d\u9700\u8981\u56de\u8c03\u901a\u77e5"));
        if (NOTIFY_SUCCESS.equals(orderInfo.getCustyNotifyCode())) {
            log.info("\u8ba2\u5355[{}]\u5df2\u7ecf\u5f02\u6b65\u901a\u77e5\u6210\u529f\uff0c\u65e0\u9700\u518d\u6b21\u901a\u77e5", (Object)orderInfo.getOrderId());
            return;
        }
        if ("01".equals(orderInfo.getOrderType())) {
            this.processPayNotice(orderInfo, payNotifyTransId);
        } else if ("02".equals(orderInfo.getOrderType()) || "06".equals(orderInfo.getOrderType())) {
            this.processRefundNotice(orderInfo, payNotifyTransId);
        } else {
            log.info("\u8ba2\u5355[{}]\u65e2\u975e\u652f\u4ed8\u5355\uff0c\u4e5f\u975e\u9000\u6b3e\u5355\uff0c\u65e0\u9700\u901a\u77e5\uff01", (Object)orderId);
        }
    }

    private void processRefundNotice(PorderPo orderInfo, String payNotifyTransId) {
        PorderRefundTransAtomReqBo refundTransReqBo = new PorderRefundTransAtomReqBo();
        refundTransReqBo.setOrderId(orderInfo.getOrderId());
        List<PorderRefundTransAtomRspBo> refundTranRetBos = this.porderRefundTransAtomService.queryOrderRefundTransByCondition(refundTransReqBo);
        if (CollectionUtils.isEmpty(refundTranRetBos)) {
            log.info("\u672a\u67e5\u8be2\u5230\u9000\u6b3e\u6d41\u6c34\u8ba2\u5355\u4fe1\u606f");
            return;
        }
        if (!"B10".equals(orderInfo.getOrderStatus())) {
            log.info("\u8ba2\u5355[{}]\u672a\u9000\u6b3e\u6210\u529f\uff0c\u65e0\u9700\u901a\u77e5", (Object)orderInfo.getOrderId());
            return;
        }
        PorderRefundTransAtomRspBo refundTranBo = null;
        for (PorderRefundTransAtomRspBo refundBo : refundTranRetBos) {
            if (!payNotifyTransId.equals(refundBo.getPayNotifyTransId())) continue;
            refundTranBo = refundBo;
            break;
        }
        Object msgData = PayProAsyncNotice.assignData(orderInfo, refundTranBo);
        JSONObject msgJson = JSON.parseObject((String)JSON.toJSONString((Object)msgData));
        this.assignMsg(msgJson, refundTranBo);
        log.debug("\u56de\u8c03\u901a\u77e5\u7684\u53c2\u6570\u4e3a: {}", (Object)msgJson.toJSONString());
        DataEncryptionReqBo dataEncryptionReqBo = new DataEncryptionReqBo();
        dataEncryptionReqBo.setBusiId(orderInfo.getBusiId().toString());
        dataEncryptionReqBo.setContent(msgJson.toJSONString());
        DataEncryptionRspBo dataEncryptionRspBo = this.dataEncryptionService.dataEncryption(dataEncryptionReqBo);
        log.info("\u901a\u77e5\u7684\u6d88\u606f\u4e3b\u9898\u5185\u5bb9\u4e3a\uff1a{}\uff0c\u76ee\u6807\u5730\u5740\u4e3a\uff1a{}", (Object)dataEncryptionRspBo.getEncrypData(), (Object)orderInfo.getNotifyUrl());
        HashMap<String, String> postData = new HashMap<String, String>(16);
        postData.put("busiCode", orderInfo.getBusiCode());
        postData.put("content", dataEncryptionRspBo.getEncrypData());
        String result = HttpUtil.post((String)orderInfo.getNotifyUrl(), postData);
        log.info("\u8fd4\u56de\u53c2\u6570\u4e3a\uff1a{}", (Object)result);
        Boolean isFail = this.dealNoticeResult(result, orderInfo);
        if (isFail.booleanValue() && this.payPropertiesVo.isUseMulitpleCallBack() && orderInfo.getCurrentNoticeTime() < CodeTypeValueConstants.P_ORDER_CURRENT_NOTICE_TIME_MAX) {
            PayProBaseRspBo rspBo = this.refundCallBackSender.sendTask(orderInfo.getOrderId().toString());
            log.info("\u9996\u6b21\u56de\u8c03\u5931\u8d25\uff0c\u591a\u6b21\u56de\u8c03\u673a\u5236\u89e6\u53d1\uff0c\u8fd4\u56de\u53c2\u6570\u4e3a\uff1a" + JSONObject.toJSONString((Object)rspBo));
        }
    }

    private Boolean dealNoticeResult(String result, PorderPo orderInfo) {
        boolean isFail = false;
        if (StringUtils.isEmpty((Object)result)) {
            log.debug("\u8c03\u7528\u76ee\u6807\u5730\u5740\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a");
            return true;
        }
        PorderPo pOrder = new PorderPo();
        pOrder.setOrderId(orderInfo.getOrderId());
        if (result.contains(RESULT_CODE)) {
            if (result.contains(SUCCESS)) {
                log.debug("===========\u672c\u6b21\u901a\u77e5\u6210\u529f===========");
                pOrder.setCustyNotifyCode(NOTIFY_SUCCESS);
                pOrder.setCustNotifyMsg(SUCCESS);
            } else {
                log.debug("===========\u672c\u6b21\u901a\u77e5\u5931\u8d25===========");
                pOrder.setCustyNotifyCode("1");
                pOrder.setCustNotifyMsg("FAIL");
                isFail = true;
            }
        } else {
            pOrder.setCustyNotifyCode("1");
            pOrder.setCustNotifyMsg("FAIL");
            isFail = true;
        }
        pOrder.setCustNotifyTime(this.queryDbDateBusiService.getDBDate());
        try {
            this.payOrderAtomService.update(pOrder);
        }
        catch (Exception e) {
            log.error("\u652f\u4ed8\u4e2d\u5fc3\u901a\u77e5\uff0c\u66f4\u65b0\u6570\u636e\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
            isFail = true;
        }
        return isFail;
    }

    public static Object assignData(PorderPo orderInfo, PorderRefundTransAtomRspBo refundTranBo) {
        PayProAsyncNoticeDataBo dataBo = new PayProAsyncNoticeDataBo();
        if ("B10".equals(orderInfo.getOrderStatus())) {
            dataBo.setResultCode(SUCCESS);
            dataBo.setResultMsg("");
            dataBo.setCreateOperId(orderInfo.getCreateOperId());
            dataBo.setMerchantId(orderInfo.getMerchantId().toString());
            dataBo.setOrderAttrValue1(orderInfo.getOrderAttrValue1());
            dataBo.setOrderAttrValue2(orderInfo.getOrderAttrValue2());
            dataBo.setOrderAttrValue3(orderInfo.getOrderAttrValue3());
            dataBo.setOutOrderId(orderInfo.getOutOrderId());
            dataBo.setRealFee(!StringUtils.isEmpty((Object)orderInfo.getRealFee()) ? String.valueOf(MoneyUtils.haoToFen((Long)orderInfo.getRealFee())) : null);
            dataBo.setRemark(orderInfo.getOutRemark());
            dataBo.setReqWay(orderInfo.getReqWay());
            dataBo.setTotalFee(String.valueOf(MoneyUtils.haoToFen((Long)orderInfo.getTotalFee())));
            dataBo.setTradeTime(orderInfo.getTradeTime());
            dataBo.setTransactionsId(String.valueOf(orderInfo.getOrderId()));
            dataBo.setRefundOrderId(refundTranBo.getRefundOrderId());
            dataBo.setPayNotifyTransId(refundTranBo.getPayNotifyTransId());
        } else if ("B20".equals(orderInfo.getOrderStatus())) {
            dataBo.setResultCode("FAIL");
            dataBo.setResultMsg(refundTranBo.getPayMsg());
        } else {
            dataBo.setResultCode("FAIL");
            dataBo.setResultMsg("\u8ba2\u5355\u9000\u6b3e\u4e2d");
        }
        return dataBo;
    }

    private void processPayNotice(PorderPo orderInfo, String payNotifyTransId) {
    }

    private void assignMsg(JSONObject msgJson, PorderRefundTransAtomRspBo refundTranBo) {
        MerChantInfoPo merChantInfo;
        Long merchantId = refundTranBo.getMerchantId();
        Long payMethod = refundTranBo.getPayMethod();
        if (null != merchantId && null != (merChantInfo = this.merchantInfoAtomService.queryMerchantInfoById(merchantId))) {
            msgJson.put("merchantName", (Object)merChantInfo.getMerchantName());
        }
        if (null != payMethod) {
            PayMethodPo methodInfo = this.payMethodAtomService.queryPayMethodById(payMethod);
            if (null != methodInfo) {
                msgJson.put("payMethodName", (Object)methodInfo.getPayMethodName());
            }
            PaymentInsPo paymentInsPo = new PaymentInsPo();
            paymentInsPo.setPaymentInsId(methodInfo.getPaymentInsId());
            List<PaymentInsPo> paymentInsList = this.paymentInsAtomService.queryPaymentInf(paymentInsPo);
            if (!CollectionUtils.isEmpty(paymentInsList)) {
                PaymentInsPo paymentInsInfo = paymentInsList.get(0);
                msgJson.put("paymentInsId", (Object)paymentInsInfo.getPaymentInsId());
                msgJson.put("paymentInsName", (Object)paymentInsInfo.getPaymentInsName());
            }
        }
    }
}

