/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.payable.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.payment.pay.busi.PayOrderBusiService;
import com.tydic.payment.pay.busi.bo.PayAbleCallBackReqBo;
import com.tydic.payment.pay.busi.bo.PayAbleCallBackRspBo;
import com.tydic.payment.pay.busi.bo.PayAbleQryPayStatusReqBo;
import com.tydic.payment.pay.busi.bo.PayAbleQryPayStatusRspBo;
import com.tydic.payment.pay.busi.bo.PayAbleRefundReqBo;
import com.tydic.payment.pay.busi.bo.PayAbleRefundRspBo;
import com.tydic.payment.pay.busi.bo.PayOrderRspBo;
import com.tydic.payment.pay.constant.PayProConstants;
import com.tydic.payment.pay.dao.PayMethodMapper;
import com.tydic.payment.pay.payable.api.PayAble;
import java.util.Date;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

public abstract class AbstractCashPayAble
implements PayAble {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractCashPayAble.class);
    @Autowired
    private PayMethodMapper payMethodMapper;
    @Autowired
    private PayOrderBusiService payOrderBusiService;

    public PayAbleRefundRspBo dealRefund(PayAbleRefundReqBo reqBo) {
        LOG.info("\u73b0\u91d1\u652f\u4ed8\u80fd\u529b\u5b9e\u73b0(\u62bd\u8c61)\u2014\u2014\u9000\u6b3e");
        PayAbleRefundRspBo retBo = new PayAbleRefundRspBo();
        String validataArgStr = this.validateRefundArg(reqBo);
        if (!StringUtils.isEmpty((Object)validataArgStr)) {
            retBo.setRespCode("212020");
            retBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validataArgStr);
            return retBo;
        }
        BeanUtils.copyProperties((Object)reqBo, (Object)retBo);
        Date dbDate = this.payMethodMapper.getDBDate().getDate();
        String tradeTime = new DateTime((Object)dbDate).toString("yyyyMMddHHmmss");
        retBo.setRefundTransId(reqBo.getRefundOrderId());
        retBo.setTradeTime(tradeTime);
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        return retBo;
    }

    public PayAbleQryPayStatusRspBo qryPayStatus(PayAbleQryPayStatusReqBo reqBo) {
        LOG.info("\u73b0\u91d1\u652f\u4ed8\u80fd\u529b\u5b9e\u73b0(\u62bd\u8c61)\u2014\u2014\u72b6\u6001\u67e5\u8be2");
        PayAbleQryPayStatusRspBo retBo = new PayAbleQryPayStatusRspBo();
        String validataQryArgStr = this.validataQryArg(reqBo);
        if (!StringUtils.isEmpty((Object)validataQryArgStr)) {
            retBo.setRespCode("212021");
            retBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validataQryArgStr);
            return retBo;
        }
        Long orderId = reqBo.getOrderId();
        PayOrderRspBo orderInfo = this.payOrderBusiService.selectOrderByOrderId(orderId);
        if (orderInfo == null || !"0000".equals(orderInfo.getRspCode())) {
            retBo.setRespDesc("212021");
            retBo.setRespDesc("\u6b64\u8ba2\u5355(" + orderId + ")\u4e0d\u5b58\u5728");
            return retBo;
        }
        this.sortQryStatusBo(retBo, orderInfo);
        BeanUtils.copyProperties((Object)reqBo, (Object)retBo);
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        return retBo;
    }

    public PayAbleCallBackRspBo dealCallBack(PayAbleCallBackReqBo reqBo) {
        LOG.info("\u8fdb\u5165\u7ebf\u4e0b\u652f\u4ed8\u56de\u8c03\u5904\u7406\u65b9\u6cd5\uff1a" + reqBo);
        PayAbleCallBackRspBo retBo = new PayAbleCallBackRspBo();
        if (StringUtils.isEmpty((Object)reqBo.getReqData())) {
            LOG.error("\u7ebf\u4e0b\u652f\u4ed8\u56de\u8c03\u5904\u7406\u65b9\u6cd5\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a\u53c2\u6570'reqData'\u4e0d\u80fd\u4e3a\u7a7a");
            retBo.setRespCode("212046");
            retBo.setRespDesc("\u7ebf\u4e0b\u652f\u4ed8\u56de\u8c03\u5904\u7406\u65b9\u6cd5\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a\u53c2\u6570'reqData'\u4e0d\u80fd\u4e3a\u7a7a");
            return retBo;
        }
        JSONObject reqDataJson = JSONObject.parseObject((String)reqBo.getReqData());
        LOG.info("jsonObject:" + reqDataJson);
        retBo.setPayNotifyTransId(reqDataJson.getString("payNotifyTransId"));
        retBo.setPayOrderId(reqDataJson.getString("payOrderId"));
        retBo.setTradeTime(reqDataJson.getString("tradeTime"));
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        return retBo;
    }

    private String validateRefundArg(PayAbleRefundReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getPayOrderId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027payOrderId\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getTotalFee())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027totalFee\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getRefundOrderId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027refundOrderId\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getRefundFee())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027refundFee\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }

    private String validataQryArg(PayAbleQryPayStatusReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getPayOrderId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027payOrderId\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getOrderId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027orderId\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }

    private void sortQryStatusBo(PayAbleQryPayStatusRspBo retBo, PayOrderRspBo orderInfo) {
        String orderState = orderInfo.getOrderStatus();
        PayProConstants.CashPayStatus cashPayStatus = PayProConstants.CashPayStatus.valueOf(orderState);
        switch (cashPayStatus) {
            case A10: {
                retBo.setTradeTime(orderInfo.getTradeTime());
                retBo.setPayNotifyTransId(orderInfo.getPayNotifyTransId());
                retBo.setRealFee(orderInfo.getTotalFee());
                retBo.setPayStatus("SUCCESS");
                retBo.setPayStatusMsg("\u652f\u4ed8\u6210\u529f(cashPay)");
                break;
            }
            case A20: {
                retBo.setPayStatus("FAIL");
                retBo.setPayStatusMsg("\u652f\u4ed8\u5931\u8d25(cashPay)");
                break;
            }
            default: {
                retBo.setPayStatusMsg("\u8ba2\u5355\u4e3a\u5176\u4ed6\u72b6\u6001");
                retBo.setPayStatus("FAIL");
            }
        }
    }
}

