/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.payable.impl;

import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alipay.api.AlipayApiException;
import com.alipay.api.AlipayRequest;
import com.alipay.api.DefaultAlipayClient;
import com.alipay.api.request.AlipayDataDataserviceBillDownloadurlQueryRequest;
import com.alipay.api.response.AlipayDataDataserviceBillDownloadurlQueryResponse;
import com.tydic.payment.bill.busi.bo.BillAliPayTransCreateReqBO;
import com.tydic.payment.bill.constant.BillConstant;
import com.tydic.payment.bill.exception.BillDownAndTransException;
import com.tydic.payment.pay.common.util.MoneyUtils;
import com.tydic.payment.pay.config.vo.PayPropertiesVo;
import com.tydic.payment.pay.exception.BusinessException;
import com.tydic.payment.pay.payable.api.PayBillAble;
import com.tydic.payment.pay.payable.api.bo.PayBillAbleDownloadReqBo;
import com.tydic.payment.pay.payable.api.bo.PayBillAbleDownloadRspBo;
import com.tydic.payment.pay.payable.api.bo.PayBillAbleDownloadRspDataBo;
import com.tydic.payment.pay.util.PayProBillUtil;
import com.tydic.payment.pay.util.PayProRspUtil;
import java.io.FileInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class PayBillAbleAliImpl
implements PayBillAble {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private static final String DEFAULT_DOWNLOAD_URL = "https://openapi.alipay.com/gateway.do";
    @Autowired
    private PayPropertiesVo payPropertiesVo;
    private static final String CHARSERT = "GBK";
    private static final String BILL_TYPE = "bill_type";
    private static final String BILL_DATE = "bill_date";
    private static final String FORMAT = "json";
    private static final String REQUEST_CHARSET = "utf-8";
    private static final String SIGNTYPE = "RSA2";

    public Long paymentIns() {
        return BillConstant.PaymentIns.ALI_PAY.getPaymentInsId();
    }

    public PayBillAbleDownloadRspBo downLoadFile(PayBillAbleDownloadReqBo reqBo) {
        PayBillAbleDownloadRspBo rspBo = PayProRspUtil.generateSucRspBo(PayBillAbleDownloadRspBo.class);
        Map paraMap = reqBo.getParaMap();
        String appId = (String)paraMap.get("appid");
        String publicKey = (String)paraMap.get("publicKey");
        String privateKey = (String)paraMap.get("privateKey");
        Long billDate = reqBo.getBillDate();
        String url = this.payPropertiesVo.getAliOpenApiDomain();
        url = !StrUtil.isEmpty((CharSequence)url) ? url : DEFAULT_DOWNLOAD_URL;
        String billDateStr = this.convertDate(String.valueOf(billDate));
        DefaultAlipayClient alipayClient = new DefaultAlipayClient(url, appId, privateKey, FORMAT, REQUEST_CHARSET, publicKey, SIGNTYPE);
        AlipayDataDataserviceBillDownloadurlQueryRequest request = new AlipayDataDataserviceBillDownloadurlQueryRequest();
        LinkedHashMap<String, String> dataMap = new LinkedHashMap<String, String>(16);
        dataMap.put(BILL_TYPE, "trade");
        dataMap.put(BILL_DATE, billDateStr);
        request.setBizContent(JSON.toJSONString(dataMap));
        AlipayDataDataserviceBillDownloadurlQueryResponse response = null;
        try {
            response = (AlipayDataDataserviceBillDownloadurlQueryResponse)alipayClient.execute((AlipayRequest)request);
        }
        catch (AlipayApiException e) {
            throw new BusinessException("218008", e.getMessage());
        }
        if (response == null || !response.isSuccess()) {
            throw new BusinessException("218008", response == null ? "\u652f\u4ed8\u5b9d\u83b7\u53d6\u8d26\u5355\u8fd4\u56de\u5bf9\u8c61\u4e3a\u7a7a" : response.getSubMsg());
        }
        String filePath = PayProBillUtil.getBillFileSavePath("aliPay", String.valueOf(billDate), appId, ".zip");
        String billDownloadUrl = response.getBillDownloadUrl();
        HttpUtil.downloadFile((String)billDownloadUrl, (String)filePath);
        ArrayList<String> dataList = new ArrayList<String>();
        try {
            ZipEntry entry;
            ZipFile zf = new ZipFile(filePath, Charset.forName(CHARSERT));
            ZipInputStream zin = new ZipInputStream((InputStream)new FileInputStream(filePath), Charset.forName(CHARSERT));
            while ((entry = zin.getNextEntry()) != null && !entry.isDirectory()) {
                if (entry.getName().lastIndexOf("\u4e1a\u52a1\u660e\u7ec6.csv") == -1 || entry.getSize() <= 0L) continue;
                IoUtil.readLines((InputStream)zf.getInputStream(entry), (String)CHARSERT, dataList);
            }
            zin.closeEntry();
            zin.close();
            zf.close();
        }
        catch (Exception e) {
            throw new BillDownAndTransException("\u5904\u7406\u538b\u7f29\u6587\u4ef6\u5f02\u5e38:" + e.getMessage());
        }
        List<String> newList = this.trimFile(dataList);
        rspBo.setRspDataBos(new ArrayList(newList.size()));
        this.parseAndSavaToRspBos(newList, appId, rspBo);
        return rspBo;
    }

    private void parseAndSavaToRspBos(List<String> contentList, String appid, PayBillAbleDownloadRspBo rspBo) {
        for (String row : contentList) {
            BillAliPayTransCreateReqBO aliPayTrans = this.buildAliTransBo(appid, row);
            this.buildPayBillDownloadData(aliPayTrans, rspBo);
        }
    }

    private BillAliPayTransCreateReqBO buildAliTransBo(String appid, String row) {
        BillAliPayTransCreateReqBO aliPayTrans = new BillAliPayTransCreateReqBO();
        int index = 0;
        String[] columns = row.trim().replaceAll("\t", "").split(",");
        aliPayTrans.setTradeNo(columns[index++]);
        aliPayTrans.setOutTradeNo(columns[index++]);
        aliPayTrans.setBusiType(columns[index++]);
        aliPayTrans.setSubject(columns[index++]);
        aliPayTrans.setTransTime(columns[index++]);
        aliPayTrans.setFinishTime(columns[index++]);
        aliPayTrans.setStoreId(columns[index++]);
        aliPayTrans.setStoreName(columns[index++]);
        aliPayTrans.setOperatorId(columns[index++]);
        aliPayTrans.setTerminalId(columns[index++]);
        aliPayTrans.setBuyerLogonId(columns[index++]);
        aliPayTrans.setTotalAmount(new BigDecimal(columns[index++]));
        aliPayTrans.setReceiptAmount(new BigDecimal(columns[index++]));
        aliPayTrans.setAlipayAmount(new BigDecimal(columns[index++]));
        aliPayTrans.setPointAmount(new BigDecimal(columns[index++]));
        aliPayTrans.setAlipayDiscountAmount(new BigDecimal(columns[index++]));
        aliPayTrans.setMchDiscountAmount(new BigDecimal(columns[index++]));
        aliPayTrans.setVoucherAmount(new BigDecimal(columns[index++]));
        aliPayTrans.setVoucherName(columns[index++]);
        aliPayTrans.setMchRedAmount(new BigDecimal(columns[index++]));
        aliPayTrans.setCardAmount(new BigDecimal(columns[index++]));
        aliPayTrans.setRefundTradeNo(columns[index++]);
        aliPayTrans.setMerFee(new BigDecimal(columns[index++]));
        aliPayTrans.setFenAmount(new BigDecimal(columns[index++]));
        aliPayTrans.setRemark(columns[index]);
        aliPayTrans.setAppid(appid);
        String billDate = aliPayTrans.getFinishTime();
        billDate = billDate.replaceAll("-", "");
        billDate = billDate.substring(0, 8);
        aliPayTrans.setBillDate(Long.valueOf(billDate));
        aliPayTrans.setBillCheckFlag("0");
        return aliPayTrans;
    }

    public void buildPayBillDownloadData(BillAliPayTransCreateReqBO aliPayTrans, PayBillAbleDownloadRspBo rspBo) {
        PayBillAbleDownloadRspDataBo trans = new PayBillAbleDownloadRspDataBo();
        trans.setBillDate(aliPayTrans.getBillDate());
        trans.setBillFlag("0");
        trans.setPaymentMchId(aliPayTrans.getAppid());
        trans.setTypeTransId(aliPayTrans.getTradeNo());
        trans.setRealFee(Long.valueOf(MoneyUtils.yuanToFen((BigDecimal)aliPayTrans.getTotalAmount().abs()).longValue()));
        trans.setPaymentInsId(BillConstant.PaymentIns.ALI_PAY.getPaymentInsId());
        String tradeTime = null;
        try {
            if (!StrUtil.isEmpty((CharSequence)aliPayTrans.getFinishTime())) {
                tradeTime = new DateTime((Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(aliPayTrans.getFinishTime())).toString("yyyyMMddHHmmss");
            }
        }
        catch (ParseException e) {
            this.LOGGER.error("\u652f\u4ed8\u5b9d\u5bf9\u8d26\uff1a\u4ea4\u6613\u5b8c\u6210\u65f6\u95f4\u8f6c\u6362\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
        }
        if (!StrUtil.isEmpty(tradeTime)) {
            trans.setTradeTime(tradeTime);
        } else {
            trans.setTradeTime(String.valueOf(trans.getBillDate()));
        }
        if (StringUtils.isEmpty((Object)aliPayTrans.getRefundTradeNo())) {
            trans.setTypeOrderId(aliPayTrans.getOutTradeNo());
            trans.setOrderType("01");
        } else {
            trans.setTypeOrderId(aliPayTrans.getRefundTradeNo());
            trans.setOrderType("02");
        }
        trans.setPaymentInsObj((Object)aliPayTrans);
        rspBo.getRspDataBos().add(trans);
    }

    private List<String> trimFile(List<String> dataList) {
        for (int i = 0; i < 5; ++i) {
            dataList.remove(0);
        }
        return dataList.stream().filter(s -> !s.startsWith("#")).collect(Collectors.toList());
    }

    private String convertDate(String date) {
        return date.substring(0, 4) + "-" + date.substring(4, 6) + "-" + date.substring(6, 8);
    }
}

