/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.service.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSON;
import com.tydic.payment.pay.atom.CashierTemplateAtomService;
import com.tydic.payment.pay.busi.QueryDBDateBusiService;
import com.tydic.payment.pay.dao.po.CashierTemplatePo;
import com.tydic.payment.pay.exception.BusinessException;
import com.tydic.payment.pay.web.bo.req.AddCashierServiceReqBo;
import com.tydic.payment.pay.web.bo.rsp.AddCashierServiceRsqBo;
import com.tydic.payment.pay.web.service.AddCashierBusiService;
import java.util.List;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="addCashierBusiService")
@HSFProvider(serviceVersion="2.0.0", serviceGroup="PAYMENT_GROUP_DEV", serviceInterface=AddCashierBusiService.class)
public class AddCashierBusiServiceImpl
implements AddCashierBusiService {
    private static final Logger log = LoggerFactory.getLogger(AddCashierBusiServiceImpl.class);
    private static String SERVICE = "AddCashierBusiService";
    private static String SERVICE_NAME = "\u6536\u94f6\u53f0\u6a21\u677f\u65b0\u589e\u4e1a\u52a1\u670d\u52a1";
    @Autowired
    private CashierTemplateAtomService cashierTemplateAtomService;
    @Autowired
    private QueryDBDateBusiService queryDBDateBusiService;

    public AddCashierServiceRsqBo addCashier(AddCashierServiceReqBo reqBo) {
        log.info(SERVICE_NAME + " -> \u5165\u53c2\uff1a" + JSON.toJSONString((Object)reqBo));
        AddCashierServiceRsqBo rspBo = new AddCashierServiceRsqBo();
        this.validateArg(reqBo);
        if (!StringUtils.isEmpty((Object)reqBo.getCashierTemplate())) {
            CashierTemplatePo qryCaPo = new CashierTemplatePo();
            qryCaPo.setCashierTemplate(Long.valueOf(reqBo.getCashierTemplate()));
            List<CashierTemplatePo> qryCaL = this.cashierTemplateAtomService.queryCashierTemplateByCondition(qryCaPo);
            if (!CollectionUtils.isEmpty(qryCaL)) {
                log.info(SERVICE_NAME + " -> " + SERVICE + " -> \u5931\u8d25\uff1a\u6a21\u677f\u7f16\u7801\u51b2\u7a81");
                rspBo.setRspCode("8888");
                rspBo.setRspName("\u6a21\u677f\u7f16\u7801\u5df2\u5b58\u5728");
                return rspBo;
            }
            CashierTemplatePo creaPo = new CashierTemplatePo();
            this.beforeCopy(reqBo, creaPo);
            Long cashierTemplate = this.cashierTemplateAtomService.createCashierTemplateWithId(creaPo);
            if (cashierTemplate == null) {
                log.info(SERVICE_NAME + " -> " + SERVICE + " ,\u5931\u8d25:\u63d2\u5165\u6570\u636e\u5e93\u8868\u5931\u8d25");
                rspBo.setRspCode("8888");
                rspBo.setRspName("\u63d2\u5165\u6570\u636e\u5e93\u8868\u540e\u6ca1\u6709\u8fd4\u56de\u6a21\u677fID");
                return rspBo;
            }
            CashierTemplatePo qryCashier = this.cashierTemplateAtomService.queryCashierTemplateById(cashierTemplate);
            if (qryCashier == null) {
                rspBo.setRspCode("8888");
                rspBo.setRspName("\u65b0\u589e\u5931\u8d25\uff0c\u6570\u636e\u5e93\u4e2d\u4e0d\u5b58\u5728\u8be5\u6536\u94f6\u53f0\u6a21\u677f\u4fe1\u606f");
            } else {
                BeanUtils.copyProperties((Object)qryCashier, (Object)rspBo);
                rspBo.setCashierTemplate(qryCashier.getCashierTemplate().toString());
                rspBo.setCreateTime(qryCashier.getCreateTime() == null ? "" : new DateTime((Object)qryCashier.getCreateTime()).toString("yyyy-MM-dd HH:mm:ss"));
                rspBo.setRspName("\u65b0\u589e\u6210\u529f");
                rspBo.setRspCode("0000");
            }
            log.info(SERVICE + " -> \u51fa\u53c2" + JSON.toJSONString((Object)rspBo));
            return rspBo;
        }
        CashierTemplatePo createPo = new CashierTemplatePo();
        this.beforeCopy(reqBo, createPo);
        log.info(SERVICE_NAME + " -> PO\uff1a" + JSON.toJSONString((Object)createPo));
        Long cashierTemplateId = this.cashierTemplateAtomService.createCashierTemplate(createPo);
        log.info(SERVICE_NAME + " -> \u8fd4\u56de\u53c2\u6570\uff1a" + cashierTemplateId);
        if (cashierTemplateId == null) {
            log.info(SERVICE_NAME + " -> \u5931\u8d25:\u63d2\u5165\u6570\u636e\u5e93\u8868\u5931\u8d25");
            rspBo.setRspCode("8888");
            rspBo.setRspName("\u63d2\u5165\u6570\u636e\u5e93\u8868\u5931\u8d25");
            return rspBo;
        }
        rspBo.setCashierTemplate(cashierTemplateId.toString());
        CashierTemplatePo qryCashT = this.cashierTemplateAtomService.queryCashierTemplateById(cashierTemplateId);
        if (qryCashT != null) {
            BeanUtils.copyProperties((Object)qryCashT, (Object)rspBo);
            rspBo.setCashierTemplate(qryCashT.getCashierTemplate().toString());
            rspBo.setCreateTime(qryCashT.getCreateTime() == null ? "" : new DateTime((Object)qryCashT.getCreateTime()).toString("yyyy-MM-dd HH:mm:ss"));
            rspBo.setRspCode("0000");
            rspBo.setRspName("\u65b0\u589e\u6210\u529f");
        } else {
            rspBo.setRspCode("8888");
            rspBo.setRspName("\u65b0\u589e\u5931\u8d25\uff0c\u6570\u636e\u5e93\u4e2d\u4e0d\u5b58\u5728\u8be5\u6536\u94f6\u53f0\u6a21\u677f\u4fe1\u606f");
        }
        log.info(SERVICE_NAME + " -> \u6210\u529f");
        log.info(SERVICE + " -> \u51fa\u53c2\uff1a" + JSON.toJSONString((Object)rspBo));
        return rspBo;
    }

    private void beforeCopy(AddCashierServiceReqBo reqbo, CashierTemplatePo createPo) {
        BeanUtils.copyProperties((Object)reqbo, (Object)createPo);
        if (!StringUtils.isEmpty((Object)reqbo.getCashierTemplate())) {
            createPo.setCashierTemplate(Long.valueOf(reqbo.getCashierTemplate()));
        }
        if (!StringUtils.isEmpty((Object)reqbo.getOperId())) {
            createPo.setCreateOperId(reqbo.getOperId());
        }
        createPo.setCreateTime(this.queryDBDateBusiService.getDBDate());
    }

    private void validateArg(AddCashierServiceReqBo reqbo) {
        if (reqbo == null) {
            log.info(SERVICE_NAME + " -> \u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5165\u53c2\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqbo.getCashierTemplateName())) {
            log.info(SERVICE_NAME + " -> \u5165\u53c2cashierTemplateName(\u6536\u94f6\u53f0\u6a21\u677f\u540d\u79f0)\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u6536\u94f6\u53f0\u6a21\u677f\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqbo.getCashierTemplateUrl())) {
            log.info(SERVICE_NAME + " -> \u5165\u53c2cashierTemplateUrl(\u6536\u94f6\u53f0URL)\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u6536\u94f6\u53f0URL\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqbo.getFlag())) {
            log.info(SERVICE_NAME + " -> \u5165\u53c2flag(\u6709\u6548\u6807\u8bc6)\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u6709\u6548\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }
}

