/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.service.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSON;
import com.tydic.payment.pay.atom.BusiSystemMerchantRelAtomService;
import com.tydic.payment.pay.atom.InfoStoreAtomService;
import com.tydic.payment.pay.atom.MerchantInfoAtomService;
import com.tydic.payment.pay.atom.MerchantPayMethodRelAtomService;
import com.tydic.payment.pay.dao.po.BusiSystemMerchantRelPo;
import com.tydic.payment.pay.dao.po.InfoStorePo;
import com.tydic.payment.pay.dao.po.MerChantInfoPo;
import com.tydic.payment.pay.exception.BusinessException;
import com.tydic.payment.pay.web.bo.req.InfoStoreUpdateWebReqBo;
import com.tydic.payment.pay.web.bo.rsp.InfoStoreUpdateWebRspBo;
import com.tydic.payment.pay.web.service.InfoStoreUpdateWebService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="infoStoreUpdateWebService")
@HSFProvider(serviceVersion="2.0.0", serviceGroup="PAYMENT_GROUP_DEV", serviceInterface=InfoStoreUpdateWebService.class)
public class InfoStoreUpdateWebServiceImpl
implements InfoStoreUpdateWebService {
    private static final Logger log = LoggerFactory.getLogger(InfoStoreUpdateWebServiceImpl.class);
    @Autowired
    private MerchantInfoAtomService merchantInfoAtomService;
    @Autowired
    private InfoStoreAtomService infoStoreAtomService;
    @Autowired
    private BusiSystemMerchantRelAtomService busiSystemMerchantRelAtomService;
    @Autowired
    private MerchantPayMethodRelAtomService merchantPayMethodRelAtomService;

    public InfoStoreUpdateWebRspBo updateInfoStore(InfoStoreUpdateWebReqBo reqbo) {
        log.info("\u95e8\u5e97\u914d\u7f6e-\u5e97\u94fa\u66f4\u65b0\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + JSON.toJSONString((Object)reqbo));
        InfoStoreUpdateWebRspBo rspBo = new InfoStoreUpdateWebRspBo();
        this.validateArg(reqbo);
        Long merchantId = Long.valueOf(reqbo.getMerchantId());
        MerChantInfoPo merResultPo = this.merchantInfoAtomService.queryMerchantInfoById(merchantId);
        if (merResultPo == null) {
            log.info("\u95e8\u5e97\u914d\u7f6e-\u5e97\u94fa\u66f4\u65b0\u5931\u8d25\uff1a\u8be5\u5546\u6237\u4e0d\u5b58\u5728");
            rspBo.setRspCode("8888");
            rspBo.setRspName("\u8be5\u5546\u6237\u4fe1\u606f\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u4fee\u6539\u95e8\u5e97\u4fe1\u606f");
            return rspBo;
        }
        if (!merResultPo.getFlag().equals("1")) {
            rspBo.setRspCode("8888");
            rspBo.setRspName("\u65b0\u589e\u5931\u8d25\uff1a\u8be5\u5546\u6237\u72b6\u6001\u4e0d\u662f\u6b63\u5e38\u4f7f\u7528\u72b6\u6001");
            return rspBo;
        }
        BusiSystemMerchantRelPo busiMerRelPo = new BusiSystemMerchantRelPo();
        busiMerRelPo.setMerchantId(merchantId);
        List<BusiSystemMerchantRelPo> qryBusiMerL = this.busiSystemMerchantRelAtomService.queryBusiSystemMerchantByCondition(busiMerRelPo);
        if (CollectionUtils.isEmpty(qryBusiMerL)) {
            rspBo.setRspCode("8888");
            rspBo.setRspName("\u65b0\u589e\u95e8\u5e97\u5931\u8d25\uff1a\u8be5\u5546\u6237\u5c1a\u672a\u914d\u7f6e\u4e1a\u52a1\u7cfb\u7edf\uff0c\u65e0\u6cd5\u65b0\u589e\u95e8\u5e97");
            return rspBo;
        }
        InfoStorePo storePo = new InfoStorePo();
        storePo.setMerchantId(Long.valueOf(reqbo.getMerchantId()));
        storePo.setStoreId(Long.valueOf(reqbo.getStoreId()));
        List<InfoStorePo> storeList = this.infoStoreAtomService.queryInfoStoreByCondition(storePo);
        if (CollectionUtils.isEmpty(storeList)) {
            log.info("\u95e8\u5e97\u914d\u7f6e-\u95e8\u5e97\u66f4\u65b0\u5931\u8d25\uff1a\u8be5\u5546\u6237(" + reqbo.getMerchantId() + ")\u4e0d\u5b58\u5728\u5e97\u94faid(" + reqbo.getStoreId() + ")\u7684\u5e97\u94fa");
            rspBo.setRspCode("8888");
            rspBo.setRspName("\u66f4\u65b0\u5931\u8d25\uff1a\u8be5\u5546\u6237\u6ca1\u6709\u8be5\u95e8\u5e97");
            return rspBo;
        }
        InfoStorePo sPo = new InfoStorePo();
        BeanUtils.copyProperties((Object)reqbo, (Object)sPo);
        sPo.setMerchantId(Long.valueOf(reqbo.getMerchantId()));
        sPo.setStoreId(Long.valueOf(reqbo.getStoreId()));
        int updStore = this.infoStoreAtomService.updateInfoStore(sPo);
        InfoStorePo qryStorePo = this.infoStoreAtomService.queryInfoStoreByStoreId(Long.valueOf(reqbo.getStoreId()));
        BeanUtils.copyProperties((Object)qryStorePo, (Object)rspBo);
        rspBo.setStoreId(qryStorePo.getStoreId().toString());
        rspBo.setMerchantId(qryStorePo.getMerchantId().toString());
        if (updStore < 1) {
            log.info("\u95e8\u5e97\u914d\u7f6e-\u5e97\u94fa\u66f4\u65b0\u5931\u8d25\uff1a\u8be5\u5e97\u94fa\u4fe1\u606f\u65e0\u6cd5\u66f4\u65b0");
            rspBo.setRspCode("8888");
            rspBo.setRspName("\u66f4\u65b0\u5931\u8d25\uff1a\u8be5\u5e97\u94fa\u4fe1\u606f\u65e0\u6cd5\u66f4\u65b0");
            return rspBo;
        }
        rspBo.setRspCode("0000");
        rspBo.setRspName("\u66f4\u65b0\u6210\u529f");
        return rspBo;
    }

    private void validateArg(InfoStoreUpdateWebReqBo reqbo) {
        if (StringUtils.isEmpty((Object)reqbo)) {
            log.info("\u95e8\u5e97\u914d\u7f6e-\u5e97\u94fa\u66f4\u65b0\u5165\u53c2bo\u4e0d\u80fd\u4e3a\u7a7a");
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqbo.getMerchantId())) {
            log.info("\u95e8\u5e97\u914d\u7f6e-\u5e97\u94fa\u66f4\u65b0\u5165\u53c2bo\u7684\u5546\u6237id(merchantId)\u4e0d\u80fd\u4e3a\u7a7a");
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5546\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqbo.getStoreId())) {
            log.info("\u95e8\u5e97\u914d\u7f6e-\u5e97\u94fa\u66f4\u65b0\u5165\u53c2bo\u7684\u5e97\u94faid(storeId)\u4e0d\u80fd\u4e3a\u7a7a");
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5e97\u94faid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqbo.getStoreName())) {
            log.info("\u95e8\u5e97\u914d\u7f6e-\u5e97\u94fa\u66f4\u65b0\u5165\u53c2bo\u7684\u5e97\u94fa\u540d\u79f0(storeName)\u4e0d\u80fd\u4e3a\u7a7a");
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5e97\u94fa\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

