/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.service.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSON;
import com.tydic.payment.pay.atom.PayMethodAtomService;
import com.tydic.payment.pay.atom.PayOrderAtomService;
import com.tydic.payment.pay.atom.PorderPayTransAtomService;
import com.tydic.payment.pay.atom.PorderRefundTransAtomService;
import com.tydic.payment.pay.atom.bo.PorderPayTransAtomReqBo;
import com.tydic.payment.pay.atom.bo.PorderPayTransAtomRspBo;
import com.tydic.payment.pay.busi.QueryPCodeInfoService;
import com.tydic.payment.pay.busi.bo.QueryPCodeInfoReqBO;
import com.tydic.payment.pay.common.util.MoneyUtils;
import com.tydic.payment.pay.dao.po.PayMethodPo;
import com.tydic.payment.pay.dao.po.PorderPo;
import com.tydic.payment.pay.dao.po.PorderRefundTransPo;
import com.tydic.payment.pay.exception.BusinessException;
import com.tydic.payment.pay.web.bo.req.PayOrderDetailInfoQryWebReqBo;
import com.tydic.payment.pay.web.bo.rsp.PayOrderDetailInfoQryWebRspBo;
import com.tydic.payment.pay.web.bo.rsp.PmcPayOrderDetailQryWebBo;
import com.tydic.payment.pay.web.bo.rsp.PmcPayOrderInfoQryWebBo;
import com.tydic.payment.pay.web.service.PayOrderDetailInfoQryWebService;
import java.util.ArrayList;
import java.util.List;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="payOrderDetailInfoQryWebService")
@HSFProvider(serviceVersion="2.0.0", serviceGroup="PAYMENT_GROUP_DEV", serviceInterface=PayOrderDetailInfoQryWebService.class)
public class PayOrderDetailInfoQryWebServiceImpl
implements PayOrderDetailInfoQryWebService {
    private static final Logger LOGGER = LoggerFactory.getLogger(PayOrderDetailInfoQryWebServiceImpl.class);
    @Autowired
    PayOrderAtomService payOrderAtomService;
    @Autowired
    PorderPayTransAtomService porderPayTransAtomService;
    @Autowired
    PorderRefundTransAtomService porderRefundTransAtomService;
    @Autowired
    QueryPCodeInfoService queryPCodeInfoService;
    @Autowired
    PayMethodAtomService payMethodAtomService;

    public PayOrderDetailInfoQryWebRspBo qryPayOrderInfo(PayOrderDetailInfoQryWebReqBo reqBo) {
        LOGGER.info("\u67e5\u8be2\u652f\u4ed8\u8ba2\u5355\u5217\u8868\u8be6\u60c5\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + JSON.toJSONString((Object)reqBo));
        this.validateArg(reqBo);
        PayOrderDetailInfoQryWebRspBo rspBo = new PayOrderDetailInfoQryWebRspBo();
        PmcPayOrderInfoQryWebBo rePorderBo = new PmcPayOrderInfoQryWebBo();
        ArrayList<PmcPayOrderDetailQryWebBo> pmcPayOrderDetailQryBusiBoList = new ArrayList<PmcPayOrderDetailQryWebBo>();
        PorderPo porderPo = this.payOrderAtomService.queryPorderInfo(Long.parseLong(reqBo.getOrderId()));
        if (porderPo == null) {
            throw new BusinessException("RSP_CODE_QUERY_NOT_NULL", "\u652f\u4ed8\u8ba2\u5355\u5217\u8868\u67e5\u8be2\u8be6\u60c5\u4e1a\u52a1\u5f02\u5e38\uff1a\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a");
        }
        BeanUtils.copyProperties((Object)porderPo, (Object)rePorderBo);
        rePorderBo.setOrderId(porderPo.getOrderId() == null ? "" : porderPo.getOrderId().toString());
        rePorderBo.setMerchantId(porderPo.getMerchantId() == null ? "" : porderPo.getMerchantId().toString());
        try {
            if (porderPo.getBalanceFee() != null) {
                rePorderBo.setBalanceFee("" + MoneyUtils.haoToFen((Long)porderPo.getBalanceFee()));
            }
            if (porderPo.getOnlineFee() != null) {
                rePorderBo.setOnlineFee("" + MoneyUtils.haoToFen((Long)porderPo.getOnlineFee()));
            }
            if (porderPo.getTotalFee() != null) {
                rePorderBo.setTotalFee("" + MoneyUtils.haoToFen((Long)porderPo.getTotalFee()));
            }
            if (porderPo.getDiscountFee() != null) {
                rePorderBo.setDiscountFee("" + MoneyUtils.haoToFen((Long)porderPo.getDiscountFee()));
            }
            if (porderPo.getRealFee() != null) {
                rePorderBo.setRealFee("" + MoneyUtils.haoToFen((Long)porderPo.getRealFee()));
            }
        }
        catch (Exception e) {
            LOGGER.error("Long2BigDecimal\u6570\u636e\u8f6c\u6362\u9519\u8bef\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
        }
        rePorderBo.setCreateTime(new DateTime((Object)porderPo.getCreateTime()).toString("yyyy-MM-dd HH:mm:ss"));
        rePorderBo.setUpdateTime(new DateTime((Object)porderPo.getUpdateTime()).toString("yyyy-MM-dd HH:mm:ss"));
        rePorderBo.setExpTime(new DateTime((Object)porderPo.getExpTime()).toString("yyyy-MM-dd HH:mm:ss"));
        if (rePorderBo.getOrderType().equals("01")) {
            PorderPayTransAtomReqBo payTransAtomReqBo = new PorderPayTransAtomReqBo();
            List<Object> porderPayTransAtomRspBos = new ArrayList();
            payTransAtomReqBo.setOrderId(Long.parseLong(reqBo.getOrderId()));
            try {
                porderPayTransAtomRspBos = this.porderPayTransAtomService.queryOrderPayTransByCondition(payTransAtomReqBo);
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
            if (porderPayTransAtomRspBos.isEmpty()) {
                LOGGER.info("\u67e5\u8be2\u652f\u4ed8\u8ba2\u5355\u5217\u8868\u8be6\u60c5\u4e1a\u52a1\u670d\u52a1\uff1a\u652f\u4ed8\u660e\u7ec6\u4e3a\u7a7a");
            } else {
                for (PorderPayTransAtomRspBo porderPayTransAtomRspBo : porderPayTransAtomRspBos) {
                    PmcPayOrderDetailQryWebBo orderDetailBo = new PmcPayOrderDetailQryWebBo();
                    BeanUtils.copyProperties((Object)porderPayTransAtomRspBo, (Object)orderDetailBo);
                    if (porderPayTransAtomRspBo.getPayIntegral() != null) {
                        orderDetailBo.setPayIntegral("" + porderPayTransAtomRspBo.getPayIntegral());
                    }
                    if (porderPayTransAtomRspBo.getPayFee() != null) {
                        try {
                            orderDetailBo.setPayFee("" + MoneyUtils.haoToFen((Long)porderPayTransAtomRspBo.getPayFee()));
                        }
                        catch (Exception e) {
                            LOGGER.error("Long2BigDecimal\u6570\u636e\u8f6c\u6362\u9519\u8bef\u5f02\u5e38:" + e.getMessage(), (Throwable)e);
                        }
                    }
                    orderDetailBo.setCreateTime(new DateTime((Object)porderPayTransAtomRspBo.getCreateTime()).toString("yyyy-MM-dd HH:mm:ss"));
                    orderDetailBo.setUpdateTime(new DateTime((Object)porderPayTransAtomRspBo.getUpdateTime()).toString("yyyy-MM-dd HH:mm:ss"));
                    if (porderPayTransAtomRspBo.getPayMethod() != null) {
                        PayMethodPo po = new PayMethodPo();
                        po.setPayMethod(porderPayTransAtomRspBo.getPayMethod());
                        List<PayMethodPo> payMethodPos = this.payMethodAtomService.queryPayMethod(po);
                        if (!CollectionUtils.isEmpty(payMethodPos)) {
                            orderDetailBo.setPayMethod(payMethodPos.get(0).getPayMethodName());
                        }
                    }
                    QueryPCodeInfoReqBO bo1 = new QueryPCodeInfoReqBO();
                    bo1.setTypeCode("P_ORDER_ORDER_STATUS");
                    bo1.setCodeValue(orderDetailBo.getOrderStatus());
                    orderDetailBo.setOrderStatus(this.queryPCodeInfoService.queryPCodeInfo(bo1).getCodeInfo());
                    pmcPayOrderDetailQryBusiBoList.add(orderDetailBo);
                }
            }
        } else if (rePorderBo.getOrderType().equals("02") || rePorderBo.getOrderType().equals("06")) {
            PorderRefundTransPo refundTransPo = new PorderRefundTransPo();
            refundTransPo.setOrderId(Long.parseLong(reqBo.getOrderId()));
            List<PorderRefundTransPo> refundTransPoList = this.porderRefundTransAtomService.queryOrderRefundTrans(refundTransPo);
            if (refundTransPoList.isEmpty()) {
                LOGGER.info("\u67e5\u8be2\u652f\u4ed8\u8ba2\u5355\u5217\u8868\u8be6\u60c5\u4e1a\u52a1\u670d\u52a1\uff1a\u9000\u6b3e\u660e\u7ec6\u4e3a\u7a7a");
            } else {
                for (PorderRefundTransPo porderRefundTransPo : refundTransPoList) {
                    PmcPayOrderDetailQryWebBo orderDe = new PmcPayOrderDetailQryWebBo();
                    BeanUtils.copyProperties((Object)porderRefundTransPo, (Object)orderDe);
                    if (porderRefundTransPo.getPayIntegral() != null) {
                        orderDe.setPayIntegral("" + porderRefundTransPo.getPayIntegral());
                    }
                    if (porderRefundTransPo.getPayFee() != null) {
                        try {
                            orderDe.setPayFee("" + MoneyUtils.haoToFen((Long)porderRefundTransPo.getPayFee()));
                        }
                        catch (Exception e) {
                            LOGGER.error("Long2BigDecimal\u6570\u636e\u8f6c\u6362\u9519\u8bef\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
                        }
                    }
                    orderDe.setCreateTime(new DateTime((Object)porderRefundTransPo.getCreateTime()).toString("yyyy-MM-dd HH:mm:ss"));
                    orderDe.setUpdateTime(new DateTime((Object)porderRefundTransPo.getUpdateTime()).toString("yyyy-MM-dd HH:mm:ss"));
                    if (porderRefundTransPo.getPayMethod() != null) {
                        PayMethodPo payMethodPo = new PayMethodPo();
                        payMethodPo.setPayMethod(porderRefundTransPo.getPayMethod());
                        List<PayMethodPo> payMethodPos = this.payMethodAtomService.queryPayMethod(payMethodPo);
                        if (!payMethodPos.isEmpty()) {
                            orderDe.setPayMethod(payMethodPos.get(0).getPayMethodName());
                        }
                    }
                    QueryPCodeInfoReqBO bo1 = new QueryPCodeInfoReqBO();
                    bo1.setTypeCode("P_ORDER_ORDER_STATUS");
                    bo1.setCodeValue(orderDe.getOrderStatus());
                    orderDe.setOrderStatus(this.queryPCodeInfoService.queryPCodeInfo(bo1).getCodeInfo());
                    pmcPayOrderDetailQryBusiBoList.add(orderDe);
                }
            }
        }
        QueryPCodeInfoReqBO bo = new QueryPCodeInfoReqBO();
        bo.setTypeCode("P_ORDER_ORDER_STATUS");
        bo.setCodeValue(rePorderBo.getOrderStatus());
        rePorderBo.setOrderStatus(this.queryPCodeInfoService.queryPCodeInfo(bo).getCodeInfo());
        bo.setTypeCode("P_ORDER_ORDER_TYPE");
        bo.setCodeValue(rePorderBo.getOrderType());
        rePorderBo.setOrderType(this.queryPCodeInfoService.queryPCodeInfo(bo).getCodeInfo());
        rspBo.setPmcPayOrderInfoQryBusiBo(rePorderBo);
        rspBo.setRows(pmcPayOrderDetailQryBusiBoList);
        rspBo.setRspCode("0000");
        rspBo.setRspName("\u6210\u529f");
        LOGGER.info("\u67e5\u8be2\u652f\u4ed8\u8ba2\u5355\u5217\u8868\u8be6\u60c5\u4e1a\u52a1\u670d\u52a1\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)rspBo));
        return rspBo;
    }

    private void validateArg(PayOrderDetailInfoQryWebReqBo reqBo) {
        if (reqBo == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u67e5\u8be2\u652f\u4ed8\u8ba2\u5355\u5217\u8868\u8be6\u60c5\u4e1a\u52a1\u670d\u52a1\u5f02\u5e38\uff1a\u5165\u53c2\u5bf9\u8c61reqBo\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBo.getOrderId())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u67e5\u8be2\u652f\u4ed8\u8ba2\u5355\u5217\u8868\u8be6\u60c5\u4e1a\u52a1\u670d\u52a1\u5f02\u5e38\uff1a\u5165\u53c2\u5bf9\u8c61reqBo\u7684\u5c5e\u6027orderId\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

