/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.service.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.ohaotian.plugin.base.bo.RspPage;
import com.tydic.payment.pay.atom.BusiSystemInfoAtomService;
import com.tydic.payment.pay.atom.CashierTemplateAtomService;
import com.tydic.payment.pay.atom.RelBusiCashierAtomService;
import com.tydic.payment.pay.busi.QueryCodeListByTypecodeService;
import com.tydic.payment.pay.busi.bo.PCodeListBoStr;
import com.tydic.payment.pay.busi.bo.QueryCodeListByTypecodeReqBo;
import com.tydic.payment.pay.busi.bo.QueryCodeListByTypecodeRspBo;
import com.tydic.payment.pay.dao.po.BusiSystemInfoPO;
import com.tydic.payment.pay.dao.po.CashierTemplatePo;
import com.tydic.payment.pay.dao.po.RelBusiCashierPo;
import com.tydic.payment.pay.exception.BusinessException;
import com.tydic.payment.pay.web.bo.CashierTemplateBoStr;
import com.tydic.payment.pay.web.bo.req.QueryBusiSystemRelReqwayCashierWebReqBo;
import com.tydic.payment.pay.web.bo.rsp.QueryBusiSystemRelReqwayCashierWebRspBo;
import com.tydic.payment.pay.web.service.QueryBusiSystemRelReqwayCashierWebService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="queryBusiSystemRelReqwayCashierWebService")
@HSFProvider(serviceVersion="2.0.0", serviceGroup="PAYMENT_GROUP_DEV", serviceInterface=QueryBusiSystemRelReqwayCashierWebService.class)
public class QueryBusiSystemRelReqwayCashierWebServiceImpl
implements QueryBusiSystemRelReqwayCashierWebService {
    private static final Logger log = LoggerFactory.getLogger(QueryBusiSystemRelReqwayCashierWebServiceImpl.class);
    private static String SERVICE = "QueryBusiSystemRelReqwayCashierBusiService";
    private static String SERVICE_NAME = "\u67e5\u8be2\u4e1a\u52a1\u7cfb\u7edf\u5173\u8054\u7684\u63a5\u5165\u65b9\u5f0f\u3001\u6536\u94f6\u53f0\u6a21\u677f";
    @Autowired
    private BusiSystemInfoAtomService busiSystemInfoAtomService;
    @Autowired
    private RelBusiCashierAtomService relBusiCashierAtomService;
    @Autowired
    private QueryCodeListByTypecodeService queryCodeListByTypecodeService;
    @Autowired
    private CashierTemplateAtomService cashierTemplateAtomService;

    public RspPage<QueryBusiSystemRelReqwayCashierWebRspBo> queryBusiRelReqWayCashier(QueryBusiSystemRelReqwayCashierWebReqBo reqBo) {
        RspPage rspBo = new RspPage();
        ArrayList<QueryBusiSystemRelReqwayCashierWebRspBo> relWayList = new ArrayList<QueryBusiSystemRelReqwayCashierWebRspBo>();
        rspBo.setRows(relWayList);
        this.validateArg(reqBo);
        Long busiId = Long.valueOf(reqBo.getBusiId());
        BusiSystemInfoPO qryBusiPo = this.busiSystemInfoAtomService.queryBusiSystemInfoById(busiId);
        if (qryBusiPo == null) {
            rspBo.setPageNo(0);
            rspBo.setTotal(0);
            rspBo.setRecordsTotal(0);
            return rspBo;
        }
        ArrayList<String> reqWayList = new ArrayList<String>();
        HashMap<String, String> reqWayMap = new HashMap<String, String>();
        QueryCodeListByTypecodeReqBo qryPCodeBo = new QueryCodeListByTypecodeReqBo();
        qryPCodeBo.setTypeCode("BUSI_SYSTEM_REQ_WAY");
        QueryCodeListByTypecodeRspBo qryPCodeRsp = this.queryCodeListByTypecodeService.queryPCodeListMethod(qryPCodeBo);
        if (qryPCodeRsp.getRspCode().equals("0000")) {
            List codeList = qryPCodeRsp.getCodeList();
            for (PCodeListBoStr ttStr : codeList) {
                if (ttStr == null) continue;
                reqWayList.add(ttStr.getCodeValue());
                reqWayMap.put(ttStr.getCodeValue(), ttStr.getCodeName());
            }
        }
        ArrayList<String> validReqWayL = new ArrayList<String>();
        for (String tempReqWay : reqWayList) {
            QueryBusiSystemRelReqwayCashierWebRspBo tmpBo = new QueryBusiSystemRelReqwayCashierWebRspBo();
            tmpBo.setReqWay(tempReqWay);
            tmpBo.setReqWayName(reqWayMap.get(tempReqWay) == null ? "" : (String)reqWayMap.get(tempReqWay));
            RelBusiCashierPo qryRelCashier = new RelBusiCashierPo();
            qryRelCashier.setBusiId(busiId);
            qryRelCashier.setReqWay(tempReqWay);
            List<RelBusiCashierPo> relBusiCaList = this.relBusiCashierAtomService.queryRelBusiCashier(qryRelCashier);
            if (CollectionUtils.isEmpty(relBusiCaList)) continue;
            validReqWayL.add(tempReqWay);
            ArrayList<CashierTemplateBoStr> cashList = new ArrayList<CashierTemplateBoStr>();
            tmpBo.setCashierTemplateList(cashList);
            for (RelBusiCashierPo relTemp : relBusiCaList) {
                CashierTemplateBoStr cashTBoStr = new CashierTemplateBoStr();
                cashTBoStr.setCashierTemplate(relTemp.getCashierTemplate().toString());
                CashierTemplatePo cashierTemplatePo = this.cashierTemplateAtomService.queryCashierTemplateById(relTemp.getCashierTemplate());
                BeanUtils.copyProperties((Object)cashierTemplatePo, (Object)cashTBoStr);
                cashTBoStr.setCashierTemplate(cashierTemplatePo.getCashierTemplate().toString());
                cashTBoStr.setCreateTime(cashierTemplatePo.getCreateTime() == null ? "" : new DateTime((Object)cashierTemplatePo.getCreateTime()).toString("yyyy-MM-dd HH:mm:ss"));
                cashTBoStr.setUpdateTime(cashierTemplatePo.getUpdateTime() == null ? "" : new DateTime((Object)cashierTemplatePo.getUpdateTime()).toString("yyyy-MM-dd HH:mm:ss"));
                cashList.add(cashTBoStr);
            }
            relWayList.add(tmpBo);
        }
        rspBo.setPageNo(1);
        rspBo.setTotal(1);
        rspBo.setRecordsTotal(validReqWayL.size());
        return rspBo;
    }

    private void validateArg(QueryBusiSystemRelReqwayCashierWebReqBo reqBo) {
        if (reqBo == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((String)reqBo.getBusiId())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5165\u53c2\u4e1a\u52a1\u7cfb\u7edfID\u3010busiId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }
}

