/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.service.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.bo.RspPage;
import com.ohaotian.plugin.db.Page;
import com.tydic.payment.pay.atom.MerchantInfoAtomService;
import com.tydic.payment.pay.busi.QueryCodeListByTypecodeService;
import com.tydic.payment.pay.busi.QueryPCodeInfoService;
import com.tydic.payment.pay.busi.bo.PCodeListBoStr;
import com.tydic.payment.pay.busi.bo.QueryCodeListByTypecodeReqBo;
import com.tydic.payment.pay.busi.bo.QueryCodeListByTypecodeRspBo;
import com.tydic.payment.pay.busi.bo.QueryPCodeInfoReqBO;
import com.tydic.payment.pay.busi.bo.QueryPCodeInfoRspBO;
import com.tydic.payment.pay.dao.po.MerChantInfoPo;
import com.tydic.payment.pay.dao.po.MerchantInfoPageReqPO;
import com.tydic.payment.pay.exception.BusinessException;
import com.tydic.payment.pay.web.bo.MerchantInfoBoStr;
import com.tydic.payment.pay.web.bo.req.QueryMerchantIdAndNameReqBo;
import com.tydic.payment.pay.web.bo.req.QueryMerchantWebReqBo;
import com.tydic.payment.pay.web.bo.rsp.QueryMerchantIdAndNameRspBo;
import com.tydic.payment.pay.web.service.QueryMerchantInfoWebService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="queryMerchantInfoWebService")
@HSFProvider(serviceVersion="2.0.0", serviceGroup="PAYMENT_GROUP_DEV", serviceInterface=QueryMerchantInfoWebService.class)
public class QueryMerchantInfoWebServiceImpl
implements QueryMerchantInfoWebService {
    private static final Logger log = LoggerFactory.getLogger(QueryMerchantInfoWebServiceImpl.class);
    private static String SERVICE = "QueryMerchantInfoWebService";
    private static String SERVICE_NAME = "\u67e5\u8be2\u5546\u6237\u4fe1\u606fweb\u670d\u52a1";
    @Autowired
    private MerchantInfoAtomService merchantInfoAtomService;
    @Autowired
    QueryCodeListByTypecodeService queryCodeListByTypecodeService;
    @Autowired
    QueryPCodeInfoService queryPCodeInfoService;

    public QueryMerchantIdAndNameRspBo getAllMerchantIdAndName(QueryMerchantIdAndNameReqBo reqBo) {
        log.info(SERVICE_NAME + " -> \u5165\u53c2\uff1a" + JSON.toJSONString((Object)reqBo));
        QueryMerchantIdAndNameRspBo rspBo = new QueryMerchantIdAndNameRspBo();
        ArrayList<MerchantInfoBoStr> merList = new ArrayList<MerchantInfoBoStr>();
        rspBo.setMerchantList(merList);
        if (reqBo == null) {
            reqBo = new QueryMerchantIdAndNameReqBo();
        }
        MerChantInfoPo qryMer = new MerChantInfoPo();
        if (!StringUtils.isEmpty((Object)reqBo.getMerchantId())) {
            qryMer.setMerchantId(Long.valueOf(reqBo.getMerchantId()));
        }
        List<MerChantInfoPo> qryResultL = this.merchantInfoAtomService.queryMerChantIdAndNameByCondition(qryMer);
        for (MerChantInfoPo temp : qryResultL) {
            MerchantInfoBoStr tempBo = new MerchantInfoBoStr();
            tempBo.setMerchantId(temp.getMerchantId().toString());
            tempBo.setMerchantName(temp.getMerchantName());
            merList.add(tempBo);
        }
        rspBo.setRspCode("0000");
        rspBo.setRspName("\u67e5\u8be2\u6210\u529f");
        log.info(SERVICE_NAME + " -> \u51fa\u53c2\uff1a" + JSON.toJSONString((Object)rspBo));
        return rspBo;
    }

    public RspPage<MerchantInfoBoStr> queryMerchantInfo(QueryMerchantWebReqBo reqBo) {
        List codesL;
        List codeL;
        List<MerChantInfoPo> queryRspList;
        log.info("\u5546\u6237\u5217\u8868\u67e5\u8be2\u670d\u52a1\u5165\u53c2\uff1a" + JSON.toJSONString((Object)reqBo));
        RspPage rspPage = new RspPage();
        ArrayList<MerchantInfoBoStr> rsList = new ArrayList<MerchantInfoBoStr>();
        rspPage.setRows(rsList);
        if (reqBo == null) {
            reqBo = new QueryMerchantWebReqBo();
        }
        Page page = null;
        if (reqBo.getPageNo() > 1) {
            page = new Page(reqBo.getPageNo(), reqBo.getPageSize());
        } else {
            page = new Page();
            BeanUtils.copyProperties((Object)reqBo, (Object)page);
            if (page.getPageNo() < 1) {
                page.setPageNo(1);
            }
            if (page.getPageSize() < 1) {
                page.setPageSize(10);
            }
        }
        MerchantInfoPageReqPO qryPo = new MerchantInfoPageReqPO();
        BeanUtils.copyProperties((Object)reqBo, (Object)((Object)qryPo));
        try {
            if (!StringUtils.isEmpty((Object)reqBo.getMerchantId())) {
                qryPo.setMerchantId(Long.parseLong(reqBo.getMerchantId()));
            }
            if (!StringUtils.isEmpty((Object)reqBo.getMainMerchantId())) {
                qryPo.setMainMerchantId(Long.parseLong(reqBo.getMainMerchantId()));
            }
            if (!StringUtils.isEmpty((Object)reqBo.getMerchantType())) {
                qryPo.setMerchantType(Integer.parseInt(reqBo.getMerchantType()));
            }
        }
        catch (Exception e) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5546\u6237\u5217\u8868\u67e5\u8be2\u670d\u52a1\u5165\u53c2\u5b57\u6bb5\u975e\u6cd5");
        }
        if (!StringUtils.isEmpty((Object)reqBo.getCreateTimeStart())) {
            qryPo.setCreateTimeStart(new DateTime((Object)reqBo.getCreateTimeStart()).withMillisOfDay(0).toString());
        }
        if (!StringUtils.isEmpty((Object)reqBo.getCreateTimeEnd())) {
            qryPo.setCreateTimeEnd(new DateTime((Object)reqBo.getCreateTimeEnd()).plusDays(1).withMillisOfDay(0).toString());
        }
        if (!StringUtils.isEmpty((Object)reqBo.getUpdateTimeStart())) {
            qryPo.setUpdateTimeStart(new DateTime((Object)reqBo.getUpdateTimeStart()).withMillisOfDay(0).toString());
        }
        if (!StringUtils.isEmpty((Object)reqBo.getUpdateTimeEnd())) {
            qryPo.setUpdateTimeEnd(new DateTime((Object)reqBo.getUpdateTimeEnd()).plusDays(1).withMillisOfDay(0).toString());
        }
        if (!StringUtils.isEmpty((Object)reqBo.getApproveTimeStart())) {
            qryPo.setApproveTimeStart(new DateTime((Object)reqBo.getApproveTimeStart()).withMillisOfDay(0).toString());
        }
        if (!StringUtils.isEmpty((Object)reqBo.getApproveTimeEnd())) {
            qryPo.setApproveTimeEnd(new DateTime((Object)reqBo.getApproveTimeEnd()).plusDays(1).withMillisOfDay(0).toString());
        }
        if (CollectionUtils.isEmpty(queryRspList = this.merchantInfoAtomService.queryMerChantInfoWithPage((Page<MerchantInfoPageReqPO>)page, qryPo))) {
            rspPage.setTotal(0);
            rspPage.setRecordsTotal(0);
            rspPage.setPageNo(1);
            return rspPage;
        }
        HashMap<String, String> typeMap = new HashMap<String, String>();
        QueryCodeListByTypecodeReqBo qryPCode = new QueryCodeListByTypecodeReqBo();
        qryPCode.setTypeCode("MERCHANT_TYPE");
        QueryCodeListByTypecodeRspBo qryPCodeRsp = this.queryCodeListByTypecodeService.queryPCodeListMethod(qryPCode);
        if (qryPCodeRsp.getRspCode().equals("0000") && !CollectionUtils.isEmpty((Collection)(codeL = qryPCodeRsp.getCodeList()))) {
            for (PCodeListBoStr tcode : codeL) {
                typeMap.put(tcode.getCodeValue(), tcode.getCodeName());
            }
        }
        HashMap<String, String> flagMap = new HashMap<String, String>();
        QueryCodeListByTypecodeReqBo qryPCFlagode = new QueryCodeListByTypecodeReqBo();
        qryPCFlagode.setTypeCode("MERCHANT_FLAG");
        QueryCodeListByTypecodeRspBo qryPCFlagodeRsp = this.queryCodeListByTypecodeService.queryPCodeListMethod(qryPCFlagode);
        if (qryPCFlagodeRsp.getRspCode().equals("0000") && !CollectionUtils.isEmpty((Collection)(codesL = qryPCFlagodeRsp.getCodeList()))) {
            for (PCodeListBoStr tcode : codesL) {
                flagMap.put(tcode.getCodeValue(), tcode.getCodeName());
            }
        }
        for (MerChantInfoPo temp : queryRspList) {
            MerchantInfoBoStr tbo = new MerchantInfoBoStr();
            BeanUtils.copyProperties((Object)temp, (Object)tbo);
            tbo.setMerchantId(temp.getMerchantId() == null ? "" : temp.getMerchantId().toString());
            tbo.setMainMerchantId(temp.getMainMerchantId() == null ? "" : temp.getMainMerchantId().toString());
            tbo.setCreateTime(temp.getCreateTime() == null ? "" : new DateTime((Object)temp.getCreateTime()).toString("yyyy-MM-dd HH:mm:ss"));
            tbo.setUpdateTime(temp.getUpdateTime() == null ? "" : new DateTime((Object)temp.getUpdateTime()).toString("yyyy-MM-dd HH:mm:ss"));
            tbo.setApproveTime(temp.getApproveTime() == null ? "" : new DateTime((Object)temp.getApproveTime()).toString("yyyy-MM-dd HH:mm:ss"));
            if (temp.getMainMerchantId() != null) {
                MerChantInfoPo mainMer = this.merchantInfoAtomService.queryMerchantInfoById(temp.getMainMerchantId());
                tbo.setMainMerchantName(StringUtils.isEmpty((Object)mainMer.getMerchantName()) ? "" : mainMer.getMerchantName());
            }
            if (temp.getMerchantType() != null) {
                String type = temp.getMerchantType().toString().trim();
                tbo.setMerchantType(type);
                String typeName = (String)typeMap.get(type);
                tbo.setMerchantTypeName(StringUtils.isEmpty((Object)typeName) ? type : typeName);
            }
            if (!StringUtils.isEmpty((Object)temp.getFlag())) {
                String flag = temp.getFlag();
                String flagName = (String)flagMap.get(flag);
                tbo.setFlagName(StringUtils.isEmpty((Object)flagName) ? flag : flagName);
            }
            rsList.add(tbo);
        }
        rspPage.setPageNo(page.getPageNo());
        rspPage.setRecordsTotal(page.getTotalCount());
        rspPage.setTotal(page.getTotalPages());
        return rspPage;
    }

    public QueryMerchantIdAndNameRspBo getAllMainMerchantIdAndName(QueryMerchantIdAndNameReqBo reqBo) {
        log.info(SERVICE_NAME + " -> \u5165\u53c2\uff1a" + JSON.toJSONString((Object)reqBo));
        QueryMerchantIdAndNameRspBo rspBo = new QueryMerchantIdAndNameRspBo();
        ArrayList<MerchantInfoBoStr> merList = new ArrayList<MerchantInfoBoStr>();
        rspBo.setMerchantList(merList);
        if (reqBo == null) {
            reqBo = new QueryMerchantIdAndNameReqBo();
        }
        MerChantInfoPo qryMer = new MerChantInfoPo();
        if (!StringUtils.isEmpty((Object)reqBo.getMerchantId())) {
            qryMer.setMerchantId(Long.valueOf(reqBo.getMerchantId()));
        }
        Integer type = Integer.valueOf("1");
        qryMer.setMerchantType(type);
        qryMer.setFlag("1");
        List<MerChantInfoPo> qryResultL = this.merchantInfoAtomService.queryMerChantIdAndNameByCondition(qryMer);
        for (MerChantInfoPo temp : qryResultL) {
            MerchantInfoBoStr tempBo = new MerchantInfoBoStr();
            tempBo.setMerchantName(temp.getMerchantName());
            tempBo.setMerchantId(temp.getMerchantId().toString());
            merList.add(tempBo);
        }
        rspBo.setRspCode("0000");
        rspBo.setRspName("\u67e5\u8be2\u6210\u529f");
        log.info(SERVICE_NAME + " -> \u51fa\u53c2\uff1a" + JSON.toJSONString((Object)rspBo));
        return rspBo;
    }

    public MerchantInfoBoStr queryMerchantBaseInfo(QueryMerchantIdAndNameReqBo reqBo) {
        log.info(SERVICE_NAME + " -> \u67e5\u8be2\u5546\u6237\u57fa\u672c\u4fe1\u606f\u5165\u53c2\uff1a" + JSON.toJSONString((Object)reqBo));
        MerchantInfoBoStr rspBo = new MerchantInfoBoStr();
        if (reqBo == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)reqBo.getMerchantId())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5165\u53c2\u3010merchantId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        Long merId = Long.valueOf(reqBo.getMerchantId());
        MerChantInfoPo resultPo = this.merchantInfoAtomService.queryMerchantInfoById(merId);
        if (resultPo == null) {
            rspBo.setRspCode("8888");
            rspBo.setRspName("\u8be5\u5546\u6237\u4fe1\u606f\u4e0d\u5b58\u5728");
            return rspBo;
        }
        BeanUtils.copyProperties((Object)resultPo, (Object)rspBo);
        rspBo.setMerchantId(resultPo.getMerchantId() == null ? "" : resultPo.getMerchantId().toString());
        rspBo.setMainMerchantId(resultPo.getMainMerchantId() == null ? "" : resultPo.getMainMerchantId().toString());
        rspBo.setCreateTime(resultPo.getCreateTime() == null ? "" : new DateTime((Object)resultPo.getCreateTime()).toString("yyyy-MM-dd HH:mm:ss"));
        rspBo.setUpdateTime(resultPo.getUpdateTime() == null ? "" : new DateTime((Object)resultPo.getUpdateTime()).toString("yyyy-MM-dd HH:mm:ss"));
        rspBo.setApproveTime(resultPo.getApproveTime() == null ? "" : new DateTime((Object)resultPo.getApproveTime()).toString("yyyy-MM-dd HH:mm:ss"));
        if (resultPo.getMainMerchantId() != null) {
            MerChantInfoPo mainMer = this.merchantInfoAtomService.queryMerchantInfoById(resultPo.getMainMerchantId());
            rspBo.setMainMerchantName(StringUtils.isEmpty((Object)mainMer.getMerchantName()) ? "" : mainMer.getMerchantName());
        }
        if (resultPo.getMerchantType() != null) {
            rspBo.setMerchantType(resultPo.getMerchantType().toString());
            QueryPCodeInfoReqBO typeReq = new QueryPCodeInfoReqBO();
            typeReq.setTypeCode("MERCHANT_TYPE");
            typeReq.setCodeValue(resultPo.getMerchantType().toString());
            QueryPCodeInfoRspBO typeRsp = this.queryPCodeInfoService.queryPCodeInfo(typeReq);
            if (typeRsp.getRespCode().equals("0000")) {
                rspBo.setMerchantTypeName(StringUtils.isEmpty((Object)typeRsp.getCodeInfo()) ? resultPo.getMerchantType().toString() : typeRsp.getCodeInfo());
            }
        }
        if (!StringUtils.isEmpty((Object)resultPo.getFlag())) {
            QueryPCodeInfoReqBO flagReq = new QueryPCodeInfoReqBO();
            flagReq.setTypeCode("MERCHANT_FLAG");
            flagReq.setCodeValue(resultPo.getFlag());
            QueryPCodeInfoRspBO flagRsp = this.queryPCodeInfoService.queryPCodeInfo(flagReq);
            if (flagRsp.getRespCode().equals("0000")) {
                rspBo.setFlagName(StringUtils.isEmpty((Object)flagRsp.getCodeInfo()) ? resultPo.getFlag() : flagRsp.getCodeInfo());
            }
        }
        return rspBo;
    }
}

