/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.service.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.bo.RspPage;
import com.ohaotian.plugin.db.Page;
import com.tydic.payment.pay.atom.BusiSystemInfoAtomService;
import com.tydic.payment.pay.atom.PaySettleBillFileAtomService;
import com.tydic.payment.pay.dao.po.BusiSystemInfoPO;
import com.tydic.payment.pay.dao.po.PaySettleBillFilePO;
import com.tydic.payment.pay.dao.po.PaySettleBillFilePageReqPO;
import com.tydic.payment.pay.exception.BusinessException;
import com.tydic.payment.pay.web.bo.req.QueryPaySettleBillFileWebServiceReqBo;
import com.tydic.payment.pay.web.bo.rsp.QueryPaySettleBillFileRspBo;
import com.tydic.payment.pay.web.service.QueryPaySettleBillFileWebService;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="queryPaySettleBillFileWebService")
@HSFProvider(serviceVersion="2.0.0", serviceGroup="PAYMENT_GROUP_DEV", serviceInterface=QueryPaySettleBillFileWebService.class)
public class QueryPaySettleBillFileWebServiceImpl
implements QueryPaySettleBillFileWebService {
    private static final Logger log = LoggerFactory.getLogger(QueryPaySettleBillFileWebServiceImpl.class);
    @Autowired
    private PaySettleBillFileAtomService paySettleBillFileAtomService;
    @Autowired
    private BusiSystemInfoAtomService busiSystemInfoAtomService;

    public RspPage<QueryPaySettleBillFileRspBo> queryBillFile(QueryPaySettleBillFileWebServiceReqBo reqBo) {
        log.info("\u5bf9\u8d26\u8d26\u5355\u67e5\u8be2\u670d\u52a1\u5165\u53c2\uff1a" + JSON.toJSONString((Object)reqBo));
        if (reqBo == null) {
            reqBo = new QueryPaySettleBillFileWebServiceReqBo();
        }
        RspPage retBo = new RspPage();
        ArrayList<QueryPaySettleBillFileRspBo> fileList = new ArrayList<QueryPaySettleBillFileRspBo>();
        retBo.setRows(fileList);
        Page page = null;
        if (reqBo.getPageNo() > 1) {
            page = new Page(reqBo.getPageNo(), reqBo.getPageSize());
        } else {
            page = new Page();
            BeanUtils.copyProperties((Object)reqBo, (Object)page);
            if (page.getPageNo() < 1) {
                page.setPageNo(1);
            }
            if (page.getPageSize() < 1) {
                page.setPageSize(10);
            }
        }
        try {
            List<PaySettleBillFilePO> fileAllPo;
            PaySettleBillFilePageReqPO qryBo = new PaySettleBillFilePageReqPO();
            Long beginDate = null;
            Long endDate = null;
            if (!StringUtils.isEmpty((String)reqBo.getBusiId())) {
                qryBo.setBusiId(Long.valueOf(reqBo.getBusiId()));
            }
            if (!StringUtils.isEmpty((String)reqBo.getBeginDate())) {
                String beginDateStr = new DateTime((Object)reqBo.getBeginDate()).toString("yyyyMMdd");
                beginDate = Long.valueOf(beginDateStr);
            }
            if (!StringUtils.isEmpty((String)reqBo.getEndDate())) {
                String endDateStr = new DateTime((Object)reqBo.getEndDate()).toString("yyyyMMdd");
                endDate = Long.valueOf(endDateStr);
            }
            if ((fileAllPo = this.paySettleBillFileAtomService.queryBillFileInfoByDay((Page<PaySettleBillFilePageReqPO>)page, qryBo, beginDate, endDate)).isEmpty()) {
                log.info("\u67e5\u8be2\u8d26\u5355\u4fe1\u606f\u5f02\u5e38\uff0c\u67e5\u8be2\u4e0d\u5230\u5f00\u59cb\u65e5\u671f\uff1a" + reqBo.getBeginDate() + "\u5230\u7ed3\u675f\u65e5\u671f\uff1a" + reqBo.getEndDate() + "\u7684\u8d26\u5355");
                retBo.setPageNo(1);
                retBo.setTotal(0);
                retBo.setRecordsTotal(0);
                return retBo;
            }
            log.info("\u67e5\u8be2\u8d26\u5355\u4fe1\u606f\u5b8c\u6210\uff0c\u5f00\u59cb\u5c01\u88c5\u51fa\u53c2");
            for (PaySettleBillFilePO tempPo : fileAllPo) {
                QueryPaySettleBillFileRspBo pmcBo = new QueryPaySettleBillFileRspBo();
                pmcBo.setBillDate(String.valueOf(tempPo.getBillDate()));
                pmcBo.setBusiId(String.valueOf(tempPo.getBusiId()));
                BusiSystemInfoPO busiResultPo = this.busiSystemInfoAtomService.queryBusiSystemInfoById(tempPo.getBusiId());
                if (busiResultPo == null) {
                    pmcBo.setBusiName("-\u4e1a\u52a1\u7cfb\u7edf\u5df2\u88ab\u5220\u9664-");
                } else {
                    pmcBo.setBusiName(busiResultPo.getBusiName());
                }
                pmcBo.setFileName(tempPo.getFileName());
                fileList.add(pmcBo);
            }
        }
        catch (Exception e) {
            throw new BusinessException("8888", "web\u670d\u52a1-QueryPaySettleBillFileWebService-\u51fa\u9519");
        }
        retBo.setTotal(page.getTotalPages());
        retBo.setRecordsTotal(page.getTotalCount());
        retBo.setPageNo(page.getPageNo());
        return retBo;
    }
}

