/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.util;

import com.tydic.payment.pay.exception.BusinessException;
import com.tydic.payment.pay.payable.api.PayBillAble;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class PayBillAbleManager {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private final Map<Long, PayBillAble> payBillAbleMap = new ConcurrentHashMap<Long, PayBillAble>();

    public PayBillAble getPayBillAble(Long paymentInsId) {
        PayBillAble payBillAble = this.payBillAbleMap.get(paymentInsId);
        if (payBillAble == null) {
            this.LOGGER.error("\u83b7\u53d6 PayBillAble \u5b9e\u73b0\u7c7b\u5931\u8d25\uff0c\u652f\u4ed8\u673a\u6784" + paymentInsId + "\u5bf9\u5e94\u5b9e\u73b0\u7c7b\u4e0d\u5b58\u5728");
            throw new BusinessException("216008", "\u652f\u4ed8\u673a\u6784(" + paymentInsId + ")\u65e0\u5bf9\u5e94\u5b9e\u73b0\u7c7b\uff01");
        }
        return payBillAble;
    }

    public void registerPayBillAble(PayBillAble payBillAble) {
        Assert.notNull((Object)payBillAble, (String)"payBillAble can not be null");
        Assert.notNull((Object)payBillAble.paymentIns(), (String)"payBillAble.paymentIns can not be null");
        PayBillAble payBillAbleIns = this.payBillAbleMap.get(payBillAble.paymentIns());
        if (payBillAbleIns != null) {
            throw new BusinessException("216008", "\u652f\u4ed8\u673a\u6784(" + payBillAble.paymentIns() + ")\u51fa\u73b0\u591a\u4e2a\u5b9e\u73b0\u7c7b\uff01");
        }
        this.LOGGER.info("PayBillAbleManager.registerPayAble\u6ce8\u518c\u4e86\u652f\u4ed8\u673a\u6784\uff1a" + payBillAble.paymentIns());
        this.payBillAbleMap.put(payBillAble.paymentIns(), payBillAble);
    }
}

