/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.bill.busi.impl;

import com.tydic.payment.bill.busi.BillSettleTransCreateBusiService;
import com.tydic.payment.bill.busi.bo.BillSettleTransCreateReqBO;
import com.tydic.payment.bill.busi.bo.BillSettleTransUpdateBusiCmpReqBO;
import com.tydic.payment.bill.busi.bo.PayBillDayBO;
import com.tydic.payment.bill.busi.bo.QueryPayDayReqBO;
import com.tydic.payment.pay.dao.PayBillDayMapper;
import com.tydic.payment.pay.dao.PaySettleTransMapper;
import com.tydic.payment.pay.dao.po.PayBillDayPo;
import com.tydic.payment.pay.dao.po.PaySettleTransPO;
import com.tydic.payment.pay.exception.BusinessException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="billSettleTransCreateBusiService")
public class BillSettleTransCreateBusiServiceImpl
implements BillSettleTransCreateBusiService {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private boolean isDebug = this.log.isDebugEnabled();
    @Autowired
    private PaySettleTransMapper paySettleTransMapper;
    @Autowired
    private PayBillDayMapper payBillDayMapper;

    public void create(BillSettleTransCreateReqBO reqBO) {
        PaySettleTransPO reqPO = new PaySettleTransPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)reqPO);
        if (StringUtils.isEmpty((Object)reqBO.getBusiCmpFlag())) {
            reqPO.setBusiCmpFlag("0");
        }
        if (StringUtils.isEmpty((Object)reqBO.getBusiCmpResult())) {
            reqPO.setBusiCmpResult("0");
        }
        try {
            this.paySettleTransMapper.insert(reqPO);
        }
        catch (Exception e) {
            if (this.isDebug) {
                this.log.debug("\u5bf9\u8d26\u7ed3\u7b97\u6d41\u6c34\u521b\u5efa\u4e1a\u52a1\u670d\u52a1\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
                e.printStackTrace();
            }
            throw new RuntimeException(e);
        }
    }

    public void updateBusiCmpFlagAndResult(BillSettleTransUpdateBusiCmpReqBO reqBO) {
        PaySettleTransPO reqPO = new PaySettleTransPO();
        reqPO.setOrderId(reqBO.getOrderId());
        reqPO.setOutOrderId(reqBO.getOutOrderId());
        reqPO.setBusiCmpFlag(reqBO.getBusiCmpFlag());
        reqPO.setBusiCmpResult(reqBO.getBusiCmpResult());
        this.paySettleTransMapper.updateBusiCmpFlagAndResult(reqPO);
    }

    public List<PayBillDayBO> query(Long billDate, Long paymentInsId, Long totalItem, Long currentItem) {
        List<PayBillDayPo> pos = this.payBillDayMapper.listByBillDate(billDate, paymentInsId, totalItem, currentItem);
        if (pos == null || pos.size() < 1) {
            if (this.isDebug) {
                this.log.debug("\u5bf9\u8d26\u7ed3\u7b97\u5bfc\u5165\u6210\u529f\uff0c\u67e5\u8be2\u652f\u4ed8\u4e2d\u5fc3\u8d26\u5355\u4e3a\u7a7a\u3002\u67e5\u8be2\u6761\u4ef6\uff1a\u8d26\u5355\u65e5\u671f\uff1a{}\uff0c\u652f\u4ed8\u673a\u6784ID{}\uff0c\u603b\u5206\u7247\u6570\uff1a{},\u5f53\u524d\u5206\u7247\u6570\uff1a{}", new Object[]{billDate, paymentInsId, totalItem, currentItem});
            }
            return null;
        }
        ArrayList<PayBillDayBO> bos = new ArrayList<PayBillDayBO>(pos.size());
        for (PayBillDayPo po : pos) {
            PayBillDayBO bo = new PayBillDayBO();
            BeanUtils.copyProperties((Object)po, (Object)bo);
            bos.add(bo);
        }
        return bos;
    }

    public PayBillDayBO getOne(Long orderId, String payOrderId, String refundOrderId) {
        PayBillDayPo rspPO = this.payBillDayMapper.queryByOrderIdAndPayOrderIdOrRefundOrderId(orderId, payOrderId, refundOrderId);
        if (rspPO == null) {
            return null;
        }
        PayBillDayBO rspBO = new PayBillDayBO();
        BeanUtils.copyProperties((Object)rspPO, (Object)rspBO);
        return rspBO;
    }

    public List<PayBillDayBO> listByOrderId(Long orderId) {
        List<PayBillDayPo> pos = this.payBillDayMapper.listByOrderId(orderId);
        if (pos == null || pos.size() < 1) {
            return null;
        }
        ArrayList<PayBillDayBO> bos = new ArrayList<PayBillDayBO>(pos.size());
        for (PayBillDayPo po : pos) {
            PayBillDayBO bo = new PayBillDayBO();
            BeanUtils.copyProperties((Object)po, (Object)bo);
            bos.add(bo);
        }
        return bos;
    }

    public List<PayBillDayBO> query(QueryPayDayReqBO reqBO) {
        List<PayBillDayPo> pos = this.payBillDayMapper.listByBillDateByMchID(reqBO.getBillDate(), reqBO.getPaymentInsId(), reqBO.getPaymentMchId(), reqBO.getTotalItem(), reqBO.getCurrentItem());
        if (pos == null || pos.size() < 1) {
            return new ArrayList<PayBillDayBO>();
        }
        ArrayList<PayBillDayBO> bos = new ArrayList<PayBillDayBO>(pos.size());
        for (PayBillDayPo po : pos) {
            PayBillDayBO bo = new PayBillDayBO();
            BeanUtils.copyProperties((Object)po, (Object)bo);
            bos.add(bo);
        }
        return bos;
    }

    public boolean hasOrderId(Long orderId) {
        try {
            PaySettleTransPO trans = this.paySettleTransMapper.getModelById(orderId);
            if (trans != null) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BusinessException("8888", "\u67e5\u8be2\u6c47\u603b\u660e\u7ec6\u8868\u5f02\u5e38", (Throwable)e);
        }
        return false;
    }
}

