/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.bill.executor;

import com.tydic.payment.bill.BillExecuteRequest;
import com.tydic.payment.bill.constant.BillExecuteStep;
import com.tydic.payment.bill.exception.BillBalanceException;
import com.tydic.payment.bill.exception.BillCompareException;
import com.tydic.payment.bill.exception.BillDownAndTransException;
import com.tydic.payment.bill.exception.BillSyncPayDayException;
import com.tydic.payment.bill.exception.BillSyncSettleTransException;
import com.tydic.payment.bill.executor.AbstractBillExecutor;

public abstract class AbstractCleanBillExecutor
extends AbstractBillExecutor {
    @Override
    protected void cleanData(BillExecuteRequest request) {
        if (BillExecuteStep.DOWNLOAD_AND_TRANS.getCode() <= request.getBillExecuteStep().getCode()) {
            this.doDownAndTransClean(request);
        }
        if (BillExecuteStep.SYNC_PAY_DAY.getCode() <= request.getBillExecuteStep().getCode()) {
            this.doSyncPayDayClean(request);
        }
        if (BillExecuteStep.COMPARE.getCode() <= request.getBillExecuteStep().getCode()) {
            this.doCompareClean(request);
        }
        if (BillExecuteStep.BALANCE.getCode() <= request.getBillExecuteStep().getCode()) {
            this.doBalanceClean(request);
        }
        if (BillExecuteStep.SYNC_SETTLE_TRANS.getCode() <= request.getBillExecuteStep().getCode()) {
            this.doSyncSettleTransClean(request);
        }
    }

    @Override
    protected void downAndTrans(BillExecuteRequest request) throws BillDownAndTransException {
        this.doDownAndTrans(request);
    }

    protected abstract void doDownAndTransClean(BillExecuteRequest var1) throws BillDownAndTransException;

    protected abstract void doDownAndTrans(BillExecuteRequest var1) throws BillDownAndTransException;

    @Override
    protected void syncSettleTrans(BillExecuteRequest request) throws BillSyncSettleTransException {
        this.doSyncSettleTransDay(request);
    }

    protected abstract void doSyncSettleTransClean(BillExecuteRequest var1) throws BillSyncSettleTransException;

    protected abstract void doSyncSettleTransDay(BillExecuteRequest var1) throws BillSyncSettleTransException;

    @Override
    protected void balance(BillExecuteRequest request) throws BillBalanceException {
        this.doBalance(request);
    }

    protected abstract void doBalanceClean(BillExecuteRequest var1) throws BillBalanceException;

    protected abstract void doBalance(BillExecuteRequest var1) throws BillBalanceException;

    @Override
    protected void compare(BillExecuteRequest request) throws BillCompareException {
        this.doCompare(request);
    }

    protected abstract void doCompareClean(BillExecuteRequest var1) throws BillCompareException;

    protected abstract void doCompare(BillExecuteRequest var1) throws BillCompareException;

    @Override
    protected void syncPayDay(BillExecuteRequest request) throws BillSyncPayDayException {
        this.doSyncPayDay(request);
    }

    protected abstract void doSyncPayDayClean(BillExecuteRequest var1) throws BillSyncPayDayException;

    protected abstract void doSyncPayDay(BillExecuteRequest var1) throws BillSyncPayDayException;
}

