/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.ability.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSON;
import com.tydic.payment.pay.ability.PayProOneCodeDealWxAbilityService;
import com.tydic.payment.pay.ability.bo.PayProOneCodeDealWxAbilityReqBo;
import com.tydic.payment.pay.ability.bo.PayProOneCodeDealWxAbilityRspBo;
import com.tydic.payment.pay.comb.PayProOneCodeDealWxCombService;
import com.tydic.payment.pay.comb.bo.PayProOneCodeDealWxCombReqBo;
import com.tydic.payment.pay.comb.bo.PayProOneCodeDealWxCombRspBo;
import com.tydic.payment.pay.config.vo.PayPropertiesVo;
import com.tydic.payment.pay.exception.BusinessException;
import com.tydic.payment.pay.util.BeanUtils;
import java.net.URLEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
@HSFProvider(serviceVersion="2.0.0", serviceGroup="PAYMENT_GROUP_DEV", serviceInterface=PayProOneCodeDealWxAbilityService.class)
public class PayProOneCodeDealWxAbilityServiceImpl
implements PayProOneCodeDealWxAbilityService {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private PayProOneCodeDealWxCombService payProOneCodeDealWxCombService;
    @Autowired
    private PayPropertiesVo payPropertiesVo;

    public PayProOneCodeDealWxAbilityRspBo dealOneCodeWx(PayProOneCodeDealWxAbilityReqBo reqBo) {
        this.LOGGER.info("\u5904\u7406\u4e00\u7801\u4ed8\u4f7f\u7528\u5fae\u4fe1\u626b\u7801\uff1a" + reqBo);
        PayProOneCodeDealWxAbilityRspBo retBo = new PayProOneCodeDealWxAbilityRspBo();
        String redirectUrl = "";
        String basePathStr = this.payPropertiesVo.getValueByKey("pay.one.code.pay.context.path");
        StringBuffer basePath = new StringBuffer(basePathStr);
        if (StringUtils.isEmpty((Object)basePathStr)) {
            this.LOGGER.error("\u4e00\u7801\u4ed8basePath\u672a\u914d\u7f6e\uff0c\u8bf7\u914d\u7f6e'pay.one.code.pay.context.path'");
            throw new BusinessException("218003", "\u4e00\u7801\u4ed8basePath\u5730\u5740\u672a\u914d\u7f6e\uff1a'pay.one.code.pay.context.path'");
        }
        String oneCodePayHtml = this.payPropertiesVo.getValueByKey("pay.one.code.pay.html");
        if (StringUtils.isEmpty((Object)oneCodePayHtml)) {
            this.LOGGER.error("\u4e00\u7801\u4ed8\u652f\u4ed8\u9875\u9762\u5730\u5740\uff08pay.one.code.pay.html\uff09\u672a\u914d\u7f6e");
            throw new BusinessException("218003", "\u4e00\u7801\u4ed8\u652f\u4ed8\u9875\u9762\u5730\u5740\uff08pay.one.code.pay.html\uff09\u672a\u914d\u7f6e");
        }
        BeanUtils.copyProperties((Object)reqBo, (Object)retBo);
        String validateStr = this.validateArgs(reqBo);
        if (!StringUtils.isEmpty((Object)validateStr)) {
            this.LOGGER.error("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            retBo.setRspCode("214023");
            retBo.setRspName("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            String respInfo = this.urlEncode(retBo);
            redirectUrl = basePath.append("/").append(oneCodePayHtml).append("?respInfo=").append(respInfo).toString();
            retBo.setRedirectUrl(redirectUrl);
            return retBo;
        }
        PayProOneCodeDealWxCombReqBo dealWxCombReqBo = new PayProOneCodeDealWxCombReqBo();
        BeanUtils.copyProperties((Object)reqBo, (Object)dealWxCombReqBo);
        dealWxCombReqBo.setBasePath(basePath);
        PayProOneCodeDealWxCombRspBo dealWxCombRetBo = this.payProOneCodeDealWxCombService.dealWxOneCode(dealWxCombReqBo);
        if (!"0000".equals(dealWxCombRetBo.getRspCode())) {
            this.LOGGER.error("\u8c03\u7528comb\u670d\u52a1\u5904\u7406\u5931\u8d25\uff1a" + dealWxCombRetBo.getRspName());
            retBo.setRspCode("214023");
            retBo.setRspName("\u8c03\u7528comb\u670d\u52a1\u5904\u7406\u5931\u8d25\uff1a" + dealWxCombRetBo.getRspName());
            String respInfo = this.urlEncode(retBo);
            redirectUrl = basePath.append("/").append(oneCodePayHtml).append("?respInfo=").append(respInfo).toString();
            retBo.setRedirectUrl(redirectUrl);
            return retBo;
        }
        BeanUtils.copyProperties((Object)dealWxCombRetBo, (Object)retBo);
        retBo.setRedirectUrl(dealWxCombRetBo.getJumpUrl());
        this.LOGGER.info("\u4e00\u7801\u4ed8\u4e0b\u5355\uff0c\u5904\u7406\u5fae\u4fe1\u626b\u7801ability\u670d\u52a1\u7684\u51fa\u53c2\uff1a" + retBo);
        return retBo;
    }

    private String validateArgs(PayProOneCodeDealWxAbilityReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getOrderId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'orderId'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getTotalFee())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'totalFee'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getCode())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'code'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }

    private String urlEncode(PayProOneCodeDealWxAbilityRspBo retBo) {
        try {
            return URLEncoder.encode(JSON.toJSONString((Object)retBo), "UTF-8");
        }
        catch (Exception e) {
            this.LOGGER.error("\u5bf9\u6570\u636e\u8fdb\u884cURLEncode\u7684\u65f6\u5019\u53d1\u751f\u5f02\u5e38\uff1a" + e);
            return "\u5bf9\u6570\u636e\u8fdb\u884cURLEncode\u7684\u65f6\u5019\u53d1\u751f\u5f02\u5e38";
        }
    }
}

