/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.ability.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSON;
import com.tydic.payment.pay.ability.PayProRealPayAbilityService;
import com.tydic.payment.pay.ability.bo.PayProRealPayAbilityServiceReqBo;
import com.tydic.payment.pay.ability.bo.PayProRealPayAbilityServiceRspBo;
import com.tydic.payment.pay.atom.MerchantInfoAtomService;
import com.tydic.payment.pay.atom.PayMethodAtomService;
import com.tydic.payment.pay.atom.PaymentInsAtomService;
import com.tydic.payment.pay.busi.PayProQueryInfoBusiSystemByConditionService;
import com.tydic.payment.pay.busi.bo.PayProQueryInfoBusiSystemByConditionBusiInfoRspBo;
import com.tydic.payment.pay.comb.PayProRealPayCombService;
import com.tydic.payment.pay.comb.bo.PayProRealPayCombServiceReqBo;
import com.tydic.payment.pay.comb.bo.PayProRealPayCombServiceRspBo;
import com.tydic.payment.pay.constant.PayProConstants;
import com.tydic.payment.pay.dao.po.MerChantInfoPo;
import com.tydic.payment.pay.dao.po.PayMethodPo;
import com.tydic.payment.pay.dao.po.PaymentInsPo;
import com.tydic.payment.pay.util.PayProRspUtil;
import com.tydic.utils.generatedoc.util.ArgValidator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="payProRealPayAbilityService")
@HSFProvider(serviceVersion="2.0.0", serviceGroup="PAYMENT_GROUP_DEV", serviceInterface=PayProRealPayAbilityService.class)
public class PayProRealPayAbilityServiceImpl
implements PayProRealPayAbilityService {
    private static final Logger log = LoggerFactory.getLogger(PayProRealPayAbilityServiceImpl.class);
    @Autowired
    private PayProQueryInfoBusiSystemByConditionService queryInfoBusiSystemByConditionService;
    @Autowired
    private MerchantInfoAtomService merchantInfoAtomService;
    @Autowired
    private PayProRealPayCombService payProRealPayCombService;
    @Autowired
    private PayMethodAtomService payMethodAtomService;
    @Autowired
    private PaymentInsAtomService paymentInsAtomService;

    public PayProRealPayAbilityServiceRspBo dealRealPay(PayProRealPayAbilityServiceReqBo reqBo) {
        log.info("===========\u652f\u4ed8\u4e2d\u5fc3-\u7279\u6b8a\u4e1a\u52a1-\u5b9e\u4ed8\u670d\u52a1\uff0c\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)reqBo));
        PayProRealPayAbilityServiceRspBo retBo = PayProRspUtil.generateSucRspBo(PayProRealPayAbilityServiceRspBo.class);
        String validateStr = this.validateArgs(reqBo);
        if (!com.tydic.payment.pay.icbc.util.StringUtils.isEmpty((String)validateStr)) {
            log.error("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a{}", (Object)validateStr);
            retBo.setRespCode("214035");
            retBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            return retBo;
        }
        String busiCode = reqBo.getBusiCode();
        PayProQueryInfoBusiSystemByConditionBusiInfoRspBo busiCodeRspBo = this.queryInfoBusiSystemByConditionService.queryBusiSysByBusiCode(busiCode);
        if (!"0000".equals(busiCodeRspBo.getRespCode())) {
            retBo.setRespCode("214035");
            retBo.setRespDesc("\u67e5\u8be2\u4e1a\u52a1\u7cfb\u7edf\u5931\u8d25:" + busiCodeRspBo.getRespDesc());
            return retBo;
        }
        if (!"1".equals(busiCodeRspBo.getState())) {
            retBo.setRespCode("214035");
            retBo.setRespDesc("\u8be5\u4e1a\u52a1\u7cfb\u7edf(" + busiCode + ")\u5df2\u5931\u6548");
            return retBo;
        }
        Long merchantId = Long.valueOf(reqBo.getMerchantId());
        MerChantInfoPo merChantInfo = this.merchantInfoAtomService.queryMerchantInfoById(merchantId);
        if (null == merChantInfo) {
            retBo.setRespCode("214035");
            retBo.setRespDesc("\u672a\u67e5\u8be2\u5230\u5546\u6237[" + merchantId + "]\u7684\u4fe1\u606f");
            return retBo;
        }
        if (!"1".equals(merChantInfo.getFlag())) {
            retBo.setRespCode("214035");
            retBo.setRespDesc("\u5546\u6237[" + merchantId + "]\u672a\u542f\u7528");
            return retBo;
        }
        PayProRealPayCombServiceReqBo combReqBo = new PayProRealPayCombServiceReqBo();
        BeanUtils.copyProperties((Object)reqBo, (Object)combReqBo);
        combReqBo.setBusiId(busiCodeRspBo.getBusiId());
        combReqBo.setMerchantId(merchantId);
        PayProRealPayCombServiceRspBo combRetBo = this.payProRealPayCombService.dealRealPay(combReqBo);
        if (!"0000".equals(combRetBo.getRespCode())) {
            BeanUtils.copyProperties((Object)combRetBo, (Object)retBo);
            return retBo;
        }
        this.assignment(combRetBo, retBo);
        retBo.setMerchantId(reqBo.getMerchantId());
        retBo.setMerchantName(merChantInfo.getMerchantName());
        return retBo;
    }

    private String validateArgs(PayProRealPayAbilityServiceReqBo reqBo) {
        String result = ArgValidator.validateArg((Object)reqBo);
        if (!com.tydic.payment.pay.icbc.util.StringUtils.isEmpty((String)result)) {
            return result;
        }
        if (PayProConstants.PayMethod.CNNC_CQT_REAL_PAY.getPayMethod().equals(reqBo.getPayMethod()) && com.tydic.payment.pay.icbc.util.StringUtils.isEmpty((String)reqBo.getNotifyUrl())) {
            return "\u5f53\u652f\u4ed8\u65b9\u5f0f\u4e3a\uff1a\u8d22\u4f01\u901a\u5b9e\u4ed8\u65f6\uff0c\u56de\u8c03\u5730\u5740[notifyUrl]\u5fc5\u4f20";
        }
        return null;
    }

    private void assignment(PayProRealPayCombServiceRspBo combRetBo, PayProRealPayAbilityServiceRspBo retBo) {
        String payMethod = combRetBo.getPayMethod();
        BeanUtils.copyProperties((Object)combRetBo, (Object)retBo);
        if (!StringUtils.isEmpty((Object)payMethod)) {
            PayMethodPo methodInfo = this.payMethodAtomService.queryPayMethodById(Long.valueOf(payMethod));
            if (null != methodInfo) {
                retBo.setPayMethod(payMethod);
                retBo.setPayMethodName(methodInfo.getPayMethodName());
            }
            PaymentInsPo paymentInsPo = new PaymentInsPo();
            paymentInsPo.setPaymentInsId(methodInfo.getPaymentInsId());
            List<PaymentInsPo> paymentInsList = this.paymentInsAtomService.queryPaymentInf(paymentInsPo);
            if (!CollectionUtils.isEmpty(paymentInsList)) {
                PaymentInsPo paymentInsInfo = paymentInsList.get(0);
                retBo.setPaymentInsId(paymentInsInfo.getPaymentInsId().toString());
                retBo.setPaymentInsName(paymentInsInfo.getPaymentInsName());
            }
        }
    }
}

