/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.ability.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSONObject;
import com.tydic.payment.pay.ability.RefundAbilityService;
import com.tydic.payment.pay.ability.bo.RefundAbilityServiceReqBo;
import com.tydic.payment.pay.ability.bo.RefundAbilityServiceRspBo;
import com.tydic.payment.pay.busi.QueryInfoBusiSystemService;
import com.tydic.payment.pay.comb.RefundCombService;
import com.tydic.payment.pay.comb.bo.RefundCombReqBO;
import com.tydic.payment.pay.comb.bo.RefundCombRspBO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="refundAbilityService")
@HSFProvider(serviceVersion="2.0.0", serviceGroup="PAYMENT_GROUP_DEV", serviceInterface=RefundAbilityService.class)
public class RefundAbilityServiceImpl
implements RefundAbilityService {
    private static final Logger log = LoggerFactory.getLogger(RefundAbilityServiceImpl.class);
    @Autowired
    private RefundCombService refundCombService;
    @Autowired
    private QueryInfoBusiSystemService queryInfoBusiSystemService;

    public RefundAbilityServiceRspBo dealRefund(RefundAbilityServiceReqBo reqBo) {
        RefundAbilityServiceRspBo rspBo = new RefundAbilityServiceRspBo();
        String errMsg = this.checkParams(reqBo);
        if (!"TRUE".equals(errMsg)) {
            rspBo.setRspCode("0000");
            rspBo.setRspName("\u9000\u6b3e\u5931\u8d25");
            rspBo.setResultCode("FAIL");
            rspBo.setResultMsg(errMsg);
            return rspBo;
        }
        if (StringUtils.isEmpty((Object)reqBo.getRefundFlag())) {
            reqBo.setRefundFlag("0");
        }
        RefundCombReqBO pmcRefundCombReqBO = new RefundCombReqBO();
        BeanUtils.copyProperties((Object)reqBo, (Object)pmcRefundCombReqBO);
        pmcRefundCombReqBO.setRefundFee(reqBo.getRefundFee());
        pmcRefundCombReqBO.setBusiId(reqBo.getBusiId());
        pmcRefundCombReqBO.setBusiCode(reqBo.getBusiCode());
        if (reqBo.getGoodsDetail() != null && reqBo.getGoodsDetail().size() > 0) {
            pmcRefundCombReqBO.setGoodsDetail(JSONObject.toJSONString((Object)reqBo.getGoodsDetail()));
        }
        RefundCombRspBO refundCombRspBO = new RefundCombRspBO();
        try {
            refundCombRspBO = this.refundCombService.dealRefund(pmcRefundCombReqBO);
            BeanUtils.copyProperties((Object)refundCombRspBO, (Object)rspBo);
            return rspBo;
        }
        catch (Exception e) {
            log.error("RefundAbilityServiceImpl\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
            rspBo.setRspCode("8888");
            rspBo.setRspName("\u9000\u6b3e\u8c03\u7528\u5f02\u5e38");
            return rspBo;
        }
    }

    public String checkParams(RefundAbilityServiceReqBo reqBo) {
        String errMsg = "TRUE";
        if (StringUtils.isEmpty((Object)reqBo.getOutOrderId())) {
            errMsg = "\u5916\u90e8\u8ba2\u5355\u53f7\u3010outOrderId\u3011 \u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getOutRefundId())) {
            errMsg = "\u4e1a\u52a1\u4fa7\u539f\u59cb\u5916\u90e8\u8ba2\u5355\u53f7\u3010outRefundId\u3011 \u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getRefundFee())) {
            errMsg = "\u9000\u6b3e\u91d1\u989d\u3010refundFee\u3011 \u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getBusiId())) {
            errMsg = "\u7cfb\u7edf\u7f16\u7801\u3010busiId\u3011 \u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (!"02".equals(reqBo.getOrderType()) && !"06".equals(reqBo.getOrderType())) {
            errMsg = "\u8bf7\u786e\u8ba4\u8ba2\u5355\u7c7b\u578b\u3010orderType\u3011 \u4e3a\u9000\u6b3e\u8ba2\u5355";
        }
        return errMsg;
    }
}

