/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.busi.impl;

import com.tydic.payment.pay.busi.PayProCreateOrderPayTransBusiService;
import com.tydic.payment.pay.busi.bo.PayProCreateOrderPayTransBusiReqBo;
import com.tydic.payment.pay.busi.bo.PayProCreateOrderPayTransBusiRspBo;
import com.tydic.payment.pay.common.util.MoneyUtils;
import com.tydic.payment.pay.config.PayProSequence;
import com.tydic.payment.pay.config.PaySequenceConfigManager;
import com.tydic.payment.pay.config.vo.PayPropertiesVo;
import com.tydic.payment.pay.constant.PayProConstants;
import com.tydic.payment.pay.dao.PayMethodMapper;
import com.tydic.payment.pay.dao.PorderPayTransMapper;
import com.tydic.payment.pay.dao.po.PorderPayTransPo;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class PayProCreateOrderPayTransBusiServiceImpl
implements PayProCreateOrderPayTransBusiService {
    @Autowired
    private PayPropertiesVo payPropertiesVo;
    @Autowired
    private PayMethodMapper payMethodMapper;
    @Autowired
    private PorderPayTransMapper porderPayTransMapper;
    @Autowired
    private PaySequenceConfigManager paySequenceConfigManager;
    private static final String RE_PAY_ORDER_ID_STR = "\u91cd\u590d\u7684\u5916\u90e8\u8ba2\u5355";

    public PayProCreateOrderPayTransBusiRspBo createPayTrans(PayProCreateOrderPayTransBusiReqBo reqBo) {
        int count;
        PayProCreateOrderPayTransBusiRspBo retBo = new PayProCreateOrderPayTransBusiRspBo();
        String validateArgStr = this.validateArg(reqBo);
        if (!StringUtils.isEmpty((Object)validateArgStr)) {
            retBo.setRespCode("212003");
            retBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateArgStr);
            return retBo;
        }
        String payOrderId = this.createNewPayOrderId(reqBo);
        if (payOrderId.startsWith(RE_PAY_ORDER_ID_STR)) {
            retBo.setRespCode("212003");
            retBo.setRespDesc(payOrderId);
            return retBo;
        }
        PorderPayTransPo transPo = new PorderPayTransPo();
        BeanUtils.copyProperties((Object)reqBo, (Object)transPo);
        transPo.setRefundFee(0L);
        transPo.setPayOrderId(payOrderId);
        transPo.setPayFee(MoneyUtils.fenToHao((Long)reqBo.getPayFee()).longValue());
        if (StringUtils.isEmpty((Object)transPo.getOrderStatus())) {
            transPo.setOrderStatus("A00");
        }
        if ((count = this.porderPayTransMapper.insert(transPo)) != 1) {
            retBo.setRespCode("212003");
            retBo.setRespDesc("\u63d2\u5165p_order_pay_trans\u5931\u8d25\uff1asql\u8fd4\u56de\u503c\u4e0d\u4e3a1");
            return retBo;
        }
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u521b\u5efa\u6210\u529f");
        retBo.setPayOrderId(payOrderId);
        return retBo;
    }

    private String createNewPayOrderId(PayProCreateOrderPayTransBusiReqBo reqBo) {
        String inputPayOrderId = reqBo.getPayOrderId();
        String payOrderId = null;
        if (!StringUtils.isEmpty((Object)inputPayOrderId)) {
            payOrderId = inputPayOrderId;
            PorderPayTransPo qryPo = new PorderPayTransPo();
            qryPo.setPayOrderId(inputPayOrderId);
            List<PorderPayTransPo> orderPayTransByCondition = this.porderPayTransMapper.getOrderPayTransByCondition(qryPo);
            if (!CollectionUtils.isEmpty(orderPayTransByCondition)) {
                return "\u91cd\u590d\u7684\u5916\u90e8\u8ba2\u5355[" + inputPayOrderId + "]";
            }
        } else {
            String projectName = this.payPropertiesVo.getProjectName();
            if (PayProConstants.PayMethod.ALI_TRANS.getPayMethod().equals(reqBo.getPayMethod())) {
                projectName = projectName + "Trans";
            }
            String id = String.valueOf(PayProSequence.nextId());
            payOrderId = projectName + id.substring(id.length() - 13);
        }
        return payOrderId;
    }

    private String validateArg(PayProCreateOrderPayTransBusiReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getOrderId())) {
            return "orderId\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getBusiId())) {
            return "busiId\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getMerchantId())) {
            return "merchantId\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getPayMethod())) {
            return "payMethod\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getPayFee())) {
            return "payFee\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }
}

