/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.comb.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.tydic.payment.pay.atom.PayOrderAtomService;
import com.tydic.payment.pay.atom.PorderPayTransAtomService;
import com.tydic.payment.pay.atom.bo.PorderPayTransAtomReqBo;
import com.tydic.payment.pay.atom.bo.PorderPayTransAtomRspBo;
import com.tydic.payment.pay.busi.PayProCreateOrderRefundTransBusiService;
import com.tydic.payment.pay.busi.PayProOrderQueryBusiService;
import com.tydic.payment.pay.busi.PayProQueryPayParaBusiService;
import com.tydic.payment.pay.busi.PayProUpdateOrderTransBusiService;
import com.tydic.payment.pay.busi.PayProUpdatePayOrderInfoAfterRefundBusiService;
import com.tydic.payment.pay.busi.PayProUpdateRefundOrderInfoAfterRefundBusiService;
import com.tydic.payment.pay.busi.QueryDBDateBusiService;
import com.tydic.payment.pay.busi.bo.PayAbleQryPayStatusReqBo;
import com.tydic.payment.pay.busi.bo.PayAbleQryPayStatusRspBo;
import com.tydic.payment.pay.busi.bo.PayAbleRefundReqBo;
import com.tydic.payment.pay.busi.bo.PayAbleRefundRspBo;
import com.tydic.payment.pay.busi.bo.PayProCreateOrderRefundTransBusiReqBo;
import com.tydic.payment.pay.busi.bo.PayProCreateOrderRefundTransBusiRspBo;
import com.tydic.payment.pay.busi.bo.PayProOrderQueryBusiReqBo;
import com.tydic.payment.pay.busi.bo.PayProOrderQueryByOutOrderIdAndBusiIdBusiRspBo;
import com.tydic.payment.pay.busi.bo.PayProQueryPayParaBusiReqBo;
import com.tydic.payment.pay.busi.bo.PayProQueryPayParaBusiRspBo;
import com.tydic.payment.pay.busi.bo.PayProUpdateOrderTransBusiReqBo;
import com.tydic.payment.pay.busi.bo.PayProUpdateOrderTransBusiRspBo;
import com.tydic.payment.pay.busi.bo.PayProUpdatePayOrderInfoAfterRefundBusiReqBo;
import com.tydic.payment.pay.busi.bo.PayProUpdatePayOrderInfoAfterRefundBusiRspBo;
import com.tydic.payment.pay.busi.bo.PayProUpdateRefundOrderInfoAfterRefundBusiReqBo;
import com.tydic.payment.pay.busi.bo.PayProUpdateRefundOrderInfoAfterRefundBusiRspBo;
import com.tydic.payment.pay.comb.PayAbleRefundCombService;
import com.tydic.payment.pay.comb.PayProPreparedOrderCombService;
import com.tydic.payment.pay.comb.bo.PayAbleRefundCombReqBo;
import com.tydic.payment.pay.comb.bo.PayAbleRefundCombRspBo;
import com.tydic.payment.pay.comb.bo.PayProPreparedOrderCombReqBo;
import com.tydic.payment.pay.comb.bo.PayProPreparedOrderCombRspBo;
import com.tydic.payment.pay.common.util.MoneyUtils;
import com.tydic.payment.pay.dao.POrderPayTransParamMapper;
import com.tydic.payment.pay.dao.po.POrderPayTransParamPo;
import com.tydic.payment.pay.dao.po.PorderPo;
import com.tydic.payment.pay.exception.BusinessException;
import com.tydic.payment.pay.payable.api.PayAble;
import com.tydic.payment.pay.util.BeanUtils;
import com.tydic.payment.pay.util.PayAbleManager;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
@HSFProvider(serviceVersion="2.0.0", serviceGroup="PAYMENT_GROUP_DEV", serviceInterface=PayAbleRefundCombService.class)
public class PayAbleRefundCombServiceImpl
implements PayAbleRefundCombService {
    private static final Logger log = LoggerFactory.getLogger(PayAbleRefundCombServiceImpl.class);
    @Autowired
    private PayProOrderQueryBusiService payProOrderQueryBusiService;
    @Autowired
    private PayOrderAtomService payOrderAtomService;
    @Autowired
    private PorderPayTransAtomService porderPayTransAtomService;
    @Autowired
    private PayProCreateOrderRefundTransBusiService payProCreateOrderRefundTransBusiService;
    @Autowired
    private PayProPreparedOrderCombService payProPreparedOrderCombService;
    @Autowired
    private PayAbleManager payAbleManager;
    @Autowired
    private PayProQueryPayParaBusiService payProQueryPayParaBusiService;
    @Autowired
    private PayProUpdatePayOrderInfoAfterRefundBusiService payProUpdatePayOrderInfoAfterRefundBusiService;
    @Autowired
    private PayProUpdateRefundOrderInfoAfterRefundBusiService payProUpdateRefundOrderInfoAfterRefundBusiService;
    @Autowired
    private PayProUpdateOrderTransBusiService payProUpdateOrderTransBusiService;
    @Autowired
    private QueryDBDateBusiService queryDBDateBusiService;
    @Autowired
    private POrderPayTransParamMapper pOrderPayTransParamMapper;
    private static final String NORMAL_REFUND_DESC = "\u6b63\u5e38\u9000\u6b3e";
    private static final String REFUND_OK = "refund-ok";
    private static final String REFUND_ACTIVE_QUERY = "1";
    private static final String ORDER_REFUND_ID_SPLIT = ",";

    public PayAbleRefundCombRspBo dealRefund(PayAbleRefundCombReqBo reqBo) {
        PayAbleRefundCombRspBo retBo = new PayAbleRefundCombRspBo();
        String validateArgStr = this.validateArg(reqBo);
        if (!StringUtils.isEmpty((Object)validateArgStr)) {
            retBo.setRespCode("213005");
            retBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateArgStr);
            return retBo;
        }
        Long busiId = reqBo.getBusiId();
        String refundOutOrderId = reqBo.getRefundOutOrderId();
        String oriOutOrderId = reqBo.getOriOutOrderId();
        PayProOrderQueryBusiReqBo queryOriOutOrderBo = new PayProOrderQueryBusiReqBo();
        queryOriOutOrderBo.setBusiId(busiId);
        queryOriOutOrderBo.setOutOrderId(oriOutOrderId);
        PayProOrderQueryByOutOrderIdAndBusiIdBusiRspBo queryOriOutOrderRetBo = this.payProOrderQueryBusiService.queryOrderQueryByBusiIdAndOutOrderId(queryOriOutOrderBo);
        if (!"0000".equals(queryOriOutOrderRetBo.getRespCode())) {
            retBo.setRespCode("213005");
            retBo.setRespDesc("\u8be5\u539f\u652f\u4ed8\u5916\u90e8\u8ba2\u5355(" + oriOutOrderId + ")\u4e0d\u5b58\u5728\uff01");
            return retBo;
        }
        PayProOrderQueryBusiReqBo queryRefundBo = new PayProOrderQueryBusiReqBo();
        queryRefundBo.setBusiId(busiId);
        queryRefundBo.setOutOrderId(refundOutOrderId);
        PayProOrderQueryByOutOrderIdAndBusiIdBusiRspBo queryRefundRetBo = this.payProOrderQueryBusiService.queryOrderQueryByBusiIdAndOutOrderId(queryRefundBo);
        if ("0000".equals(queryRefundRetBo.getRespCode())) {
            retBo.setRespCode("213005");
            retBo.setRespDesc("\u8be5\u5916\u90e8\u8ba2\u5355(" + refundOutOrderId + ")\u5df2\u5b58\u5728\uff01");
            return retBo;
        }
        PorderPo orderInfo = this.payOrderAtomService.queryPorderByOutOrderId(oriOutOrderId, queryOriOutOrderRetBo.getOrderId());
        PorderPayTransAtomReqBo orderPayTransAtomReq = new PorderPayTransAtomReqBo();
        orderPayTransAtomReq.setOrderId(orderInfo.getOrderId());
        orderPayTransAtomReq.setOrderStatus("A10");
        List<PorderPayTransAtomRspBo> transAtomList = this.porderPayTransAtomService.queryOrderPayTransByCondition(orderPayTransAtomReq);
        String checkResult = this.checkOrderInfo(orderInfo, oriOutOrderId, reqBo, transAtomList);
        if (checkResult != null) {
            if (REFUND_OK.equals(checkResult) && REFUND_ACTIVE_QUERY.equals(reqBo.getIdempotent())) {
                BeanUtils.copyProperties((Object)reqBo, (Object)retBo);
                retBo.setRespCode("0000");
                retBo.setRespDesc("\u9000\u6b3e\u5b8c\u6210(idempotent)");
                return retBo;
            }
            if (REFUND_OK.equals(checkResult)) {
                retBo.setRespCode("213005");
                retBo.setRespDesc("\u8be5\u652f\u4ed8\u8ba2\u5355(" + oriOutOrderId + ")\u5df2\u9000\u5b8c\u6b3e\u4e86\uff01");
                return retBo;
            }
            retBo.setRespCode("213005");
            retBo.setRespDesc(checkResult);
            return retBo;
        }
        PorderPayTransAtomRspBo payTransBo = transAtomList.get(0);
        Long payMethod = payTransBo.getPayMethod();
        PayAble payAbleByPayMethod = this.payAbleManager.getPayAbleByPayMethod(payMethod);
        PayProPreparedOrderCombReqBo createRefundOrderBo = new PayProPreparedOrderCombReqBo();
        this.preparedPOrderBo(reqBo, orderInfo, createRefundOrderBo);
        PayProPreparedOrderCombRspBo createRefundOrderRetBo = this.payProPreparedOrderCombService.createOrder(createRefundOrderBo);
        if (!"0000".equals(createRefundOrderRetBo.getRespCode())) {
            retBo.setRespCode("213005");
            retBo.setRespDesc("\u8c03\u7528\u652f\u4ed8\u4e2d\u5fc3\u4e0b\u5355\u7ec4\u5408\u670d\u52a1\u5931\u8d25\uff1a" + createRefundOrderRetBo.getRespDesc());
            return retBo;
        }
        PayProCreateOrderRefundTransBusiReqBo addRefundBo = new PayProCreateOrderRefundTransBusiReqBo();
        this.preparedRefundTransBo(reqBo, orderInfo, payTransBo, addRefundBo, createRefundOrderRetBo);
        PayProCreateOrderRefundTransBusiRspBo addRefundRetBo = this.payProCreateOrderRefundTransBusiService.addRefundTrans(addRefundBo);
        if (!"0000".equals(addRefundRetBo.getRespCode())) {
            retBo.setRespCode("213005");
            retBo.setRespDesc("\u8c03\u7528\u5199\u5165p_order_refund_trans\u670d\u52a1\u5931\u8d25\uff1a" + addRefundRetBo.getRespDesc());
            return retBo;
        }
        PayProQueryPayParaBusiReqBo qryParaBo = new PayProQueryPayParaBusiReqBo();
        qryParaBo.setMerchantId(orderInfo.getMerchantId());
        qryParaBo.setPayMethod(payMethod);
        PayProQueryPayParaBusiRspBo payProQueryPayParaBusiRspBo = this.payProQueryPayParaBusiService.queryPayPara(qryParaBo);
        if (!"0000".equals(payProQueryPayParaBusiRspBo.getRespCode())) {
            retBo.setRespCode("213004");
            retBo.setRespDesc("\u67e5\u8be2\u652f\u4ed8\u53c2\u6570\u5931\u8d25\uff1a" + payProQueryPayParaBusiRspBo.getRespDesc());
            return retBo;
        }
        PayAbleRefundReqBo refundBo = new PayAbleRefundReqBo();
        BeanUtils.copyProperties((Object)reqBo, (Object)refundBo);
        refundBo.setPayOrderId(payTransBo.getPayOrderId());
        refundBo.setRefundFee(reqBo.getRefundFee());
        refundBo.setRefundOrderId(addRefundRetBo.getRefundOrderId());
        refundBo.setParaMap(payProQueryPayParaBusiRspBo.getDetailAttrs());
        refundBo.setOrderId(orderInfo.getOrderId());
        refundBo.setTotalFee(Long.valueOf(MoneyUtils.haoToFen((Long)orderInfo.getTotalFee()).longValue()));
        refundBo.setRefundReason(reqBo.getRefundReason());
        refundBo.setTradeTime(payTransBo.getTradeTime());
        refundBo.setPayNotifyTransId(payTransBo.getPayNotifyTransId());
        refundBo.setMerchantId(orderInfo.getMerchantId().toString());
        Map<String, String> payTransParam = this.qryPayTransParam(payTransBo.getPayOrderId());
        refundBo.setPayTransParam(payTransParam);
        PayAbleRefundRspBo payAbleRefundRspBo = payAbleByPayMethod.dealRefund(refundBo);
        if (!"0000".equals(payAbleRefundRspBo.getRespCode())) {
            retBo.setRespCode("213004");
            retBo.setRespDesc(payAbleRefundRspBo.getRespDesc());
            return retBo;
        }
        if (!StringUtils.isEmpty((Object)payAbleRefundRspBo.getRefundTransId()) && !StringUtils.isEmpty((Object)payAbleRefundRspBo.getTradeTime())) {
            PayProUpdatePayOrderInfoAfterRefundBusiReqBo updatePayOrderInfoAfterBo = new PayProUpdatePayOrderInfoAfterRefundBusiReqBo();
            updatePayOrderInfoAfterBo.setOrderId(orderInfo.getOrderId());
            updatePayOrderInfoAfterBo.setPayOrderId(payTransBo.getPayOrderId());
            updatePayOrderInfoAfterBo.setRefundedFee(Long.valueOf(MoneyUtils.haoToFen((Long)orderInfo.getRefundFee()).longValue()));
            updatePayOrderInfoAfterBo.setRefundFee(reqBo.getRefundFee());
            String oldRefundOrderStr = orderInfo.getOrderRefundId();
            String refundOrderStr = null;
            refundOrderStr = StringUtils.isEmpty((Object)oldRefundOrderStr) ? createRefundOrderRetBo.getOrderId() : oldRefundOrderStr + ORDER_REFUND_ID_SPLIT + createRefundOrderRetBo.getOrderId();
            updatePayOrderInfoAfterBo.setOrderRefundIdStr(refundOrderStr);
            PayProUpdatePayOrderInfoAfterRefundBusiRspBo updateRetBo = this.payProUpdatePayOrderInfoAfterRefundBusiService.updatePayOrderInfo(updatePayOrderInfoAfterBo);
            if (!"0000".equals(updateRetBo.getRespCode())) {
                retBo.setRespCode("213004");
                retBo.setRespDesc("\u8c03\u7528\u652f\u4ed8\u673a\u6784\u9000\u6b3e\u63a5\u53e3\u540e\u8c03\u7528\u66f4\u65b0\u652f\u4ed8\u6570\u636e\u670d\u52a1\u5931\u8d25\uff1a" + updateRetBo.getRespDesc());
                return retBo;
            }
            PayProUpdateRefundOrderInfoAfterRefundBusiReqBo updateRefundBo = new PayProUpdateRefundOrderInfoAfterRefundBusiReqBo();
            updateRefundBo.setOrderId(Long.valueOf(Long.parseLong(createRefundOrderRetBo.getOrderId())));
            updateRefundBo.setRefundOrderId(addRefundRetBo.getRefundOrderId());
            updateRefundBo.setRefundFee(reqBo.getRefundFee());
            updateRefundBo.setRefundTransId(payAbleRefundRspBo.getRefundTransId());
            updateRefundBo.setTradeTime(payAbleRefundRspBo.getTradeTime());
            PayProUpdateRefundOrderInfoAfterRefundBusiRspBo updateRefundRetBo = this.payProUpdateRefundOrderInfoAfterRefundBusiService.updateRefundInfo(updateRefundBo);
            if (!"0000".equals(updateRefundRetBo.getRespCode())) {
                retBo.setRespCode("213004");
                retBo.setRespDesc("\u8c03\u7528\u652f\u4ed8\u673a\u6784\u9000\u6b3e\u63a5\u53e3\u540e\u8c03\u7528\u66f4\u65b0\u9000\u6b3e\u6570\u636e\u670d\u52a1\u5931\u8d25\uff1a" + updateRefundRetBo.getRespDesc());
                return retBo;
            }
        }
        BeanUtils.copyProperties((Object)reqBo, (Object)retBo);
        retBo.setTradeTime(payAbleRefundRspBo.getTradeTime());
        retBo.setRefundTransId(payAbleRefundRspBo.getRefundTransId());
        retBo.setWebUrl(payAbleRefundRspBo.getWebUrl());
        retBo.setPayCenterRefundOrderId(Long.valueOf(Long.parseLong(createRefundOrderRetBo.getOrderId())));
        retBo.setPayCenterRefundTransOrderId(addRefundRetBo.getRefundOrderId());
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u8c03\u7528\u6210\u529f");
        return retBo;
    }

    private Map<String, String> qryPayTransParam(String payOrderId) {
        POrderPayTransParamPo qryPo = new POrderPayTransParamPo();
        qryPo.setPayOrderId(payOrderId);
        List<POrderPayTransParamPo> pOrderPayTransParamPos = this.pOrderPayTransParamMapper.selectByCondition(qryPo);
        HashMap<String, String> retMap = new HashMap<String, String>();
        for (POrderPayTransParamPo po : pOrderPayTransParamPos) {
            retMap.put(po.getParamKey(), po.getParamValue());
        }
        return retMap;
    }

    private void preparedRefundTransBo(PayAbleRefundCombReqBo reqBo, PorderPo orderInfo, PorderPayTransAtomRspBo payTransBo, PayProCreateOrderRefundTransBusiReqBo addRefundBo, PayProPreparedOrderCombRspBo createRefundOrderRetBo) {
        addRefundBo.setPayOrderId(payTransBo.getPayOrderId());
        addRefundBo.setOrderId(Long.valueOf(Long.parseLong(createRefundOrderRetBo.getOrderId())));
        addRefundBo.setBusiId(orderInfo.getBusiId());
        addRefundBo.setMerchantId(orderInfo.getMerchantId());
        addRefundBo.setPayMethod(payTransBo.getPayMethod());
        addRefundBo.setPayFee(reqBo.getRefundFee());
        addRefundBo.setOrderStatus("B00");
    }

    private void preparedPOrderBo(PayAbleRefundCombReqBo reqBo, PorderPo orderInfo, PayProPreparedOrderCombReqBo createRefundOrderBo) {
        BeanUtils.copyProperties((Object)reqBo, (Object)createRefundOrderBo);
        createRefundOrderBo.setMerchantId(orderInfo.getMerchantId() + "");
        createRefundOrderBo.setOutOrderId(reqBo.getRefundOutOrderId());
        createRefundOrderBo.setBusiCode(orderInfo.getBusiCode());
        createRefundOrderBo.setBusiId(orderInfo.getBusiId());
        createRefundOrderBo.setTotalFee(reqBo.getRefundFee() + "");
        createRefundOrderBo.setReqWay(orderInfo.getReqWay());
        createRefundOrderBo.setDetailName(reqBo.getRefundReason());
        createRefundOrderBo.setRefundFee(reqBo.getRefundFee());
        createRefundOrderBo.setOrderType(reqBo.getOrderType());
        if (StringUtils.isEmpty((Object)createRefundOrderBo.getOrderType())) {
            createRefundOrderBo.setOrderType("02");
        }
        createRefundOrderBo.setOutRefundNo(reqBo.getOriOutOrderId());
    }

    private String checkOrderInfo(PorderPo orderInfo, String oriOutOrderId, PayAbleRefundCombReqBo reqBo, List<PorderPayTransAtomRspBo> transAtomList) {
        if (orderInfo == null) {
            return "\u8be5\u539f\u652f\u4ed8\u5916\u90e8\u8ba2\u5355(" + oriOutOrderId + ")\u5bf9\u5e94\u7684\u8ba2\u5355\u4e0d\u5b58\u5728\uff01";
        }
        if (!"A10".equals(orderInfo.getOrderStatus())) {
            if (!REFUND_ACTIVE_QUERY.equals(reqBo.getActiveQueryFlag())) {
                return "\u8be5\u652f\u4ed8\u8ba2\u5355(" + oriOutOrderId + ")\u8fd8\u672a\u652f\u4ed8\uff0c\u4e0d\u80fd\u9000\u6b3e\uff01";
            }
            PorderPayTransAtomReqBo orderPayTransAtomReq = new PorderPayTransAtomReqBo();
            orderPayTransAtomReq.setOrderId(orderInfo.getOrderId());
            List<PorderPayTransAtomRspBo> porderPayTransAtomRspBos = this.porderPayTransAtomService.queryOrderPayTransByCondition(orderPayTransAtomReq);
            PorderPayTransAtomRspBo payTransBo = porderPayTransAtomRspBos.get(0);
            Long payMethod = payTransBo.getPayMethod();
            PayAble payAble = this.payAbleManager.getPayAbleByPayMethod(payMethod);
            PayProQueryPayParaBusiReqBo qryParaBo = new PayProQueryPayParaBusiReqBo();
            qryParaBo.setMerchantId(orderInfo.getMerchantId());
            qryParaBo.setPayMethod(payMethod);
            PayProQueryPayParaBusiRspBo payProQueryPayParaBusiRspBo = this.payProQueryPayParaBusiService.queryPayPara(qryParaBo);
            if (!"0000".equals(payProQueryPayParaBusiRspBo.getRespCode())) {
                return "\u67e5\u8be2\u652f\u4ed8\u53c2\u6570\u5931\u8d25\uff1a" + payProQueryPayParaBusiRspBo.getRespDesc();
            }
            PorderPayTransAtomRspBo transAtomRspBo = this.porderPayTransAtomService.queryLastRecordByOrderId(orderInfo.getOrderId());
            if (transAtomRspBo == null) {
                return "\u8be5\u8ba2\u5355" + orderInfo.getOrderId() + "\u8fd8\u672a\u53d1\u8d77\u652f\u4ed8";
            }
            String payOrderId = transAtomRspBo.getPayOrderId();
            PayAbleQryPayStatusReqBo qryPayStatusBo = new PayAbleQryPayStatusReqBo();
            BeanUtils.copyProperties((Object)reqBo, (Object)qryPayStatusBo);
            qryPayStatusBo.setOrderId(orderInfo.getOrderId());
            qryPayStatusBo.setPayOrderId(payOrderId);
            qryPayStatusBo.setParaMap(payProQueryPayParaBusiRspBo.getDetailAttrs());
            qryPayStatusBo.setTradeTime(transAtomRspBo.getTradeTime());
            qryPayStatusBo.setPayNotifyTransId(transAtomRspBo.getPayNotifyTransId());
            qryPayStatusBo.setCreateTime(transAtomRspBo.getCreateTime());
            PayAbleQryPayStatusRspBo payAbleQryPayStatusRspBo = payAble.qryPayStatus(qryPayStatusBo);
            if (!"0000".equals(payAbleQryPayStatusRspBo.getRespCode())) {
                return "\u8c03\u7528\u652f\u4ed8\u673a\u6784\u67e5\u8be2\u652f\u4ed8\u72b6\u6001\u5931\u8d25\uff1a" + payAbleQryPayStatusRspBo.getRespDesc();
            }
            if (!"SUCCESS".equals(payAbleQryPayStatusRspBo.getPayStatus())) {
                return "\u8be5\u652f\u4ed8\u8ba2\u5355(" + oriOutOrderId + ")\u8fd8\u672a\u652f\u4ed8\u6210\u529f\uff0c\u4e0d\u80fd\u9000\u6b3e\uff01";
            }
            String validateQueryResultStr = this.validateQueryResult(payAbleQryPayStatusRspBo, payMethod);
            if (!StringUtils.isEmpty((Object)validateQueryResultStr)) {
                log.error(validateQueryResultStr);
                throw new BusinessException("217001", validateQueryResultStr);
            }
            PayProUpdateOrderTransBusiReqBo updateOrderData = this.makeUpdateBo(orderInfo.getOrderId(), payAbleQryPayStatusRspBo);
            PayProUpdateOrderTransBusiRspBo payProUpdateOrderTransBusiRspBo = this.payProUpdateOrderTransBusiService.updateOrderData(updateOrderData);
            if (!"0000".equals(payProUpdateOrderTransBusiRspBo.getRespCode())) {
                return "\u67e5\u8be2\u56de\u6765\u66f4\u65b0\u6570\u636e\u5931\u8d25\uff1a" + payProUpdateOrderTransBusiRspBo.getRespDesc();
            }
            transAtomRspBo.setOrderStatus("A10");
            transAtomList.add(transAtomRspBo);
            orderInfo.setOrderStatus("A10");
            orderInfo.setPayNotifyTransId(payAbleQryPayStatusRspBo.getPayNotifyTransId());
            orderInfo.setTradeTime(payAbleQryPayStatusRspBo.getTradeTime());
        }
        if (transAtomList.isEmpty()) {
            return "\u8be5\u652f\u4ed8\u8ba2\u5355(" + oriOutOrderId + ")\u6ca1\u6709\u652f\u4ed8\u6210\u529f\u7684\u652f\u4ed8\u8ba2\u5355\uff01";
        }
        long orderRefundFeeHao = orderInfo.getRefundFee() == null ? 0L : orderInfo.getRefundFee();
        long orderTotalFeeHao = orderInfo.getTotalFee();
        long orderTotalFeeFen = MoneyUtils.haoToFen((Long)orderTotalFeeHao).longValue();
        long canRefundFeeFen = MoneyUtils.haoToFen((Long)(orderTotalFeeHao - orderRefundFeeHao)).longValue();
        long refundFeeFen = reqBo.getRefundFee();
        if (orderTotalFeeHao == orderRefundFeeHao) {
            return REFUND_OK;
        }
        if (transAtomList.size() > 1) {
            return "\u8be5\u652f\u4ed8\u8ba2\u5355(" + oriOutOrderId + ")\u6709\u591a\u7b14\u652f\u4ed8\u6210\u529f\u7684\u5355\u5b50\uff01";
        }
        if (refundFeeFen > canRefundFeeFen) {
            return "\u9000\u6b3e\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u5f53\u524d\u53ef\u9000\u6b3e\u91d1\u989d\uff0c\u5f53\u524d\u53ef\u9000\u91d1\u989d\uff1a(" + canRefundFeeFen + ")\u5206\uff0c\u6b32\u9000\u6b3e\u91d1\u989d\uff1a(" + refundFeeFen + ")\u5206";
        }
        if ("02".equals(reqBo.getOrderType()) && orderRefundFeeHao > 0L) {
            return "\u8be5\u8ba2\u5355\u5df2\u8fdb\u884c\u8fc7\u90e8\u5206\u9000\u6b3e\uff0c\u4e0d\u80fd\u518d\u8fdb\u884c\u5168\u989d\u9000\u6b3e";
        }
        if ("02".equals(reqBo.getOrderType()) && orderTotalFeeFen != refundFeeFen) {
            return "\u5168\u989d\u9000\u6b3e\u65f6\u4f20\u5165\u91d1\u989d\u5fc5\u987b\u7b49\u4e8e\u4e0b\u5355\u91d1\u989d\uff0c\u4e0b\u5355\u91d1\u989d\u4e3a\uff1a" + orderTotalFeeFen + " \u5206";
        }
        return null;
    }

    private String validateArg(PayAbleRefundCombReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getBusiId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027busiId\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getOriOutOrderId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027oriOutOrderId\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getRefundFee())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027refundFee\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getRefundOutOrderId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027refundOutOrderId\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getRefundReason())) {
            reqBo.setRefundReason(NORMAL_REFUND_DESC);
        }
        String orderType = reqBo.getOrderType();
        String refund = "02";
        String bufenRefund = "06";
        String errorStr = refund + "\u3010\u6574\u5355\u9000\u6b3e\u3011\uff0c" + bufenRefund + "\u3010\u90e8\u5206\u9000\u6b3e\u3011";
        if (!StringUtils.isEmpty((Object)orderType)) {
            if (!refund.equals(orderType) && !bufenRefund.equals(orderType)) {
                return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027orderType\u5fc5\u987b\u4e3a(" + errorStr + ")\u4e2d\u7684\u503c";
            }
        } else {
            reqBo.setOrderType(refund);
        }
        return null;
    }

    private String validateQueryResult(PayAbleQryPayStatusRspBo payBo, Long payMethod) {
        if (StringUtils.isEmpty((Object)payBo.getOrderId())) {
            return "\u67e5\u8be2\u652f\u4ed8\u72b6\u6001\u6210\u529f\u65f6\uff0c\u652f\u4ed8\u65b9\u5f0f(" + payMethod + ")\u672a\u8fd4\u56deorderId";
        }
        if (StringUtils.isEmpty((Object)payBo.getPayNotifyTransId())) {
            return "\u67e5\u8be2\u652f\u4ed8\u72b6\u6001\u6210\u529f\u65f6\uff0c\u652f\u4ed8\u65b9\u5f0f(" + payMethod + ")\u672a\u8fd4\u56depayNotifyTransId";
        }
        if (StringUtils.isEmpty((Object)payBo.getPayOrderId())) {
            return "\u67e5\u8be2\u652f\u4ed8\u72b6\u6001\u6210\u529f\u65f6\uff0c\u652f\u4ed8\u65b9\u5f0f(" + payMethod + ")\u672a\u8fd4\u56depayOrderId";
        }
        if (StringUtils.isEmpty((Object)payBo.getRealFee())) {
            return "\u67e5\u8be2\u652f\u4ed8\u72b6\u6001\u6210\u529f\u65f6\uff0c\u652f\u4ed8\u65b9\u5f0f(" + payMethod + ")\u672a\u8fd4\u56derealFee";
        }
        if (StringUtils.isEmpty((Object)payBo.getTradeTime())) {
            return "\u67e5\u8be2\u652f\u4ed8\u72b6\u6001\u6210\u529f\u65f6\uff0c\u652f\u4ed8\u65b9\u5f0f(" + payMethod + ")\u672a\u8fd4\u56detradeTime";
        }
        return null;
    }

    private PayProUpdateOrderTransBusiReqBo makeUpdateBo(Long orderId, PayAbleQryPayStatusRspBo payAbleQryPayStatusRspBo) {
        PayProUpdateOrderTransBusiReqBo updateOrderData = new PayProUpdateOrderTransBusiReqBo();
        updateOrderData.setOrderId(orderId);
        updateOrderData.setOrderStatus("A10");
        updateOrderData.setPayNotifyTransId(payAbleQryPayStatusRspBo.getPayNotifyTransId());
        updateOrderData.setPayOrderId(payAbleQryPayStatusRspBo.getPayOrderId());
        updateOrderData.setTradeTime(payAbleQryPayStatusRspBo.getTradeTime());
        updateOrderData.setPayNotifyCode("0");
        updateOrderData.setPayNotifyMsg("\u67e5\u8be2\u66f4\u65b0");
        updateOrderData.setPayNotifyTime(this.queryDBDateBusiService.getDBDate());
        return updateOrderData;
    }
}

