/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.payable.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alipay.api.AlipayApiException;
import com.alipay.api.AlipayRequest;
import com.alipay.api.DefaultAlipayClient;
import com.alipay.api.request.AlipayTradePayRequest;
import com.alipay.api.response.AlipayTradePayResponse;
import com.tydic.payment.pay.busi.PayInfoContractQueryBusiService;
import com.tydic.payment.pay.busi.bo.PayAbleBusiReqDataBo;
import com.tydic.payment.pay.busi.bo.PayAbleDealPayReqBo;
import com.tydic.payment.pay.busi.bo.PayAbleDealPayRspBo;
import com.tydic.payment.pay.busi.bo.PayInfoContractQueryBusiReqBo;
import com.tydic.payment.pay.busi.bo.PayInfoContractQueryBusiRspBo;
import com.tydic.payment.pay.common.util.MoneyUtils;
import com.tydic.payment.pay.config.vo.PayPropertiesVo;
import com.tydic.payment.pay.constant.PayProConstants;
import com.tydic.payment.pay.payable.api.PayAble;
import com.tydic.payment.pay.payable.impl.AbstractAliPayAble;
import java.util.HashMap;
import java.util.Map;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class AliPayDeductPayAbleImpl
extends AbstractAliPayAble
implements PayAble {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private static final String ALI_CODE_SUCCESS = "10000";
    private static final String PRODUCT_CODE = "CYCLE_PAY_AUTH";
    @Autowired
    private PayPropertiesVo payPropertiesVo;
    @Autowired
    private PayInfoContractQueryBusiService payInfoContractQueryBusiService;

    public Long getPayMethod() {
        return PayProConstants.PayMethod.ALI_DEDUCT.getPayMethod();
    }

    public PayAbleDealPayRspBo dealPay(PayAbleDealPayReqBo reqBo) {
        AlipayTradePayResponse response;
        this.LOGGER.info("\u8fdb\u5165\u652f\u4ed8\u5b9d\u6263\u6b3e\u80fd\u529b\u5b9e\u73b0\u7c7b\uff1a" + reqBo);
        PayAbleDealPayRspBo retBo = new PayAbleDealPayRspBo();
        String validateStr = this.validateArgs(reqBo);
        if (!StringUtils.isEmpty((Object)validateStr)) {
            this.LOGGER.info("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            retBo.setRespCode("212056");
            retBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            return retBo;
        }
        String serverUrl = this.payPropertiesVo.getAliOpenApiDomain();
        String aliNotifyUrl = this.payPropertiesVo.getValueByKey("ali.pay.new.notify.url");
        if (StringUtils.isEmpty((Object)serverUrl)) {
            this.LOGGER.error("\u652f\u4ed8\u5b9d\u8bf7\u6c42\u5730\u5740'aliOpenApiDomain'\u672a\u914d\u7f6e");
            retBo.setRespCode("212050");
            retBo.setRespDesc("\u652f\u4ed8\u5b9d\u8bf7\u6c42\u5730\u5740'aliOpenApiDomain'\u672a\u914d\u7f6e");
            return retBo;
        }
        if (StringUtils.isEmpty((Object)aliNotifyUrl)) {
            this.LOGGER.error("\u652f\u4ed8\u5b9d\u56de\u8c03\u5730\u5740'ali.pay.new.notify.url'\u672a\u914d\u7f6e");
            retBo.setRespCode("212050");
            retBo.setRespDesc("\u652f\u4ed8\u5b9d\u56de\u8c03\u5730\u5740'ali.pay.new.notify.url'\u672a\u914d\u7f6e");
            return retBo;
        }
        Map paraMap = reqBo.getParaMap();
        String privateKey = (String)paraMap.get("privateKey");
        String appId = (String)paraMap.get("appid");
        String publicKey = (String)paraMap.get("publicKey");
        PayAbleBusiReqDataBo reqDataBo = (PayAbleBusiReqDataBo)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)reqBo.getBusiReqData()), PayAbleBusiReqDataBo.class);
        DefaultAlipayClient alipayClient = new DefaultAlipayClient(serverUrl, appId, privateKey, "json", "UTF-8", publicKey, "RSA2");
        AlipayTradePayRequest request = new AlipayTradePayRequest();
        request.setNotifyUrl(aliNotifyUrl);
        String bizContent = this.sortBizContent(reqBo, reqDataBo, retBo);
        if (StringUtils.isEmpty((Object)bizContent)) {
            return retBo;
        }
        request.setBizContent(bizContent);
        try {
            response = (AlipayTradePayResponse)alipayClient.execute((AlipayRequest)request);
        }
        catch (AlipayApiException e) {
            this.LOGGER.error("\u8c03\u7528\u652f\u4ed8\u5b9d\u63a5\u53e3\u5931\u8d25\uff1a" + e.getMessage());
            retBo.setRespCode("212056");
            retBo.setRespDesc("\u8c03\u7528\u652f\u4ed8\u5b9d\u63a5\u53e3\u5931\u8d25\uff1a" + e.getMessage());
            return retBo;
        }
        this.LOGGER.info("\u652f\u4ed8\u5b9d\u6263\u6b3e\u63a5\u53e3\u8fd4\u56de\u4fe1\u606f\u4e3a\uff1a" + (response != null ? JSON.toJSONString((Object)response) : null));
        if (response == null) {
            this.LOGGER.error("\u8c03\u7528\u652f\u4ed8\u5b9d\u63a5\u53e3\u5931\u8d25\uff1a\u8fd4\u56de\u5bf9\u8c61\u4e3a\u7a7a");
            retBo.setRespCode("212056");
            retBo.setRespDesc("\u8c03\u7528\u652f\u4ed8\u5b9d\u63a5\u53e3\u5931\u8d25\uff1a\u8fd4\u56de\u5bf9\u8c61\u4e3a\u7a7a");
            retBo.setPayResultCode("FAIL");
            return retBo;
        }
        if (response.isSuccess()) {
            String payResultCode;
            BeanUtils.copyProperties((Object)reqBo, (Object)retBo);
            String returnCode = response.getCode();
            String returnMsg = response.getMsg();
            if (ALI_CODE_SUCCESS.equals(returnCode)) {
                payResultCode = "SUCCESS";
                retBo.setPayResultMsg("\u652f\u4ed8\u5b9d\u6263\u6b3e\u6210\u529f");
                retBo.setPayNotifyTransId(response.getTradeNo());
                retBo.setTradeTime(new DateTime((Object)response.getGmtPayment()).toString("yyyyMMddHHmmss"));
            } else {
                payResultCode = "FAIL";
                retBo.setPayResultMsg(returnMsg);
            }
            retBo.setPayResultCode(payResultCode);
            retBo.setRespCode("0000");
            retBo.setRespDesc("\u652f\u4ed8\u6263\u6b3e\u63a5\u53e3\u8c03\u7528\u6210\u529f");
        } else {
            this.LOGGER.error("\u8c03\u7528\u652f\u4ed8\u5b9d\u63a5\u53e3\u5931\u8d25\uff1a" + response.getSubMsg());
            retBo.setRespCode("212056");
            retBo.setRespDesc("\u8c03\u7528\u652f\u4ed8\u5b9d\u63a5\u53e3\u5931\u8d25\uff1a" + response.getSubMsg());
            retBo.setPayResultCode("FAIL");
        }
        return retBo;
    }

    private String sortBizContent(PayAbleDealPayReqBo reqBo, PayAbleBusiReqDataBo reqDataBo, PayAbleDealPayRspBo retBo) {
        PayInfoContractQueryBusiReqBo qryContractReqBo = new PayInfoContractQueryBusiReqBo();
        qryContractReqBo.setContractId(reqDataBo.getContractId());
        qryContractReqBo.setContractStatus(Long.valueOf("1"));
        PayInfoContractQueryBusiRspBo qryContractRetBo = this.payInfoContractQueryBusiService.queryContractInfo(qryContractReqBo);
        if (!"0000".equals(qryContractRetBo.getRespCode()) || StringUtils.isEmpty((Object)qryContractRetBo.getAgreementNo())) {
            this.LOGGER.error("\u83b7\u53d6\u7b7e\u7ea6\u53f7\u5931\u8d25\uff1a" + qryContractRetBo.getRespDesc());
            retBo.setRespCode(qryContractRetBo.getRespCode());
            retBo.setRespDesc("\u83b7\u53d6\u7b7e\u7ea6\u53f7\u5931\u8d25\uff1a" + qryContractRetBo.getRespDesc());
            return null;
        }
        HashMap<String, String> agreementSignParams = new HashMap<String, String>(16);
        agreementSignParams.put("agreement_no", qryContractRetBo.getAgreementNo());
        HashMap<String, Object> bizContent = new HashMap<String, Object>(16);
        bizContent.put("out_trade_no", reqBo.getPayOrderId());
        bizContent.put("subject", reqBo.getDetailName());
        bizContent.put("total_amount", MoneyUtils.fenToYuan((Long)reqBo.getPayFee()));
        bizContent.put("product_code", PRODUCT_CODE);
        bizContent.put("agreement_params", agreementSignParams);
        this.LOGGER.info("bizContent:" + JSON.toJSONString(bizContent));
        return JSON.toJSONString(bizContent);
    }

    private String validateArgs(PayAbleDealPayReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getPayOrderId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'payOrderId'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getPayFee())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'payFee'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getDetailName())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'detailName'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        Map paraMap = reqBo.getParaMap();
        String publicKey = (String)paraMap.get("publicKey");
        String privateKey = (String)paraMap.get("privateKey");
        String appId = (String)paraMap.get("appid");
        if (StringUtils.isEmpty((Object)privateKey)) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'paraMap'\u4e2dkey(privateKey)\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)publicKey)) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'paraMap'\u4e2dkey(publicKey)\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)appId)) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'paraMap'\u4e2dkey(appId)\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getExtTime())) {
            reqBo.setExtTime("3");
        }
        if (StringUtils.isEmpty((Object)reqBo.getBusiReqData())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'busiReqDataBo'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        PayAbleBusiReqDataBo reqDataBo = (PayAbleBusiReqDataBo)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)reqBo.getBusiReqData()), PayAbleBusiReqDataBo.class);
        if (StringUtils.isEmpty((Object)reqDataBo.getContractId())) {
            return "\u5165\u53c2\u5bf9\u8c61'busiReqData'\u4e2d'contractId'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }
}

