/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.service.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.bo.RspPage;
import com.ohaotian.plugin.db.Page;
import com.tydic.payment.pay.atom.PaymentInsAtomService;
import com.tydic.payment.pay.busi.QueryPCodeInfoService;
import com.tydic.payment.pay.busi.bo.QueryPCodeInfoReqBO;
import com.tydic.payment.pay.dao.BillCheckConfigMapper;
import com.tydic.payment.pay.dao.po.BillCheckConfigPO;
import com.tydic.payment.pay.dao.po.PaymentInsPo;
import com.tydic.payment.pay.web.bo.req.BillCheckConfigQueryWebReqBo;
import com.tydic.payment.pay.web.bo.rsp.BillCheckConfigQueryWebRspBo;
import com.tydic.payment.pay.web.service.BillCheckConfigQueryWebService;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="billCheckConfigQueryWebService")
@HSFProvider(serviceVersion="2.0.0", serviceGroup="PAYMENT_GROUP_DEV", serviceInterface=BillCheckConfigQueryWebService.class)
public class BillCheckConfigQueryWebServiceImpl
implements BillCheckConfigQueryWebService {
    private static final String SERVICE_NAME = "\u5bf9\u8d26\u652f\u4ed8\u5546\u6237\u914d\u7f6e\u8868\u67e5\u8be2web\u670d\u52a1";
    private static final Logger LOG = LoggerFactory.getLogger(BillCheckConfigQueryWebServiceImpl.class);
    @Autowired
    private BillCheckConfigMapper billCheckConfigMapper;
    @Autowired
    private QueryPCodeInfoService queryPCodeInfoService;
    @Autowired
    private PaymentInsAtomService paymentInsAtomService;

    public RspPage<BillCheckConfigQueryWebRspBo> getListWithPage(BillCheckConfigQueryWebReqBo reqBo) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("\u5bf9\u8d26\u652f\u4ed8\u5546\u6237\u914d\u7f6e\u8868\u67e5\u8be2web\u670d\u52a1-> \u5165\u53c2\uff1a" + JSON.toJSONString((Object)reqBo));
        }
        BillCheckConfigPO billCheckConfigPO = new BillCheckConfigPO();
        RspPage retBo = new RspPage();
        ArrayList<BillCheckConfigQueryWebRspBo> rspList = new ArrayList<BillCheckConfigQueryWebRspBo>();
        retBo.setRows(rspList);
        this.initReqBo(reqBo);
        BeanUtils.copyProperties((Object)reqBo, (Object)billCheckConfigPO);
        if (!StringUtils.isEmpty((Object)reqBo.getPaymentInsId())) {
            billCheckConfigPO.setPaymentInsId(Long.valueOf(reqBo.getPaymentInsId()));
        }
        Page billCheckConfigPOPage = new Page();
        if (reqBo.getPageNo() > 1) {
            billCheckConfigPOPage = new Page(reqBo.getPageNo(), reqBo.getPageSize());
        } else {
            billCheckConfigPOPage = new Page();
            BeanUtils.copyProperties((Object)reqBo, (Object)billCheckConfigPOPage);
            if (billCheckConfigPOPage.getPageNo() < 1) {
                billCheckConfigPOPage.setPageNo(1);
            }
            if (billCheckConfigPOPage.getPageSize() < 1) {
                billCheckConfigPOPage.setPageSize(10);
            }
        }
        List<BillCheckConfigPO> billCheckConfigPOList = this.billCheckConfigMapper.selectBySelectiveWithPage(billCheckConfigPO, (Page<BillCheckConfigPO>)billCheckConfigPOPage);
        if (!CollectionUtils.isEmpty(billCheckConfigPOList)) {
            for (BillCheckConfigPO tempList : billCheckConfigPOList) {
                BillCheckConfigQueryWebRspBo bo = this.valueTransmit(tempList);
                rspList.add(bo);
            }
        }
        retBo.setRecordsTotal(billCheckConfigPOPage.getTotalCount());
        retBo.setTotal(billCheckConfigPOPage.getTotalPages());
        retBo.setPageNo(billCheckConfigPOPage.getPageNo());
        return retBo;
    }

    private void initReqBo(BillCheckConfigQueryWebReqBo reqBo) {
        if (reqBo != null) {
            if (StringUtils.isEmpty((Object)reqBo.getEffFlag())) {
                reqBo.setEffFlag(null);
            }
            if (StringUtils.isEmpty((Object)reqBo.getPaymentInsId())) {
                reqBo.setPaymentInsId(null);
            }
            if (StringUtils.isEmpty((Object)reqBo.getLastResult())) {
                reqBo.setLastResult(null);
            }
            if (StringUtils.isEmpty((Object)reqBo.getPaymentMchId())) {
                reqBo.setPaymentMchId(null);
            }
        }
    }

    public BillCheckConfigQueryWebRspBo valueTransmit(BillCheckConfigPO po) {
        BillCheckConfigQueryWebRspBo bo = new BillCheckConfigQueryWebRspBo();
        if (!StringUtils.isEmpty((Object)po.getConfigId())) {
            bo.setConfigId(po.getConfigId() + "");
        }
        if (!StringUtils.isEmpty((Object)po.getPaymentInsId())) {
            bo.setPaymentInsId(po.getPaymentInsId() + "");
            PaymentInsPo queryPo = new PaymentInsPo();
            List<PaymentInsPo> queryList = this.paymentInsAtomService.queryAllPaymentIdAndName(queryPo);
            for (PaymentInsPo temp : queryList) {
                if (!temp.getPaymentInsId().equals(Long.valueOf(bo.getPaymentInsId()))) continue;
                bo.setPaymentInsName(temp.getPaymentInsName());
            }
        }
        if (!StringUtils.isEmpty((Object)po.getPaymentMchId())) {
            bo.setPaymentMchId(po.getPaymentMchId() + "");
        }
        if (!StringUtils.isEmpty((Object)po.getLastResult())) {
            bo.setLastResult(po.getLastResult() + "");
            QueryPCodeInfoReqBO queryPCodeInfoReqBo = new QueryPCodeInfoReqBO();
            queryPCodeInfoReqBo.setTypeCode("BILL_CHECK_CONFIG_LAST_RESULT");
            queryPCodeInfoReqBo.setCodeValue(po.getLastResult());
            bo.setLastResultName(this.queryPCodeInfoService.queryPCodeInfo(queryPCodeInfoReqBo).getCodeInfo());
        }
        if (!StringUtils.isEmpty((Object)po.getNextDate())) {
            bo.setNextDate(po.getNextDate() + "");
        }
        if (!StringUtils.isEmpty((Object)po.getEffFlag())) {
            bo.setEffFlag(po.getEffFlag());
            QueryPCodeInfoReqBO queryPCodeInfoReqBO = new QueryPCodeInfoReqBO();
            queryPCodeInfoReqBO.setTypeCode("BILL_CHECK_CONFIG_EFF_FLAG");
            queryPCodeInfoReqBO.setCodeValue(po.getEffFlag());
            bo.setEffFlagname(this.queryPCodeInfoService.queryPCodeInfo(queryPCodeInfoReqBO).getCodeInfo());
        }
        if (!StringUtils.isEmpty((Object)po.getLastResultCode())) {
            bo.setLastResultCode(po.getLastResultCode());
        }
        if (!StringUtils.isEmpty((Object)po.getLastResultDesc())) {
            bo.setLastResultDesc(po.getLastResultDesc());
        }
        if (!StringUtils.isEmpty((Object)po.getPayCenterMerchant())) {
            bo.setPayCenterMerchant(po.getPayCenterMerchant());
        }
        return bo;
    }
}

