/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.service.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSONObject;
import com.tydic.payment.pay.busi.PayOrderBusiService;
import com.tydic.payment.pay.busi.bo.PayOrderRspBo;
import com.tydic.payment.pay.comb.RefundCombService;
import com.tydic.payment.pay.comb.bo.RefundCombReqBO;
import com.tydic.payment.pay.comb.bo.RefundCombRspBO;
import com.tydic.payment.pay.common.util.MoneyUtils;
import com.tydic.payment.pay.web.bo.req.CancleOrderSelfReqBo;
import com.tydic.payment.pay.web.bo.rsp.CancleOrderSelfRspBo;
import com.tydic.payment.pay.web.service.CancelOrderBySelfeWebService;
import java.math.BigDecimal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="cancelOrderBySelfeWebService")
@HSFProvider(serviceVersion="2.0.0", serviceGroup="PAYMENT_GROUP_DEV", serviceInterface=CancelOrderBySelfeWebService.class)
public class CancelOrderBySelfeWebServiceImpl
implements CancelOrderBySelfeWebService {
    private static final Logger LOGGER = LoggerFactory.getLogger(CancelOrderBySelfeWebServiceImpl.class);
    @Autowired
    private PayOrderBusiService payOrderBusiService;
    @Autowired
    private RefundCombService refundCombService;

    public CancleOrderSelfRspBo dealCancleOrder(CancleOrderSelfReqBo cancleOrderSelfReqBo) {
        CancleOrderSelfRspBo rspBo = new CancleOrderSelfRspBo();
        String errMsg = "";
        LOGGER.info("\u9000\u6b3e\u7533\u8bf7\u5165\u53c2\u4e3a\uff1a" + JSONObject.toJSONString((Object)cancleOrderSelfReqBo));
        if (StringUtils.isEmpty((Object)cancleOrderSelfReqBo.getOrderId())) {
            errMsg = "\u9000\u6b3e\u7533\u8bf7\u3010orderId\u3011 \u4e0d\u80fd\u4e3a\u7a7a";
            LOGGER.info(errMsg);
            rspBo.setRspCode("0000");
            rspBo.setRspName("\u9000\u6b3e\u5f02\u5e38");
            rspBo.setResultCode("FAIL");
            rspBo.setResultMsg(errMsg);
            return rspBo;
        }
        Long orderId = 0L;
        try {
            orderId = Long.parseLong(cancleOrderSelfReqBo.getOrderId());
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        PayOrderRspBo orderInfo = this.payOrderBusiService.selectOrderByOrderId(orderId);
        if (!"0000".equals(orderInfo.getRspCode())) {
            errMsg = "\u672a\u67e5\u8be2\u5230\u8ba2\u5355\u6570\u636e orderId = " + orderId;
            LOGGER.info(errMsg);
            rspBo.setRspCode("0000");
            rspBo.setRspName("\u9000\u6b3e\u5f02\u5e38");
            rspBo.setResultCode("FAIL");
            rspBo.setResultMsg(errMsg);
            return rspBo;
        }
        if (!"A10".equals(orderInfo.getOrderStatus())) {
            errMsg = "\u8ba2\u5355\u6570\u636e orderId = " + orderId + "\u672a\u652f\u4ed8\uff0c\u4e0d\u80fd\u8fdb\u884c\u9000\u6b3e\u64cd\u4f5c";
            LOGGER.info(errMsg);
            rspBo.setRspCode("0000");
            rspBo.setRspName("\u9000\u6b3e\u5f02\u5e38");
            rspBo.setResultCode("FAIL");
            rspBo.setResultMsg(errMsg);
            return rspBo;
        }
        Long refunFee = orderInfo.getTotalFee() - orderInfo.getRefundFee();
        if (refunFee.compareTo(0L) == 0) {
            errMsg = "\u8ba2\u5355\u53f7 orderId =" + orderId + "\u65e0\u53ef\u9000\u91d1\u989d";
            LOGGER.info(errMsg);
            rspBo.setRspCode("0000");
            rspBo.setRspName("\u9000\u6b3e\u5f02\u5e38");
            rspBo.setResultCode("FAIL");
            rspBo.setResultMsg(errMsg);
            return rspBo;
        }
        if (orderInfo.getRefundFee() != 0L) {
            errMsg = "\u5f53\u524d\u8ba2\u5355\u4e0d\u652f\u6301\u90e8\u5206\u9000\u6b3e";
            LOGGER.info(errMsg);
            rspBo.setRspCode("0000");
            rspBo.setRspName("\u9000\u6b3e\u5f02\u5e38");
            rspBo.setResultCode("FAIL");
            rspBo.setResultMsg(errMsg);
            return rspBo;
        }
        String outOrderId = "self" + System.currentTimeMillis();
        RefundCombReqBO reqBO = new RefundCombReqBO();
        reqBO.setBusiId(String.valueOf(orderInfo.getBusiId()));
        reqBO.setBusiCode(orderInfo.getBusiCode());
        reqBO.setChannelId(orderInfo.getChannelId());
        reqBO.setChannelType("1010000");
        reqBO.setCreateOperId(orderInfo.getCreateOperId());
        reqBO.setCreateOperIdName(orderInfo.getCreateOperIdName());
        reqBO.setOrderType("02");
        reqBO.setOutOrderId(outOrderId);
        reqBO.setOutRefundId(orderInfo.getOutOrderId());
        BigDecimal fee = new BigDecimal(0);
        try {
            fee = MoneyUtils.haoToFen((Long)orderInfo.getTotalFee());
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        String feeStr = fee.toString();
        reqBO.setRealFee(feeStr);
        reqBO.setTotalFee(feeStr);
        reqBO.setRefundFee(feeStr);
        reqBO.setRefundDesc("\u4eba\u5de5\u64a4\u9500");
        reqBO.setRefundFlag("2");
        reqBO.setReqWay(orderInfo.getReqWay());
        RefundCombRspBO refundCombRspBO = new RefundCombRspBO();
        try {
            refundCombRspBO = this.refundCombService.dealRefund(reqBO);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            errMsg = e.getMessage();
            LOGGER.info(errMsg);
            rspBo.setRspCode("0000");
            rspBo.setRspName("\u9000\u6b3e\u5f02\u5e38");
            rspBo.setResultCode("FAIL");
            rspBo.setResultMsg(errMsg);
            return rspBo;
        }
        BeanUtils.copyProperties((Object)refundCombRspBO, (Object)rspBo);
        rspBo.setRspCode(refundCombRspBO.getRspCode());
        rspBo.setRspName(refundCombRspBO.getRspName());
        return rspBo;
    }
}

