/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.service.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSON;
import com.tydic.payment.pay.atom.CashierPayMethodRelAtomService;
import com.tydic.payment.pay.atom.CashierTemplateAtomService;
import com.tydic.payment.pay.atom.PayMethodAtomService;
import com.tydic.payment.pay.bo.BaseRspInfoBO;
import com.tydic.payment.pay.busi.QueryDBDateBusiService;
import com.tydic.payment.pay.dao.po.CashierPayMethodRelPo;
import com.tydic.payment.pay.dao.po.CashierTemplatePo;
import com.tydic.payment.pay.dao.po.PayMethodPo;
import com.tydic.payment.pay.exception.BusinessException;
import com.tydic.payment.pay.web.bo.req.CashierPayMethodReqBO;
import com.tydic.payment.pay.web.bo.req.CashierPaymentManagerWebReqBo;
import com.tydic.payment.pay.web.service.CashierPaymentManagerWebService;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="cashierPaymentManagerWebService")
@HSFProvider(serviceVersion="2.0.0", serviceGroup="PAYMENT_GROUP_DEV", serviceInterface=CashierPaymentManagerWebService.class)
public class CashierPaymentManagerWebServiceImpl
implements CashierPaymentManagerWebService {
    private static final Logger log = LoggerFactory.getLogger(CashierPaymentManagerWebServiceImpl.class);
    private static String SERVICE_NAME = "\u6536\u94f6\u53f0\u652f\u4ed8\u65b9\u5f0f\u7ba1\u7406\u4e1a\u52a1\u670d\u52a1";
    @Autowired
    CashierTemplateAtomService cashierTemplateAtomService;
    @Autowired
    QueryDBDateBusiService queryDBDateBusiService;
    @Autowired
    CashierPayMethodRelAtomService cashierPayMethodRelAtomService;
    @Autowired
    PayMethodAtomService payMethodAtomService;

    public BaseRspInfoBO dealCashierPaymentManager(CashierPaymentManagerWebReqBo reqbo) {
        List<CashierPayMethodRelPo> qryRelList;
        CashierPayMethodRelPo qryRelPo;
        log.info(SERVICE_NAME + " -> \u5165\u53c2\uff1a" + JSON.toJSONString((Object)reqbo));
        BaseRspInfoBO rspBo = new BaseRspInfoBO();
        this.validateArg(reqbo);
        List payMethodList = reqbo.getPayMethodList();
        CashierTemplatePo qryCashierPo = new CashierTemplatePo();
        qryCashierPo.setCashierTemplate(Long.valueOf(reqbo.getCashierTemplate()));
        List<CashierTemplatePo> qryCashierL = this.cashierTemplateAtomService.queryCashierTemplateByCondition(qryCashierPo);
        if (qryCashierL == null || qryCashierL.size() < 1) {
            log.info(SERVICE_NAME + " ->  \u5931\u8d25\uff1a\u6536\u94f6\u53f0\u6a21\u677fID[ casiherTemplate = " + reqbo.getCashierTemplate() + " ]\u5728p_info_cashier_template\u8868\u4e2d\u4e0d\u5b58\u5728");
            rspBo.setRspCode("8888");
            rspBo.setRspName("\u6536\u94f6\u53f0\u6a21\u677fID\u65e0\u6548");
            return rspBo;
        }
        for (CashierPayMethodReqBO temp : payMethodList) {
            PayMethodPo qryPayMethodPo = new PayMethodPo();
            qryPayMethodPo.setPayMethod(Long.valueOf(temp.getPayMethod()));
            List<PayMethodPo> payMethodL = this.payMethodAtomService.queryPayMethod(qryPayMethodPo);
            if (payMethodL == null || payMethodL.size() < 1) {
                log.info(SERVICE_NAME + " -> \u8be5\u652f\u4ed8\u65b9\u5f0f" + temp.getPayMethod() + "\u5728p_code_pay_method\u8868\u4e2d\u4e0d\u5b58\u5728");
                rspBo.setRspCode("8888");
                rspBo.setRspName("\u652f\u4ed8\u65b9\u5f0f\u4e0d\u5b58\u5728");
                return rspBo;
            }
            CashierPayMethodRelPo qryCashierPayMethodRel = new CashierPayMethodRelPo();
            qryCashierPayMethodRel.setCashierTemplate(Long.valueOf(reqbo.getCashierTemplate()));
            qryCashierPayMethodRel.setPayMethod(Long.valueOf(temp.getPayMethod()));
            List<CashierPayMethodRelPo> qryCPMRelL = this.cashierPayMethodRelAtomService.queryCashierPayMethodRelByCondition(qryCashierPayMethodRel);
            if (qryCPMRelL != null && qryCPMRelL.size() > 0) {
                log.info("\u67e5\u8be2\u5230\u8be5\u652f\u4ed8\u65b9\u5f0f\u5728\u8be5\u6536\u94f6\u53f0\u6a21\u677f\u4e2d\u5b58\u5728\uff0c\u5219\u65e0\u6cd5\u8fdb\u884c\u65b0\u589e");
                if (reqbo.getOperType().equals("0")) {
                    log.info("\u65b0\u589e\u5931\u8d25\uff0c\u6536\u94f6\u53f0\u5df2\u5b58\u5728\u8be5\u652f\u4ed8\u65b9\u5f0f");
                    rspBo.setRspCode("8888");
                    rspBo.setRspName("\u8be5\u6536\u94f6\u53f0\u5df2\u5b58\u5728\u8be5\u652f\u4ed8\u65b9\u5f0f");
                    return rspBo;
                }
            }
            if (qryCPMRelL != null && qryCPMRelL.size() >= 1) continue;
            log.info("\u67e5\u8be2\u5230\u8be5\u652f\u4ed8\u65b9\u5f0f\u5728\u8be5\u6536\u94f6\u53f0\u6a21\u677f\u4e2d\u4e0d\u5b58\u5728\uff0c\u5219\u65e0\u6cd5\u8fdb\u884c\u5220\u9664\u6216\u4fee\u6539");
            if (!reqbo.getOperType().equals("1") && !reqbo.getOperType().equals("2")) continue;
            log.info("\u8be5\u652f\u4ed8\u65b9\u5f0f\u5728\u6536\u94f6\u53f0\u4e2d\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u5220\u9664\u6216\u4fee\u6539");
            rspBo.setRspCode("8888");
            rspBo.setRspName("\u8be5\u652f\u4ed8\u65b9\u5f0f\u5728\u6536\u94f6\u53f0\u4e2d\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u5220\u9664\u6216\u4fee\u6539");
            return rspBo;
        }
        if (reqbo.getOperType().equals("0")) {
            for (CashierPayMethodReqBO temp : payMethodList) {
                CashierPayMethodRelPo addPo = new CashierPayMethodRelPo();
                addPo.setCashierTemplate(Long.valueOf(reqbo.getCashierTemplate()));
                addPo.setPayMethod(Long.valueOf(temp.getPayMethod()));
                if (!StringUtils.isEmpty((Object)temp.getRemark())) {
                    addPo.setRemark(temp.getRemark());
                }
                if (!StringUtils.isEmpty((Object)reqbo.getOperId())) {
                    addPo.setCreateOperId(reqbo.getOperId());
                }
                addPo.setCreateTime(this.queryDBDateBusiService.getDBDate());
                Long createCPMR = this.cashierPayMethodRelAtomService.createCashierPayMethodRel(addPo);
                log.info(SERVICE_NAME + " -> \u65b0\u589ep_rel_cashier_pay_method\u7684ID\uff1a" + createCPMR);
            }
            log.info(SERVICE_NAME + " -> \u6210\u529f\uff1a\u6536\u94f6\u53f0\u652f\u4ed8\u65b9\u5f0f\u65b0\u589e\u6210\u529f");
            rspBo.setRspCode("0000");
            rspBo.setRspName("\u65b0\u589e\u6210\u529f");
            return rspBo;
        }
        if (reqbo.getOperType().equals("1")) {
            for (CashierPayMethodReqBO temp : payMethodList) {
                qryRelPo = new CashierPayMethodRelPo();
                qryRelPo.setCashierTemplate(Long.valueOf(reqbo.getCashierTemplate()));
                qryRelPo.setPayMethod(Long.valueOf(temp.getPayMethod()));
                qryRelList = this.cashierPayMethodRelAtomService.queryCashierPayMethodRelByCondition(qryRelPo);
                if (qryRelList == null || qryRelList.isEmpty()) {
                    rspBo.setRspCode("8888");
                    rspBo.setRspName("\u672a\u67e5\u8be2\u5230\u6a21\u677f\u6570\u636e");
                    return rspBo;
                }
                if (qryRelList.size() > 1) {
                    log.error("\u6570\u636e\u5e93\u4e2d\u6570\u636e\u6709\u9519\uff0c\u5b58\u5728\u4e24\u6761\u76f8\u540c\u6570\u636e\uff0c\u6536\u94f6\u53f0\u6a21\u677fid\u4e3a\uff1a" + reqbo.getCashierTemplate() + "\u3001\u652f\u4ed8\u65b9\u5f0f\u4e3a\uff1a" + temp.getPayMethod());
                    rspBo.setRspCode("8888");
                    rspBo.setRspName("\u6570\u636e\u5e93\u8bbe\u7f6e\u9519\u8bef\uff0c\u5b58\u5728\u91cd\u590d\u6570\u636e\uff0c\u4fee\u6539\u5931\u8d25");
                    return rspBo;
                }
                CashierPayMethodRelPo updPo = new CashierPayMethodRelPo();
                updPo.setId(qryRelList.get(0).getId());
                if (!StringUtils.isEmpty((Object)reqbo.getOperId())) {
                    updPo.setUpdateOperId(reqbo.getOperId());
                }
                updPo.setRemark(temp.getRemark());
                updPo.setUpdateTime(this.queryDBDateBusiService.getDBDate());
                int updFlag = this.cashierPayMethodRelAtomService.updateCashierPayMethodRel(updPo);
                if (updFlag >= 1) continue;
                log.info("\u6570\u636e\u5e93\u66f4\u65b0\u6570\u636e\u5931\u8d25");
                rspBo.setRspCode("8888");
                rspBo.setRspName("\u66f4\u65b0\u5931\u8d25\uff1a\u6570\u636e\u5e93\u9519\u8bef");
                return rspBo;
            }
            log.info(SERVICE_NAME + " -> \u6210\u529f\uff1a\u6536\u94f6\u53f0\u652f\u4ed8\u65b9\u5f0f\u4fee\u6539\u6210\u529f");
            rspBo.setRspCode("0000");
            rspBo.setRspName("\u4fee\u6539\u6210\u529f");
            return rspBo;
        }
        if (reqbo.getOperType().equals("2")) {
            for (CashierPayMethodReqBO temp : payMethodList) {
                qryRelPo = new CashierPayMethodRelPo();
                qryRelPo.setCashierTemplate(Long.valueOf(reqbo.getCashierTemplate()));
                qryRelPo.setPayMethod(Long.valueOf(temp.getPayMethod()));
                qryRelList = this.cashierPayMethodRelAtomService.queryCashierPayMethodRelByCondition(qryRelPo);
                for (CashierPayMethodRelPo ttPo : qryRelList) {
                    log.info(SERVICE_NAME + " -> \u5220\u9664\u8bb0\u5f55\uff1a" + JSON.toJSONString((Object)ttPo));
                    CashierPayMethodRelPo delPo = new CashierPayMethodRelPo();
                    delPo.setId(ttPo.getId());
                    int n = this.cashierPayMethodRelAtomService.deleteCashierPayMethodRel(delPo);
                }
            }
            log.info(SERVICE_NAME + " -> \u6210\u529f\uff1a\u6536\u94f6\u53f0\u652f\u4ed8\u65b9\u5f0f\u5220\u9664\u6210\u529f");
            rspBo.setRspCode("0000");
            rspBo.setRspName("\u5220\u9664\u6210\u529f");
            return rspBo;
        }
        log.info("\u6536\u94f6\u53f0\u652f\u4ed8\u65b9\u5f0f\u7ba1\u7406\u670d\u52a1\u64cd\u4f5c\u5931\u8d25");
        rspBo.setRspCode("8888");
        rspBo.setRspName("\u64cd\u4f5c\u5931\u8d25");
        return rspBo;
    }

    private void validateArg(CashierPaymentManagerWebReqBo reqbo) {
        if (reqbo == null) {
            log.info(SERVICE_NAME + " -> \u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5165\u53c2\u4e0d\u53ef\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqbo.getCashierTemplate())) {
            log.info(SERVICE_NAME + " -> \u5165\u53c2cashierTemplate(\u6536\u94f6\u53f0\u6a21\u677fid)\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u6536\u94f6\u53f0\u6a21\u677fid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqbo.getOperType())) {
            log.info(SERVICE_NAME + " -> \u5165\u53c2operType(\u64cd\u4f5c\u7c7b\u578b)\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u64cd\u4f5c\u7c7b\u578b\u4e3a\u7a7a");
        }
        if (!(reqbo.getOperType().equals("0") || reqbo.getOperType().equals("1") || reqbo.getOperType().equals("2"))) {
            log.info(SERVICE_NAME + " -> \u5165\u53c2operType(\u64cd\u4f5c\u7c7b\u578b)\u53ea\u80fd\u4e3a0\u65b0\u589e1\u4fee\u65392\u5220\u9664\uff01");
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u64cd\u4f5c\u7c7b\u578b\u8bbe\u7f6e\u9519\u8bef");
        }
        if (StringUtils.isEmpty((Object)reqbo.getPayMethodListStr())) {
            log.info(SERVICE_NAME + " -> \u5165\u53c2payMethodListStr(\u652f\u4ed8\u65b9\u5f0f\u5217\u8868)\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u652f\u4ed8\u65b9\u5f0f\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String payMethodListStr = reqbo.getPayMethodListStr();
        List parseA = JSON.parseArray((String)payMethodListStr, CashierPayMethodReqBO.class);
        reqbo.setPayMethodList(parseA);
        if (reqbo.getPayMethodList() == null || reqbo.getPayMethodList().size() < 1) {
            reqbo.setPayMethodList(new ArrayList());
        }
        List payMethodL = reqbo.getPayMethodList();
        for (CashierPayMethodReqBO temp : payMethodL) {
            if (!StringUtils.isEmpty((Object)temp.getPayMethod())) continue;
            log.info(SERVICE_NAME + " -> \u5165\u53c2\u652f\u4ed8\u65b9\u5f0f\u5217\u8868\u7684\u652f\u4ed8\u65b9\u5f0f(\u64cd\u4f5c\u7c7b\u578b)\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u652f\u4ed8\u65b9\u5f0f\u5217\u8868\u7684\u652f\u4ed8\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }
}

