/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.service.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.bo.RspPage;
import com.ohaotian.plugin.db.Page;
import com.tydic.payment.pay.atom.BusiSystemInfoAtomService;
import com.tydic.payment.pay.atom.PayMethodAtomService;
import com.tydic.payment.pay.atom.PayOrderAtomService;
import com.tydic.payment.pay.atom.PorderPayTransAtomService;
import com.tydic.payment.pay.busi.OrderQueryConstructionBusiService;
import com.tydic.payment.pay.busi.QueryCodeListByTypecodeService;
import com.tydic.payment.pay.busi.QueryPCodeInfoService;
import com.tydic.payment.pay.busi.bo.OrderQueryConstructionReqBo;
import com.tydic.payment.pay.busi.bo.OrderQueryConstructionRspBo;
import com.tydic.payment.pay.busi.bo.PCodeListBoStr;
import com.tydic.payment.pay.busi.bo.QueryCodeListByTypecodeReqBo;
import com.tydic.payment.pay.busi.bo.QueryCodeListByTypecodeRspBo;
import com.tydic.payment.pay.common.util.MoneyUtils;
import com.tydic.payment.pay.dao.po.BusiSystemInfoPO;
import com.tydic.payment.pay.dao.po.PayMethodPo;
import com.tydic.payment.pay.dao.po.PorderPageReqPO;
import com.tydic.payment.pay.dao.po.PorderPayTransPo;
import com.tydic.payment.pay.dao.po.PorderPo;
import com.tydic.payment.pay.web.bo.req.QueryPayOrderOfSuccAndFailWebReqBo;
import com.tydic.payment.pay.web.bo.rsp.QueryPayOrderWebRspBo;
import com.tydic.payment.pay.web.service.QueryPayOrderOfSuccAndFailWebService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="queryPayOrderOfSuccAndFailWebService")
@HSFProvider(serviceVersion="2.0.0", serviceGroup="PAYMENT_GROUP_DEV", serviceInterface=QueryPayOrderOfSuccAndFailWebService.class)
public class QueryPayOrderOfSuccAndFailWebServiceImpl
implements QueryPayOrderOfSuccAndFailWebService {
    private static final Logger LOGGER = LoggerFactory.getLogger(QueryPayOrderOfSuccAndFailWebServiceImpl.class);
    private static String SERVICE = "QueryPayOrderOfSuccAndFailWebService";
    private static String SERVICE_NAME = "\u67e5\u8be2\u652f\u4ed8\u6210\u529f\u548c\u652f\u4ed8\u5931\u8d25\u8ba2\u5355Web\u670d\u52a1";
    @Autowired
    PayOrderAtomService payOrderAtomService;
    @Autowired
    PorderPayTransAtomService porderPayTransAtomService;
    @Autowired
    OrderQueryConstructionBusiService orderQueryConstructionBusiService;
    @Autowired
    QueryPCodeInfoService queryPCodeInfoService;
    @Autowired
    PayMethodAtomService payMethodAtomService;
    @Autowired
    BusiSystemInfoAtomService busiSystemInfoAtomService;
    @Autowired
    QueryCodeListByTypecodeService queryCodeListByTypecodeService;

    public RspPage<QueryPayOrderWebRspBo> qryPaySuccessAndFail(QueryPayOrderOfSuccAndFailWebReqBo reqBo) {
        LOGGER.info("\u67e5\u8be2\u652f\u4ed8\u8ba2\u5355\u5217\u8868\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + JSON.toJSONString((Object)reqBo));
        this.validateArg(reqBo);
        RspPage retBo = new RspPage();
        ArrayList<QueryPayOrderWebRspBo> rspList = new ArrayList<QueryPayOrderWebRspBo>();
        retBo.setRows(rspList);
        HashSet<Long> orderIdList = new HashSet<Long>();
        if (!StringUtils.isEmpty((Object)reqBo.getOutOrderId())) {
            OrderQueryConstructionReqBo queryConReqBo = new OrderQueryConstructionReqBo();
            queryConReqBo.setOutOrderId(reqBo.getOutOrderId());
            OrderQueryConstructionRspBo queryConRspBo = this.orderQueryConstructionBusiService.queryConstructionByOutOrderId(queryConReqBo);
            if (queryConRspBo.getOrderId() == null) {
                LOGGER.info(SERVICE_NAME + SERVICE + " -> \u672a\u67e5\u8be2\u5230\u5916\u90e8\u8ba2\u5355\u53f7\u5173\u8054\u7684\u8ba2\u5355\u53f7");
                retBo.setRecordsTotal(0);
                retBo.setTotal(0);
                retBo.setPageNo(1);
                return retBo;
            }
            if (!StringUtils.isEmpty((Object)reqBo.getOrderId())) {
                if (!reqBo.getOrderId().equals(queryConRspBo.getOrderId().toString())) {
                    LOGGER.info(SERVICE_NAME + SERVICE + "outOrderId" + reqBo.getOutOrderId() + "\u548corderId" + reqBo.getOrderId() + "\u4e0d\u662f\u540c\u4e00\u7b14\u8ba2\u5355");
                    retBo.setTotal(0);
                    retBo.setRecordsTotal(0);
                    retBo.setPageNo(1);
                    return retBo;
                }
            } else {
                reqBo.setOrderId(queryConRspBo.getOrderId().toString());
            }
        }
        PorderPayTransPo qryPorderPayTransPo = new PorderPayTransPo();
        if (!StringUtils.isEmpty((Object)reqBo.getPayMethod())) {
            qryPorderPayTransPo.setPayMethod(Long.parseLong(reqBo.getPayMethod()));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getOrderId())) {
            qryPorderPayTransPo.setOrderId(Long.parseLong(reqBo.getOrderId()));
        }
        HashSet<String> orderStatusSet = new HashSet<String>();
        if (StringUtils.isEmpty((Object)reqBo.getOrderStatus())) {
            orderStatusSet.add("A10");
            orderStatusSet.add("A20");
        } else {
            orderStatusSet.add(reqBo.getOrderStatus());
        }
        List<PorderPayTransPo> payTransPoList = this.porderPayTransAtomService.queryOrderPayTransByOrderStatusSetCondition(qryPorderPayTransPo, orderStatusSet);
        if (CollectionUtils.isEmpty(payTransPoList)) {
            LOGGER.info(SERVICE_NAME + SERVICE + " -> \u67e5\u8be2p_order_pay_trans\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u7684\u8ba2\u5355");
            retBo.setRecordsTotal(0);
            retBo.setTotal(0);
            retBo.setPageNo(1);
            return retBo;
        }
        for (PorderPayTransPo transPo : payTransPoList) {
            if (orderIdList.contains(transPo.getOrderId())) continue;
            orderIdList.add(transPo.getOrderId());
        }
        PorderPageReqPO porderPo = new PorderPageReqPO();
        Date dateEnd = null;
        Long payFeeLess = null;
        Long payFeeMore = null;
        this.setQueryItemWithPOrderPayTrans(reqBo, porderPo);
        if (!StringUtils.isEmpty((Object)reqBo.getDateEnd())) {
            dateEnd = new DateTime((Object)reqBo.getDateEnd()).plusDays(1).withMillisOfDay(0).toDate();
        }
        try {
            if (!StringUtils.isEmpty((Object)reqBo.getPayFeeLess())) {
                payFeeLess = MoneyUtils.fenToHaoToLong((BigDecimal)new BigDecimal(reqBo.getPayFeeLess()));
            }
            if (!StringUtils.isEmpty((Object)reqBo.getPayFeeMore())) {
                payFeeMore = MoneyUtils.fenToHaoToLong((BigDecimal)new BigDecimal(reqBo.getPayFeeMore()));
            }
        }
        catch (Exception e) {
            LOGGER.error("BigDecimal2Long\u6570\u636e\u8f6c\u6362\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
        }
        Page page = null;
        if (reqBo.getPageNo() > 1) {
            page = new Page(reqBo.getPageNo(), reqBo.getPageSize());
        } else {
            page = new Page();
            BeanUtils.copyProperties((Object)reqBo, (Object)page);
            if (page.getPageNo() < 1) {
                page.setPageNo(1);
            }
            if (page.getPageSize() < 1) {
                page.setPageSize(10);
            }
        }
        List<PorderPo> porderPoList = this.payOrderAtomService.queryPorderByCondition((Page<PorderPageReqPO>)page, porderPo, dateEnd, payFeeLess, payFeeMore, orderIdList);
        this.generateRspList(porderPoList, rspList, reqBo);
        retBo.setPageNo(page.getPageNo());
        retBo.setRecordsTotal(page.getTotalCount());
        retBo.setTotal(page.getTotalPages());
        LOGGER.info("\u67e5\u8be2\u652f\u4ed8\u8ba2\u5355\u5217\u8868\u4e1a\u52a1\u670d\u52a1\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)retBo));
        return retBo;
    }

    private void setQueryItemWithPOrderPayTrans(QueryPayOrderOfSuccAndFailWebReqBo reqBo, PorderPageReqPO qryPorderPayTransPo) {
        if (!StringUtils.isEmpty((Object)reqBo.getBusiId())) {
            qryPorderPayTransPo.setBusiId(Long.parseLong(reqBo.getBusiId()));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getMerchantId())) {
            qryPorderPayTransPo.setMerchantId(Long.parseLong(reqBo.getMerchantId()));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getDateBegin())) {
            qryPorderPayTransPo.setCreateTime(new DateTime((Object)reqBo.getDateBegin()).withMillisOfDay(0).toDate());
        }
    }

    private void generateRspList(List<PorderPo> porderPoList, List<QueryPayOrderWebRspBo> rspList, QueryPayOrderOfSuccAndFailWebReqBo reqBo) {
        HashMap<String, PCodeListBoStr> orderStatusMap = new HashMap<String, PCodeListBoStr>();
        QueryCodeListByTypecodeReqBo qryPCodeBo = new QueryCodeListByTypecodeReqBo();
        qryPCodeBo.setTypeCode("P_ORDER_ORDER_STATUS");
        QueryCodeListByTypecodeRspBo qryPCodeRsp = this.queryCodeListByTypecodeService.queryPCodeListMethod(qryPCodeBo);
        if (qryPCodeRsp.getRspCode().equals("0000")) {
            List pCodeL = qryPCodeRsp.getCodeList();
            for (PCodeListBoStr temp : pCodeL) {
                orderStatusMap.put(temp.getCodeValue(), temp);
            }
        } else {
            LOGGER.info("\u914d\u7f6e\u6570\u636e\u5b57\u5178\u9519\u8bef\uff0c\u8bf7\u91cd\u65b0\u914d\u7f6e\u6570\u636e\u5b57\u5178\u6570\u636e\uff0c\u5173\u4e8eP_ORDER_ORDER_STATUS");
        }
        HashMap<String, PCodeListBoStr> orderTypeMap = new HashMap<String, PCodeListBoStr>();
        QueryCodeListByTypecodeReqBo qryPCodeBo2 = new QueryCodeListByTypecodeReqBo();
        qryPCodeBo2.setTypeCode("P_ORDER_ORDER_TYPE");
        QueryCodeListByTypecodeRspBo qryPCodeRsp2 = this.queryCodeListByTypecodeService.queryPCodeListMethod(qryPCodeBo2);
        if (qryPCodeRsp2.getRspCode().equals("0000")) {
            List pCodeL = qryPCodeRsp2.getCodeList();
            for (PCodeListBoStr temp : pCodeL) {
                orderTypeMap.put(temp.getCodeValue(), temp);
            }
        } else {
            LOGGER.info("\u914d\u7f6e\u6570\u636e\u5b57\u5178\u9519\u8bef\uff0c\u8bf7\u91cd\u65b0\u914d\u7f6e\u6570\u636e\u5b57\u5178\u6570\u636e\uff0cP_ORDER_ORDER_TYPE");
        }
        for (PorderPo po : porderPoList) {
            QueryPayOrderWebRspBo tempBo = new QueryPayOrderWebRspBo();
            tempBo.setCreateTime(po.getCreateTime() == null ? "" : new DateTime((Object)po.getCreateTime()).toString("yyyy-MM-dd HH:mm:ss"));
            PorderPayTransPo transPo = new PorderPayTransPo();
            transPo.setOrderId(po.getOrderId());
            List<PorderPayTransPo> transPos = this.porderPayTransAtomService.queryOrderPayTrans(transPo);
            if (!transPos.isEmpty()) {
                tempBo.setPayMethod("" + transPos.get(0).getPayMethod());
                tempBo.setOrderStatus(transPos.get(0).getOrderStatus());
            } else {
                tempBo.setPayMethod(StringUtils.isEmpty((Object)reqBo.getPayMethod()) ? "" : reqBo.getPayMethod());
                tempBo.setOrderStatus(StringUtils.isEmpty((Object)po.getOrderStatus()) ? "" : po.getOrderStatus());
            }
            if (!StringUtils.isEmpty((Object)tempBo.getPayMethod())) {
                PayMethodPo methodPo = new PayMethodPo();
                methodPo.setPayMethod(Long.parseLong(tempBo.getPayMethod()));
                List<PayMethodPo> payMethodPos = this.payMethodAtomService.queryPayMethod(methodPo);
                if (!payMethodPos.isEmpty()) {
                    tempBo.setPayMethod(payMethodPos.get(0).getPayMethodName());
                }
            }
            if (!StringUtils.isEmpty((Object)po.getOrderStatus())) {
                tempBo.setOrderStatus(orderStatusMap.get(po.getOrderStatus()) == null ? po.getOrderStatus() : ((PCodeListBoStr)orderStatusMap.get(po.getOrderStatus())).getCodeName());
            }
            tempBo.setOrderId(po.getOrderId() == null ? "" : po.getOrderId().toString());
            tempBo.setOutOrderId(StringUtils.isEmpty((Object)po.getOutOrderId()) ? "" : po.getOutOrderId());
            tempBo.setMerchantId(po.getMerchantId() == null ? "" : po.getMerchantId().toString());
            tempBo.setMerchantName(StringUtils.isEmpty((Object)po.getMerchantName()) ? "" : po.getMerchantName());
            if (po.getBusiId() == null) {
                tempBo.setBusiId("");
            } else {
                BusiSystemInfoPO busiSystemInfoPO = new BusiSystemInfoPO();
                busiSystemInfoPO.setBusiId(po.getBusiId());
                List<BusiSystemInfoPO> busiSystemInfoPOS = this.busiSystemInfoAtomService.queryBusiSystemInfoByCondition(busiSystemInfoPO);
                if (!busiSystemInfoPOS.isEmpty()) {
                    tempBo.setBusiId(busiSystemInfoPOS.get(0).getBusiName());
                }
            }
            try {
                if (po.getTotalFee() == null) {
                    tempBo.setTotalFee("");
                } else {
                    BigDecimal totalFee = MoneyUtils.haoToFen((String)po.getTotalFee().toString());
                    tempBo.setTotalFee(totalFee.toPlainString());
                }
                if (po.getRealFee() == null) {
                    tempBo.setRealFee("");
                } else {
                    BigDecimal realFee = MoneyUtils.haoToFen((String)po.getRealFee().toString());
                    tempBo.setRealFee(realFee.toPlainString());
                }
            }
            catch (Exception e) {
                LOGGER.error("Long2BigDecimal\u6570\u636e\u8f6c\u6362\u9519\u8bef:" + e.getMessage(), (Throwable)e);
            }
            if (!StringUtils.isEmpty((Object)po.getOrderType())) {
                tempBo.setOrderType(orderTypeMap.get(po.getOrderType()) == null ? po.getOrderType() : ((PCodeListBoStr)orderTypeMap.get(po.getOrderType())).getCodeName());
            }
            rspList.add(tempBo);
        }
    }

    private void validateArg(QueryPayOrderOfSuccAndFailWebReqBo reqBo) {
        if (reqBo == null) {
            reqBo = new QueryPayOrderOfSuccAndFailWebReqBo();
        }
    }
}

