/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.bill.util;

import com.thoughtworks.xstream.io.StreamException;
import com.tydic.payment.bill.util.DownloadBillReqData;
import com.tydic.payment.bill.util.DownloadBillResData;
import com.tydic.payment.pay.wx.util.HttpsRequest;
import com.tydic.payment.pay.wx.util.Util;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WXPayUtil {
    private static final Logger logger = LoggerFactory.getLogger(WXPayUtil.class);

    private static String getIpAddress() {
        try {
            Enumeration<NetworkInterface> allNetInterfaces = NetworkInterface.getNetworkInterfaces();
            InetAddress ip = null;
            while (allNetInterfaces.hasMoreElements()) {
                NetworkInterface netInterface = allNetInterfaces.nextElement();
                Enumeration<InetAddress> addresses = netInterface.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    ip = addresses.nextElement();
                    if (ip == null || !(ip instanceof Inet4Address)) continue;
                    return ip.getHostAddress();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "127.0.0.1";
    }

    public static String doDownloadBillBusiness(DownloadBillReqData downloadBillReqData, String downLoadUrl) throws Exception {
        String rspStr = "";
        HttpsRequest httpsRequest = new HttpsRequest();
        String resultString = httpsRequest.sendPost(downLoadUrl, (Object)downloadBillReqData);
        logger.debug("---------\u8bf7\u6c42\u8fd4\u56de\u7ed3\u679c----------");
        logger.debug(resultString);
        try {
            DownloadBillResData resData = (DownloadBillResData)Util.getObjectFromXMLGeneric((String)resultString, DownloadBillResData.class);
            if (resData == null || resData.getReturn_code() == null) {
                throw new Exception("\u83b7\u53d6\u4e0d\u5230\u8fd4\u56de\u4fe1\u606f");
            }
            if ("FAIL".equals(resData.getReturn_code())) {
                if ("No Bill Exist".equals(resData.getReturn_msg())) {
                    logger.debug("\u8d26\u5355\u4e0d\u5b58\u5728\uff1a" + resData.getReturn_msg());
                    logger.debug("\u8fd4\u56de\u5fae\u4fe1\u652f\u4ed8\u9ed8\u8ba4\u7a7a\u8d26\u5355\u6587\u4ef6");
                    return WXPayUtil.getEmptyFileString();
                }
                throw new Exception(resData.getReturn_msg());
            }
        }
        catch (StreamException e) {
            rspStr = resultString;
        }
        return rspStr;
    }

    private static String getEmptyFileString() {
        StringBuilder file = new StringBuilder(512);
        file.append("\u4ea4\u6613\u65f6\u95f4,\u516c\u4f17\u8d26\u53f7ID,\u5546\u6237\u53f7,\u5b50\u5546\u6237\u53f7,\u8bbe\u5907\u53f7,\u5fae\u4fe1\u8ba2\u5355\u53f7,\u5546\u6237\u8ba2\u5355\u53f7,\u7528\u6237\u6807\u8bc6,\u4ea4\u6613\u7c7b\u578b,\u4ea4\u6613\u72b6\u6001,\u4ed8\u6b3e\u94f6\u884c,\u8d27\u5e01\u79cd\u7c7b,\u603b\u91d1\u989d,\u4f01\u4e1a\u7ea2\u5305\u91d1\u989d,\u5fae\u4fe1\u9000\u6b3e\u5355\u53f7,\u5546\u6237\u9000\u6b3e\u5355\u53f7,\u9000\u6b3e\u91d1\u989d,\u4f01\u4e1a\u7ea2\u5305\u9000\u6b3e\u91d1\u989d,\u9000\u6b3e\u7c7b\u578b,\u9000\u6b3e\u72b6\u6001,\u5546\u54c1\u540d\u79f0,\u5546\u6237\u6570\u636e\u5305,\u624b\u7eed\u8d39,\u8d39\u7387\n");
        file.append("\u603b\u4ea4\u6613\u5355\u6570,\u603b\u4ea4\u6613\u989d,\u603b\u9000\u6b3e\u91d1\u989d,\u603b\u4f01\u4e1a\u7ea2\u5305\u9000\u6b3e\u91d1\u989d,\u624b\u7eed\u8d39\u603b\u91d1\u989d\n");
        file.append("`0,`0.00,`0.00,`0.00,`0.00000");
        return file.toString();
    }
}

