/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.ability.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSON;
import com.tydic.payment.pay.ability.PayProOneCodePayProcessRequestAbilityService;
import com.tydic.payment.pay.ability.bo.PayProOneCodePayProcessRequestAbilityServiceReqBo;
import com.tydic.payment.pay.ability.bo.PayProOneCodePayProcessRequestAbilityServiceRspBo;
import com.tydic.payment.pay.comb.PayProOneCodePayCombService;
import com.tydic.payment.pay.comb.bo.PayProOneCodePayCombReqBo;
import com.tydic.payment.pay.comb.bo.PayProOneCodePayCombRspBo;
import com.tydic.payment.pay.config.vo.PayPropertiesVo;
import com.tydic.payment.pay.exception.BusinessException;
import java.net.URLEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

@HSFProvider(serviceVersion="2.0.0", serviceGroup="PAYMENT_GROUP_DEV", serviceInterface=PayProOneCodePayProcessRequestAbilityService.class)
public class PayProOneCodePayProcessRequestAbilityServiceImpl
implements PayProOneCodePayProcessRequestAbilityService {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private PayProOneCodePayCombService payProOneCodePayCombService;
    @Autowired
    private PayPropertiesVo payPropertiesVo;

    public PayProOneCodePayProcessRequestAbilityServiceRspBo processRequest(PayProOneCodePayProcessRequestAbilityServiceReqBo reqBo) {
        this.LOGGER.info("\u4e00\u7801\u4ed8\u8bf7\u6c42\u5904\u7406ability\u670d\u52a1:" + reqBo);
        PayProOneCodePayProcessRequestAbilityServiceRspBo retBo = new PayProOneCodePayProcessRequestAbilityServiceRspBo();
        String redirectUrl = "";
        String basePathStr = this.payPropertiesVo.getValueByKey("pay.one.code.pay.context.path");
        if (StringUtils.isEmpty((Object)basePathStr)) {
            this.LOGGER.error("\u4e00\u7801\u4ed8basePath\u672a\u914d\u7f6e\uff0c\u8bf7\u914d\u7f6e'pay.one.code.pay.context.path'");
            throw new BusinessException("218002", "\u4e00\u7801\u4ed8basePath\u5730\u5740\u672a\u914d\u7f6e\uff1a'pay.one.code.pay.context.path'");
        }
        String oneCodePayHtml = this.payPropertiesVo.getValueByKey("pay.one.code.pay.html");
        if (StringUtils.isEmpty((Object)oneCodePayHtml)) {
            this.LOGGER.error("\u4e00\u7801\u4ed8\u652f\u4ed8\u9875\u9762\u5730\u5740\uff08pay.one.code.pay.html\uff09\u672a\u914d\u7f6e");
            throw new BusinessException("218002", "\u4e00\u7801\u4ed8\u652f\u4ed8\u9875\u9762\u5730\u5740\uff08pay.one.code.pay.html\uff09\u672a\u914d\u7f6e");
        }
        StringBuffer basePath = new StringBuffer(basePathStr);
        BeanUtils.copyProperties((Object)reqBo, (Object)retBo);
        String validateStr = this.validateArgs(reqBo);
        if (!StringUtils.isEmpty((Object)validateStr)) {
            this.LOGGER.error("\u4e00\u7801\u4ed8ability\u670d\u52a1\uff0c\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            retBo.setRspCode("214022");
            retBo.setRspName("\u4e00\u7801\u4ed8ability\u670d\u52a1\uff0c\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            String respInfo = this.urlEncode(retBo);
            redirectUrl = basePath.append("/").append(oneCodePayHtml).append("?respInfo=").append(respInfo).toString();
            retBo.setRedirectUrl(redirectUrl);
            return retBo;
        }
        PayProOneCodePayCombReqBo combReqBo = new PayProOneCodePayCombReqBo();
        BeanUtils.copyProperties((Object)reqBo, (Object)combReqBo);
        combReqBo.setBasePath(basePath);
        PayProOneCodePayCombRspBo combRetBo = this.payProOneCodePayCombService.dealOneCodePay(combReqBo);
        if (!"0000".equals(combRetBo.getRspCode())) {
            this.LOGGER.error("\u8c03\u7528comb\u670d\u52a1\u5904\u7406\u4e00\u7801\u4ed8\u5931\u8d25\uff1a" + combRetBo.getRspName());
            retBo.setRspCode("214022");
            retBo.setRspName(combRetBo.getRspName());
            retBo.setDetailName(combRetBo.getDetailName());
            String respInfo = this.urlEncode(retBo);
            redirectUrl = basePath.append("/").append(oneCodePayHtml).append("?respInfo=").append(respInfo).toString();
            retBo.setRedirectUrl(redirectUrl);
            return retBo;
        }
        BeanUtils.copyProperties((Object)combRetBo, (Object)retBo);
        this.LOGGER.info("\u8df3\u8f6c\u5730\u5740\u4e3a\uff1a" + combRetBo.getJumpUrl());
        retBo.setRedirectUrl(combRetBo.getJumpUrl());
        return retBo;
    }

    private String validateArgs(PayProOneCodePayProcessRequestAbilityServiceReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getOrderId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'orderId'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getTotalFee())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'totalFee'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getUserAgent())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'userAgent'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }

    private String urlEncode(PayProOneCodePayProcessRequestAbilityServiceRspBo retBo) {
        try {
            return URLEncoder.encode(JSON.toJSONString((Object)retBo), "UTF-8");
        }
        catch (Exception e) {
            this.LOGGER.error("\u5bf9\u6570\u636e\u8fdb\u884cURLEncode\u7684\u65f6\u5019\u53d1\u751f\u5f02\u5e38\uff1a" + e);
            return "\u5bf9\u6570\u636e\u8fdb\u884cURLEncode\u7684\u65f6\u5019\u53d1\u751f\u5f02\u5e38";
        }
    }
}

