/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.ability.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSON;
import com.tydic.payment.pay.ability.PayProTransPayInsAbilityService;
import com.tydic.payment.pay.ability.bo.PayProPayMethodDataBo;
import com.tydic.payment.pay.ability.bo.PayProPaymentInsDataBo;
import com.tydic.payment.pay.ability.bo.PayProTransPayInsReqBo;
import com.tydic.payment.pay.ability.bo.PayProTransPayInsRspBo;
import com.tydic.payment.pay.ability.impl.PayProUniPayAbilityServiceImpl;
import com.tydic.payment.pay.dao.PayMethodMapper;
import com.tydic.payment.pay.dao.PaymentInsMapper;
import com.tydic.payment.pay.dao.po.PayMethodPo;
import com.tydic.payment.pay.dao.po.PaymentInsPo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@HSFProvider(serviceVersion="2.0.0", serviceGroup="PAYMENT_GROUP_DEV", serviceInterface=PayProTransPayInsAbilityService.class)
public class PayProTransPayInsAbilityServiceImpl
implements PayProTransPayInsAbilityService {
    private static final Logger LOG = LoggerFactory.getLogger(PayProUniPayAbilityServiceImpl.class);
    @Autowired
    private PaymentInsMapper paymentInsMapper;
    @Autowired
    private PayMethodMapper payMethodMapper;

    public PayProTransPayInsRspBo tranPayIns(PayProTransPayInsReqBo reqBo) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("\u652f\u4ed8\u673a\u6784\u53ca\u652f\u4ed8\u65b9\u5f0f\u7ffb\u8bd1\u5165\u53c2\uff1a" + JSON.toJSONString((Object)reqBo));
        }
        PayProTransPayInsRspBo rspBo = new PayProTransPayInsRspBo();
        String validateArgStr = this.validateArg(reqBo);
        if (!StringUtils.isEmpty((Object)validateArgStr)) {
            rspBo.setRespCode("212003");
            rspBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateArgStr);
            return rspBo;
        }
        ArrayList<PayProPaymentInsDataBo> payProPaymentInsDataBoList = new ArrayList<PayProPaymentInsDataBo>();
        List paymentInsIds = reqBo.getPaymentInsId();
        for (Long paymentInsId : paymentInsIds) {
            PaymentInsPo payMethodInsPo = new PaymentInsPo();
            payMethodInsPo.setPaymentInsId(paymentInsId);
            List<PaymentInsPo> paymentInsPoList = this.paymentInsMapper.queryPaymentInf(payMethodInsPo);
            if (paymentInsPoList.isEmpty()) {
                LOG.error("P_INFO_PAYMENT_INS\u8868\u4e2d\u65e0\u5bf9\u5e94ID\u7684\u652f\u4ed8\u673a\u6784\uff0cID\uff1a" + paymentInsId);
                rspBo.setRespCode("212054");
                rspBo.setRespDesc("\u652f\u4ed8\u673a\u6784\u8868\u4e2d\u65e0\u5bf9\u5e94ID\u7684\u652f\u4ed8\u673a\u6784\uff0cID\uff1a" + paymentInsId);
                return rspBo;
            }
            LOG.info("\u6839\u636e\u652f\u4ed8\u673a\u6784ID\u67e5\u8be2\u51fa\u7684\u652f\u4ed8\u673a\u6784\u4fe1\u606f\uff1a", paymentInsPoList);
            PaymentInsPo paymentInsPo = paymentInsPoList.get(0);
            PayProPaymentInsDataBo payProPaymentInsDataBo = new PayProPaymentInsDataBo();
            payProPaymentInsDataBo.setPaymentInsId(paymentInsId);
            payProPaymentInsDataBo.setPaymentInsName(paymentInsPo.getPaymentInsName());
            ArrayList<PayProPayMethodDataBo> payProPayMethodDataBoList = new ArrayList<PayProPayMethodDataBo>();
            PayMethodPo payMethodPo = new PayMethodPo();
            payMethodPo.setPaymentInsId(paymentInsId);
            List<PayMethodPo> payMethodPoList = this.payMethodMapper.queryPayMethod(payMethodPo);
            if (payMethodPoList.isEmpty()) {
                LOG.error("P_CODE_PAY_METHOD\u8868\u4e2d\u65e0\u5bf9\u5e94\u652f\u4ed8\u673a\u6784\u7684\u914d\u7f6e\uff0c\u5bf9\u5e94\u652f\u4ed8\u673a\u6784ID\u4e3a\uff1a", (Object)paymentInsId);
                rspBo.setRespCode("214027");
                rspBo.setRespDesc("\u652f\u4ed8\u65b9\u5f0f\u914d\u7f6e\u8868\u4e2d\u65e0\u5bf9\u5e94\u652f\u4ed8\u673a\u6784\u7684\u914d\u7f6e\uff0c\u652f\u4ed8\u673a\u6784ID\uff1a" + paymentInsId);
                return rspBo;
            }
            LOG.info("\u6839\u636e\u652f\u4ed8\u673a\u6784ID\u67e5\u8be2\u51fa\u7684\u652f\u4ed8\u65b9\u5f0f\u4fe1\u606f\uff1a", payMethodPoList);
            for (PayMethodPo payMethodPO : payMethodPoList) {
                PayProPayMethodDataBo payProPayMethodDataBo = new PayProPayMethodDataBo();
                payProPayMethodDataBo.setPayMethod(String.valueOf(payMethodPO.getPayMethod()));
                payProPayMethodDataBo.setPayMethodName(payMethodPO.getPayMethodName());
                payProPayMethodDataBo.setPayMethodStatus(payMethodPO.getPayMethodStatus());
                payProPayMethodDataBoList.add(payProPayMethodDataBo);
            }
            payProPaymentInsDataBo.setPayMethodList(payProPayMethodDataBoList);
            payProPaymentInsDataBoList.add(payProPaymentInsDataBo);
        }
        rspBo.setPaymentInsList(payProPaymentInsDataBoList);
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("SUCCESS");
        return rspBo;
    }

    private String validateArg(PayProTransPayInsReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (CollectionUtils.isEmpty((Collection)reqBo.getPaymentInsId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027PaymentInsId\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }
}

