/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.ali.service.impl;

import com.alipay.api.AlipayClient;
import com.alipay.api.AlipayRequest;
import com.alipay.api.DefaultAlipayClient;
import com.alipay.api.request.MonitorHeartbeatSynRequest;
import com.alipay.api.response.MonitorHeartbeatSynResponse;
import com.tydic.payment.pay.ali.common.Configs;
import com.tydic.payment.pay.ali.model.AlipayHeartbeatSynRequestBuilder;
import com.tydic.payment.pay.ali.service.AlipayMonitorService;
import com.tydic.payment.pay.ali.service.impl.AbsAlipayService;
import org.apache.commons.lang.StringUtils;

public class AlipayMonitorServiceImpl
extends AbsAlipayService
implements AlipayMonitorService {
    private AlipayClient client;

    public AlipayMonitorServiceImpl(ClientBuilder builder) {
        if (StringUtils.isEmpty((String)builder.getGatewayUrl())) {
            throw new NullPointerException("gatewayUrl should not be NULL!");
        }
        if (StringUtils.isEmpty((String)builder.getAppid())) {
            throw new NullPointerException("appid should not be NULL!");
        }
        if (StringUtils.isEmpty((String)builder.getPrivateKey())) {
            throw new NullPointerException("privateKey should not be NULL!");
        }
        if (StringUtils.isEmpty((String)builder.getFormat())) {
            throw new NullPointerException("format should not be NULL!");
        }
        if (StringUtils.isEmpty((String)builder.getCharset())) {
            throw new NullPointerException("charset should not be NULL!");
        }
        if (StringUtils.isEmpty((String)builder.getSignType())) {
            throw new NullPointerException("signType should not be NULL!");
        }
        this.client = new DefaultAlipayClient(builder.getGatewayUrl(), builder.getAppid(), builder.getPrivateKey(), builder.getFormat(), builder.getCharset(), builder.getSignType());
    }

    @Override
    public MonitorHeartbeatSynResponse heartbeatSyn(AlipayHeartbeatSynRequestBuilder builder) {
        this.validateBuilder(builder);
        MonitorHeartbeatSynRequest request = new MonitorHeartbeatSynRequest();
        request.putOtherTextParam("app_auth_token", builder.getAppAuthToken());
        request.setBizContent(builder.toJsonString());
        this.log.info((Object)("heartbeat.sync bizContent:" + request.getBizContent()));
        return (MonitorHeartbeatSynResponse)this.getResponse(this.client, (AlipayRequest)request);
    }

    public static class ClientBuilder {
        private String gatewayUrl;
        private String appid;
        private String privateKey;
        private String format;
        private String charset;
        private String signType;

        public AlipayMonitorServiceImpl build() {
            if (StringUtils.isEmpty((String)this.gatewayUrl)) {
                this.gatewayUrl = Configs.getMcloudApiDomain();
            }
            if (StringUtils.isEmpty((String)this.appid)) {
                this.appid = Configs.getAppid();
            }
            if (StringUtils.isEmpty((String)this.privateKey)) {
                this.privateKey = Configs.getPrivateKey();
            }
            if (StringUtils.isEmpty((String)this.format)) {
                this.format = "json";
            }
            if (StringUtils.isEmpty((String)this.charset)) {
                this.charset = "utf-8";
            }
            if (StringUtils.isEmpty((String)this.signType)) {
                this.signType = Configs.getSignType();
            }
            return new AlipayMonitorServiceImpl(this);
        }

        public AlipayMonitorServiceImpl build(String appid, String privateKey) {
            if (StringUtils.isEmpty((String)this.gatewayUrl)) {
                this.gatewayUrl = Configs.getMcloudApiDomain();
            }
            this.appid = appid;
            this.privateKey = privateKey;
            if (StringUtils.isEmpty((String)this.format)) {
                this.format = "json";
            }
            if (StringUtils.isEmpty((String)this.charset)) {
                this.charset = "utf-8";
            }
            if (StringUtils.isEmpty((String)this.signType)) {
                this.signType = Configs.getSignType();
            }
            return new AlipayMonitorServiceImpl(this);
        }

        public ClientBuilder setAppid(String appid) {
            this.appid = appid;
            return this;
        }

        public ClientBuilder setCharset(String charset) {
            this.charset = charset;
            return this;
        }

        public ClientBuilder setFormat(String format) {
            this.format = format;
            return this;
        }

        public ClientBuilder setGatewayUrl(String gatewayUrl) {
            this.gatewayUrl = gatewayUrl;
            return this;
        }

        public ClientBuilder setPrivateKey(String privateKey) {
            this.privateKey = privateKey;
            return this;
        }

        public ClientBuilder setSignType(String signType) {
            this.signType = signType;
            return this;
        }

        public String getAppid() {
            return this.appid;
        }

        public String getCharset() {
            return this.charset;
        }

        public String getFormat() {
            return this.format;
        }

        public String getGatewayUrl() {
            return this.gatewayUrl;
        }

        public String getPrivateKey() {
            return this.privateKey;
        }

        public String getSignType() {
            return this.signType;
        }
    }
}

