/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.busi.impl;

import com.tydic.payment.pay.busi.PayProBillSummaryBusiService;
import com.tydic.payment.pay.busi.bo.PayProBillSummaryBusiServiceReqBo;
import com.tydic.payment.pay.busi.bo.PayProBillSummaryBusiServiceRspBo;
import com.tydic.payment.pay.dao.PBillResultMapper;
import com.tydic.payment.pay.dao.PayBillDayMapper;
import com.tydic.payment.pay.dao.TransPaymentMapper;
import com.tydic.payment.pay.dao.po.PBillResultPo;
import com.tydic.payment.pay.dao.po.PayProQryBillAllResultPo;
import com.tydic.payment.pay.dao.po.PayProQryBillAllResultRspPo;
import com.tydic.payment.pay.util.PayProRspUtil;
import com.tydic.utils.generatedoc.util.ArgValidator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PayProBillSummaryBusiServiceImpl
implements PayProBillSummaryBusiService {
    @Autowired
    private PayBillDayMapper payBillDayMapper;
    @Autowired
    private TransPaymentMapper transPaymentMapper;
    @Autowired
    private PBillResultMapper pBillResultMapper;

    public PayProBillSummaryBusiServiceRspBo addSummaryResult(PayProBillSummaryBusiServiceReqBo reqBo) {
        PBillResultPo po;
        ArgValidator.validateArgWithThrow((Object)reqBo);
        PayProBillSummaryBusiServiceRspBo rspBo = PayProRspUtil.generateSucRspBo(PayProBillSummaryBusiServiceRspBo.class);
        Long billDate = reqBo.getBillDate();
        PayProQryBillAllResultPo qryPayResultPo = new PayProQryBillAllResultPo();
        qryPayResultPo.setBillDate(billDate);
        qryPayResultPo.setOrderType("01");
        List<PayProQryBillAllResultRspPo> qryPayResultRsp = this.payBillDayMapper.selectBillResult(qryPayResultPo);
        List<PayProQryBillAllResultRspPo> qryPaymentPayResultRsp = this.transPaymentMapper.selectBillResult(qryPayResultPo);
        qryPayResultPo.setOrderType("02");
        List<PayProQryBillAllResultRspPo> qryRefundResultRsp = this.payBillDayMapper.selectBillResult(qryPayResultPo);
        List<PayProQryBillAllResultRspPo> qryPaymentRefundResultRsp = this.transPaymentMapper.selectBillResult(qryPayResultPo);
        HashMap<String, PBillResultPo> dataMap = new HashMap<String, PBillResultPo>();
        for (PayProQryBillAllResultRspPo tmp : qryPayResultRsp) {
            po = this.getPo(billDate, dataMap, tmp);
            po.setPayCenterPayCount(po.getPayCenterPayCount() + (long)tmp.getTCount().intValue());
            po.setPayCenterPayFee(po.getPayCenterPayFee() + tmp.getTFee());
        }
        for (PayProQryBillAllResultRspPo tmp : qryPaymentPayResultRsp) {
            po = this.getPo(billDate, dataMap, tmp);
            po.setPaymentInsPayCount(po.getPaymentInsPayCount() + (long)tmp.getTCount().intValue());
            po.setPaymentInsPayFee(po.getPaymentInsPayFee() + tmp.getTFee());
        }
        for (PayProQryBillAllResultRspPo tmp : qryRefundResultRsp) {
            po = this.getPo(billDate, dataMap, tmp);
            po.setPayCenterRefundCount(po.getPayCenterRefundCount() + (long)tmp.getTCount().intValue());
            po.setPayCenterRefundFee(po.getPayCenterRefundFee() + tmp.getTFee());
        }
        for (PayProQryBillAllResultRspPo tmp : qryPaymentRefundResultRsp) {
            po = this.getPo(billDate, dataMap, tmp);
            po.setPaymentInsRefundCount(po.getPaymentInsRefundCount() + (long)tmp.getTCount().intValue());
            po.setPaymentInsRefundFee(po.getPaymentInsRefundFee() + tmp.getTFee());
        }
        ArrayList<PBillResultPo> dataList = new ArrayList<PBillResultPo>(dataMap.values());
        this.pBillResultMapper.insertBatch(dataList);
        return rspBo;
    }

    private PBillResultPo getPo(Long billDate, Map<String, PBillResultPo> dataMap, PayProQryBillAllResultRspPo tmp) {
        String mapKey = tmp.getPaymentInsId() + "_" + tmp.getPaymentMchId();
        PBillResultPo po = dataMap.get(mapKey);
        if (po == null) {
            po = new PBillResultPo();
            po.setBillDate(billDate);
            String billDateStr = billDate.toString();
            DateTime billDateTime = DateTime.parse((String)billDateStr, (DateTimeFormatter)DateTimeFormat.forPattern((String)"yyyyMMdd"));
            po.setBillMonth(Long.valueOf(billDateTime.toString("yyyyMM")));
            po.setPaymentIns(tmp.getPaymentInsId());
            po.setPaymentMchId(tmp.getPaymentMchId());
            po.setPayCenterPayCount(0L);
            po.setPayCenterPayFee(0L);
            po.setPayCenterRefundCount(0L);
            po.setPayCenterRefundFee(0L);
            po.setPaymentInsPayCount(0L);
            po.setPaymentInsPayFee(0L);
            po.setPaymentInsRefundCount(0L);
            po.setPaymentInsRefundFee(0L);
            dataMap.put(mapKey, po);
        }
        return po;
    }
}

