/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.payable.impl;

import com.alibaba.fastjson.JSON;
import com.alipay.api.AlipayApiException;
import com.alipay.api.AlipayObject;
import com.alipay.api.AlipayRequest;
import com.alipay.api.DefaultAlipayClient;
import com.alipay.api.domain.AlipayTradeAppPayModel;
import com.alipay.api.request.AlipayTradeAppPayRequest;
import com.alipay.api.response.AlipayTradeAppPayResponse;
import com.tydic.payment.pay.busi.bo.PayAbleDealPayReqBo;
import com.tydic.payment.pay.busi.bo.PayAbleDealPayRspBo;
import com.tydic.payment.pay.common.util.MoneyUtils;
import com.tydic.payment.pay.config.vo.PayPropertiesVo;
import com.tydic.payment.pay.constant.PayProConstants;
import com.tydic.payment.pay.payable.impl.AbstractAliPayAble;
import com.tydic.payment.pay.util.PayProRspUtil;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class AliPayAppPayAbleImpl
extends AbstractAliPayAble {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private static final String PRODUCT_CODE = "QUICK_MSECURITY_PAY";
    @Autowired
    private PayPropertiesVo payPropertiesVo;

    public Long getPayMethod() {
        return PayProConstants.PayMethod.ALI_APP.getPayMethod();
    }

    public PayAbleDealPayRspBo dealPay(PayAbleDealPayReqBo reqBo) {
        PayAbleDealPayRspBo rspBo = new PayAbleDealPayRspBo();
        String validateArgStr = this.validateReqArg(reqBo);
        if (!StringUtils.isEmpty((Object)validateArgStr)) {
            return PayProRspUtil.generateRspBo("212048", "\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateArgStr, PayAbleDealPayRspBo.class);
        }
        String serverUrl = this.payPropertiesVo.getAliOpenApiDomain();
        String aliNotifyUrl = this.payPropertiesVo.getAliNotifyUrl();
        if (StringUtils.isEmpty((Object)serverUrl)) {
            this.LOGGER.error("\u652f\u4ed8\u5b9d\u8bf7\u6c42\u5730\u5740'aliOpenApiDomain'\u672a\u914d\u7f6e");
            return PayProRspUtil.generateRspBo("212048", "\u652f\u4ed8\u5b9d\u8bf7\u6c42\u5730\u5740'aliOpenApiDomain'\u672a\u914d\u7f6e", PayAbleDealPayRspBo.class);
        }
        if (StringUtils.isEmpty((Object)aliNotifyUrl)) {
            this.LOGGER.error("\u652f\u4ed8\u5b9d\u56de\u8c03\u5730\u5740'aliNotifuUrl'\u672a\u914d\u7f6e");
            return PayProRspUtil.generateRspBo("212048", "\u652f\u4ed8\u5b9d\u56de\u8c03\u5730\u5740'aliNotifuUrl'\u672a\u914d\u7f6e", PayAbleDealPayRspBo.class);
        }
        Map paraMap = reqBo.getParaMap();
        String privateKey = (String)paraMap.get("privateKey");
        String appId = (String)paraMap.get("appid");
        String publicKey = (String)paraMap.get("publicKey");
        DefaultAlipayClient alipayClient = new DefaultAlipayClient(serverUrl, appId, privateKey, "json", "UTF-8", publicKey, "RSA2");
        AlipayTradeAppPayRequest request = new AlipayTradeAppPayRequest();
        AlipayTradeAppPayModel model = new AlipayTradeAppPayModel();
        model.setTotalAmount(MoneyUtils.fenToYuan((Long)reqBo.getPayFee()).toString());
        model.setSubject(reqBo.getDetailName());
        model.setOutTradeNo(reqBo.getPayOrderId());
        model.setProductCode(PRODUCT_CODE);
        model.setTimeoutExpress(reqBo.getExtTime() + "m");
        request.setBizModel((AlipayObject)model);
        request.setNotifyUrl(aliNotifyUrl);
        AlipayTradeAppPayResponse response = null;
        try {
            response = (AlipayTradeAppPayResponse)alipayClient.sdkExecute((AlipayRequest)request);
            this.LOGGER.info("\u652f\u4ed8\u5b9dapp\u652f\u4ed8\u8fd4\u56de\u7ed3\u679c\uff1a" + JSON.toJSONString((Object)response));
        }
        catch (AlipayApiException e) {
            this.LOGGER.error("\u8c03\u7528\u652f\u4ed8\u5b9d\u5f02\u5e38\uff1a" + e.getMessage() + "-" + e.getErrCode() + "-" + e.getErrMsg(), (Throwable)e);
            return PayProRspUtil.generateRspBo("212048", "\u8c03\u7528\u652f\u4ed8\u5b9d\u5f02\u5e38\uff1a" + e.getMessage() + "-" + e.getErrCode() + "-" + e.getErrMsg(), PayAbleDealPayRspBo.class);
        }
        if (!response.isSuccess()) {
            return PayProRspUtil.generateRspBo("212048", "\u652f\u4ed8\u5b9d\u8fd4\u56de\u9519\u8bef\uff1amsg=" + response.getMsg() + ",subMsg=" + response.getSubMsg(), PayAbleDealPayRspBo.class);
        }
        BeanUtils.copyProperties((Object)reqBo, (Object)rspBo);
        rspBo.setOrderInfoStr(response.getBody());
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private String validateReqArg(PayAbleDealPayReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getDetailName())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027detailName\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getParaMap())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'paraMap'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getPayOrderId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'payOrderId'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        Map paraMap = reqBo.getParaMap();
        String appId = (String)paraMap.get("appid");
        String publicKey = (String)paraMap.get("publicKey");
        String privateKey = (String)paraMap.get("privateKey");
        if (StringUtils.isEmpty((Object)appId)) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'paraMap'\u4e2dkey(appId)\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)privateKey)) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'paraMap'\u4e2dkey(privateKey)\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)publicKey)) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'paraMap'\u4e2dkey(publicKey)\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getExtTime())) {
            reqBo.setExtTime("3");
        }
        return null;
    }
}

