/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.service.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSON;
import com.tydic.payment.pay.atom.MerchantInfoAtomService;
import com.tydic.payment.pay.atom.PorderPayTransAtomService;
import com.tydic.payment.pay.atom.PorderRefundTransAtomService;
import com.tydic.payment.pay.common.util.MoneyUtils;
import com.tydic.payment.pay.dao.po.MerChantInfoPo;
import com.tydic.payment.pay.dao.po.PorderPayTransPo;
import com.tydic.payment.pay.dao.po.PorderPayTransStatisticResultPo;
import com.tydic.payment.pay.dao.po.PorderRefundTransPo;
import com.tydic.payment.pay.dao.po.PorderRefundTransStatisticResultPo;
import com.tydic.payment.pay.exception.BusinessException;
import com.tydic.payment.pay.web.bo.req.QueryIncomeTrendChartWebReqBo;
import com.tydic.payment.pay.web.bo.rsp.QueryIncomeTrendChartBo;
import com.tydic.payment.pay.web.bo.rsp.QueryIncomeTrendChartWebRspBo;
import com.tydic.payment.pay.web.service.QueryIncomeTrendChartWebService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@HSFProvider(serviceVersion="2.0.0", serviceGroup="PAYMENT_GROUP_DEV", serviceInterface=QueryIncomeTrendChartWebService.class)
public class QueryIncomeTrendChartWebServiceImpl
implements QueryIncomeTrendChartWebService {
    private static final Logger LOGGER = LoggerFactory.getLogger(QueryIncomeTrendChartWebServiceImpl.class);
    @Autowired
    private MerchantInfoAtomService merchantInfoAtomService;
    @Autowired
    private PorderPayTransAtomService porderPayTransAtomService;
    @Autowired
    private PorderRefundTransAtomService porderRefundTransAtomService;

    public QueryIncomeTrendChartWebRspBo queryIncomTrend(QueryIncomeTrendChartWebReqBo reqBo) {
        Date todayDate;
        LOGGER.info("\u5165\u53c2\uff1a" + JSON.toJSONString((Object)reqBo));
        this.validateArg(reqBo);
        QueryIncomeTrendChartWebRspBo rspBo = new QueryIncomeTrendChartWebRspBo();
        ArrayList<QueryIncomeTrendChartBo> dayIncomeList = new ArrayList<QueryIncomeTrendChartBo>();
        rspBo.setRspCode("0000");
        rspBo.setRspName("\u6210\u529f");
        rspBo.setDayIncome(dayIncomeList);
        MerChantInfoPo qryMerPo = new MerChantInfoPo();
        qryMerPo.setCreateOperId(reqBo.getOperId());
        List<MerChantInfoPo> qryMerL = this.merchantInfoAtomService.queryMerChantIdAndNameByCondition(qryMerPo);
        if (CollectionUtils.isEmpty(qryMerL)) {
            LOGGER.info("\u8be5\u5de5\u53f7\u7684\u5546\u6237\u5217\u8868\u4e3a\u7a7a");
            return rspBo;
        }
        HashSet<Long> merchantIdSet = new HashSet<Long>();
        for (MerChantInfoPo temp : qryMerL) {
            if (merchantIdSet.contains(temp.getMerchantId())) continue;
            merchantIdSet.add(temp.getMerchantId());
        }
        PorderPayTransPo qryPorderPayTranasPo = new PorderPayTransPo();
        PorderRefundTransPo qryRefundPBo = new PorderRefundTransPo();
        if (!StringUtils.isEmpty((Object)reqBo.getTotalDays())) {
            todayDate = new DateTime().withMillisOfDay(0).toDate();
            Integer totalDaysI = Integer.valueOf(reqBo.getTotalDays());
            qryPorderPayTranasPo.setCreateTime(new DateTime((Object)todayDate).minusDays(totalDaysI.intValue()).withMillisOfDay(0).toDate());
            qryPorderPayTranasPo.setCreateTimeEnd(todayDate);
            qryRefundPBo.setCreateTime(new DateTime((Object)todayDate).minusDays(totalDaysI.intValue()).withMillisOfDay(0).toDate());
            qryRefundPBo.setCreateTimeEnd(todayDate);
        } else {
            todayDate = new DateTime().withMillisOfDay(0).toDate();
            qryPorderPayTranasPo.setCreateTime(new DateTime((Object)todayDate).minusDays(30).withMillisOfDay(0).toDate());
            qryPorderPayTranasPo.setCreateTimeEnd(todayDate);
            qryRefundPBo.setCreateTime(new DateTime((Object)todayDate).minusDays(30).withMillisOfDay(0).toDate());
            qryRefundPBo.setCreateTimeEnd(todayDate);
        }
        qryPorderPayTranasPo.setOrderStatus("A10");
        qryRefundPBo.setOrderStatus("B10");
        List<PorderPayTransStatisticResultPo> payTransAtomList = this.porderPayTransAtomService.countIncomeOfMerchants(qryPorderPayTranasPo, merchantIdSet);
        List<PorderRefundTransStatisticResultPo> porderRefundTransAtomList = this.porderRefundTransAtomService.countIncomeOfMerchants(qryRefundPBo, merchantIdSet);
        if (CollectionUtils.isEmpty(payTransAtomList) && CollectionUtils.isEmpty(porderRefundTransAtomList)) {
            LOGGER.info("\u672a\u67e5\u8be2\u5230\u8ba2\u5355\u5b58\u5728\uff1a\u5165\u53c2" + JSON.toJSONString((Object)reqBo));
            return rspBo;
        }
        this.generateRspBo(reqBo.getTotalDays(), payTransAtomList, porderRefundTransAtomList, dayIncomeList);
        return rspBo;
    }

    private void generateRspBo(String totalDays, List<PorderPayTransStatisticResultPo> payTransAtomList, List<PorderRefundTransStatisticResultPo> porderRefundTransAtomList, List<QueryIncomeTrendChartBo> incomeList) {
        try {
            HashMap<String, PorderPayTransStatisticResultPo> payTransMap = new HashMap<String, PorderPayTransStatisticResultPo>();
            for (PorderPayTransStatisticResultPo porderPayTransStatisticResultPo : payTransAtomList) {
                if (StringUtils.isEmpty((Object)porderPayTransStatisticResultPo.getOneDate())) continue;
                payTransMap.put(porderPayTransStatisticResultPo.getOneDate(), porderPayTransStatisticResultPo);
            }
            HashMap<String, PorderRefundTransStatisticResultPo> refundTransMap = new HashMap<String, PorderRefundTransStatisticResultPo>();
            for (PorderRefundTransStatisticResultPo refundTransT : porderRefundTransAtomList) {
                if (StringUtils.isEmpty((Object)refundTransT.getOneDate())) continue;
                refundTransMap.put(refundTransT.getOneDate(), refundTransT);
            }
            String string = new DateTime().withMillisOfDay(0).toString("yyyyMMdd");
            long todayDateLong = Long.valueOf(string);
            int totalDaysI = Integer.valueOf(totalDays);
            for (int i = 1; i < totalDaysI + 1; ++i) {
                String someDayStr = new DateTime().minusDays(i).withMillisOfDay(0).toString("yyyyMMdd");
                long someDay = Long.valueOf(someDayStr);
                Long totalIncomeFeeLong = new Long("0");
                Long totalRefundFeeLong = new Long("0");
                QueryIncomeTrendChartBo tmpRspBo = new QueryIncomeTrendChartBo();
                tmpRspBo.setOneDate(someDay + "");
                PorderPayTransStatisticResultPo someDayPayTrans = (PorderPayTransStatisticResultPo)payTransMap.get(String.valueOf(someDay));
                if (someDayPayTrans != null) {
                    if (someDayPayTrans.getTotalFee() != null) {
                        BigDecimal totalIncomeFeeBD = MoneyUtils.haoToFen((Long)someDayPayTrans.getTotalFee());
                        tmpRspBo.setTotalIncomeFee(totalIncomeFeeBD.toPlainString());
                        totalIncomeFeeLong = someDayPayTrans.getTotalFee();
                    } else {
                        tmpRspBo.setTotalIncomeFee("0");
                    }
                    if (someDayPayTrans.getTotalCount() != null) {
                        tmpRspBo.setIncomeNumber(someDayPayTrans.getTotalCount().toString());
                    } else {
                        tmpRspBo.setIncomeNumber("0");
                    }
                } else {
                    tmpRspBo.setTotalIncomeFee("0");
                    tmpRspBo.setIncomeNumber("0");
                }
                PorderRefundTransStatisticResultPo someDayRefundTrans = (PorderRefundTransStatisticResultPo)refundTransMap.get(String.valueOf(someDay));
                if (someDayRefundTrans != null) {
                    if (someDayRefundTrans.getTotalFee() != null) {
                        BigDecimal totalRefundFeeBD = MoneyUtils.haoToFen((Long)someDayRefundTrans.getTotalFee());
                        tmpRspBo.setTotalRefundFee(totalRefundFeeBD.toPlainString());
                        totalIncomeFeeLong = someDayRefundTrans.getTotalFee();
                    } else {
                        tmpRspBo.setTotalRefundFee("0");
                    }
                    if (someDayRefundTrans.getTotalCount() != null) {
                        tmpRspBo.setRefundNumber(someDayRefundTrans.getTotalCount().toString());
                    } else {
                        tmpRspBo.setRefundNumber("0");
                    }
                } else {
                    tmpRspBo.setTotalRefundFee("0");
                    tmpRspBo.setRefundNumber("0");
                }
                Long netIncomeFeeLong = totalIncomeFeeLong - totalRefundFeeLong;
                BigDecimal netIncomeFeeBD = MoneyUtils.haoToFen((Long)netIncomeFeeLong);
                tmpRspBo.setNetIncomeFee(netIncomeFeeBD.toPlainString());
                incomeList.add(tmpRspBo);
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    private void validateArg(QueryIncomeTrendChartWebReqBo reqBo) {
        if (reqBo == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)reqBo.getOperId())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5165\u53c2\u3010operId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)reqBo.getTotalDays())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5165\u53c2\u67e5\u8be2\u5929\u6570\u3010totalDay\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }
}

