/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.bill.busi.impl;

import com.tydic.payment.bill.busi.BillCompareMonitorBusiService;
import com.tydic.payment.bill.busi.bo.BillCompareMonitorCreateReqBO;
import com.tydic.payment.bill.busi.bo.BillCompareMonitorQueryReqBO;
import com.tydic.payment.bill.busi.bo.BillCompareMonitorQueryRspBO;
import com.tydic.payment.bill.busi.bo.BillCompareMonitorUpdateReqBO;
import com.tydic.payment.pay.busi.QueryDBDateBusiService;
import com.tydic.payment.pay.dao.BillCompareMonitorMapper;
import com.tydic.payment.pay.dao.po.BillCompareMonitorPO;
import java.time.Duration;
import java.util.Date;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="billCompareMonitorBusiService")
public class BillCompareMonitorBusiServiceImpl
implements BillCompareMonitorBusiService {
    @Autowired
    private BillCompareMonitorMapper mapper;
    @Autowired
    private QueryDBDateBusiService queryDBDateBusiService;

    public void create(BillCompareMonitorCreateReqBO reqBO) {
        BillCompareMonitorPO reqPO = new BillCompareMonitorPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)reqPO);
        BillCompareMonitorPO rspPO = this.mapper.query(reqPO);
        if (rspPO != null) {
            return;
        }
        reqPO.setStartTime(this.queryDBDateBusiService.getDBDate());
        reqPO.setCreateTime(this.queryDBDateBusiService.getDBDate());
        reqPO.setExecuteState(2);
        this.mapper.create(reqPO);
    }

    public void update(BillCompareMonitorUpdateReqBO reqBO) {
        BillCompareMonitorPO reqPO = new BillCompareMonitorPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)reqPO);
        BillCompareMonitorPO rspPO = this.mapper.query(reqPO);
        if (rspPO == null) {
            return;
        }
        Date endTime = this.queryDBDateBusiService.getDBDate();
        rspPO.setExecuteTime(Duration.between(rspPO.getStartTime().toInstant(), endTime.toInstant()).getSeconds());
        rspPO.setEndTime(endTime);
        rspPO.setExecuteState(reqBO.getExecuteState());
        rspPO.setException(reqBO.getException());
        this.mapper.update(rspPO);
    }

    public BillCompareMonitorQueryRspBO query(BillCompareMonitorQueryReqBO reqBO) {
        BillCompareMonitorPO reqPO = new BillCompareMonitorPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)reqPO);
        BillCompareMonitorPO rspPO = this.mapper.query(reqPO);
        BillCompareMonitorQueryRspBO rspBO = new BillCompareMonitorQueryRspBO();
        BeanUtils.copyProperties((Object)rspPO, (Object)rspBO);
        return rspBO;
    }

    public boolean check(BillCompareMonitorQueryReqBO reqBO) {
        BillCompareMonitorPO reqPO = new BillCompareMonitorPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)reqPO);
        BillCompareMonitorPO rspPO = this.mapper.query(reqPO);
        return rspPO != null;
    }

    public boolean checkSuccess(BillCompareMonitorQueryReqBO reqBO) {
        BillCompareMonitorPO reqPO = new BillCompareMonitorPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)reqPO);
        BillCompareMonitorPO rspPO = this.mapper.query(reqPO);
        return rspPO != null && 1 == rspPO.getExecuteState();
    }
}

