/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.bill.busi.impl;

import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.payment.bill.busi.UpdateShardingCountRedisBusiService;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="updateShardingCountRedisBusiService")
public class UpdateShardingCountRedisBusiServiceImpl
implements UpdateShardingCountRedisBusiService {
    private static final String SPLIT_KEY = "BILL_SPLIT_TOTAL";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private CacheClient cacheClient;

    @Autowired
    public UpdateShardingCountRedisBusiServiceImpl(CacheClient cacheClient) {
        this.cacheClient = cacheClient;
    }

    public boolean updateShardingCount(Long splitTotal) {
        Long total = this.cacheClient.incr(SPLIT_KEY);
        this.logger.info("\u66f4\u65b0 redis , \u66f4\u65b0\u540e BILL_SPLIT_TOTAL = [{}], \u603b\u5206\u7247[{}]", (Object)total, (Object)splitTotal);
        if (Objects.equals(total, splitTotal)) {
            this.cacheClient.delete(SPLIT_KEY);
            return true;
        }
        return false;
    }
}

