/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.ability.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.bo.RspPage;
import com.ohaotian.plugin.db.Page;
import com.tydic.payment.pay.ability.PayProWebQryCanRefundedAbilityService;
import com.tydic.payment.pay.ability.bo.PayProWebQryCanRefundedAbilityReqBo;
import com.tydic.payment.pay.ability.bo.PayProWebQryCanRefundedAbilityRspBo;
import com.tydic.payment.pay.atom.PayMethodAtomService;
import com.tydic.payment.pay.bo.PayPageRspBo;
import com.tydic.payment.pay.busi.PayProQueryCodeListBusiService;
import com.tydic.payment.pay.busi.bo.PayProQueryCodeListBusiReqBo;
import com.tydic.payment.pay.common.util.MoneyUtils;
import com.tydic.payment.pay.dao.PorderMapper;
import com.tydic.payment.pay.dao.PorderPayTransMapper;
import com.tydic.payment.pay.dao.po.PayMethodPo;
import com.tydic.payment.pay.dao.po.PayProQueryCanRefundedReqPo;
import com.tydic.payment.pay.dao.po.PorderPayTransPo;
import com.tydic.payment.pay.dao.po.PorderPo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

@HSFProvider(serviceVersion="2.0.0", serviceGroup="PAYMENT_GROUP_DEV", serviceInterface=PayProWebQryCanRefundedAbilityService.class)
public class PayProWebQryCanRefundedAbilityServiceImpl
implements PayProWebQryCanRefundedAbilityService {
    private static final Logger LOG = LoggerFactory.getLogger(PayProWebQryCanRefundedAbilityServiceImpl.class);
    @Autowired
    private PorderMapper porderMapper;
    @Autowired
    private PayProQueryCodeListBusiService payProQueryCodeListBusiService;
    @Autowired
    private PorderPayTransMapper porderPayTransMapper;
    @Autowired
    private PayMethodAtomService payMethodAtomService;
    private Map<Long, String> methodMap = new HashMap<Long, String>(16);

    public PayPageRspBo<RspPage<PayProWebQryCanRefundedAbilityRspBo>> qryList(PayProWebQryCanRefundedAbilityReqBo reqBo) {
        String validateArgStr;
        if (LOG.isDebugEnabled()) {
            LOG.debug("\u67e5\u8be2\u53ef\u9000\u6b3e\u5217\u8868\u670d\u52a1\u5165\u53c2\uff1a" + JSON.toJSONString((Object)reqBo));
        }
        PayPageRspBo retBo = new PayPageRspBo();
        if (reqBo == null) {
            reqBo = new PayProWebQryCanRefundedAbilityReqBo();
        }
        if (!StringUtils.isEmpty((Object)(validateArgStr = this.validateArg(reqBo)))) {
            retBo.setRespCode("8888");
            retBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateArgStr);
            return retBo;
        }
        PayProQueryCanRefundedReqPo reqPo = new PayProQueryCanRefundedReqPo();
        this.copyProperties(reqBo, reqPo);
        if (reqPo.getDateBegin() != null && reqPo.getDateEnd() != null && reqPo.getDateBegin().equals(reqPo.getDateEnd())) {
            reqPo.setDateEnd(new DateTime((Object)reqPo.getDateEnd()).plusDays(1).toDate());
        }
        Page page = new Page();
        if (reqPo.getPageNo() != 0) {
            page.setPageNo(reqPo.getPageNo());
        }
        if (reqPo.getPageSize() != 10) {
            page.setPageSize(reqPo.getPageSize());
        }
        List<PorderPo> porderPos = this.porderMapper.selectPorderByPayMethod((Page<PayProQueryCanRefundedReqPo>)page, reqPo);
        ArrayList<PayProWebQryCanRefundedAbilityRspBo> canRefundList = new ArrayList<PayProWebQryCanRefundedAbilityRspBo>();
        this.copyRetBoProperties(porderPos, canRefundList);
        RspPage pageBo = new RspPage();
        pageBo.setTotal(page.getTotalPages());
        pageBo.setRecordsTotal(page.getTotalCount());
        pageBo.setPageNo(page.getPageNo());
        pageBo.setRows(canRefundList);
        retBo.setData(pageBo);
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        return retBo;
    }

    private String validateArg(PayProWebQryCanRefundedAbilityReqBo reqBo) {
        if (!StringUtils.isEmpty((Object)reqBo.getBusiId())) {
            try {
                Long.parseLong(reqBo.getBusiId());
            }
            catch (NumberFormatException e) {
                return "busiId\u5fc5\u987b\u4e3a\u6570\u5b57";
            }
        }
        if (!StringUtils.isEmpty((Object)reqBo.getMerchantId())) {
            try {
                Long.parseLong(reqBo.getMerchantId());
            }
            catch (NumberFormatException e) {
                return "merchantId\u5fc5\u987b\u4e3a\u6570\u5b57";
            }
        }
        if (!StringUtils.isEmpty((Object)reqBo.getDateBegin())) {
            try {
                DateTime.parse((String)reqBo.getDateBegin(), (DateTimeFormatter)DateTimeFormat.forPattern((String)"yyyy-MM-dd"));
            }
            catch (Exception e) {
                return "dateBegin\u4e0d\u7b26\u5408\u89c4\u8303";
            }
        }
        if (!StringUtils.isEmpty((Object)reqBo.getDateEnd())) {
            try {
                DateTime.parse((String)reqBo.getDateEnd(), (DateTimeFormatter)DateTimeFormat.forPattern((String)"yyyy-MM-dd"));
            }
            catch (Exception e) {
                return "dateEnd\u4e0d\u7b26\u5408\u89c4\u8303";
            }
        }
        if (!StringUtils.isEmpty((Object)reqBo.getPayMethod())) {
            try {
                Long.parseLong(reqBo.getPayMethod());
            }
            catch (NumberFormatException e) {
                return "payMethod\u5fc5\u987b\u4e3a\u6570\u5b57";
            }
        }
        return null;
    }

    private void copyRetBoProperties(List<PorderPo> porderPos, List<PayProWebQryCanRefundedAbilityRspBo> canRefundList) {
        if (this.methodMap.isEmpty()) {
            PayMethodPo qryMethodPo = new PayMethodPo();
            List<PayMethodPo> payMethodPos = this.payMethodAtomService.queryPayMethod(qryMethodPo);
            for (PayMethodPo po : payMethodPos) {
                this.methodMap.put(po.getPayMethod(), po.getPayMethodName());
            }
        }
        HashMap<Long, String> orderMethodMapping = new HashMap<Long, String>();
        Map orderTypeMap = new HashMap();
        Map orderStatusMap = new HashMap();
        if (!porderPos.isEmpty()) {
            PayProQueryCodeListBusiReqBo qryCodeListBo = new PayProQueryCodeListBusiReqBo();
            qryCodeListBo.setTypeCode("P_ORDER_ORDER_TYPE");
            orderTypeMap = this.payProQueryCodeListBusiService.querCodeList(qryCodeListBo).getData();
            qryCodeListBo.setTypeCode("P_ORDER_ORDER_STATUS");
            orderStatusMap = this.payProQueryCodeListBusiService.querCodeList(qryCodeListBo).getData();
            ArrayList<Long> orders = new ArrayList<Long>();
            for (PorderPo po : porderPos) {
                orders.add(po.getOrderId());
            }
            List<PorderPayTransPo> porderPayTransPos = this.porderPayTransMapper.listOrdersByOrderList(orders);
            for (PorderPayTransPo po : porderPayTransPos) {
                orderMethodMapping.put(po.getOrderId(), this.methodMap.get(po.getPayMethod()));
            }
        }
        for (PorderPo po : porderPos) {
            PayProWebQryCanRefundedAbilityRspBo bo = new PayProWebQryCanRefundedAbilityRspBo();
            BeanUtils.copyProperties((Object)po, (Object)bo);
            bo.setOrderId(po.getOrderId() + "");
            bo.setBusiId(po.getBusiCode());
            bo.setMerchantId(po.getMerchantId() + "");
            bo.setMerchantName(po.getMerchantName());
            bo.setTotalFee(MoneyUtils.haoToFen((Long)po.getTotalFee()).toString());
            if (po.getRealFee() != null) {
                bo.setRealFee(MoneyUtils.haoToFen((Long)po.getRealFee()).toString());
            }
            bo.setCreateTime(new DateTime((Object)po.getCreateTime()).toString("yyyy-MM-dd HH:mm:ss"));
            bo.setOrderType((String)orderTypeMap.get(po.getOrderType()));
            bo.setOrderStatus((String)orderStatusMap.get(po.getOrderStatus()));
            bo.setPayMethod((String)orderMethodMapping.get(po.getOrderId()));
            canRefundList.add(bo);
        }
    }

    private void copyProperties(PayProWebQryCanRefundedAbilityReqBo reqBo, PayProQueryCanRefundedReqPo reqPo) {
        BeanUtils.copyProperties((Object)reqBo, (Object)((Object)reqPo));
        if (!StringUtils.isEmpty((Object)reqBo.getBusiId())) {
            reqPo.setBusiId(Long.valueOf(reqBo.getBusiId()));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getMerchantId())) {
            reqPo.setMerchantId(Long.valueOf(reqBo.getMerchantId()));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getDateBegin())) {
            reqPo.setDateBegin(DateTime.parse((String)reqBo.getDateBegin(), (DateTimeFormatter)DateTimeFormat.forPattern((String)"yyyy-MM-dd")).toDate());
        }
        if (!StringUtils.isEmpty((Object)reqBo.getDateEnd())) {
            reqPo.setDateEnd(DateTime.parse((String)reqBo.getDateEnd(), (DateTimeFormatter)DateTimeFormat.forPattern((String)"yyyy-MM-dd")).toDate());
        }
        if (!StringUtils.isEmpty((Object)reqBo.getPayFeeLess())) {
            reqPo.setPayFeeLess(MoneyUtils.fenToHao((String)reqBo.getPayFeeLess()).longValue());
        }
        if (!StringUtils.isEmpty((Object)reqBo.getPayFeeMore())) {
            reqPo.setPayFeeMore(MoneyUtils.fenToHao((String)reqBo.getPayFeeMore()).longValue());
        }
        if (!StringUtils.isEmpty((Object)reqBo.getPayMethod())) {
            reqPo.setPayMethod(Long.valueOf(reqBo.getPayMethod()));
        }
    }
}

