/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.ali.service.impl;

import com.alipay.api.AlipayClient;
import com.alipay.api.AlipayRequest;
import com.alipay.api.AlipayResponse;
import com.alipay.api.request.AlipayDataDataserviceBillDownloadurlQueryRequest;
import com.alipay.api.request.AlipayTradeAppPayRequest;
import com.alipay.api.request.AlipayTradeCancelRequest;
import com.alipay.api.request.AlipayTradeCloseRequest;
import com.alipay.api.request.AlipayTradePagePayRequest;
import com.alipay.api.request.AlipayTradePrecreateRequest;
import com.alipay.api.request.AlipayTradeQueryRequest;
import com.alipay.api.request.AlipayTradeRefundRequest;
import com.alipay.api.request.AlipayTradeWapPayRequest;
import com.alipay.api.response.AlipayDataDataserviceBillDownloadurlQueryResponse;
import com.alipay.api.response.AlipayTradeAppPayResponse;
import com.alipay.api.response.AlipayTradeCancelResponse;
import com.alipay.api.response.AlipayTradeCloseResponse;
import com.alipay.api.response.AlipayTradePagePayResponse;
import com.alipay.api.response.AlipayTradePayResponse;
import com.alipay.api.response.AlipayTradePrecreateResponse;
import com.alipay.api.response.AlipayTradeQueryResponse;
import com.alipay.api.response.AlipayTradeRefundResponse;
import com.alipay.api.response.AlipayTradeWapPayResponse;
import com.tydic.payment.pay.ali.common.Configs;
import com.tydic.payment.pay.ali.common.TradeStatus;
import com.tydic.payment.pay.ali.common.Utils;
import com.tydic.payment.pay.ali.model.AliPayCloseRequestBuilder;
import com.tydic.payment.pay.ali.model.AlipayAppPayResult;
import com.tydic.payment.pay.ali.model.AlipayF2FDownloadBillResult;
import com.tydic.payment.pay.ali.model.AlipayF2FPayResult;
import com.tydic.payment.pay.ali.model.AlipayF2FPrecreateResult;
import com.tydic.payment.pay.ali.model.AlipayF2FQueryResult;
import com.tydic.payment.pay.ali.model.AlipayF2FRefundResult;
import com.tydic.payment.pay.ali.model.AlipayTradeAppPayRequestBuilder;
import com.tydic.payment.pay.ali.model.AlipayTradeCancelRequestBuilder;
import com.tydic.payment.pay.ali.model.AlipayTradeDownloadBillRequestBuilder;
import com.tydic.payment.pay.ali.model.AlipayTradePrecreateRequestBuilder;
import com.tydic.payment.pay.ali.model.AlipayTradeQueryRequestBuilder;
import com.tydic.payment.pay.ali.model.AlipayTradeRefundRequestBuilder;
import com.tydic.payment.pay.ali.model.AlipayTradeWapPayRequestBuilder;
import com.tydic.payment.pay.ali.model.AlipayTradeWebRequestBuilder;
import com.tydic.payment.pay.ali.model.AlipayWapPayResult;
import com.tydic.payment.pay.ali.model.AlipayWebPayResult;
import com.tydic.payment.pay.ali.service.AlipayTradeService;
import com.tydic.payment.pay.ali.service.impl.AbsAlipayService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

abstract class AbsAlipayTradeService
extends AbsAlipayService
implements AlipayTradeService {
    protected static ExecutorService executorService = Executors.newCachedThreadPool();
    protected AlipayClient client;

    AbsAlipayTradeService() {
    }

    @Override
    public AlipayF2FQueryResult queryTradeResult(AlipayTradeQueryRequestBuilder builder) {
        AlipayTradeQueryResponse response = this.tradeQuery(builder);
        AlipayF2FQueryResult result = new AlipayF2FQueryResult(response);
        if (this.querySuccess(response)) {
            result.setTradeStatus(TradeStatus.SUCCESS);
        } else if (this.tradeError((AlipayResponse)response)) {
            result.setTradeStatus(TradeStatus.UNKNOWN);
        } else if ("WAIT_BUYER_PAY".equals(response.getTradeStatus())) {
            result.setTradeStatus(TradeStatus.PAYING);
        } else {
            result.setTradeStatus(TradeStatus.FAILED);
        }
        return result;
    }

    protected AlipayTradeQueryResponse tradeQuery(AlipayTradeQueryRequestBuilder builder) {
        this.validateBuilder(builder);
        AlipayTradeQueryRequest request = new AlipayTradeQueryRequest();
        request.putOtherTextParam("app_auth_token", builder.getAppAuthToken());
        request.setBizContent(builder.toJsonString());
        this.log.info((Object)("trade.query bizContent:" + request.getBizContent()));
        return (AlipayTradeQueryResponse)this.getResponse(this.client, (AlipayRequest)request);
    }

    @Override
    public AlipayF2FRefundResult tradeRefund(AlipayTradeRefundRequestBuilder builder) {
        this.validateBuilder(builder);
        AlipayTradeRefundRequest request = new AlipayTradeRefundRequest();
        request.setNotifyUrl(builder.getNotifyUrl());
        request.putOtherTextParam("app_auth_token", builder.getAppAuthToken());
        request.setBizContent(builder.toJsonString());
        this.log.info((Object)("trade.refund bizContent:" + request.getBizContent()));
        AlipayTradeRefundResponse response = (AlipayTradeRefundResponse)this.getResponse(this.client, (AlipayRequest)request);
        AlipayF2FRefundResult result = new AlipayF2FRefundResult(response);
        if (response != null && "10000".equals(response.getCode())) {
            result.setTradeStatus(TradeStatus.SUCCESS);
        } else if (this.tradeError((AlipayResponse)response)) {
            result.setTradeStatus(TradeStatus.UNKNOWN);
        } else {
            result.setTradeStatus(TradeStatus.FAILED);
        }
        return result;
    }

    @Override
    public AlipayF2FPrecreateResult tradePrecreate(AlipayTradePrecreateRequestBuilder builder) {
        this.validateBuilder(builder);
        AlipayTradePrecreateRequest request = new AlipayTradePrecreateRequest();
        request.setNotifyUrl(builder.getNotifyUrl());
        request.putOtherTextParam("app_auth_token", builder.getAppAuthToken());
        request.setBizContent(builder.toJsonString());
        this.log.info((Object)("trade.precreate:" + request));
        AlipayTradePrecreateResponse response = (AlipayTradePrecreateResponse)this.getResponse(this.client, (AlipayRequest)request);
        AlipayF2FPrecreateResult result = new AlipayF2FPrecreateResult(response);
        if (response != null && "10000".equals(response.getCode())) {
            result.setTradeStatus(TradeStatus.SUCCESS);
        } else if (this.tradeError((AlipayResponse)response)) {
            result.setTradeStatus(TradeStatus.UNKNOWN);
        } else {
            result.setTradeStatus(TradeStatus.FAILED);
        }
        return result;
    }

    protected AlipayF2FPayResult checkQueryAndCancel(String outTradeNo, String appAuthToken, AlipayF2FPayResult result, AlipayTradeQueryResponse queryResponse) {
        if (this.querySuccess(queryResponse)) {
            result.setTradeStatus(TradeStatus.SUCCESS);
            result.setResponse(this.toPayResponse(queryResponse));
            return result;
        }
        AlipayTradeCancelRequestBuilder builder = new AlipayTradeCancelRequestBuilder().setOutTradeNo(outTradeNo);
        builder.setAppAuthToken(appAuthToken);
        AlipayTradeCancelResponse cancelResponse = this.cancelPayResult(builder);
        if (this.tradeError((AlipayResponse)cancelResponse)) {
            result.setTradeStatus(TradeStatus.UNKNOWN);
        } else {
            result.setTradeStatus(TradeStatus.FAILED);
        }
        return result;
    }

    protected AlipayTradeCancelResponse tradeCancel(AlipayTradeCancelRequestBuilder builder) {
        this.validateBuilder(builder);
        AlipayTradeCancelRequest request = new AlipayTradeCancelRequest();
        request.putOtherTextParam("app_auth_token", builder.getAppAuthToken());
        request.setBizContent(builder.toJsonString());
        this.log.info((Object)("trade.cancel bizContent:" + request.getBizContent()));
        return (AlipayTradeCancelResponse)this.getResponse(this.client, (AlipayRequest)request);
    }

    protected AlipayTradeQueryResponse loopQueryResult(AlipayTradeQueryRequestBuilder builder) {
        AlipayTradeQueryResponse queryResult = null;
        for (int i = 0; i < Configs.getMaxQueryRetry(); ++i) {
            Utils.sleep(Configs.getQueryDuration());
            AlipayTradeQueryResponse response = this.tradeQuery(builder);
            if (response == null) continue;
            if (this.stopQuery(response)) {
                return response;
            }
            queryResult = response;
        }
        return queryResult;
    }

    protected boolean stopQuery(AlipayTradeQueryResponse response) {
        return "10000".equals(response.getCode()) && ("TRADE_FINISHED".equals(response.getTradeStatus()) || "TRADE_SUCCESS".equals(response.getTradeStatus()) || "TRADE_CLOSED".equals(response.getTradeStatus()));
    }

    protected AlipayTradeCancelResponse cancelPayResult(AlipayTradeCancelRequestBuilder builder) {
        AlipayTradeCancelResponse response = this.tradeCancel(builder);
        if (this.cancelSuccess(response)) {
            return response;
        }
        if (this.needRetry(response)) {
            this.log.warn((Object)("begin async cancel request:" + builder));
            this.asyncCancel(builder);
        }
        return response;
    }

    protected void asyncCancel(final AlipayTradeCancelRequestBuilder builder) {
        executorService.submit(new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < Configs.getMaxCancelRetry(); ++i) {
                    Utils.sleep(Configs.getCancelDuration());
                    AlipayTradeCancelResponse response = AbsAlipayTradeService.this.tradeCancel(builder);
                    if (!AbsAlipayTradeService.this.cancelSuccess(response) && AbsAlipayTradeService.this.needRetry(response)) continue;
                    return;
                }
            }
        });
    }

    protected AlipayTradePayResponse toPayResponse(AlipayTradeQueryResponse response) {
        AlipayTradePayResponse payResponse = new AlipayTradePayResponse();
        payResponse.setCode(this.querySuccess(response) ? "10000" : "40004");
        StringBuilder msg = new StringBuilder(response.getMsg()).append(" tradeStatus:").append(response.getTradeStatus());
        payResponse.setMsg(msg.toString());
        payResponse.setSubCode(response.getSubCode());
        payResponse.setSubMsg(response.getSubMsg());
        payResponse.setBody(response.getBody());
        payResponse.setParams(response.getParams());
        payResponse.setBuyerLogonId(response.getBuyerLogonId());
        payResponse.setFundBillList(response.getFundBillList());
        payResponse.setOpenId(response.getOpenId());
        payResponse.setOutTradeNo(response.getOutTradeNo());
        payResponse.setReceiptAmount(response.getReceiptAmount());
        payResponse.setTotalAmount(response.getTotalAmount());
        payResponse.setTradeNo(response.getTradeNo());
        return payResponse;
    }

    protected boolean needRetry(AlipayTradeCancelResponse response) {
        return response == null || "Y".equals(response.getRetryFlag());
    }

    protected boolean querySuccess(AlipayTradeQueryResponse response) {
        return response != null && "10000".equals(response.getCode()) && ("TRADE_SUCCESS".equals(response.getTradeStatus()) || "TRADE_FINISHED".equals(response.getTradeStatus()));
    }

    protected boolean cancelSuccess(AlipayTradeCancelResponse response) {
        return response != null && "10000".equals(response.getCode());
    }

    protected boolean tradeError(AlipayResponse response) {
        return response == null || "20000".equals(response.getCode());
    }

    @Override
    public AlipayF2FDownloadBillResult downloadBill(AlipayTradeDownloadBillRequestBuilder builder) {
        this.validateBuilder(builder);
        AlipayDataDataserviceBillDownloadurlQueryRequest request = new AlipayDataDataserviceBillDownloadurlQueryRequest();
        request.setBizContent(builder.toJsonString());
        this.log.info((Object)("downloadbill bizContent:" + request.getBizContent()));
        AlipayDataDataserviceBillDownloadurlQueryResponse response = (AlipayDataDataserviceBillDownloadurlQueryResponse)this.getResponse(this.client, (AlipayRequest)request);
        AlipayF2FDownloadBillResult result = new AlipayF2FDownloadBillResult(response);
        if (response != null && "10000".equals(response.getCode())) {
            result.setTradeStatus(TradeStatus.SUCCESS);
        } else if (this.tradeError((AlipayResponse)response)) {
            result.setTradeStatus(TradeStatus.UNKNOWN);
        } else {
            result.setTradeStatus(TradeStatus.FAILED);
        }
        return result;
    }

    @Override
    public AlipayAppPayResult appPay(AlipayTradeAppPayRequestBuilder builder) {
        this.validateBuilder(builder);
        AlipayTradeAppPayRequest request = new AlipayTradeAppPayRequest();
        request.setBizContent(builder.toJsonString());
        request.setNotifyUrl(builder.getNotifyUrl());
        request.setNeedEncrypt(false);
        this.log.info((Object)("appPay bizContent:" + request.getBizContent()));
        AlipayTradeAppPayResponse response = (AlipayTradeAppPayResponse)this.getAppResponse(this.client, (AlipayRequest)request);
        AlipayAppPayResult result = new AlipayAppPayResult(response);
        if (response != null) {
            result.setTradeStatus(TradeStatus.SUCCESS);
        } else if (this.tradeError((AlipayResponse)response)) {
            result.setTradeStatus(TradeStatus.UNKNOWN);
        } else {
            result.setTradeStatus(TradeStatus.FAILED);
        }
        return result;
    }

    @Override
    public AlipayWapPayResult h5Pay(AlipayTradeWapPayRequestBuilder builder) {
        this.validateBuilder(builder);
        AlipayTradeWapPayRequest request = new AlipayTradeWapPayRequest();
        request.setBizContent(builder.toJsonString());
        request.setNotifyUrl(builder.getNotifyUrl());
        request.setReturnUrl(builder.getRerutnUrl());
        request.setNeedEncrypt(false);
        this.log.info((Object)("appPay bizContent:" + request.getBizContent()));
        AlipayTradeWapPayResponse response = (AlipayTradeWapPayResponse)this.getH5Response(this.client, (AlipayRequest)request);
        AlipayWapPayResult result = new AlipayWapPayResult(response);
        if (response != null) {
            result.setTradeStatus(TradeStatus.SUCCESS);
        } else if (this.tradeError((AlipayResponse)response)) {
            result.setTradeStatus(TradeStatus.UNKNOWN);
        } else {
            result.setTradeStatus(TradeStatus.FAILED);
        }
        return result;
    }

    @Override
    public AlipayWebPayResult webPay(AlipayTradeWebRequestBuilder builder) {
        this.validateBuilder(builder);
        AlipayTradePagePayRequest request = new AlipayTradePagePayRequest();
        request.setBizContent(builder.toJsonString());
        request.setNotifyUrl(builder.getNotifyUrl());
        request.setReturnUrl(builder.getRerutnUrl());
        request.setNeedEncrypt(false);
        this.log.info((Object)("appPay bizContent:" + request.getBizContent()));
        AlipayTradePagePayResponse response = (AlipayTradePagePayResponse)this.getH5Response(this.client, (AlipayRequest)request);
        AlipayWebPayResult result = new AlipayWebPayResult(response);
        if (response != null) {
            result.setTradeStatus(TradeStatus.SUCCESS);
        } else if (this.tradeError((AlipayResponse)response)) {
            result.setTradeStatus(TradeStatus.UNKNOWN);
        } else {
            result.setTradeStatus(TradeStatus.FAILED);
        }
        return result;
    }

    @Override
    public AlipayTradeCloseResponse close(AliPayCloseRequestBuilder builder) {
        this.validateBuilder(builder);
        AlipayTradeCloseRequest request = new AlipayTradeCloseRequest();
        request.setBizContent(builder.toJsonString());
        this.log.info((Object)("AliPayCloseRequest:" + request.getBizContent()));
        AlipayTradeCloseResponse response = (AlipayTradeCloseResponse)this.getResponse(this.client, (AlipayRequest)request);
        return response;
    }
}

